 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Functionality routines for running a workspace
   >>>>
   >>>>  Private:
   >>>>          create_workspace
   >>>>          quit_cb
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "runwksp.h"

/*-----------------------------------------------------------
|
|  Routine Name: quit_cb - routine for quit callback
|
|       Purpose: This is the quit workspace callback routine
|         Input: quit        - the quit button
|                client_data - the workspace object to quit
|                call_data   - unused
|    Written By: Mark Young
|          Date: Jul 14, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void quit_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	xvobject toplevel = (xvobject) client_data;
	xvw_destroy(toplevel);
}

/*-----------------------------------------------------------
|
|  Routine Name: workspace_cb - routine for workspace callback
|
|       Purpose: This is the workspace run callback routine
|         Input: workspace   - the workspace
|                client_data - the workspace object to quit
|                call_data   - unused
|    Written By: Mark Young
|          Date: Sep 05, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void workspace_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	int running = *((int *) call_data);
	xvobject toplevel = (xvobject) client_data;

	if (running != FALSE)
	   return;

	xvw_destroy(toplevel);
}

/*-----------------------------------------------------------
|
|  Routine Name: create_workspace()
|
|       Purpose: Creates the display workspace for running a compiled
|	         "workspace" (pane) object.
|
|         Input: 
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Sep 08, 1993
| Modifications:
|
------------------------------------------------------------*/
void create_workspace(void)
{
	kform    *form = NULL;
	kobject  toolbox, program, obj;
	char	 *tbname, *oname, *wksp_file = NULL;
	xvobject toplevel, parent, workspace, commandbar = NULL, quit = NULL;


	/*
	 *  Create the toplevel
	 */
	toplevel = xvw_create_application_shell("Run Workspace Program",
				NULL, NULL);

	/*
	 *  Create the parent in which the workspace will be placed
	 */
        parent = xvw_create_manager(toplevel, "Parent");
	xvw_set_attributes(parent,
                XVW_WIDTH, 860,
                XVW_HEIGHT, 650,
		XVW_SELECTABLE, TRUE,
		XVW_RESIZABLE, TRUE,
		XVW_MENUABLE, TRUE,
		NULL);

	if (clui_info->hidden_flag == FALSE)
	{
           quit = xvw_create_button(parent, "Quit");
	   xvw_set_attributes(quit,
                XVW_LABEL, "Quit",
                XVW_LEFT_OF, NULL,
                XVW_CHAR_WIDTH, 6.0,
                XVW_CHAR_HEIGHT, 1.2,
                NULL);

	   /*
	    *  Create the commandbar
	    */
           commandbar = xvw_create_commandbar(parent, "CommandBar");
           xvw_set_attributes(commandbar,
                XVW_BELOW,   NULL,
                XVW_LEFT_OF, quit,
                XVW_TACK_EDGE, KMANAGER_TACK_HORIZ,
                NULL);
	}

	/*
	 *  Create the workspace
	 */
        workspace = xvw_create_workspace(parent, "Workspace");
        xvw_set_attributes(workspace,
                XVW_BELOW,         commandbar,
		XVW_CANVAS_WIDTH,  3000,
		XVW_CANVAS_HEIGHT, 3000,
		XVW_TACK_EDGE,     KMANAGER_TACK_ALL,
		XVW_GLYPH_REPORTING, (clui_info->hidden_flag == FALSE),
		XVW_GLYPH_ECHO,      (clui_info->silent_flag == FALSE),
                NULL);

	if (clui_info->hidden_flag == FALSE)
	   xvw_set_attribute(commandbar, XVW_COMMANDBAR_WORKSPACE, workspace);

        if (clui_info->wksp_file)
        {
           wksp_file = clui_info->wksp_file;
        }
        else if (clui_info->tb_string && clui_info->oname_string)
        {
           tbname = clui_info->tb_string;
           oname  = clui_info->oname_string;
           if ((toolbox = kcms_open_toolbox(tbname)) == NULL ||
               (program = kcms_open_cmobj(toolbox, oname)) == NULL)
           {
              (void) kerror(NULL, "main()", "Cannot open %s '%s'.",
                        (!toolbox) ? "toolbox" : "program",
                        (!toolbox) ? clui_info->tb_string :
                        clui_info->oname_string);
              kexit(KEXIT_FAILURE);
           }
 
           if (kcms_get_attribute(program, KCMS_CMOBJ_WORKSPACE, &obj) && obj)
              kcms_get_attribute(obj, KCMS_PATH, &wksp_file);
 
           kcms_close(program); kcms_close(toolbox);
        }

	if (wksp_file != NULL)
	   xvw_set_attribute(workspace, XVW_WORKSPACE_RESTORE, wksp_file);
 
	if (clui_info->args_flag)
	{
	   xvw_get_attribute(workspace, XVW_WORKSPACE_WKSPGUI, &form);
	   if (form != NULL && clui_info->args_string != NULL)
	      xvf_modify_form_from_cmd(form, clui_info->args_string);
	}

	if (clui_info->hidden_flag == FALSE)
	{
	   xvw_realize(toplevel);
	   xvw_add_callback(quit, XVW_BUTTON_SELECT, quit_cb, toplevel);
	}
	else
	{
	   xvw_unrealize(toplevel);
	}

	if (clui_info->showgui_flag == TRUE)
	{
	   xvw_set_attribute(workspace, XVW_WORKSPACE_SHOW_WKSPGUI, TRUE);
	}
	else if (clui_info->hidden_flag == TRUE)
	{
           xvw_add_callback(workspace, XVW_WORKSPACE_RUN_CALLBACK,
		workspace_cb, toplevel);
	   xvw_set_attribute(workspace, XVW_WORKSPACE_RUN, TRUE);
	}
}
