 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "preview.h"
/*-----------------------------------------------------------
| 
|  Routine Name: preview_get_args
| 
|       Purpose: Gets command line args for preview
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname preview
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void preview_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for preview is out of sync with arguments specified in preview's *.pane file; please rerun ghostwriter on preview.";


	/*
	 * allocate the preview structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "preview_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "form",
	                &(clui_info->form_file),
	                &(clui_info->form_flag))))
	{
	    kerror(NULL, "preview_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "x",
	                &(clui_info->x_int),
	                &(clui_info->x_flag))))
	{
	    kerror(NULL, "preview_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}
	if (!(kclui_get_int(pane, "y",
	                &(clui_info->y_int),
	                &(clui_info->y_flag))))
	{
	    kerror(NULL, "preview_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

}



