 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for preview
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "preview.h"

clui_info_struct *clui_info = NULL;

gui_info_struct *gui_info;

/*-----------------------------------------------------------
|
|  Routine Name: main() - GUI display tool
|
|       Purpose: main program for preview
|
|         Input:
|		char *clui_info->i_file; {input UIS file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|        Output:
|       Returns:
|
|    Written By: John Rasure, Mark Young
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *form;            /* form tree representing *.form file */
	char   *form_filestring; /* *.form file for preview    */ 
	char   *form_pathname;   /* location of preview.form   */
	char   *form_fullpath;   /* expanded preview.form path */
	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DESIGN");
	kexit_handler(preview_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_XVROUTINE, "DESIGN", "preview",
		preview_usage_additions);

	preview_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

	/*
	 * Initialize xvwidgets lib
	 */
	if (!(xvw_initialize(XVW_MENUS_XVFORMS)))
	{
	     kinfo(KSTANDARD, "Could not open connection to server");
	     kexit(KEXIT_FAILURE);
	}

	/*
	 * Set location of preview.form
	 */
	if (clui_info->form_flag)
	{
	    form_filestring = kstrdup(clui_info->form_file);
	    form_pathname   = NULL;
	}
	else
	{
	    form_filestring = kstrdup("preview.form");
	    form_pathname   = kstrdup("$TOOLBOX/objects/xvroutine/preview/uis");
	}
	form_fullpath   = kfullpath(form_filestring, form_pathname, NULL);

	/*
	 * Allocate the GUI Info structure 
	 */
	gui_info = (gui_info_struct *)
				kcalloc (1, sizeof (gui_info_struct));
	/*
	 * Create the forms for preview 
	 */
	form = xvf_create_form(form_fullpath, NONE, run_preview, gui_info,
				clui_info->x_int, clui_info->y_int,
				XVF_PARTIAL_EDIT);
	if (form == NULL)
	   kexit(KEXIT_FAILURE);

	/*
	 * Initialize the GUI Info structure 
	 */
	if (!(_xvf_init_preview(form, gui_info)))
	    kexit(KEXIT_FAILURE);

/* -main_before_lib_call */
	if (clui_info->i_flag)
	{
	    if (gui_info->show->view->i_struct != NULL)
		xvf_set_attribute(gui_info->show->view->i_struct,
			          XVF_FILE_NAME, clui_info->i_file);

	    display_form = xvf_create_form(clui_info->i_file, NONE, 
					   run_display, gui_info, 
					   -1, -1, XVF_FULL_EDIT);
	    if (display_form != NULL)
		xvw_add_detectfile(NULL, clui_info->i_file, PREVIEW_DELAY,
				   update_displayed_uisfile, NULL);
	}
/* -main_before_lib_call_end */

/* -main_library_call */
	xvf_run_form();
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */

	kfree(form_filestring);
	kfree(form_pathname);
	kfree(form_fullpath);

	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: preview_usage_additions
| 
|       Purpose: Prints usage additions in preview_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname preview
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void preview_usage_additions(void)
{
	kfprintf(kstderr, "\tGUI display tool\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: preview_free_args
| 
|       Purpose: Frees CLUI struct allocated in preview_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname preview
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
preview_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
		kfree(clui_info->form_file);
	kfree(clui_info->i_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
