 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane preview
   >>>> 
   >>>>  Private: 
   >>>> 	run_display
   >>>> 	view_i
   >>>> 	view_revisit
   >>>> 	view_edit
   >>>> 	view_print
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "preview.h"
/*-----------------------------------------------------------
|
|  Routine Name: run_display
|
|       Purpose: Main GUI driver for the displayed form
|
|         Input: form        - pointer to the form tree of displayed GUI
|                subform     - pointer to currently displayed subform
|                client_data - client data passed in
|
|        Output: None
|    Written By: Danielle Argiro
|          Date: Sept 20, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
void run_display(
     kform    *form,
     ksubform *subform,
     kaddr    client_data)
{
        /*
         * GUI info structure passed in as client_data
         */
        gui_info_struct *master_info = (gui_info_struct *) client_data;

        if ((display_form->quit) && (master_info->show != NULL))
        {
            xvf_destroy_form(display_form);
            display_form = NULL;
        }
}


/*-----------------------------------------------------------
| 
|  Routine Name: view_i
| 
|       Purpose: Called when input selection i is used
| 
|         Input: view_info - ptr to PaneInfo struct for view pane
| 
|        Output: None
|    Written By: 
|          Date: Tue Dec 15 11:07:48 1992
| Modifications: 
| 
------------------------------------------------------------*/
void view_i(
   show_view *view_info)
{
	if (view_info->i == NULL)
        {
            kerror(NULL, "view_i",
                   "Please specify a UIS file to edit");
            return;
        }
	if (display_form != NULL)
            xvf_destroy_form(display_form);

        xvw_remove_detectfile(NULL, clui_info->i_file,
                              update_displayed_uisfile, NULL);

	kfree(clui_info->i_file);
	clui_info->i_file = kstring_copy(view_info->i, NULL);

        display_form = xvf_create_form(clui_info->i_file, NONE,
                                       run_display, gui_info,
                                       -1, -1, XVF_FULL_EDIT);
        if (display_form != NULL)
	{
            xvw_add_detectfile(NULL, clui_info->i_file, PREVIEW_DELAY, 
			       update_displayed_uisfile, NULL);
	}
}


/*-----------------------------------------------------------
| 
|  Routine Name: view_revisit
| 
|       Purpose: Called when pane action button revisit is used
| 
|         Input: view_info - ptr to PaneInfo struct for view pane
| 
|        Output: None
|    Written By: 
|          Date: Tue Dec 15 11:07:48 1992
| Modifications: 
| 
------------------------------------------------------------*/
void view_revisit(
   show_view *view_info)
{
	view_i(view_info);
}


/*-----------------------------------------------------------
| 
|  Routine Name: view_edit
| 
|       Purpose: Called when pane action button edit is used
| 
|         Input: view_info - ptr to PaneInfo struct for view pane
| 
|        Output: None
|    Written By: 
|          Date: Tue Dec 15 11:07:48 1992
| Modifications: 
| 
------------------------------------------------------------*/
void view_edit(
   show_view *view_info)
{
	char *editor, *filename; 
	char temp[KLENGTH];

	/*
         * user clicked on pane action button selection 'edit'
         */
        if (view_info->edit)
        {
           filename = kfullpath(clui_info->i_file, NULL, NULL);
           if (filename != NULL)
           {
               /*
                * Check to see if the user has specified a preferred editor.
                * If not use the default EDITOR.
                */
               if (!(editor = kgetenv("EDITOR")))
                  (void) ksprintf(temp,
                        "xterm -display %s -geometry 132x24 -e %s %s",
                         XDisplayName(NULL), EDITOR, filename);
               else
               {
                  /* kludge by Robin Corbet to avoid producing an xterm
                   * window if one isn't really needed
                   */
                   if (kstrcmp(editor,"textedit") == 0 ||
                       kstrcmp(editor,"xedit") == 0    ||
                       kstrcmp(editor,"emacs") == 0)
                       (void) ksprintf(temp, "%s %s", editor, filename);
                   else
                       (void) ksprintf(temp,
                        "xterm -display %s -geometry 132x24 -e %s %s",
                         XDisplayName(NULL), editor, filename);
               }
               xvw_fork(temp, NULL, NULL);
               kfree(filename);
            }
        }
}


/*-----------------------------------------------------------
| 
|  Routine Name: view_print
| 
|       Purpose: Called when input selection print is used
| 
|         Input: view_info - ptr to PaneInfo struct for view pane
| 
|        Output: None
|    Written By: 
|          Date: Tue Dec 15 11:07:48 1992
| Modifications: 
| 
------------------------------------------------------------*/
void view_print(
   show_view *view_info)
{
	if (kvf_print_UIS_file(display_form, view_info->print, 
				TRUE, FALSE))
            kinfo(KSTANDARD,  "UIS written to file %s", view_info->print);
}

/*-----------------------------------------------------------
|
|  Routine Name: update_displayed_uisfile
|
|       Purpose: This is the callback routine for the detection of
|                a change in the UIS file. Unmaps the old form, creates
|                and maps the new form.
|
|         Input:  object   - object associated with file (not applicable here)
|                 filename - name of UIS file
|                 data     - data structure sent back ... not implemented
|
|        Output: None
|    Written By: Mark Young and John Rasure
|          Date: Dec 15 1991
| Modifications: Updated from Khoros 1.0 
|
------------------------------------------------------------*/

/*ARGSUSED*/
int update_displayed_uisfile(
   xvobject object,
   char *filename,
   char *data)
{
        int  x, y, width, height;


        if (display_form != NULL)
        {
           if (display_form->toplevel != NULL)
              xvf_form_geometry(display_form, &x, &y, &width, &height);
           else xvf_subform_geometry(display_form->subform, 
				   &x, &y, &width, &height);

           xvf_destroy_form(display_form);
        }
        else x = y = -1;

	display_form = xvf_create_form(filename, NONE, run_display, 
				       gui_info, x, y, XVF_FULL_EDIT);
        return(1);
}


