 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "khelp.h"
/*-----------------------------------------------------------
| 
|  Routine Name: khelp_get_args
| 
|       Purpose: Gets command line args for khelp
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname khelp
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void khelp_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for khelp is out of sync with arguments specified in khelp's *.pane file; please rerun ghostwriter on khelp.";


	/*
	 * allocate the khelp structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i",
			  &(clui_info->i_file),
			  &(clui_info->i_flag))))
	{
	    kerror(NULL, "khelp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "x",
			  &(clui_info->x_int),
			  &(clui_info->x_flag))))
	{
	    kerror(NULL, "khelp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "width",
			  &(clui_info->width_int),
			  &(clui_info->width_flag))))
	{
	    kerror(NULL, "khelp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "y",
			  &(clui_info->y_int),
			  &(clui_info->y_flag))))
	{
	    kerror(NULL, "khelp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "height",
			  &(clui_info->height_int),
			  &(clui_info->height_flag))))
	{
	    kerror(NULL, "khelp_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



