 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_guise
   >>>> 	_xvf_free_guise
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_guise_warning
   >>>> 	_xvf_init_guise_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "guise.h"

static void _xvf_init_guise_warning PROTO((char *));
static void _xvf_init_guise_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_guise
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_guise_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 14, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_guise(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	/*
	 * initializing 'guise' Form Info structure
	 */

	forminfo->options_struct =
	    kvf_create_struct_from_subformname(form, "guise.options");
	if (forminfo->options_struct == NULL)
	{
	    _xvf_init_guise_error("subform 'options' on form 'guise'", 
			    "guise_options");
	    return(FALSE);
	}

	/*
	 * initializing 'guise->options' Subform Info structure
	 */

	forminfo->options = (guise_options *)
				kcalloc(1, sizeof(guise_options));
	subform = forminfo->options_struct->Subformptr;

	/*
	 * initializing 'guise->options->create' Pane Info structure
	 */

	forminfo->options->create = (options_create *)
				kcalloc(1, sizeof(options_create));
	forminfo->options->create_struct =
	    kvf_create_struct_from_panename(subform, "guise.options.create");
	if (forminfo->options->create_struct == NULL)
	{
	    _xvf_init_guise_error("pane 'create' on subform 'options'", "options_create");
	    return(FALSE);
	}
	pane = forminfo->options->create_struct->Controlptr;
	forminfo->options->create->license_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.license");
	if (forminfo->options->create->license_struct == NULL)
		    _xvf_init_guise_warning("unknown selection 'license' on pane 'create' of subform 'options'");

	forminfo->options->create->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.help");
	if (forminfo->options->create->help_struct == NULL)
		    _xvf_init_guise_warning("unknown selection 'help' on pane 'create' of subform 'options'");

	forminfo->options->create->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.quit");
	if (forminfo->options->create->quit_struct == NULL)
		    _xvf_init_guise_warning("quit button 'quit' on pane 'create' of subform 'options'");
	forminfo->options->create->quit = FALSE;

	forminfo->options->create->i_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.i");
	if (forminfo->options->create->i_struct != NULL)
	{
	    selection = forminfo->options->create->i_struct->Selptr;
	    kvf_get_attribute(forminfo->options->create->i_struct, KVF_FILE_DEF,
	                    &(forminfo->options->create->i));
	}
	else
	    _xvf_init_guise_warning("input selection 'i' on pane 'create' of subform 'options'");

	forminfo->options->create->i_selected = FALSE;

	forminfo->options->create->save_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.save");
	if (forminfo->options->create->save_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'save' on pane 'create' of subform 'options'");
	forminfo->options->create->save = FALSE;
	selection = forminfo->options->create->save_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->reload_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.reload");
	if (forminfo->options->create->reload_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'reload' on pane 'create' of subform 'options'");
	forminfo->options->create->reload = FALSE;
	selection = forminfo->options->create->reload_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->edit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.edit");
	if (forminfo->options->create->edit_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'edit' on pane 'create' of subform 'options'");
	forminfo->options->create->edit = FALSE;
	selection = forminfo->options->create->edit_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->new_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.new");
	if (forminfo->options->create->new_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'new' on pane 'create' of subform 'options'");
	forminfo->options->create->new = FALSE;
	selection = forminfo->options->create->new_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->options_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.options");
	if (forminfo->options->create->options_struct == NULL)
	    _xvf_init_guise_warning("unknown selection 'options' on pane 'create' of subform 'options'");

	forminfo->options->create->copy_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.copy");
	if (forminfo->options->create->copy_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'copy' on pane 'create' of subform 'options'");
	forminfo->options->create->copy = FALSE;
	selection = forminfo->options->create->copy_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->menuform_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.menuform");
	if (forminfo->options->create->menuform_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'menuform' on pane 'create' of subform 'options'");
	forminfo->options->create->menuform = FALSE;
	selection = forminfo->options->create->menuform_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->delete_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.delete");
	if (forminfo->options->create->delete_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'delete' on pane 'create' of subform 'options'");
	forminfo->options->create->delete = FALSE;
	selection = forminfo->options->create->delete_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->grouping_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.grouping");
	if (forminfo->options->create->grouping_struct == NULL)
	    _xvf_init_guise_warning("unknown selection 'grouping' on pane 'create' of subform 'options'");

	forminfo->options->create->submenu_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.submenu");
	if (forminfo->options->create->submenu_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'submenu' on pane 'create' of subform 'options'");
	forminfo->options->create->submenu = FALSE;
	selection = forminfo->options->create->submenu_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->me_group_req_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.me_group_req");
	if (forminfo->options->create->me_group_req_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'me_group_req' on pane 'create' of subform 'options'");
	forminfo->options->create->me_group_req = FALSE;
	selection = forminfo->options->create->me_group_req_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->me_group_opt_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.me_group_opt");
	if (forminfo->options->create->me_group_opt_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'me_group_opt' on pane 'create' of subform 'options'");
	forminfo->options->create->me_group_opt = FALSE;
	selection = forminfo->options->create->me_group_opt_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->mi_group_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.mi_group");
	if (forminfo->options->create->mi_group_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'mi_group' on pane 'create' of subform 'options'");
	forminfo->options->create->mi_group = FALSE;
	selection = forminfo->options->create->mi_group_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->ls_group_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.ls_group");
	if (forminfo->options->create->ls_group_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'ls_group' on pane 'create' of subform 'options'");
	forminfo->options->create->ls_group = FALSE;
	selection = forminfo->options->create->ls_group_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->o_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.o");
	if (forminfo->options->create->o_struct != NULL)
	{
	    selection = forminfo->options->create->o_struct->Selptr;
	    kvf_get_attribute(forminfo->options->create->o_struct, KVF_FILE_DEF,
	                    &(forminfo->options->create->o));
	}
	else
	    _xvf_init_guise_warning("output selection 'o' on pane 'create' of subform 'options'");

	forminfo->options->create->o_selected = FALSE;

	forminfo->options->create->control_dest_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.control_dest");
	if (forminfo->options->create->control_dest_struct != NULL)
	{
	    selection = forminfo->options->create->control_dest_struct->Selptr;
	    kvf_get_attribute(forminfo->options->create->control_dest_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->options->create->control_dest_num));
	    forminfo->options->create->control_dest_val = 8;
	}
	else
	    _xvf_init_guise_warning("toggle selection 'control_dest' on pane 'create' of subform 'options'");

	forminfo->options->create->control_dest_selected = FALSE;

	forminfo->options->create->force_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.force");
	if (forminfo->options->create->force_struct != NULL)
	{
	    selection = forminfo->options->create->force_struct->Selptr;
	    kvf_get_attribute(forminfo->options->create->force_struct, KVF_LOGIC_DEF,
	                    &(forminfo->options->create->force));
	    kvf_get_attribute(forminfo->options->create->force_struct, KVF_LOGIC_LABEL,
	                    &(forminfo->options->create->force_label));
	}
	else
	    _xvf_init_guise_warning("logical selection 'force' on pane 'create' of subform 'options'");

	forminfo->options->create->force_selected = FALSE;

	forminfo->options->create->simples_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.simples");
	if (forminfo->options->create->simples_struct == NULL)
	    _xvf_init_guise_warning("unknown selection 'simples' on pane 'create' of subform 'options'");

	forminfo->options->create->int_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.int_sel");
	if (forminfo->options->create->int_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'int_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->int_sel = FALSE;
	selection = forminfo->options->create->int_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->float_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.float_sel");
	if (forminfo->options->create->float_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'float_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->float_sel = FALSE;
	selection = forminfo->options->create->float_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->double_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.double_sel");
	if (forminfo->options->create->double_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'double_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->double_sel = FALSE;
	selection = forminfo->options->create->double_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->string_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.string_sel");
	if (forminfo->options->create->string_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'string_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->string_sel = FALSE;
	selection = forminfo->options->create->string_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->flag_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.flag_sel");
	if (forminfo->options->create->flag_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'flag_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->flag_sel = FALSE;
	selection = forminfo->options->create->flag_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->logic_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.logic_sel");
	if (forminfo->options->create->logic_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'logic_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->logic_sel = FALSE;
	selection = forminfo->options->create->logic_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->files_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.files");
	if (forminfo->options->create->files_struct == NULL)
	    _xvf_init_guise_warning("unknown selection 'files' on pane 'create' of subform 'options'");

	forminfo->options->create->infile_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.infile_sel");
	if (forminfo->options->create->infile_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'infile_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->infile_sel = FALSE;
	selection = forminfo->options->create->infile_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->outfile_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.outfile_sel");
	if (forminfo->options->create->outfile_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'outfile_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->outfile_sel = FALSE;
	selection = forminfo->options->create->outfile_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->stdin_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.stdin_sel");
	if (forminfo->options->create->stdin_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'stdin_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->stdin_sel = FALSE;
	selection = forminfo->options->create->stdin_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->stdout_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.stdout_sel");
	if (forminfo->options->create->stdout_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'stdout_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->stdout_sel = FALSE;
	selection = forminfo->options->create->stdout_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->buttons_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.buttons");
	if (forminfo->options->create->buttons_struct == NULL)
	    _xvf_init_guise_warning("unknown selection 'buttons' on pane 'create' of subform 'options'");

	forminfo->options->create->action_button_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.action_button");
	if (forminfo->options->create->action_button_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'action_button' on pane 'create' of subform 'options'");
	forminfo->options->create->action_button = FALSE;
	selection = forminfo->options->create->action_button_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->routine_button_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.routine_button");
	if (forminfo->options->create->routine_button_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'routine_button' on pane 'create' of subform 'options'");
	forminfo->options->create->routine_button = FALSE;
	selection = forminfo->options->create->routine_button_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->help_button_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.help_button");
	if (forminfo->options->create->help_button_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'help_button' on pane 'create' of subform 'options'");
	forminfo->options->create->help_button = FALSE;
	selection = forminfo->options->create->help_button_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->quit_button_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.quit_button");
	if (forminfo->options->create->quit_button_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'quit_button' on pane 'create' of subform 'options'");
	forminfo->options->create->quit_button = FALSE;
	selection = forminfo->options->create->quit_button_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->guide_button_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.guide_button");
	if (forminfo->options->create->guide_button_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'guide_button' on pane 'create' of subform 'options'");
	forminfo->options->create->guide_button = FALSE;
	selection = forminfo->options->create->guide_button_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->lists_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.lists");
	if (forminfo->options->create->lists_struct == NULL)
	    _xvf_init_guise_warning("unknown selection 'lists' on pane 'create' of subform 'options'");

	forminfo->options->create->cycle_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.cycle_sel");
	if (forminfo->options->create->cycle_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'cycle_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->cycle_sel = FALSE;
	selection = forminfo->options->create->cycle_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->list_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.list_sel");
	if (forminfo->options->create->list_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'list_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->list_sel = FALSE;
	selection = forminfo->options->create->list_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->displaylist_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.displaylist_sel");
	if (forminfo->options->create->displaylist_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'displaylist_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->displaylist_sel = FALSE;
	selection = forminfo->options->create->displaylist_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->strlist_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.strlist_sel");
	if (forminfo->options->create->strlist_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'strlist_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->strlist_sel = FALSE;
	selection = forminfo->options->create->strlist_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->toggles_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.toggles");
	if (forminfo->options->create->toggles_struct == NULL)
	    _xvf_init_guise_warning("unknown selection 'toggles' on pane 'create' of subform 'options'");

	forminfo->options->create->flag_toggle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.flag_toggle");
	if (forminfo->options->create->flag_toggle_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'flag_toggle' on pane 'create' of subform 'options'");
	forminfo->options->create->flag_toggle = FALSE;
	selection = forminfo->options->create->flag_toggle_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->logical_toggle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.logical_toggle");
	if (forminfo->options->create->logical_toggle_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'logical_toggle' on pane 'create' of subform 'options'");
	forminfo->options->create->logical_toggle = FALSE;
	selection = forminfo->options->create->logical_toggle_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->int_toggle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.int_toggle");
	if (forminfo->options->create->int_toggle_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'int_toggle' on pane 'create' of subform 'options'");
	forminfo->options->create->int_toggle = FALSE;
	selection = forminfo->options->create->int_toggle_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->flt_toggle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.flt_toggle");
	if (forminfo->options->create->flt_toggle_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'flt_toggle' on pane 'create' of subform 'options'");
	forminfo->options->create->flt_toggle = FALSE;
	selection = forminfo->options->create->flt_toggle_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->dbl_toggle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.dbl_toggle");
	if (forminfo->options->create->dbl_toggle_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'dbl_toggle' on pane 'create' of subform 'options'");
	forminfo->options->create->dbl_toggle = FALSE;
	selection = forminfo->options->create->dbl_toggle_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->str_toggle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.str_toggle");
	if (forminfo->options->create->str_toggle_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'str_toggle' on pane 'create' of subform 'options'");
	forminfo->options->create->str_toggle = FALSE;
	selection = forminfo->options->create->str_toggle_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->infile_toggle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.infile_toggle");
	if (forminfo->options->create->infile_toggle_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'infile_toggle' on pane 'create' of subform 'options'");
	forminfo->options->create->infile_toggle = FALSE;
	selection = forminfo->options->create->infile_toggle_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->outfile_toggle_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.outfile_toggle");
	if (forminfo->options->create->outfile_toggle_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'outfile_toggle' on pane 'create' of subform 'options'");
	forminfo->options->create->outfile_toggle = FALSE;
	selection = forminfo->options->create->outfile_toggle_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->wksp_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.wksp_sel");
	if (forminfo->options->create->wksp_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'wksp_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->wksp_sel = FALSE;
	selection = forminfo->options->create->wksp_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->blank_sel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.blank_sel");
	if (forminfo->options->create->blank_sel_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'blank_sel' on pane 'create' of subform 'options'");
	forminfo->options->create->blank_sel = FALSE;
	selection = forminfo->options->create->blank_sel_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->options->create->subform_button_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "guise.options.create.subform_button");
	if (forminfo->options->create->subform_button_struct == NULL)
	    _xvf_init_guise_warning("pane action button 'subform_button' on pane 'create' of subform 'options'");
	forminfo->options->create->subform_button = FALSE;
	selection = forminfo->options->create->subform_button_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_guise_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 14, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_guise_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_guise_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 14, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_guise_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_guise
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_guise_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 14, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_guise(
    gui_info_struct *forminfo)
{
	if (forminfo->options->create->license_struct != NULL)
	    kfree(forminfo->options->create->license_struct);
	if (forminfo->options->create->help_struct != NULL)
	    kfree(forminfo->options->create->help_struct);
	if (forminfo->options->create->quit_struct != NULL)
	    kfree(forminfo->options->create->quit_struct);
	kfree(forminfo->options->create->i);
	if (forminfo->options->create->i_struct != NULL)
	    kfree(forminfo->options->create->i_struct);
	if (forminfo->options->create->save_struct != NULL)
	    kfree(forminfo->options->create->save_struct);
	if (forminfo->options->create->reload_struct != NULL)
	    kfree(forminfo->options->create->reload_struct);
	if (forminfo->options->create->edit_struct != NULL)
	    kfree(forminfo->options->create->edit_struct);
	if (forminfo->options->create->new_struct != NULL)
	    kfree(forminfo->options->create->new_struct);
	if (forminfo->options->create->options_struct != NULL)
	    kfree(forminfo->options->create->options_struct);
	if (forminfo->options->create->copy_struct != NULL)
	    kfree(forminfo->options->create->copy_struct);
	if (forminfo->options->create->menuform_struct != NULL)
	    kfree(forminfo->options->create->menuform_struct);
	if (forminfo->options->create->delete_struct != NULL)
	    kfree(forminfo->options->create->delete_struct);
	if (forminfo->options->create->grouping_struct != NULL)
	    kfree(forminfo->options->create->grouping_struct);
	if (forminfo->options->create->submenu_struct != NULL)
	    kfree(forminfo->options->create->submenu_struct);
	if (forminfo->options->create->me_group_req_struct != NULL)
	    kfree(forminfo->options->create->me_group_req_struct);
	if (forminfo->options->create->me_group_opt_struct != NULL)
	    kfree(forminfo->options->create->me_group_opt_struct);
	if (forminfo->options->create->mi_group_struct != NULL)
	    kfree(forminfo->options->create->mi_group_struct);
	if (forminfo->options->create->ls_group_struct != NULL)
	    kfree(forminfo->options->create->ls_group_struct);
	kfree(forminfo->options->create->o);
	if (forminfo->options->create->o_struct != NULL)
	    kfree(forminfo->options->create->o_struct);
	if (forminfo->options->create->control_dest_struct != NULL)
	    kfree(forminfo->options->create->control_dest_struct);
	if (forminfo->options->create->force_struct != NULL)
	    kfree(forminfo->options->create->force_struct);
	kfree(forminfo->options->create->force_label);
	if (forminfo->options->create->simples_struct != NULL)
	    kfree(forminfo->options->create->simples_struct);
	if (forminfo->options->create->int_sel_struct != NULL)
	    kfree(forminfo->options->create->int_sel_struct);
	if (forminfo->options->create->float_sel_struct != NULL)
	    kfree(forminfo->options->create->float_sel_struct);
	if (forminfo->options->create->double_sel_struct != NULL)
	    kfree(forminfo->options->create->double_sel_struct);
	if (forminfo->options->create->string_sel_struct != NULL)
	    kfree(forminfo->options->create->string_sel_struct);
	if (forminfo->options->create->flag_sel_struct != NULL)
	    kfree(forminfo->options->create->flag_sel_struct);
	if (forminfo->options->create->logic_sel_struct != NULL)
	    kfree(forminfo->options->create->logic_sel_struct);
	if (forminfo->options->create->files_struct != NULL)
	    kfree(forminfo->options->create->files_struct);
	if (forminfo->options->create->infile_sel_struct != NULL)
	    kfree(forminfo->options->create->infile_sel_struct);
	if (forminfo->options->create->outfile_sel_struct != NULL)
	    kfree(forminfo->options->create->outfile_sel_struct);
	if (forminfo->options->create->stdin_sel_struct != NULL)
	    kfree(forminfo->options->create->stdin_sel_struct);
	if (forminfo->options->create->stdout_sel_struct != NULL)
	    kfree(forminfo->options->create->stdout_sel_struct);
	if (forminfo->options->create->buttons_struct != NULL)
	    kfree(forminfo->options->create->buttons_struct);
	if (forminfo->options->create->action_button_struct != NULL)
	    kfree(forminfo->options->create->action_button_struct);
	if (forminfo->options->create->routine_button_struct != NULL)
	    kfree(forminfo->options->create->routine_button_struct);
	if (forminfo->options->create->help_button_struct != NULL)
	    kfree(forminfo->options->create->help_button_struct);
	if (forminfo->options->create->quit_button_struct != NULL)
	    kfree(forminfo->options->create->quit_button_struct);
	if (forminfo->options->create->guide_button_struct != NULL)
	    kfree(forminfo->options->create->guide_button_struct);
	if (forminfo->options->create->lists_struct != NULL)
	    kfree(forminfo->options->create->lists_struct);
	if (forminfo->options->create->cycle_sel_struct != NULL)
	    kfree(forminfo->options->create->cycle_sel_struct);
	if (forminfo->options->create->list_sel_struct != NULL)
	    kfree(forminfo->options->create->list_sel_struct);
	if (forminfo->options->create->displaylist_sel_struct != NULL)
	    kfree(forminfo->options->create->displaylist_sel_struct);
	if (forminfo->options->create->strlist_sel_struct != NULL)
	    kfree(forminfo->options->create->strlist_sel_struct);
	if (forminfo->options->create->toggles_struct != NULL)
	    kfree(forminfo->options->create->toggles_struct);
	if (forminfo->options->create->flag_toggle_struct != NULL)
	    kfree(forminfo->options->create->flag_toggle_struct);
	if (forminfo->options->create->logical_toggle_struct != NULL)
	    kfree(forminfo->options->create->logical_toggle_struct);
	if (forminfo->options->create->int_toggle_struct != NULL)
	    kfree(forminfo->options->create->int_toggle_struct);
	if (forminfo->options->create->flt_toggle_struct != NULL)
	    kfree(forminfo->options->create->flt_toggle_struct);
	if (forminfo->options->create->dbl_toggle_struct != NULL)
	    kfree(forminfo->options->create->dbl_toggle_struct);
	if (forminfo->options->create->str_toggle_struct != NULL)
	    kfree(forminfo->options->create->str_toggle_struct);
	if (forminfo->options->create->infile_toggle_struct != NULL)
	    kfree(forminfo->options->create->infile_toggle_struct);
	if (forminfo->options->create->outfile_toggle_struct != NULL)
	    kfree(forminfo->options->create->outfile_toggle_struct);
	if (forminfo->options->create->wksp_sel_struct != NULL)
	    kfree(forminfo->options->create->wksp_sel_struct);
	if (forminfo->options->create->blank_sel_struct != NULL)
	    kfree(forminfo->options->create->blank_sel_struct);
	if (forminfo->options->create->subform_button_struct != NULL)
	    kfree(forminfo->options->create->subform_button_struct);
	kfree(forminfo->options->create);
	if (forminfo->options->create_struct != NULL)
	    kfree(forminfo->options->create_struct);


	if (forminfo->options_struct != NULL)
	    kfree(forminfo->options_struct);
	kfree(forminfo->options);
	kfree(forminfo);
}
