 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Extraction Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_get_craftsman
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_get_preferences
   >>>> 	_xvf_get_types
   >>>> 	_xvf_get_console
   >>>> 	_xvf_get_conspane
   >>>> 	_xvf_get_newtb
   >>>> 	_xvf_get_mktb
   >>>> 	_xvf_get_tbaddref
   >>>> 	_xvf_get_addref
   >>>> 	_xvf_get_tbattrs
   >>>> 	_xvf_get_strings
   >>>> 	_xvf_get_keywords
   >>>> 	_xvf_get_flags
   >>>> 	_xvf_get_copyright
   >>>> 	_xvf_get_files
   >>>> 	_xvf_get_template
   >>>> 	_xvf_get_kroutine
   >>>> 	_xvf_get_xvroutine
   >>>> 	_xvf_get_library
   >>>> 	_xvf_get_script
   >>>> 	_xvf_get_pane
   >>>> 	_xvf_get_obj_attributes
   >>>> 	_xvf_get_obj_attrs
   >>>> 	_xvf_get_obj_keywords
   >>>> 	_xvf_get_paneattrs
   >>>> 	_xvf_get_copyobject
   >>>> 	_xvf_get_copy
   >>>> 	_xvf_get_mvobject
   >>>> 	_xvf_get_move
   >>>> 	_xvf_get_rename_obj
   >>>> 	_xvf_get_rename
   >>>> 	_xvf_get_objinfo
   >>>> 	_xvf_get_infopane
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_craftsman
| 
|       Purpose: Extracts information from GUI
| 
|         Input: forminfo - pointer to gui_info_struct
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_craftsman(
     gui_info_struct *forminfo)
{
	kselection *selection;
	ksubform   *subform;
	if (forminfo->quit_struct != NULL)
	{
	    selection = forminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->quit));

	}

	if (forminfo->tblist_struct != NULL)
	{
	    selection = forminfo->tblist_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(forminfo->tblist));
	    if (forminfo->tblist_label != NULL) kfree(forminfo->tblist_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(forminfo->tblist_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->tblist_selected));
	    }

	}

	if (forminfo->objlist_struct != NULL)
	{
	    selection = forminfo->objlist_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(forminfo->objlist));
	    if (forminfo->objlist_label != NULL) kfree(forminfo->objlist_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(forminfo->objlist_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->objlist_selected));
	    forminfo->objlist_dblclick = selection->prev_selected;
	    }

	}

	if (forminfo->mkmanual_struct != NULL)
	{
	    selection = forminfo->mkmanual_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->mkmanual));

	}

	if (forminfo->dereftb_struct != NULL)
	{
	    selection = forminfo->dereftb_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->dereftb));

	}

	if (forminfo->klinttb_struct != NULL)
	{
	    selection = forminfo->klinttb_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->klinttb));

	}

	if (forminfo->rmtb_struct != NULL)
	{
	    selection = forminfo->rmtb_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->rmtb));

	}

	if (forminfo->open_struct != NULL)
	{
	    selection = forminfo->open_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->open));

	}

	if (forminfo->klintobj_struct != NULL)
	{
	    selection = forminfo->klintobj_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->klintobj));

	}

	if (forminfo->delete_struct != NULL)
	{
	    selection = forminfo->delete_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->delete));

	}

	if (forminfo->preferences_struct != NULL)
	{
	    subform = forminfo->preferences_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->preferences_selected));
	    _xvf_get_preferences(forminfo->preferences);

	}
	if (forminfo->console_struct != NULL)
	{
	    subform = forminfo->console_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->console_selected));
	    _xvf_get_console(forminfo->console);

	}
	if (forminfo->newtb_struct != NULL)
	{
	    subform = forminfo->newtb_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->newtb_selected));
	    _xvf_get_newtb(forminfo->newtb);

	}
	if (forminfo->tbaddref_struct != NULL)
	{
	    subform = forminfo->tbaddref_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->tbaddref_selected));
	    _xvf_get_tbaddref(forminfo->tbaddref);

	}
	if (forminfo->tbattrs_struct != NULL)
	{
	    subform = forminfo->tbattrs_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->tbattrs_selected));
	    _xvf_get_tbattrs(forminfo->tbattrs);

	}
	if (forminfo->template_struct != NULL)
	{
	    subform = forminfo->template_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->template_selected));
	    _xvf_get_template(forminfo->template);

	}
	if (forminfo->obj_attributes_struct != NULL)
	{
	    subform = forminfo->obj_attributes_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->obj_attributes_selected));
	    _xvf_get_obj_attributes(forminfo->obj_attributes);

	}
	if (forminfo->copyobject_struct != NULL)
	{
	    subform = forminfo->copyobject_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->copyobject_selected));
	    _xvf_get_copyobject(forminfo->copyobject);

	}
	if (forminfo->mvobject_struct != NULL)
	{
	    subform = forminfo->mvobject_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->mvobject_selected));
	    _xvf_get_mvobject(forminfo->mvobject);

	}
	if (forminfo->rename_obj_struct != NULL)
	{
	    subform = forminfo->rename_obj_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->rename_obj_selected));
	    _xvf_get_rename_obj(forminfo->rename_obj);

	}
	if (forminfo->objinfo_struct != NULL)
	{
	    subform = forminfo->objinfo_struct->Subformptr;
	    kvf_get_attribute(subform->back_kformstruct, KVF_SELECTED,
	                    &(forminfo->objinfo_selected));
	    _xvf_get_objinfo(forminfo->objinfo);

	}

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_preferences
| 
|       Purpose: Extracts information from preferences subform
| 
|         Input: subforminfo - pointer to craftsman_preferences structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_preferences(
     craftsman_preferences *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->types_struct != NULL)
	{
	    pane = subforminfo->types_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->types_selected));
	    _xvf_get_types(subforminfo->types);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_types
| 
|       Purpose: Extracts information from types pane
| 
|         Input: paneinfo - pointer to preferences_types structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_types(
     preferences_types *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->preferences->types' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->objtypes_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->objtypes_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->objtypes_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->objtypes_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->objtypes_selected));
	    }

	}

	if (paneinfo->cattype_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->cattype_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->cattype_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->cattype_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->cattype_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_console
| 
|       Purpose: Extracts information from console subform
| 
|         Input: subforminfo - pointer to craftsman_console structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_console(
     craftsman_console *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->conspane_struct != NULL)
	{
	    pane = subforminfo->conspane_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->conspane_selected));
	    _xvf_get_conspane(subforminfo->conspane);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_conspane
| 
|       Purpose: Extracts information from conspane pane
| 
|         Input: paneinfo - pointer to console_conspane structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_conspane(
     console_conspane *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->console->conspane' Pane Info structure
	 */

	if (paneinfo->clear_struct != NULL)
	{
	    selection = paneinfo->clear_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->clear));

	}

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->workspace_struct != NULL)
	{
	    selection = paneinfo->workspace_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_WORKSPACE,
	                    &(paneinfo->workspace));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_newtb
| 
|       Purpose: Extracts information from newtb subform
| 
|         Input: subforminfo - pointer to craftsman_newtb structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_newtb(
     craftsman_newtb *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->mktb_struct != NULL)
	{
	    pane = subforminfo->mktb_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->mktb_selected));
	    _xvf_get_mktb(subforminfo->mktb);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_mktb
| 
|       Purpose: Extracts information from mktb pane
| 
|         Input: paneinfo - pointer to newtb_mktb structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_mktb(
     newtb_mktb *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->newtb->mktb' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->tbname_struct != NULL)
	{
	    selection = paneinfo->tbname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbname != NULL) kfree(paneinfo->tbname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbname));
	    }

	}

	if (paneinfo->tbpath_struct != NULL)
	{
	    selection = paneinfo->tbpath_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbpath != NULL) kfree(paneinfo->tbpath);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbpath));
	    }

	}

	if (paneinfo->tbtitle_struct != NULL)
	{
	    selection = paneinfo->tbtitle_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbtitle != NULL) kfree(paneinfo->tbtitle);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbtitle));
	    }

	}

	if (paneinfo->name_struct != NULL)
	{
	    selection = paneinfo->name_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->name != NULL) kfree(paneinfo->name);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->name));
	    }

	}

	if (paneinfo->email_struct != NULL)
	{
	    selection = paneinfo->email_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->email != NULL) kfree(paneinfo->email);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->email));
	    }

	}

	if (paneinfo->tbstatus_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->tbstatus_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->tbstatus_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->tbstatus_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->createtb_struct != NULL)
	{
	    selection = paneinfo->createtb_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->createtb));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_tbaddref
| 
|       Purpose: Extracts information from tbaddref subform
| 
|         Input: subforminfo - pointer to craftsman_tbaddref structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_tbaddref(
     craftsman_tbaddref *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->addref_struct != NULL)
	{
	    pane = subforminfo->addref_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->addref_selected));
	    _xvf_get_addref(subforminfo->addref);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_addref
| 
|       Purpose: Extracts information from addref pane
| 
|         Input: paneinfo - pointer to tbaddref_addref structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_addref(
     tbaddref_addref *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->tbaddref->addref' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->tbname_struct != NULL)
	{
	    selection = paneinfo->tbname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbname != NULL) kfree(paneinfo->tbname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbname));
	    }

	}

	if (paneinfo->tbpath_struct != NULL)
	{
	    selection = paneinfo->tbpath_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbpath != NULL) kfree(paneinfo->tbpath);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbpath));
	    }

	}

	if (paneinfo->addit_struct != NULL)
	{
	    selection = paneinfo->addit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->addit));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_tbattrs
| 
|       Purpose: Extracts information from tbattrs subform
| 
|         Input: subforminfo - pointer to craftsman_tbattrs structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_tbattrs(
     craftsman_tbattrs *subforminfo)
{
	kselection *selection;
	kcontrol   *pane;
	if (subforminfo->quit_struct != NULL)
	{
	    selection = subforminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->quit));

	}

	if (subforminfo->strings_struct != NULL)
	{
	    pane = subforminfo->strings_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->strings_selected));
	    _xvf_get_strings(subforminfo->strings);
	}

	if (subforminfo->keywords_struct != NULL)
	{
	    pane = subforminfo->keywords_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->keywords_selected));
	    _xvf_get_keywords(subforminfo->keywords);
	}

	if (subforminfo->flags_struct != NULL)
	{
	    pane = subforminfo->flags_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->flags_selected));
	    _xvf_get_flags(subforminfo->flags);
	}

	if (subforminfo->copyright_struct != NULL)
	{
	    pane = subforminfo->copyright_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->copyright_selected));
	    _xvf_get_copyright(subforminfo->copyright);
	}

	if (subforminfo->files_struct != NULL)
	{
	    pane = subforminfo->files_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->files_selected));
	    _xvf_get_files(subforminfo->files);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_strings
| 
|       Purpose: Extracts information from strings pane
| 
|         Input: paneinfo - pointer to tbattrs_strings structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_strings(
     tbattrs_strings *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->tbattrs->strings' Pane Info structure
	 */

	if (paneinfo->tbtitle_struct != NULL)
	{
	    selection = paneinfo->tbtitle_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbtitle != NULL) kfree(paneinfo->tbtitle);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbtitle));
	    }

	}

	if (paneinfo->authname_struct != NULL)
	{
	    selection = paneinfo->authname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->authname != NULL) kfree(paneinfo->authname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->authname));
	    }

	}

	if (paneinfo->authemail_struct != NULL)
	{
	    selection = paneinfo->authemail_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->authemail != NULL) kfree(paneinfo->authemail);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->authemail));
	    }

	}

	if (paneinfo->apply_struct != NULL)
	{
	    selection = paneinfo->apply_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->apply));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_keywords
| 
|       Purpose: Extracts information from keywords pane
| 
|         Input: paneinfo - pointer to tbattrs_keywords structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_keywords(
     tbattrs_keywords *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->tbattrs->keywords' Pane Info structure
	 */

	if (paneinfo->keylist_struct != NULL)
	{
	    selection = paneinfo->keylist_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->keylist));
	    if (paneinfo->keylist_label != NULL) kfree(paneinfo->keylist_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->keylist_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->keylist_selected));
	    }

	}

	if (paneinfo->delete_struct != NULL)
	{
	    selection = paneinfo->delete_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->delete));

	}

	if (paneinfo->addkey_struct != NULL)
	{
	    selection = paneinfo->addkey_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->addkey != NULL) kfree(paneinfo->addkey);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->addkey));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->addkey_selected));
	    }

	}

	if (paneinfo->chkey_struct != NULL)
	{
	    selection = paneinfo->chkey_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->chkey != NULL) kfree(paneinfo->chkey);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->chkey));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->chkey_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_flags
| 
|       Purpose: Extracts information from flags pane
| 
|         Input: paneinfo - pointer to tbattrs_flags structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_flags(
     tbattrs_flags *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->tbattrs->flags' Pane Info structure
	 */

	if (paneinfo->tbstatus_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->tbstatus_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->tbstatus_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->tbstatus_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->flags_apply_struct != NULL)
	{
	    selection = paneinfo->flags_apply_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->flags_apply));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_copyright
| 
|       Purpose: Extracts information from copyright pane
| 
|         Input: paneinfo - pointer to tbattrs_copyright structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_copyright(
     tbattrs_copyright *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->tbattrs->copyright' Pane Info structure
	 */

	if (paneinfo->short_copyright_struct != NULL)
	{
	    selection = paneinfo->short_copyright_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->short_copyright != NULL) kfree(paneinfo->short_copyright);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->short_copyright));
	    }

	}

	if (paneinfo->long_copyright_struct != NULL)
	{
	    selection = paneinfo->long_copyright_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->long_copyright != NULL) kfree(paneinfo->long_copyright);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->long_copyright));
	    }

	}

	if (paneinfo->copyright_apply_struct != NULL)
	{
	    selection = paneinfo->copyright_apply_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->copyright_apply));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_files
| 
|       Purpose: Extracts information from files pane
| 
|         Input: paneinfo - pointer to tbattrs_files structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_files(
     tbattrs_files *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->tbattrs->files' Pane Info structure
	 */

	if (paneinfo->config_struct != NULL)
	{
	    selection = paneinfo->config_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->config));

	}

	if (paneinfo->tbinclude_struct != NULL)
	{
	    selection = paneinfo->tbinclude_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->tbinclude));

	}

	if (paneinfo->tbinfo_struct != NULL)
	{
	    selection = paneinfo->tbinfo_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->tbinfo));

	}

	if (paneinfo->tbaliases_struct != NULL)
	{
	    selection = paneinfo->tbaliases_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->tbaliases));

	}

	if (paneinfo->tbtodo_struct != NULL)
	{
	    selection = paneinfo->tbtodo_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->tbtodo));

	}

	if (paneinfo->tbchangelog_struct != NULL)
	{
	    selection = paneinfo->tbchangelog_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->tbchangelog));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_template
| 
|       Purpose: Extracts information from template subform
| 
|         Input: subforminfo - pointer to craftsman_template structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_template(
     craftsman_template *subforminfo)
{
	kselection *selection;
	kcontrol   *pane;
	if (subforminfo->quit_struct != NULL)
	{
	    selection = subforminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->quit));

	}

	if (subforminfo->obj_name_struct != NULL)
	{
	    selection = subforminfo->obj_name_struct->Selptr;
	    if (selection->modified)
	    {
	    if (subforminfo->obj_name != NULL) kfree(subforminfo->obj_name);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(subforminfo->obj_name));
	    }

	}

	if (subforminfo->bname_struct != NULL)
	{
	    selection = subforminfo->bname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (subforminfo->bname != NULL) kfree(subforminfo->bname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(subforminfo->bname));
	    }

	}

	if (subforminfo->icon_name_struct != NULL)
	{
	    selection = subforminfo->icon_name_struct->Selptr;
	    if (selection->modified)
	    {
	    if (subforminfo->icon_name != NULL) kfree(subforminfo->icon_name);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(subforminfo->icon_name));
	    }

	}

	if (subforminfo->author_struct != NULL)
	{
	    selection = subforminfo->author_struct->Selptr;
	    if (selection->modified)
	    {
	    if (subforminfo->author != NULL) kfree(subforminfo->author);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(subforminfo->author));
	    }

	}

	if (subforminfo->email_struct != NULL)
	{
	    selection = subforminfo->email_struct->Selptr;
	    if (selection->modified)
	    {
	    if (subforminfo->email != NULL) kfree(subforminfo->email);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(subforminfo->email));
	    }

	}

	if (subforminfo->category_struct != NULL)
	{
	    selection = subforminfo->category_struct->Selptr;
	    if (selection->modified)
	    {
	    if (subforminfo->category != NULL) kfree(subforminfo->category);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(subforminfo->category));
	    }

	}

	if (subforminfo->subcategory_struct != NULL)
	{
	    selection = subforminfo->subcategory_struct->Selptr;
	    if (selection->modified)
	    {
	    if (subforminfo->subcategory != NULL) kfree(subforminfo->subcategory);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(subforminfo->subcategory));
	    }

	}

	if (subforminfo->description_struct != NULL)
	{
	    selection = subforminfo->description_struct->Selptr;
	    if (selection->modified)
	    {
	    if (subforminfo->description != NULL) kfree(subforminfo->description);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(subforminfo->description));
	    }

	}

	if (subforminfo->kroutine_struct != NULL)
	{
	    pane = subforminfo->kroutine_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->kroutine_selected));
	    _xvf_get_kroutine(subforminfo->kroutine);
	}

	if (subforminfo->xvroutine_struct != NULL)
	{
	    pane = subforminfo->xvroutine_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->xvroutine_selected));
	    _xvf_get_xvroutine(subforminfo->xvroutine);
	}

	if (subforminfo->library_struct != NULL)
	{
	    pane = subforminfo->library_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->library_selected));
	    _xvf_get_library(subforminfo->library);
	}

	if (subforminfo->script_struct != NULL)
	{
	    pane = subforminfo->script_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->script_selected));
	    _xvf_get_script(subforminfo->script);
	}

	if (subforminfo->pane_struct != NULL)
	{
	    pane = subforminfo->pane_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->pane_selected));
	    _xvf_get_pane(subforminfo->pane);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_kroutine
| 
|       Purpose: Extracts information from kroutine pane
| 
|         Input: paneinfo - pointer to template_kroutine structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_kroutine(
     template_kroutine *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->template->kroutine' Pane Info structure
	 */

	if (paneinfo->incantata_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->incantata_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->incantata_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->incantata_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->lib_routine_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->lib_routine_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->lib_routine_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->lib_routine_val = atoi(value_string);
	    kfree(value_string);
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->lib_routine_selected));
	    }

	}

	if (paneinfo->lib_list_struct != NULL)
	{
	    selection = paneinfo->lib_list_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->lib_list != NULL) kfree(paneinfo->lib_list);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->lib_list));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->lib_list_selected));
	    }

	}

	if (paneinfo->create_kroutine_struct != NULL)
	{
	    selection = paneinfo->create_kroutine_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->create_kroutine));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_xvroutine
| 
|       Purpose: Extracts information from xvroutine pane
| 
|         Input: paneinfo - pointer to template_xvroutine structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_xvroutine(
     template_xvroutine *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->template->xvroutine' Pane Info structure
	 */

	if (paneinfo->incantata_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->incantata_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->incantata_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->incantata_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->useform_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->useform_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->useform_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->useform_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->create_xvroutine_struct != NULL)
	{
	    selection = paneinfo->create_xvroutine_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->create_xvroutine));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_library
| 
|       Purpose: Extracts information from library pane
| 
|         Input: paneinfo - pointer to template_library structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_library(
     template_library *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->template->library' Pane Info structure
	 */

	if (paneinfo->create_library_struct != NULL)
	{
	    selection = paneinfo->create_library_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->create_library));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_script
| 
|       Purpose: Extracts information from script pane
| 
|         Input: paneinfo - pointer to template_script structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_script(
     template_script *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->template->script' Pane Info structure
	 */

	if (paneinfo->lang_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->lang_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->lang_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->lang_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->wantpane_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->wantpane_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->wantpane_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->wantpane_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->incantata_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->incantata_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->incantata_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->incantata_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->create_script_struct != NULL)
	{
	    selection = paneinfo->create_script_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->create_script));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_pane
| 
|       Purpose: Extracts information from pane pane
| 
|         Input: paneinfo - pointer to template_pane structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_pane(
     template_pane *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->template->pane' Pane Info structure
	 */

	if (paneinfo->incantata_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->incantata_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->incantata_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->incantata_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->genexec_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->genexec_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->genexec_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->genexec_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->tbname_struct != NULL)
	{
	    selection = paneinfo->tbname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbname != NULL) kfree(paneinfo->tbname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbname));
	    }

	}

	if (paneinfo->oname_struct != NULL)
	{
	    selection = paneinfo->oname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->oname != NULL) kfree(paneinfo->oname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->oname));
	    }

	}

	if (paneinfo->args_struct != NULL)
	{
	    selection = paneinfo->args_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->args != NULL) kfree(paneinfo->args);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->args));
	    }

	}

	if (paneinfo->create_pane_struct != NULL)
	{
	    selection = paneinfo->create_pane_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->create_pane));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_obj_attributes
| 
|       Purpose: Extracts information from obj_attributes subform
| 
|         Input: subforminfo - pointer to craftsman_obj_attributes structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_obj_attributes(
     craftsman_obj_attributes *subforminfo)
{
	kselection *selection;
	kcontrol   *pane;
	if (subforminfo->quit_struct != NULL)
	{
	    selection = subforminfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->quit));

	}

	if (subforminfo->obj_attrs_struct != NULL)
	{
	    pane = subforminfo->obj_attrs_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->obj_attrs_selected));
	    _xvf_get_obj_attrs(subforminfo->obj_attrs);
	}

	if (subforminfo->obj_keywords_struct != NULL)
	{
	    pane = subforminfo->obj_keywords_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->obj_keywords_selected));
	    _xvf_get_obj_keywords(subforminfo->obj_keywords);
	}

	if (subforminfo->paneattrs_struct != NULL)
	{
	    pane = subforminfo->paneattrs_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->paneattrs_selected));
	    _xvf_get_paneattrs(subforminfo->paneattrs);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_obj_attrs
| 
|       Purpose: Extracts information from obj_attrs pane
| 
|         Input: paneinfo - pointer to obj_attributes_obj_attrs structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_obj_attrs(
     obj_attributes_obj_attrs *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->obj_attributes->obj_attrs' Pane Info structure
	 */

	if (paneinfo->description_struct != NULL)
	{
	    selection = paneinfo->description_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->description != NULL) kfree(paneinfo->description);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->description));
	    }

	}

	if (paneinfo->category_struct != NULL)
	{
	    selection = paneinfo->category_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->category != NULL) kfree(paneinfo->category);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->category));
	    }

	}

	if (paneinfo->subcategory_struct != NULL)
	{
	    selection = paneinfo->subcategory_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->subcategory != NULL) kfree(paneinfo->subcategory);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->subcategory));
	    }

	}

	if (paneinfo->icon_name_struct != NULL)
	{
	    selection = paneinfo->icon_name_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->icon_name != NULL) kfree(paneinfo->icon_name);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->icon_name));
	    }

	}

	if (paneinfo->name_struct != NULL)
	{
	    selection = paneinfo->name_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->name != NULL) kfree(paneinfo->name);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->name));
	    }

	}

	if (paneinfo->email_struct != NULL)
	{
	    selection = paneinfo->email_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->email != NULL) kfree(paneinfo->email);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->email));
	    }

	}

	if (paneinfo->install_in_cantata_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->install_in_cantata_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->install_in_cantata_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->install_in_cantata_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->apply_struct != NULL)
	{
	    selection = paneinfo->apply_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->apply));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_obj_keywords
| 
|       Purpose: Extracts information from obj_keywords pane
| 
|         Input: paneinfo - pointer to obj_attributes_obj_keywords structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_obj_keywords(
     obj_attributes_obj_keywords *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->obj_attributes->obj_keywords' Pane Info structure
	 */

	if (paneinfo->keylist_struct != NULL)
	{
	    selection = paneinfo->keylist_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_VAL,
	                    &(paneinfo->keylist));
	    if (paneinfo->keylist_label != NULL) kfree(paneinfo->keylist_label);
	    kvf_get_attribute(selection->back_kformstruct, KVF_LIST_LABEL,
	                    &(paneinfo->keylist_label));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->keylist_selected));
	    }

	}

	if (paneinfo->delete_struct != NULL)
	{
	    selection = paneinfo->delete_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->delete));

	}

	if (paneinfo->addkey_struct != NULL)
	{
	    selection = paneinfo->addkey_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->addkey != NULL) kfree(paneinfo->addkey);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->addkey));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->addkey_selected));
	    }

	}

	if (paneinfo->chkey_struct != NULL)
	{
	    selection = paneinfo->chkey_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->chkey != NULL) kfree(paneinfo->chkey);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->chkey));
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->chkey_selected));
	    }

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_paneattrs
| 
|       Purpose: Extracts information from paneattrs pane
| 
|         Input: paneinfo - pointer to obj_attributes_paneattrs structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_paneattrs(
     obj_attributes_paneattrs *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->obj_attributes->paneattrs' Pane Info structure
	 */

	if (paneinfo->tbname_struct != NULL)
	{
	    selection = paneinfo->tbname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->tbname != NULL) kfree(paneinfo->tbname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->tbname));
	    }

	}

	if (paneinfo->oname_struct != NULL)
	{
	    selection = paneinfo->oname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->oname != NULL) kfree(paneinfo->oname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->oname));
	    }

	}

	if (paneinfo->args_struct != NULL)
	{
	    selection = paneinfo->args_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->args != NULL) kfree(paneinfo->args);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->args));
	    }

	}

	if (paneinfo->genexec_struct != NULL)
	{
	    char *value_string;
	    selection = paneinfo->genexec_struct->Selptr;
	    if (selection->modified)
	    {
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_NUM,
	                    &(paneinfo->genexec_num));
	    kvf_get_attribute(selection->back_kformstruct, KVF_TOGGLE_VAL,
	                    &(value_string));
	    paneinfo->genexec_val = atoi(value_string);
	    kfree(value_string);
	    }

	}

	if (paneinfo->apply_struct != NULL)
	{
	    selection = paneinfo->apply_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->apply));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_copyobject
| 
|       Purpose: Extracts information from copyobject subform
| 
|         Input: subforminfo - pointer to craftsman_copyobject structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_copyobject(
     craftsman_copyobject *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->copy_struct != NULL)
	{
	    pane = subforminfo->copy_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->copy_selected));
	    _xvf_get_copy(subforminfo->copy);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_copy
| 
|       Purpose: Extracts information from copy pane
| 
|         Input: paneinfo - pointer to copyobject_copy structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_copy(
     copyobject_copy *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->copyobject->copy' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->desttb_struct != NULL)
	{
	    selection = paneinfo->desttb_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->desttb != NULL) kfree(paneinfo->desttb);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->desttb));
	    }

	}

	if (paneinfo->docopy_struct != NULL)
	{
	    selection = paneinfo->docopy_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->docopy));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_mvobject
| 
|       Purpose: Extracts information from mvobject subform
| 
|         Input: subforminfo - pointer to craftsman_mvobject structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_mvobject(
     craftsman_mvobject *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->move_struct != NULL)
	{
	    pane = subforminfo->move_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->move_selected));
	    _xvf_get_move(subforminfo->move);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_move
| 
|       Purpose: Extracts information from move pane
| 
|         Input: paneinfo - pointer to mvobject_move structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_move(
     mvobject_move *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->mvobject->move' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->desttb_struct != NULL)
	{
	    selection = paneinfo->desttb_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->desttb != NULL) kfree(paneinfo->desttb);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->desttb));
	    }

	}

	if (paneinfo->domove_struct != NULL)
	{
	    selection = paneinfo->domove_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->domove));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_rename_obj
| 
|       Purpose: Extracts information from rename_obj subform
| 
|         Input: subforminfo - pointer to craftsman_rename_obj structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_rename_obj(
     craftsman_rename_obj *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->rename_struct != NULL)
	{
	    pane = subforminfo->rename_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->rename_selected));
	    _xvf_get_rename(subforminfo->rename);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_rename
| 
|       Purpose: Extracts information from rename pane
| 
|         Input: paneinfo - pointer to rename_obj_rename structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_rename(
     rename_obj_rename *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->rename_obj->rename' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->newname_struct != NULL)
	{
	    selection = paneinfo->newname_struct->Selptr;
	    if (selection->modified)
	    {
	    if (paneinfo->newname != NULL) kfree(paneinfo->newname);
	    kvf_get_attribute(selection->back_kformstruct, KVF_STRING_VAL,
	                    &(paneinfo->newname));
	    }

	}

	if (paneinfo->dorename_struct != NULL)
	{
	    selection = paneinfo->dorename_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->dorename));

	}

}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_objinfo
| 
|       Purpose: Extracts information from objinfo subform
| 
|         Input: subforminfo - pointer to craftsman_objinfo structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_objinfo(
     craftsman_objinfo *subforminfo)
{
	kcontrol   *pane;
	if (subforminfo->infopane_struct != NULL)
	{
	    pane = subforminfo->infopane_struct->Controlptr;
	    kvf_get_attribute(pane->back_kformstruct, KVF_SELECTED,
	                    &(subforminfo->infopane_selected));
	    _xvf_get_infopane(subforminfo->infopane);
	}


}



/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_get_infopane
| 
|       Purpose: Extracts information from infopane pane
| 
|         Input: paneinfo - pointer to objinfo_infopane structure
| 
|        Output: none
|    Written By: conductor -name craftsman -l 1
|          Date: Apr 27, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void _xvf_get_infopane(
     objinfo_infopane *paneinfo)
{
	kselection *selection;

	/*
	 * extracting 'craftsman->objinfo->infopane' Pane Info structure
	 */

	if (paneinfo->quit_struct != NULL)
	{
	    selection = paneinfo->quit_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->quit));

	}

	if (paneinfo->todo_struct != NULL)
	{
	    selection = paneinfo->todo_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->todo));

	}

	if (paneinfo->crtodo_struct != NULL)
	{
	    selection = paneinfo->crtodo_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->crtodo));

	}

	if (paneinfo->bugs_struct != NULL)
	{
	    selection = paneinfo->bugs_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->bugs));

	}

	if (paneinfo->crbugs_struct != NULL)
	{
	    selection = paneinfo->crbugs_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->crbugs));

	}

	if (paneinfo->done_struct != NULL)
	{
	    selection = paneinfo->done_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->done));

	}

	if (paneinfo->crdone_struct != NULL)
	{
	    selection = paneinfo->crdone_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->crdone));

	}

	if (paneinfo->changelog_struct != NULL)
	{
	    selection = paneinfo->changelog_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->changelog));

	}

	if (paneinfo->crchangelog_struct != NULL)
	{
	    selection = paneinfo->crchangelog_struct->Selptr;
	    kvf_get_attribute(selection->back_kformstruct, KVF_SELECTED,
	                    &(paneinfo->crchangelog));

	}

}


