/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane types
   >>>> 
   >>>>  Private: 
   >>>> 	types_objtypes
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name: types_objtypes
| 
| Purpose:	This function is called when the user selects one of the
|		object types, or "all", on the Preferences subform.
| 
| Input:	types_info - ptr to PaneInfo struct for types pane
| 
| Written By:	Neil Bowers
| Date:		7-jul-1995
------------------------------------------------------------*/
/* ARGSUSED */
void
types_objtypes(
   preferences_types *types_info)
{
   update_object_list();
}


/*-----------------------------------------------------------
| Routine Name:	types_cattype - specify where to get cats & subcats from
| 
| Purpose:	Do routine which is called when
|		toggle selection cattype is used
| 
| Input:	types_info - ptr to PaneInfo struct for types pane
| 
| Written By:	Neil Bowers
| Date:		16-mar-1995
------------------------------------------------------------*/
/* ARGSUSED */
void types_cattype(
     preferences_types *types_info)
{
   static int  initialize_global = 0;


   if (types_info->cattype_num == 1)
      update_categories();
   else if (types_info->cattype_num == 2)
   {
      if (initialize_global == 0)
      {
	 xvw_set_attributes(xvoNotifier,
			    XVW_NOTIFYWINDOW_VISIBLE, TRUE,
			    XVW_NOTIFYWINDOW_MESSAGE,
			    "loading all categories and subcategories",
			    NULL);
	 (void)kcms_foreach(NULL, craftsman_load_categories, KOBJ_CMSTB, TRUE);
	 xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
	 initialize_global = 1;
      }

      pstrCategories = karray_sort(pstrCategories, nCategories, FALSE);
      pstrSubcategories = karray_sort(pstrSubcategories, nSubcategories,
				      FALSE);

      xvf_set_attributes(gui_info->template->subcategory_struct,
			 XVF_LIST_SIZE,     nSubcategories,
			 XVF_LIST_CONTENTS, pstrSubcategories,
			 NULL);
      xvf_set_attributes(paneObjAttrs->subcategory_struct,
			 XVF_LIST_SIZE,     nSubcategories,
			 XVF_LIST_CONTENTS, pstrSubcategories,
			 NULL);
      xvf_set_attributes(gui_info->template->category_struct,
			 XVF_LIST_SIZE,     nCategories,
			 XVF_LIST_CONTENTS, pstrCategories,
			 NULL);
      xvf_set_attributes(paneObjAttrs->category_struct,
			 XVF_LIST_SIZE,     nCategories,
			 XVF_LIST_CONTENTS, pstrCategories,
			 NULL);

   }
}

