 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane paneattrs
   >>>> 
   >>>>  Private: 
   >>>> 	paneattrs_apply
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

/*-----------------------------------------------------------
| 
|  Routine Name: paneattrs_apply
| 
|       Purpose: Do routine which is called when
|                  pane action button apply is used
| 
|         Input: paneattrs_info - ptr to PaneInfo struct for paneattrs pane
| 
|        Output: None
|    Written By: 
|          Date: Feb 13, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
paneattrs_apply(
   obj_attributes_paneattrs *paneattrs_info)
{
   kstring   routine = "paneattrs_apply()";
   kobject   object;
   int       otype;
   int       gen;
   kstring   a_tb, a_ob, a_args;


   if (strObject == NULL)
   {
      kerror(NULL, routine, "You have not selected an object.");
      return;
   }

   if ((object = kcms_open_cmobj(cmsToolbox, strObject)) == NULL)
   {
      kerror(NULL, routine,
	     "Unable to open selected software object, "
	     "`%s' in toolbox `%s'.", strObject, strToolbox);
      return;
   }

   if (!kcms_get_attribute(object, KCMS_CMOBJ_PROGTYPE, &otype))
      return;

   if (otype != KCMS_PANE)
   {
      kwarn(NULL, routine, "The attributes on this pane only apply "
	    "to `pane' type objects.\n"
	    "I'll ignore your requests to `Apply Changes', hope that's Ok!");
      return;
   }

   if (kcms_get_attribute(object,
			  KCMS_CMOBJ_GENERATE_EXECUTABLE, &gen) &&
       gen != paneattrs_info->genexec_val - 1)
   {
      kcms_set_attribute(object, KCMS_CMOBJ_GENERATE_EXECUTABLE,
			 paneattrs_info->genexec_val - 1);
   }

   if (kcms_get_attribute(object, KCMS_CMOBJ_ASSOCIATED_OBJECT,
			  &a_tb, &a_ob, &a_args)
       && (kstrcmp(a_tb, paneattrs_info->tbname) != 0
	   || kstrcmp(a_ob, paneattrs_info->oname) != 0
	   || kstrcmp(a_args, paneattrs_info->args) != 0))
   {
      kcms_set_attribute(object, KCMS_CMOBJ_ASSOCIATED_OBJECT,
			 paneattrs_info->tbname,
			 paneattrs_info->oname,
			 paneattrs_info->args);
   }

   kcms_close(object);
}


