 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane obj_keywords
   >>>> 
   >>>>  Private: 
   >>>> 	obj_keywords_delete
   >>>> 	obj_keywords_addkey
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name:	obj_keywords_delete
| 
| Purpose:	Do routine which is called when
|		pane action button delete is used
| 
| Input:	obj_keywords_info - ptr to PaneInfo struct for
|				    obj_keywords pane
| 
| Written By:	Neil Bowers
| Date:		13-jul-94
------------------------------------------------------------*/
void
obj_keywords_delete(
   obj_attributes_obj_keywords *obj_keywords_info)
{
   kobject  object;
   int      selected;
   kstring  keyword;


   if (strObject == NULL)
   {
      kerror(NULL, "obj_keywords_delete()",
	     "You have not selected an object.");
      return;
   }

   if (xvf_get_attribute(obj_keywords_info->keylist_struct,
			 XVF_LIST_INDEX, &selected)
       && selected >= 0
       && (object = kcms_open_cmobj(cmsToolbox, strObject)) != NULL)
   {
      keyword = obj_keywords_info->keylist_label;
      kcms_remove_keyword(object, keyword);
      update_keywords(object, NULL);
      xvf_set_attributes(obj_keywords_info->chkey_struct,
			 XVF_ACTIVATE,   FALSE,
			 XVF_STRING_VAL, NULL,
			 NULL);
      kfree(obj_keywords_info->chkey);
      obj_keywords_info->chkey = NULL;
      xvf_set_attribute(obj_keywords_info->delete_struct,
			XVF_ACTIVATE,    FALSE);
      kcms_close(object);
   }
}


/*-----------------------------------------------------------
| Routine Name:	obj_keywords_addkey
| 
| Purpose:	Do routine which is called when
|		string selection addkey is used
| 
| Input:	obj_keywords_info - ptr to PaneInfo struct for
|				    obj_keywords pane
| 
| Written By:	Neil Bowers
| Date:		13-jul-94
------------------------------------------------------------*/
void
obj_keywords_addkey(
   obj_attributes_obj_keywords *obj_keywords_info)
{
   kobject  object;


   if (strObject == NULL)
   {
      kerror(NULL, "obj_keywords_addkey()",
	     "You have not selected an object.");
      return;
   }

   if ((object = kcms_open_cmobj(cmsToolbox, strObject)) != NULL)
   {
      kcms_add_keyword(object, obj_keywords_info->addkey);
      update_keywords(object, obj_keywords_info->addkey);
      kcms_close(object);

      xvf_set_attribute(obj_keywords_info->addkey_struct,
			XVF_STRING_VAL, NULL);
      kfree(obj_keywords_info->addkey);
      obj_keywords_info->addkey = NULL;

      xvf_set_attribute(obj_keywords_info->delete_struct, XVF_ACTIVATE, TRUE);
      xvf_set_attributes(obj_keywords_info->chkey_struct,
			 XVF_STRING_VAL, obj_keywords_info->addkey,
			 XVF_ACTIVATE,   TRUE,
			 NULL);
      kfree(obj_keywords_info->chkey);
      obj_keywords_info->chkey = kstrdup(obj_keywords_info->addkey);
   }
}
/*-----------------------------------------------------------
| Routine Name:	obj_keywords_keylist - callback routine for keyword list
| 
| Purpose:	This routine is invoked when the user selects a keyword in
|		the keyword DisplayList selection.
|		We activate the "Change selected keyword" selection.
| 
| Input:	obj_keywords_info - ptr to PaneInfo struct for
|				    obj_keywords pane
| 
| Written By:	Neil Bowers
| Date:		21-nov-94
------------------------------------------------------------*/
void
obj_keywords_keylist(
   obj_attributes_obj_keywords *obj_keywords_info)
{
   xvf_set_attributes(obj_keywords_info->chkey_struct,
		      XVF_ACTIVATE,   TRUE,
		      XVF_STRING_VAL, obj_keywords_info->keylist_label,
		      NULL);
   kfree(obj_keywords_info->chkey);
   obj_keywords_info->chkey = kstrdup(obj_keywords_info->keylist_label);
   xvf_set_attribute(obj_keywords_info->delete_struct, XVF_ACTIVATE, TRUE);
}


/*-----------------------------------------------------------
| Routine Name:	obj_keywords_chkey - change selected keyword
| 
| Purpose:	This routine is called when the user enters a new string
|		for the currently selected keyword.
|		We delete the old keyword, and add the new one.
| 
| Input:	obj_keywords_info - ptr to PaneInfo struct for
|				    obj_keywords pane
| 
| Written By:	Neil Bowers
| Date:		21-nov-94
------------------------------------------------------------*/
void
obj_keywords_chkey(
   obj_attributes_obj_keywords  *obj_keywords_info)
{
   kobject  object;


   if (strObject == NULL)
      kerror(NULL, "obj_keywords_chkey()", "You have not selected an object.");

   else if ((object = kcms_open_cmobj(cmsToolbox, strObject)) != NULL)
   {
      kcms_remove_keyword(object, obj_keywords_info->keylist_label);
      kcms_add_keyword(object, obj_keywords_info->chkey);
      update_keywords(object, obj_keywords_info->chkey);
      kcms_close(object);

      xvf_set_attribute(obj_keywords_info->delete_struct, XVF_ACTIVATE, TRUE);
   }
}


