/* 
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/* 
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>         Functionality routines for pane copy
   >>>> 
   >>>>  Private: 
   >>>>         copy_docopy
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "craftsman.h"

/*-----------------------------------------------------------
| Routine Name:	copy_docopy - handler routine to copy a software object
| 
| Purpose:	This is the `do routine' associated with the "Copy Object"
|		action button on the "Copy Object" subform.
| 
| Input:	copy_info - ptr to PaneInfo struct for copy pane
| Output:	None
|
| Written By:	Neil Bowers
| Date:		Nov 16, 1993
------------------------------------------------------------*/
void
copy_docopy(
   copyobject_copy * copy_info)
{
   kstring  routine         = "Copy Object";
   kobject  toolbox         = NULL;
   kobject  object          = NULL;
   char     oname[KLENGTH];
   kstring  desttbname;
   kobject  newobject;


   if (strObject == NULL)
   {
      kerror(NULL, routine,
	     "You have not selected a software object to copy!");
      return;
   }

   kstrcpy(oname, strObject);
   if (copy_info->desttb == NULL)
      kerror(NULL, routine, "You must specify a destination toolbox.");

   else if ((toolbox = kcms_open_toolbox(copy_info->desttb)) == NULL)
      kerror(NULL, routine, "Could not open destination "
	     "toolbox, `%s'.", copy_info->desttb);

   else if ((object = kcms_open_cmobj(cmsToolbox, strObject)) == NULL)
      kerror(NULL, routine, "Could not open object to copy "
	     "(object `%s' in toolbox `%s').",
	     oname, strToolbox);

   else if (!kcms_get_attribute(toolbox, KCMS_NAME, &desttbname))
      kerror(NULL, routine, "Could not get name attribute of "
	     "destination toolbox.");
   else
   {
      /*-- Notifier: let user know that copy is in progress --*/
      xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, TRUE);
      xvw_format_attribute(xvoNotifier, XVW_NOTIFYWINDOW_MESSAGE,
			   "Copying object `%s' from toolbox `%s' "
			   "to toolbox `%s'", oname, strToolbox, desttbname);

      /*-- call kcms to copy the object --*/
      if ((newobject = kcms_duplicate(object, toolbox)) != NULL)
	 kcms_close(newobject);
      kcms_close(object);

      /*-- Notifier: pop down the notifier --*/
      xvw_set_attribute(xvoNotifier, XVW_NOTIFYWINDOW_VISIBLE, FALSE);
   }
}
