/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	FormInfo Initialization Routines
   >>>> 
   >>>>  Private: 
   >>>> 	_xvf_init_composer
   >>>> 	_xvf_free_composer
   >>>> 
   >>>>   Static: 
   >>>> 	_xvf_init_composer_warning
   >>>> 	_xvf_init_composer_error
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "composer.h"

static void _xvf_init_composer_warning PROTO((char *));
static void _xvf_init_composer_error   PROTO((char *, char *));

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_composer
| 
|       Purpose: Initializes the GUI Information (gui_info_struct) structure
| 
|         Input: forminfo - ptr to _xvf_init_composer_gui_struct
|                form     - pointer to the form tree
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
int _xvf_init_composer(

    kform *form, 
    gui_info_struct *forminfo)
{
	ksubform   *subform;
	kcontrol   *pane;
	kselection *selection;
	kcontrol   *master;
	kcontrol   *guidepane;

	master = form->master;
	/*
	 * initializing 'composer' Form Info structure
	 */

	forminfo->status_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.status");
	if (forminfo->status_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'status' on master form");
	forminfo->options_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.options");
	if (forminfo->options_struct == NULL)
	    _xvf_init_composer_warning("unknown selection 'options' on master form");

	forminfo->license_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.license");
	if (forminfo->license_struct == NULL)
		    _xvf_init_composer_warning("unknown selection 'license' on master form");

	forminfo->help_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.help");
	if (forminfo->help_struct == NULL)
		    _xvf_init_composer_warning("unknown selection 'help' on master form");

	forminfo->quit_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.quit");
	if (forminfo->quit_struct == NULL)
		    _xvf_init_composer_warning("quit button 'quit' on master form");
	forminfo->quit = FALSE;

	forminfo->file_type_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.file_type");
	if (forminfo->file_type_struct != NULL)
	{
	    selection = forminfo->file_type_struct->Selptr;
	    kvf_get_attribute(forminfo->file_type_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->file_type_num));
	    forminfo->file_type_val = 1;
	}
	else
	    _xvf_init_composer_warning("toggle selection 'file_type' on master form");

	forminfo->file_type_selected = FALSE;

	forminfo->filelist_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.filelist");
	if (forminfo->filelist_struct != NULL)
	{
	    selection = forminfo->filelist_struct->Selptr;
	    kvf_get_attribute(forminfo->filelist_struct, KVF_LIST_VAL,
	                    &(forminfo->filelist));
	    kvf_get_attribute(forminfo->filelist_struct, KVF_LIST_LABEL,
	                    &(forminfo->filelist_label));
	}
	else
	    _xvf_init_composer_warning("displaylist selection 'filelist' on master form");

	forminfo->filelist_selected = FALSE;

	forminfo->filelist_dblclick = FALSE;

	forminfo->save_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.save");
	if (forminfo->save_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'save' on master form");
	forminfo->save = FALSE;
	selection = forminfo->save_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->spawntty_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.spawntty");
	if (forminfo->spawntty_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'spawntty' on master form");
	forminfo->spawntty = FALSE;
	selection = forminfo->spawntty_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->fileops_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.fileops");
	if (forminfo->fileops_struct == NULL)
	    _xvf_init_composer_warning("unknown selection 'fileops' on master form");

	forminfo->interactive_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.interactive");
	if (forminfo->interactive_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'interactive' on master form");
	forminfo->interactive = FALSE;
	selection = forminfo->interactive_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->edit_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.edit");
	if (forminfo->edit_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'edit' on master form");
	forminfo->edit = FALSE;
	selection = forminfo->edit_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->view_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.view");
	if (forminfo->view_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'view' on master form");
	forminfo->view = FALSE;
	selection = forminfo->view_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->rmfile_struct =
	    kvf_create_struct_from_selname(master->sel_list, "composer.rmfile");
	if (forminfo->rmfile_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'rmfile' on master form");
	forminfo->rmfile = FALSE;
	selection = forminfo->rmfile_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->addfile_struct =
	    kvf_create_struct_from_subformname(form, "composer.addfile");
	if (forminfo->addfile_struct == NULL)
	{
	    _xvf_init_composer_error("subform 'addfile' on form 'composer'", 
			    "composer_addfile");
	    return(FALSE);
	}

	/*
	 * initializing 'composer->addfile' Subform Info structure
	 */

	forminfo->addfile = (composer_addfile *)
				kcalloc(1, sizeof(composer_addfile));
	subform = forminfo->addfile_struct->Subformptr;

	/*
	 * initializing 'composer->addfile->add_pane' Pane Info structure
	 */

	forminfo->addfile->add_pane = (addfile_add_pane *)
				kcalloc(1, sizeof(addfile_add_pane));
	forminfo->addfile->add_pane_struct =
	    kvf_create_struct_from_panename(subform, "composer.addfile.add_pane");
	if (forminfo->addfile->add_pane_struct == NULL)
	{
	    _xvf_init_composer_error("pane 'add_pane' on subform 'addfile'", "addfile_add_pane");
	    return(FALSE);
	}
	pane = forminfo->addfile->add_pane_struct->Controlptr;
	forminfo->addfile->add_pane->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.addfile.add_pane.help");
	if (forminfo->addfile->add_pane->help_struct == NULL)
		    _xvf_init_composer_warning("unknown selection 'help' on pane 'add_pane' of subform 'addfile'");

	forminfo->addfile->add_pane->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.addfile.add_pane.quit");
	if (forminfo->addfile->add_pane->quit_struct == NULL)
		    _xvf_init_composer_warning("quit button 'quit' on pane 'add_pane' of subform 'addfile'");
	forminfo->addfile->add_pane->quit = FALSE;

	forminfo->addfile->add_pane->add_file_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.addfile.add_pane.add_file");
	if (forminfo->addfile->add_pane->add_file_struct != NULL)
	{
	    selection = forminfo->addfile->add_pane->add_file_struct->Selptr;
	    kvf_get_attribute(forminfo->addfile->add_pane->add_file_struct, KVF_STRING_DEF,
	                    &(forminfo->addfile->add_pane->add_file));
	}
	else
	    _xvf_init_composer_warning("string selection 'add_file' on pane 'add_pane' of subform 'addfile'");

	forminfo->addfile->add_pane->add_file_selected = FALSE;

	forminfo->addfile->add_pane->add_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.addfile.add_pane.add");
	if (forminfo->addfile->add_pane->add_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'add' on pane 'add_pane' of subform 'addfile'");
	forminfo->addfile->add_pane->add = FALSE;
	selection = forminfo->addfile->add_pane->add_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->renamefile_struct =
	    kvf_create_struct_from_subformname(form, "composer.renamefile");
	if (forminfo->renamefile_struct == NULL)
	{
	    _xvf_init_composer_error("subform 'renamefile' on form 'composer'", 
			    "composer_renamefile");
	    return(FALSE);
	}

	/*
	 * initializing 'composer->renamefile' Subform Info structure
	 */

	forminfo->renamefile = (composer_renamefile *)
				kcalloc(1, sizeof(composer_renamefile));
	subform = forminfo->renamefile_struct->Subformptr;

	/*
	 * initializing 'composer->renamefile->rename_pane' Pane Info structure
	 */

	forminfo->renamefile->rename_pane = (renamefile_rename_pane *)
				kcalloc(1, sizeof(renamefile_rename_pane));
	forminfo->renamefile->rename_pane_struct =
	    kvf_create_struct_from_panename(subform, "composer.renamefile.rename_pane");
	if (forminfo->renamefile->rename_pane_struct == NULL)
	{
	    _xvf_init_composer_error("pane 'rename_pane' on subform 'renamefile'", "renamefile_rename_pane");
	    return(FALSE);
	}
	pane = forminfo->renamefile->rename_pane_struct->Controlptr;
	forminfo->renamefile->rename_pane->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.renamefile.rename_pane.help");
	if (forminfo->renamefile->rename_pane->help_struct == NULL)
		    _xvf_init_composer_warning("unknown selection 'help' on pane 'rename_pane' of subform 'renamefile'");

	forminfo->renamefile->rename_pane->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.renamefile.rename_pane.quit");
	if (forminfo->renamefile->rename_pane->quit_struct == NULL)
		    _xvf_init_composer_warning("quit button 'quit' on pane 'rename_pane' of subform 'renamefile'");
	forminfo->renamefile->rename_pane->quit = FALSE;

	forminfo->renamefile->rename_pane->rename_to_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.renamefile.rename_pane.rename_to");
	if (forminfo->renamefile->rename_pane->rename_to_struct != NULL)
	{
	    selection = forminfo->renamefile->rename_pane->rename_to_struct->Selptr;
	    kvf_get_attribute(forminfo->renamefile->rename_pane->rename_to_struct, KVF_STRING_DEF,
	                    &(forminfo->renamefile->rename_pane->rename_to));
	}
	else
	    _xvf_init_composer_warning("string selection 'rename_to' on pane 'rename_pane' of subform 'renamefile'");

	forminfo->renamefile->rename_pane->rename_to_selected = FALSE;

	forminfo->renamefile->rename_pane->rename_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.renamefile.rename_pane.rename");
	if (forminfo->renamefile->rename_pane->rename_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'rename' on pane 'rename_pane' of subform 'renamefile'");
	forminfo->renamefile->rename_pane->rename = FALSE;
	selection = forminfo->renamefile->rename_pane->rename_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->renamefile->rename_pane->fileblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.renamefile.rename_pane.fileblank");
	if (forminfo->renamefile->rename_pane->fileblank_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'fileblank' on pane 'rename_pane' of subform 'renamefile'");
	forminfo->renamefile->rename_pane->filename_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.renamefile.rename_pane.filename");
	if (forminfo->renamefile->rename_pane->filename_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'filename' on pane 'rename_pane' of subform 'renamefile'");
	forminfo->printfile_struct =
	    kvf_create_struct_from_subformname(form, "composer.printfile");
	if (forminfo->printfile_struct == NULL)
	{
	    _xvf_init_composer_error("subform 'printfile' on form 'composer'", 
			    "composer_printfile");
	    return(FALSE);
	}

	/*
	 * initializing 'composer->printfile' Subform Info structure
	 */

	forminfo->printfile = (composer_printfile *)
				kcalloc(1, sizeof(composer_printfile));
	subform = forminfo->printfile_struct->Subformptr;

	/*
	 * initializing 'composer->printfile->printpane' Pane Info structure
	 */

	forminfo->printfile->printpane = (printfile_printpane *)
				kcalloc(1, sizeof(printfile_printpane));
	forminfo->printfile->printpane_struct =
	    kvf_create_struct_from_panename(subform, "composer.printfile.printpane");
	if (forminfo->printfile->printpane_struct == NULL)
	{
	    _xvf_init_composer_error("pane 'printpane' on subform 'printfile'", "printfile_printpane");
	    return(FALSE);
	}
	pane = forminfo->printfile->printpane_struct->Controlptr;
	forminfo->printfile->printpane->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.printfile.printpane.help");
	if (forminfo->printfile->printpane->help_struct == NULL)
		    _xvf_init_composer_warning("unknown selection 'help' on pane 'printpane' of subform 'printfile'");

	forminfo->printfile->printpane->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.printfile.printpane.quit");
	if (forminfo->printfile->printpane->quit_struct == NULL)
		    _xvf_init_composer_warning("quit button 'quit' on pane 'printpane' of subform 'printfile'");
	forminfo->printfile->printpane->quit = FALSE;

	forminfo->printfile->printpane->printer_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.printfile.printpane.printer");
	if (forminfo->printfile->printpane->printer_struct != NULL)
	{
	    selection = forminfo->printfile->printpane->printer_struct->Selptr;
	    kvf_get_attribute(forminfo->printfile->printpane->printer_struct, KVF_STRING_DEF,
	                    &(forminfo->printfile->printpane->printer));
	}
	else
	    _xvf_init_composer_warning("string selection 'printer' on pane 'printpane' of subform 'printfile'");


	forminfo->printfile->printpane->printcmd_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.printfile.printpane.printcmd");
	if (forminfo->printfile->printpane->printcmd_struct != NULL)
	{
	    selection = forminfo->printfile->printpane->printcmd_struct->Selptr;
	    kvf_get_attribute(forminfo->printfile->printpane->printcmd_struct, KVF_STRING_DEF,
	                    &(forminfo->printfile->printpane->printcmd));
	}
	else
	    _xvf_init_composer_warning("string selection 'printcmd' on pane 'printpane' of subform 'printfile'");

	forminfo->printfile->printpane->printcmd_optsel = FALSE;

	forminfo->printfile->printpane->print_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.printfile.printpane.print");
	if (forminfo->printfile->printpane->print_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'print' on pane 'printpane' of subform 'printfile'");
	forminfo->printfile->printpane->print = FALSE;
	selection = forminfo->printfile->printpane->print_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->printfile->printpane->baselabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.printfile.printpane.baselabel");
	if (forminfo->printfile->printpane->baselabel_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'baselabel' on pane 'printpane' of subform 'printfile'");
	forminfo->printfile->printpane->pathlabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.printfile.printpane.pathlabel");
	if (forminfo->printfile->printpane->pathlabel_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'pathlabel' on pane 'printpane' of subform 'printfile'");
	forminfo->printfile->printpane->basename_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.printfile.printpane.basename");
	if (forminfo->printfile->printpane->basename_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'basename' on pane 'printpane' of subform 'printfile'");
	forminfo->printfile->printpane->fullpath_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.printfile.printpane.fullpath");
	if (forminfo->printfile->printpane->fullpath_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'fullpath' on pane 'printpane' of subform 'printfile'");
	forminfo->obj_attributes_struct =
	    kvf_create_struct_from_subformname(form, "composer.obj_attributes");
	if (forminfo->obj_attributes_struct == NULL)
	{
	    _xvf_init_composer_error("subform 'obj_attributes' on form 'composer'", 
			    "composer_obj_attributes");
	    return(FALSE);
	}

	/*
	 * initializing 'composer->obj_attributes' Subform Info structure
	 */

	forminfo->obj_attributes = (composer_obj_attributes *)
				kcalloc(1, sizeof(composer_obj_attributes));
	subform = forminfo->obj_attributes_struct->Subformptr;
	guidepane = subform->guidepane;
	forminfo->obj_attributes->help_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "composer.obj_attributes.help");
	if (forminfo->obj_attributes->help_struct == NULL)
		    _xvf_init_composer_warning("unknown selection 'help' on subform 'obj_attributes'");

	forminfo->obj_attributes->quit_struct =
	    kvf_create_struct_from_selname(guidepane->sel_list, "composer.obj_attributes.quit");
	if (forminfo->obj_attributes->quit_struct == NULL)
		    _xvf_init_composer_warning("quit button 'quit' on subform 'obj_attributes'");
	forminfo->obj_attributes->quit = FALSE;


	/*
	 * initializing 'composer->obj_attributes->obj_attrs' Pane Info structure
	 */

	forminfo->obj_attributes->obj_attrs = (obj_attributes_obj_attrs *)
				kcalloc(1, sizeof(obj_attributes_obj_attrs));
	forminfo->obj_attributes->obj_attrs_struct =
	    kvf_create_struct_from_panename(subform, "composer.obj_attributes.obj_attrs");
	if (forminfo->obj_attributes->obj_attrs_struct == NULL)
	{
	    _xvf_init_composer_error("pane 'obj_attrs' on subform 'obj_attributes'", "obj_attributes_obj_attrs");
	    return(FALSE);
	}
	pane = forminfo->obj_attributes->obj_attrs_struct->Controlptr;
	forminfo->obj_attributes->obj_attrs->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.help");
	if (forminfo->obj_attributes->obj_attrs->help_struct == NULL)
		    _xvf_init_composer_warning("unknown selection 'help' on pane 'obj_attrs' of subform 'obj_attributes'");

	forminfo->obj_attributes->obj_attrs->description_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.description");
	if (forminfo->obj_attributes->obj_attrs->description_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->description_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->description_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->description));
	}
	else
	    _xvf_init_composer_warning("string selection 'description' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->category_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.category");
	if (forminfo->obj_attributes->obj_attrs->category_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->category_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->category_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->category));
	}
	else
	    _xvf_init_composer_warning("string list selection 'category' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->subcategory_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.subcategory");
	if (forminfo->obj_attributes->obj_attrs->subcategory_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->subcategory_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->subcategory_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->subcategory));
	}
	else
	    _xvf_init_composer_warning("string list selection 'subcategory' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->icon_name_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.icon_name");
	if (forminfo->obj_attributes->obj_attrs->icon_name_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->icon_name_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->icon_name_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->icon_name));
	}
	else
	    _xvf_init_composer_warning("string selection 'icon_name' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->name_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.name");
	if (forminfo->obj_attributes->obj_attrs->name_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->name_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->name_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->name));
	}
	else
	    _xvf_init_composer_warning("string selection 'name' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->email_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.email");
	if (forminfo->obj_attributes->obj_attrs->email_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->email_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->email_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_attrs->email));
	}
	else
	    _xvf_init_composer_warning("string selection 'email' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->install_in_cantata_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.install_in_cantata");
	if (forminfo->obj_attributes->obj_attrs->install_in_cantata_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_attrs->install_in_cantata_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_attrs->install_in_cantata_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->obj_attributes->obj_attrs->install_in_cantata_num));
	    forminfo->obj_attributes->obj_attrs->install_in_cantata_val = 1;
	}
	else
	    _xvf_init_composer_warning("toggle selection 'install_in_cantata' on pane 'obj_attrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->obj_attrs->apply_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.apply");
	if (forminfo->obj_attributes->obj_attrs->apply_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'apply' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->apply = FALSE;
	selection = forminfo->obj_attributes->obj_attrs->apply_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->obj_attributes->obj_attrs->tblabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.tblabel");
	if (forminfo->obj_attributes->obj_attrs->tblabel_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'tblabel' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->onamelabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.onamelabel");
	if (forminfo->obj_attributes->obj_attrs->onamelabel_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'onamelabel' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->tb_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.tb");
	if (forminfo->obj_attributes->obj_attrs->tb_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'tb' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.oname");
	if (forminfo->obj_attributes->obj_attrs->oname_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'oname' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->authlabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.authlabel");
	if (forminfo->obj_attributes->obj_attrs->authlabel_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'authlabel' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->otypelabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.otypelabel");
	if (forminfo->obj_attributes->obj_attrs->otypelabel_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'otypelabel' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->otype_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.otype");
	if (forminfo->obj_attributes->obj_attrs->otype_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'otype' on pane 'obj_attrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_attrs->descblank_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_attrs.descblank");
	if (forminfo->obj_attributes->obj_attrs->descblank_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'descblank' on pane 'obj_attrs' of subform 'obj_attributes'");

	/*
	 * initializing 'composer->obj_attributes->obj_keywords' Pane Info structure
	 */

	forminfo->obj_attributes->obj_keywords = (obj_attributes_obj_keywords *)
				kcalloc(1, sizeof(obj_attributes_obj_keywords));
	forminfo->obj_attributes->obj_keywords_struct =
	    kvf_create_struct_from_panename(subform, "composer.obj_attributes.obj_keywords");
	if (forminfo->obj_attributes->obj_keywords_struct == NULL)
	{
	    _xvf_init_composer_error("pane 'obj_keywords' on subform 'obj_attributes'", "obj_attributes_obj_keywords");
	    return(FALSE);
	}
	pane = forminfo->obj_attributes->obj_keywords_struct->Controlptr;
	forminfo->obj_attributes->obj_keywords->keylist_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_keywords.keylist");
	if (forminfo->obj_attributes->obj_keywords->keylist_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_keywords->keylist_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_keywords->keylist_struct, KVF_LIST_VAL,
	                    &(forminfo->obj_attributes->obj_keywords->keylist));
	    kvf_get_attribute(forminfo->obj_attributes->obj_keywords->keylist_struct, KVF_LIST_LABEL,
	                    &(forminfo->obj_attributes->obj_keywords->keylist_label));
	}
	else
	    _xvf_init_composer_warning("displaylist selection 'keylist' on pane 'obj_keywords' of subform 'obj_attributes'");

	forminfo->obj_attributes->obj_keywords->keylist_selected = FALSE;

	forminfo->obj_attributes->obj_keywords->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_keywords.help");
	if (forminfo->obj_attributes->obj_keywords->help_struct == NULL)
		    _xvf_init_composer_warning("unknown selection 'help' on pane 'obj_keywords' of subform 'obj_attributes'");

	forminfo->obj_attributes->obj_keywords->delete_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_keywords.delete");
	if (forminfo->obj_attributes->obj_keywords->delete_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'delete' on pane 'obj_keywords' of subform 'obj_attributes'");
	forminfo->obj_attributes->obj_keywords->delete = FALSE;
	selection = forminfo->obj_attributes->obj_keywords->delete_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->obj_attributes->obj_keywords->addkey_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_keywords.addkey");
	if (forminfo->obj_attributes->obj_keywords->addkey_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_keywords->addkey_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_keywords->addkey_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_keywords->addkey));
	}
	else
	    _xvf_init_composer_warning("string selection 'addkey' on pane 'obj_keywords' of subform 'obj_attributes'");

	forminfo->obj_attributes->obj_keywords->addkey_selected = FALSE;

	forminfo->obj_attributes->obj_keywords->chkey_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.obj_keywords.chkey");
	if (forminfo->obj_attributes->obj_keywords->chkey_struct != NULL)
	{
	    selection = forminfo->obj_attributes->obj_keywords->chkey_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->obj_keywords->chkey_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->obj_keywords->chkey));
	}
	else
	    _xvf_init_composer_warning("string selection 'chkey' on pane 'obj_keywords' of subform 'obj_attributes'");

	forminfo->obj_attributes->obj_keywords->chkey_selected = FALSE;


	/*
	 * initializing 'composer->obj_attributes->paneattrs' Pane Info structure
	 */

	forminfo->obj_attributes->paneattrs = (obj_attributes_paneattrs *)
				kcalloc(1, sizeof(obj_attributes_paneattrs));
	forminfo->obj_attributes->paneattrs_struct =
	    kvf_create_struct_from_panename(subform, "composer.obj_attributes.paneattrs");
	if (forminfo->obj_attributes->paneattrs_struct == NULL)
	{
	    _xvf_init_composer_error("pane 'paneattrs' on subform 'obj_attributes'", "obj_attributes_paneattrs");
	    return(FALSE);
	}
	pane = forminfo->obj_attributes->paneattrs_struct->Controlptr;
	forminfo->obj_attributes->paneattrs->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.paneattrs.help");
	if (forminfo->obj_attributes->paneattrs->help_struct == NULL)
		    _xvf_init_composer_warning("unknown selection 'help' on pane 'paneattrs' of subform 'obj_attributes'");

	forminfo->obj_attributes->paneattrs->tbname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.paneattrs.tbname");
	if (forminfo->obj_attributes->paneattrs->tbname_struct != NULL)
	{
	    selection = forminfo->obj_attributes->paneattrs->tbname_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->paneattrs->tbname_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->paneattrs->tbname));
	}
	else
	    _xvf_init_composer_warning("string selection 'tbname' on pane 'paneattrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->paneattrs->oname_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.paneattrs.oname");
	if (forminfo->obj_attributes->paneattrs->oname_struct != NULL)
	{
	    selection = forminfo->obj_attributes->paneattrs->oname_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->paneattrs->oname_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->paneattrs->oname));
	}
	else
	    _xvf_init_composer_warning("string selection 'oname' on pane 'paneattrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->paneattrs->args_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.paneattrs.args");
	if (forminfo->obj_attributes->paneattrs->args_struct != NULL)
	{
	    selection = forminfo->obj_attributes->paneattrs->args_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->paneattrs->args_struct, KVF_STRING_DEF,
	                    &(forminfo->obj_attributes->paneattrs->args));
	}
	else
	    _xvf_init_composer_warning("string selection 'args' on pane 'paneattrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->paneattrs->genexec_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.paneattrs.genexec");
	if (forminfo->obj_attributes->paneattrs->genexec_struct != NULL)
	{
	    selection = forminfo->obj_attributes->paneattrs->genexec_struct->Selptr;
	    kvf_get_attribute(forminfo->obj_attributes->paneattrs->genexec_struct, KVF_TOGGLE_NUM,
	                    &(forminfo->obj_attributes->paneattrs->genexec_num));
	    forminfo->obj_attributes->paneattrs->genexec_val = 1;
	}
	else
	    _xvf_init_composer_warning("toggle selection 'genexec' on pane 'paneattrs' of subform 'obj_attributes'");


	forminfo->obj_attributes->paneattrs->apply_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.paneattrs.apply");
	if (forminfo->obj_attributes->paneattrs->apply_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'apply' on pane 'paneattrs' of subform 'obj_attributes'");
	forminfo->obj_attributes->paneattrs->apply = FALSE;
	selection = forminfo->obj_attributes->paneattrs->apply_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->obj_attributes->paneattrs->assoclabel_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.obj_attributes.paneattrs.assoclabel");
	if (forminfo->obj_attributes->paneattrs->assoclabel_struct == NULL)
	    _xvf_init_composer_warning("blank selection 'assoclabel' on pane 'paneattrs' of subform 'obj_attributes'");
	forminfo->logform_struct =
	    kvf_create_struct_from_subformname(form, "composer.logform");
	if (forminfo->logform_struct == NULL)
	{
	    _xvf_init_composer_error("subform 'logform' on form 'composer'", 
			    "composer_logform");
	    return(FALSE);
	}

	/*
	 * initializing 'composer->logform' Subform Info structure
	 */

	forminfo->logform = (composer_logform *)
				kcalloc(1, sizeof(composer_logform));
	subform = forminfo->logform_struct->Subformptr;

	/*
	 * initializing 'composer->logform->logging' Pane Info structure
	 */

	forminfo->logform->logging = (logform_logging *)
				kcalloc(1, sizeof(logform_logging));
	forminfo->logform->logging_struct =
	    kvf_create_struct_from_panename(subform, "composer.logform.logging");
	if (forminfo->logform->logging_struct == NULL)
	{
	    _xvf_init_composer_error("pane 'logging' on subform 'logform'", "logform_logging");
	    return(FALSE);
	}
	pane = forminfo->logform->logging_struct->Controlptr;
	forminfo->logform->logging->clear_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.clear");
	if (forminfo->logform->logging->clear_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'clear' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->clear = FALSE;
	selection = forminfo->logform->logging->clear_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->logform->logging->help_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.help");
	if (forminfo->logform->logging->help_struct == NULL)
		    _xvf_init_composer_warning("unknown selection 'help' on pane 'logging' of subform 'logform'");

	forminfo->logform->logging->quit_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.quit");
	if (forminfo->logform->logging->quit_struct == NULL)
		    _xvf_init_composer_warning("quit button 'quit' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->quit = FALSE;

	forminfo->logform->logging->gen_code_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.gen_code");
	if (forminfo->logform->logging->gen_code_struct == NULL)
	    _xvf_init_composer_warning("pane action button 'gen_code' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->gen_code = FALSE;
	selection = forminfo->logform->logging->gen_code_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);
	forminfo->logform->logging->force_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.force");
	if (forminfo->logform->logging->force_struct != NULL)
	{
	    selection = forminfo->logform->logging->force_struct->Selptr;
	    kvf_get_attribute(forminfo->logform->logging->force_struct, KVF_OPTSEL,
	                    &(forminfo->logform->logging->force));
	}
	else
	    _xvf_init_composer_warning("flag selection 'force' on pane 'logging' of subform 'logform'");

	forminfo->logform->logging->make_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.make");
	if (forminfo->logform->logging->make_struct == NULL)
	    _xvf_init_composer_warning("unknown selection 'make' on pane 'logging' of subform 'logform'");

	forminfo->logform->logging->make_target_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.make_target");
	if (forminfo->logform->logging->make_target_struct == NULL)
	    _xvf_init_composer_warning("master action button 'make_target' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->make_target = FALSE;
	selection = forminfo->logform->logging->make_target_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->make_install_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.make_install");
	if (forminfo->logform->logging->make_install_struct == NULL)
	    _xvf_init_composer_warning("master action button 'make_install' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->make_install = FALSE;
	selection = forminfo->logform->logging->make_install_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->make_Imakefile_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.make_Imakefile");
	if (forminfo->logform->logging->make_Imakefile_struct == NULL)
	    _xvf_init_composer_warning("master action button 'make_Imakefile' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->make_Imakefile = FALSE;
	selection = forminfo->logform->logging->make_Imakefile_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->make_Makefile_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.make_Makefile");
	if (forminfo->logform->logging->make_Makefile_struct == NULL)
	    _xvf_init_composer_warning("master action button 'make_Makefile' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->make_Makefile = FALSE;
	selection = forminfo->logform->logging->make_Makefile_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->make_klint_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.make_klint");
	if (forminfo->logform->logging->make_klint_struct == NULL)
	    _xvf_init_composer_warning("master action button 'make_klint' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->make_klint = FALSE;
	selection = forminfo->logform->logging->make_klint_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->make_clean_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.make_clean");
	if (forminfo->logform->logging->make_clean_struct == NULL)
	    _xvf_init_composer_warning("master action button 'make_clean' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->make_clean = FALSE;
	selection = forminfo->logform->logging->make_clean_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->make_lib_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.make_lib");
	if (forminfo->logform->logging->make_lib_struct == NULL)
	    _xvf_init_composer_warning("unknown selection 'make_lib' on pane 'logging' of subform 'logform'");

	forminfo->logform->logging->lib_make_target_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.lib_make_target");
	if (forminfo->logform->logging->lib_make_target_struct == NULL)
	    _xvf_init_composer_warning("master action button 'lib_make_target' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->lib_make_target = FALSE;
	selection = forminfo->logform->logging->lib_make_target_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->lib_make_install_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.lib_make_install");
	if (forminfo->logform->logging->lib_make_install_struct == NULL)
	    _xvf_init_composer_warning("master action button 'lib_make_install' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->lib_make_install = FALSE;
	selection = forminfo->logform->logging->lib_make_install_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->lib_make_Imakefile_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.lib_make_Imakefile");
	if (forminfo->logform->logging->lib_make_Imakefile_struct == NULL)
	    _xvf_init_composer_warning("master action button 'lib_make_Imakefile' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->lib_make_Imakefile = FALSE;
	selection = forminfo->logform->logging->lib_make_Imakefile_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->lib_make_Makefile_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.lib_make_Makefile");
	if (forminfo->logform->logging->lib_make_Makefile_struct == NULL)
	    _xvf_init_composer_warning("master action button 'lib_make_Makefile' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->lib_make_Makefile = FALSE;
	selection = forminfo->logform->logging->lib_make_Makefile_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->lib_make_klint_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.lib_make_klint");
	if (forminfo->logform->logging->lib_make_klint_struct == NULL)
	    _xvf_init_composer_warning("master action button 'lib_make_klint' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->lib_make_klint = FALSE;
	selection = forminfo->logform->logging->lib_make_klint_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	forminfo->logform->logging->lib_make_clean_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.lib_make_clean");
	if (forminfo->logform->logging->lib_make_clean_struct == NULL)
	    _xvf_init_composer_warning("master action button 'lib_make_clean' on pane 'logging' of subform 'logform'");
	forminfo->logform->logging->lib_make_clean = FALSE;
	selection = forminfo->logform->logging->lib_make_clean_struct->Selptr;
	kvf_set_attribute(selection->back_kformstruct,
	                  KVF_SELECTED, FALSE);

	if (!(xvf_create_subform(subform, -1, -1, FALSE)))
	   return(FALSE);
	_xvf_get_logform(forminfo->logform);
	if (!(xvf_create_pane(pane, FALSE)))
	   return(FALSE);
	_xvf_get_logging(forminfo->logform->logging);
	forminfo->logform->logging->workspace_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.workspace");
	if (forminfo->logform->logging->workspace_struct == NULL)
	    _xvf_init_composer_warning("workspace 'workspace' on pane 'logging' of subform 'logform'");
	else
	{
	    kvf_get_attribute(forminfo->logform->logging->workspace_struct, KVF_WORKSPACE,
	                    &(forminfo->logform->logging->workspace));

	}
	forminfo->logform->logging->grep_struct =
	    kvf_create_struct_from_selname(pane->sel_list, "composer.logform.logging.grep");
	if (forminfo->logform->logging->grep_struct != NULL)
	{
	    selection = forminfo->logform->logging->grep_struct->Selptr;
	    kvf_get_attribute(forminfo->logform->logging->grep_struct, KVF_STRING_DEF,
	                    &(forminfo->logform->logging->grep));
	}
	else
	    _xvf_init_composer_warning("string selection 'grep' on pane 'logging' of subform 'logform'");

	forminfo->logform->logging->grep_selected = FALSE;

	forminfo->composer_struct =
	    kvf_create_struct_from_mastername(form, "composer");
	if (forminfo->composer_struct == NULL)
	{
	    _xvf_init_composer_error("form 'composer'",
			    "gui_info");
	    return(FALSE);
	}

	return(TRUE);

}

/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_composer_warning
| 
|       Purpose: Prints warning when code is out of sync with UIS file
| 
|         Input: string - item that cannot be found
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_composer_warning(
    char *string)
{
	kfprintf(kstderr, "Warning: cannot find %s.\n", string);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_init_composer_error
| 
|       Purpose: Prints error when code is irreconcilable with UIS file
| 
|         Input: string1 - item that cannot be found
|                string2 - name of FormInfo structure
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
static void _xvf_init_composer_error(
    char *string1,
    char *string2)
{
	kfprintf(kstderr, "ERROR: cannot find %s.\n", string1);
	kfprintf(kstderr, "         UIS file out of sync with code\n");
	kfprintf(kstderr, "         generated by conductor in 'form_init.c'.\n");
	kfprintf(kstderr, "         Unable to initialize '%s' structure as defined in form_info.h; Aborting.\n", string2);
}


/*-----------------------------------------------------------
| 
|  Routine Name: _xvf_free_composer
| 
|       Purpose: Frees the gui_info_struct
| 
|         Input: forminfo - ptr to _xvf_free_composer_gui_struct
| 
|        Output: none
|    Written By: conductor
|          Date: Apr 08, 1995
| Modifications:  
| 
------------------------------------------------------------*/
void _xvf_free_composer(
    gui_info_struct *forminfo)
{
	if (forminfo->status_struct != NULL)
	    kfree(forminfo->status_struct);
	if (forminfo->options_struct != NULL)
	    kfree(forminfo->options_struct);
	if (forminfo->license_struct != NULL)
	    kfree(forminfo->license_struct);
	if (forminfo->help_struct != NULL)
	    kfree(forminfo->help_struct);
	if (forminfo->quit_struct != NULL)
	    kfree(forminfo->quit_struct);
	if (forminfo->file_type_struct != NULL)
	    kfree(forminfo->file_type_struct);
	if (forminfo->filelist_struct != NULL)
	    kfree(forminfo->filelist_struct);
	kfree(forminfo->filelist_label);
	if (forminfo->save_struct != NULL)
	    kfree(forminfo->save_struct);
	if (forminfo->spawntty_struct != NULL)
	    kfree(forminfo->spawntty_struct);
	if (forminfo->fileops_struct != NULL)
	    kfree(forminfo->fileops_struct);
	if (forminfo->interactive_struct != NULL)
	    kfree(forminfo->interactive_struct);
	if (forminfo->edit_struct != NULL)
	    kfree(forminfo->edit_struct);
	if (forminfo->view_struct != NULL)
	    kfree(forminfo->view_struct);
	if (forminfo->rmfile_struct != NULL)
	    kfree(forminfo->rmfile_struct);
	if (forminfo->addfile->add_pane->help_struct != NULL)
	    kfree(forminfo->addfile->add_pane->help_struct);
	if (forminfo->addfile->add_pane->quit_struct != NULL)
	    kfree(forminfo->addfile->add_pane->quit_struct);
	kfree(forminfo->addfile->add_pane->add_file);
	if (forminfo->addfile->add_pane->add_file_struct != NULL)
	    kfree(forminfo->addfile->add_pane->add_file_struct);
	if (forminfo->addfile->add_pane->add_struct != NULL)
	    kfree(forminfo->addfile->add_pane->add_struct);
	kfree(forminfo->addfile->add_pane);
	if (forminfo->addfile->add_pane_struct != NULL)
	    kfree(forminfo->addfile->add_pane_struct);


	if (forminfo->addfile_struct != NULL)
	    kfree(forminfo->addfile_struct);
	kfree(forminfo->addfile);
	if (forminfo->renamefile->rename_pane->help_struct != NULL)
	    kfree(forminfo->renamefile->rename_pane->help_struct);
	if (forminfo->renamefile->rename_pane->quit_struct != NULL)
	    kfree(forminfo->renamefile->rename_pane->quit_struct);
	kfree(forminfo->renamefile->rename_pane->rename_to);
	if (forminfo->renamefile->rename_pane->rename_to_struct != NULL)
	    kfree(forminfo->renamefile->rename_pane->rename_to_struct);
	if (forminfo->renamefile->rename_pane->rename_struct != NULL)
	    kfree(forminfo->renamefile->rename_pane->rename_struct);
	if (forminfo->renamefile->rename_pane->fileblank_struct != NULL)
	    kfree(forminfo->renamefile->rename_pane->fileblank_struct);
	if (forminfo->renamefile->rename_pane->filename_struct != NULL)
	    kfree(forminfo->renamefile->rename_pane->filename_struct);
	kfree(forminfo->renamefile->rename_pane);
	if (forminfo->renamefile->rename_pane_struct != NULL)
	    kfree(forminfo->renamefile->rename_pane_struct);


	if (forminfo->renamefile_struct != NULL)
	    kfree(forminfo->renamefile_struct);
	kfree(forminfo->renamefile);
	if (forminfo->printfile->printpane->help_struct != NULL)
	    kfree(forminfo->printfile->printpane->help_struct);
	if (forminfo->printfile->printpane->quit_struct != NULL)
	    kfree(forminfo->printfile->printpane->quit_struct);
	kfree(forminfo->printfile->printpane->printer);
	if (forminfo->printfile->printpane->printer_struct != NULL)
	    kfree(forminfo->printfile->printpane->printer_struct);
	kfree(forminfo->printfile->printpane->printcmd);
	if (forminfo->printfile->printpane->printcmd_struct != NULL)
	    kfree(forminfo->printfile->printpane->printcmd_struct);
	if (forminfo->printfile->printpane->print_struct != NULL)
	    kfree(forminfo->printfile->printpane->print_struct);
	if (forminfo->printfile->printpane->baselabel_struct != NULL)
	    kfree(forminfo->printfile->printpane->baselabel_struct);
	if (forminfo->printfile->printpane->pathlabel_struct != NULL)
	    kfree(forminfo->printfile->printpane->pathlabel_struct);
	if (forminfo->printfile->printpane->basename_struct != NULL)
	    kfree(forminfo->printfile->printpane->basename_struct);
	if (forminfo->printfile->printpane->fullpath_struct != NULL)
	    kfree(forminfo->printfile->printpane->fullpath_struct);
	kfree(forminfo->printfile->printpane);
	if (forminfo->printfile->printpane_struct != NULL)
	    kfree(forminfo->printfile->printpane_struct);


	if (forminfo->printfile_struct != NULL)
	    kfree(forminfo->printfile_struct);
	kfree(forminfo->printfile);
	if (forminfo->obj_attributes->help_struct != NULL)
	    kfree(forminfo->obj_attributes->help_struct);
	if (forminfo->obj_attributes->quit_struct != NULL)
	    kfree(forminfo->obj_attributes->quit_struct);
	if (forminfo->obj_attributes->obj_attrs->help_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->help_struct);
	kfree(forminfo->obj_attributes->obj_attrs->description);
	if (forminfo->obj_attributes->obj_attrs->description_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->description_struct);
	kfree(forminfo->obj_attributes->obj_attrs->category);
	if (forminfo->obj_attributes->obj_attrs->category_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->category_struct);
	kfree(forminfo->obj_attributes->obj_attrs->subcategory);
	if (forminfo->obj_attributes->obj_attrs->subcategory_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->subcategory_struct);
	kfree(forminfo->obj_attributes->obj_attrs->icon_name);
	if (forminfo->obj_attributes->obj_attrs->icon_name_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->icon_name_struct);
	kfree(forminfo->obj_attributes->obj_attrs->name);
	if (forminfo->obj_attributes->obj_attrs->name_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->name_struct);
	kfree(forminfo->obj_attributes->obj_attrs->email);
	if (forminfo->obj_attributes->obj_attrs->email_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->email_struct);
	if (forminfo->obj_attributes->obj_attrs->install_in_cantata_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->install_in_cantata_struct);
	if (forminfo->obj_attributes->obj_attrs->apply_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->apply_struct);
	if (forminfo->obj_attributes->obj_attrs->tblabel_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->tblabel_struct);
	if (forminfo->obj_attributes->obj_attrs->onamelabel_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->onamelabel_struct);
	if (forminfo->obj_attributes->obj_attrs->tb_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->tb_struct);
	if (forminfo->obj_attributes->obj_attrs->oname_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->oname_struct);
	if (forminfo->obj_attributes->obj_attrs->authlabel_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->authlabel_struct);
	if (forminfo->obj_attributes->obj_attrs->otypelabel_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->otypelabel_struct);
	if (forminfo->obj_attributes->obj_attrs->otype_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->otype_struct);
	if (forminfo->obj_attributes->obj_attrs->descblank_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs->descblank_struct);
	kfree(forminfo->obj_attributes->obj_attrs);
	if (forminfo->obj_attributes->obj_attrs_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_attrs_struct);

	if (forminfo->obj_attributes->obj_keywords->keylist_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords->keylist_struct);
	kfree(forminfo->obj_attributes->obj_keywords->keylist_label);
	if (forminfo->obj_attributes->obj_keywords->help_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords->help_struct);
	if (forminfo->obj_attributes->obj_keywords->delete_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords->delete_struct);
	kfree(forminfo->obj_attributes->obj_keywords->addkey);
	if (forminfo->obj_attributes->obj_keywords->addkey_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords->addkey_struct);
	kfree(forminfo->obj_attributes->obj_keywords->chkey);
	if (forminfo->obj_attributes->obj_keywords->chkey_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords->chkey_struct);
	kfree(forminfo->obj_attributes->obj_keywords);
	if (forminfo->obj_attributes->obj_keywords_struct != NULL)
	    kfree(forminfo->obj_attributes->obj_keywords_struct);

	if (forminfo->obj_attributes->paneattrs->help_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->help_struct);
	kfree(forminfo->obj_attributes->paneattrs->tbname);
	if (forminfo->obj_attributes->paneattrs->tbname_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->tbname_struct);
	kfree(forminfo->obj_attributes->paneattrs->oname);
	if (forminfo->obj_attributes->paneattrs->oname_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->oname_struct);
	kfree(forminfo->obj_attributes->paneattrs->args);
	if (forminfo->obj_attributes->paneattrs->args_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->args_struct);
	if (forminfo->obj_attributes->paneattrs->genexec_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->genexec_struct);
	if (forminfo->obj_attributes->paneattrs->apply_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->apply_struct);
	if (forminfo->obj_attributes->paneattrs->assoclabel_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs->assoclabel_struct);
	kfree(forminfo->obj_attributes->paneattrs);
	if (forminfo->obj_attributes->paneattrs_struct != NULL)
	    kfree(forminfo->obj_attributes->paneattrs_struct);


	if (forminfo->obj_attributes_struct != NULL)
	    kfree(forminfo->obj_attributes_struct);
	kfree(forminfo->obj_attributes);
	if (forminfo->logform->logging->clear_struct != NULL)
	    kfree(forminfo->logform->logging->clear_struct);
	if (forminfo->logform->logging->help_struct != NULL)
	    kfree(forminfo->logform->logging->help_struct);
	if (forminfo->logform->logging->quit_struct != NULL)
	    kfree(forminfo->logform->logging->quit_struct);
	if (forminfo->logform->logging->gen_code_struct != NULL)
	    kfree(forminfo->logform->logging->gen_code_struct);
	if (forminfo->logform->logging->force_struct != NULL)
	    kfree(forminfo->logform->logging->force_struct);
	if (forminfo->logform->logging->make_struct != NULL)
	    kfree(forminfo->logform->logging->make_struct);
	if (forminfo->logform->logging->make_target_struct != NULL)
	    kfree(forminfo->logform->logging->make_target_struct);
	if (forminfo->logform->logging->make_install_struct != NULL)
	    kfree(forminfo->logform->logging->make_install_struct);
	if (forminfo->logform->logging->make_Imakefile_struct != NULL)
	    kfree(forminfo->logform->logging->make_Imakefile_struct);
	if (forminfo->logform->logging->make_Makefile_struct != NULL)
	    kfree(forminfo->logform->logging->make_Makefile_struct);
	if (forminfo->logform->logging->make_klint_struct != NULL)
	    kfree(forminfo->logform->logging->make_klint_struct);
	if (forminfo->logform->logging->make_clean_struct != NULL)
	    kfree(forminfo->logform->logging->make_clean_struct);
	if (forminfo->logform->logging->make_lib_struct != NULL)
	    kfree(forminfo->logform->logging->make_lib_struct);
	if (forminfo->logform->logging->lib_make_target_struct != NULL)
	    kfree(forminfo->logform->logging->lib_make_target_struct);
	if (forminfo->logform->logging->lib_make_install_struct != NULL)
	    kfree(forminfo->logform->logging->lib_make_install_struct);
	if (forminfo->logform->logging->lib_make_Imakefile_struct != NULL)
	    kfree(forminfo->logform->logging->lib_make_Imakefile_struct);
	if (forminfo->logform->logging->lib_make_Makefile_struct != NULL)
	    kfree(forminfo->logform->logging->lib_make_Makefile_struct);
	if (forminfo->logform->logging->lib_make_klint_struct != NULL)
	    kfree(forminfo->logform->logging->lib_make_klint_struct);
	if (forminfo->logform->logging->lib_make_clean_struct != NULL)
	    kfree(forminfo->logform->logging->lib_make_clean_struct);
	if (forminfo->logform->logging->workspace_struct != NULL)
	    kfree(forminfo->logform->logging->workspace_struct);
	kfree(forminfo->logform->logging->grep);
	if (forminfo->logform->logging->grep_struct != NULL)
	    kfree(forminfo->logform->logging->grep_struct);
	kfree(forminfo->logform->logging);
	if (forminfo->logform->logging_struct != NULL)
	    kfree(forminfo->logform->logging_struct);


	if (forminfo->logform_struct != NULL)
	    kfree(forminfo->logform_struct);
	kfree(forminfo->logform);
	kfree(forminfo);
}
