/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Functionality routines for pane obj_keywords
   >>>> 
   >>>>  Private: 
   >>>> 	obj_keywords_delete
   >>>> 	obj_keywords_addkey
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "composer.h"

/*-----------------------------------------------------------
| Routine Name:	obj_keywords_delete - delete selected keyword
| 
| Purpose:	Do routine which is called when
|		pane action button delete is used
| 
| Input:	obj_keywords_info - ptr to PaneInfo struct for
|				    obj_keywords pane
| 
| Written By:	Neil Bowers
| Date:		14-jul-94
------------------------------------------------------------*/
void obj_keywords_delete(
     obj_attributes_obj_keywords *obj_keywords_info)
{
   int      selected;
   kstring  keyword;


   if (xvf_get_attribute(obj_keywords_info->keylist_struct,
			 XVF_LIST_INDEX, &selected)
       && selected >= 0)
   {
      keyword = obj_keywords_info->keylist_label;
      kcms_remove_keyword(cmsObject, keyword);
      update_keywords(cmsObject, NULL);
      xvf_set_attributes(obj_keywords_info->chkey_struct,
			 XVF_ACTIVATE,   FALSE,
			 XVF_STRING_VAL, NULL,
			 NULL);
      kfree(obj_keywords_info->chkey);
      obj_keywords_info->chkey = NULL;
      xvf_set_attribute(obj_keywords_info->delete_struct,
			XVF_ACTIVATE,    FALSE);
   }
}


/*-----------------------------------------------------------
| Routine Name:	obj_keywords_addkey
| 
| Purpose:	Do routine which is called when
|		string selection addkey is used
| 
| Input:	obj_keywords_info - ptr to PaneInfo struct
|				    for obj_keywords pane
| 
| Written By:	Neil Bowers
| Date:		14-jul-94
------------------------------------------------------------*/
void
obj_keywords_addkey(
   obj_attributes_obj_keywords *obj_keywords_info)
{
   kcms_add_keyword(cmsObject, obj_keywords_info->addkey);
   update_keywords(cmsObject, obj_keywords_info->addkey);
   xvf_set_attribute(obj_keywords_info->addkey_struct, XVF_STRING_VAL, NULL);
   kfree(obj_keywords_info->addkey);
   obj_keywords_info->addkey = NULL;
   xvf_set_attribute(obj_keywords_info->delete_struct, XVF_ACTIVATE, TRUE);
   xvf_set_attributes(obj_keywords_info->chkey_struct,
		      XVF_STRING_VAL, obj_keywords_info->addkey,
		      XVF_ACTIVATE,   TRUE,
		      NULL);
   kfree(obj_keywords_info->chkey);
   obj_keywords_info->chkey = kstrdup(obj_keywords_info->addkey);
}

/*-----------------------------------------------------------
| Routine Name:	obj_keywords_chkey - change selected keyword
| 
| Purpose:	Do routine which is called when
|		string selection chkey is used
| 
| Input:	obj_keywords_info - ptr to PaneInfo struct for
|				    obj_keywords pane
| 
| Written By:	Neil Bowers
| Date:		Nov 10, 1994
------------------------------------------------------------*/
void obj_keywords_chkey(
     obj_attributes_obj_keywords *obj_keywords_info)
{
   kcms_remove_keyword(cmsObject, obj_keywords_info->keylist_label);
   kcms_add_keyword(cmsObject, obj_keywords_info->chkey);
   update_keywords(cmsObject, obj_keywords_info->chkey);
   xvf_set_attribute(obj_keywords_info->delete_struct, XVF_ACTIVATE, TRUE);
}


/*-----------------------------------------------------------
| Routine Name: obj_keywords_keylist
| 
| Purpose:	Do routine which is called when
|		displaylist selection keylist is used
| 
| Input:	obj_keywords_info - ptr to PaneInfo struct for
|				    obj_keywords pane
| 
| Written By:	Neil Bowers
| Date:		10-nov-94
------------------------------------------------------------*/
void obj_keywords_keylist(
     obj_attributes_obj_keywords *obj_keywords_info)
{
   /*--------------------------------------------------------------------
   | The user selected a keyword, so we can activate
   | the "Change selected keyword" selection
   --------------------------------------------------------------------*/
   xvf_set_attributes(obj_keywords_info->chkey_struct,
		      XVF_ACTIVATE,   TRUE,
		      XVF_STRING_VAL, obj_keywords_info->keylist_label,
		      NULL);
   kfree(obj_keywords_info->chkey);
   obj_keywords_info->chkey = kstrdup(obj_keywords_info->keylist_label);
   xvf_set_attribute(obj_keywords_info->delete_struct, XVF_ACTIVATE, TRUE);
}
