 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       	xvobject Initialization Routine
   >>>>
   >>>>   Static:
   >>>>		  exit_xvwidgets()
   >>>>  Private:
   >>>>           xvw_init_display()
   >>>>   Public:
   >>>>           xvw_display()
   >>>>           xvw_appcontext()
   >>>>           xvw_screen()
   >>>>           xvw_screennum()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "internals.h"
#include <X11/Vendor.h>


static Display      *display              = NULL;
static Screen       *screen               = NULL;
static int          screennum             = 0;
static XtAppContext appcontext            = NULL;


/*
 *  Fallback Resources used for initialization
 */
static kstring fallback_resources[] = {
        "*input:                True",
        NULL,
};

/*-----------------------------------------------------------
|
|  Routine Name: (static) exit_xvwidgets
|
|       Purpose: This routine is used to cleanup xvwidgets upon
|                exiting of the application.  Currently the only
|                thing it does is to annoy people.
|
|         Input: status - the exit status
|                client_data - the data we installed with the kexit_handler
|                              handler
|
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Oct 31, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void exit_xvwidgets(
   int   status,
   kaddr client_data)
{
	Display *disp = (Display *) client_data;

	if (kget_notify() == KHOSTILE				  &&
	    kaccess("/usr/demo/SOUND/sounds/flush.au", R_OK) == 0 &&
	    kaccess("/dev/audio", W_OK) == 0			  &&
	    xvw_check_localhost(NULL))
	{
	   kcopyfile("/usr/demo/SOUND/sounds/flush.au", "/dev/audio");
	}
	kset_errorhandler(NULL);
        kset_warnhandler(NULL);
        kset_prompthandler(NULL);
        kset_infohandler(NULL);
        kset_announcehandler(NULL);
        kset_choosehandler(NULL);
	if (disp) XtCloseDisplay(disp);
	kinfo(KDEBUG, "exiting....");
}


/*-----------------------------------------------------------
|
|  Routine Name: xvw_init_display()
|
|       Purpose: Initializes the xvwidget library.  Should be called
|                before any other calls to the xvwidget library are made.
|                xvw_init_display is acutally called by the public routine
|		 xvw_initialize(), a call to which is generated by conductor
|		 and is specific to the widget set being used.
|
|         Input: menu_handler - the general menu handling routines one of:
|
|		 ! XVW_MENUS_XVFORMS -  Enable the use of xvforms as internal
|                !                      menus
|		 ! XVW_MENUS_NONE    -  Disable internal menus
|
|        Output: none
|	Returns: the newly init_display display structure or NULL upon failure
|
|    Written By: Mark Young and Danielle Argiro
|          Date: Jul 14, 1992 15:31
| Modifications:
|
------------------------------------------------------------*/

Display *xvw_init_display(
   kfunc_void menu_handler)
{
	/*
	 *   *****  general initializations  *****
	 */
	xvw_toplevels       = NULL;

	/*
	 *  Sanity check for now...  Make sure that we don't allow the
	 *  programmer to re-initialize the display.
	 */
	if (display) return(display);

        /*  initialize the toolkit */
        XtToolkitInitialize();

        /* create an application context */
        appcontext = XtCreateApplicationContext();

        /* in case there was a problem creating application context,
           set fallback resources */
        XtAppSetFallbackResources(appcontext, fallback_resources);

        /*
         * open the display
         */
	xvw_ac = kprog_get_argc();
	xvw_av = kprog_get_argv();
        display = XtOpenDisplay(appcontext, NULL, kprog_get_program(),
                                kprog_get_program(), NULL, (Cardinal) 0,
                                &xvw_ac, xvw_av);
        if (display == NULL)
        {
	    kerror("xvwidgets", "xvw_init_display", 
		   "Unable to open display... '%s'", XDisplayName(NULL));
            return(NULL);
        }
	kprog_set_argc(xvw_ac);
	kprog_set_argv(xvw_av);

	XtInitializeWidgetClass(vendorShellWidgetClass);
	XtInitializeWidgetClass(ManagerWidgetClass);
        screennum = XDefaultScreen(display);
        screen = XDefaultScreenOfDisplay(display);

	/*
	 *  Install our own X error handlers and Xt converters.  An exit
	 *  handler is also installed in order to shutdown the display.
	 */
	xvw_init_errors();
	xvw_init_converters();
	kexit_handler(exit_xvwidgets, display);

	/*
	 *  Check the command line arguments and make sure that there are
	 *  no left-over command line.
	 */
	if (!kclui_check_args())
	   kexit(KEXIT_FAILURE);

	if (menu_handler != XVW_MENUS_NONE)
	    (*menu_handler)();

	khoros_imprint();
	return(display);
}


/************************************************************
*
*  Routine Name: xvw_display - returns the display associated with a object
*
*       Purpose: Returns the display associated with the object.
*		 Note that this is the GUI & Visualization
*                services equivalent of \fIXtDisplay()\fP.
*		 If object is NULL, returns the default display.
*
*         Input: object - object for which to identify the display
*
*        Output: none
*	Returns: The display associated with the object or gadget
*                on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jun 15, 1992 18:20
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

Display *xvw_display(
   xvobject object)
{
	Widget widget = xvw_widget(object);

	if (!object)
	   return(display);
	do
	{
	   if (XtIsWidget(widget))
	      return(XtDisplay(widget));
	} while ((widget = XtParent(widget)) != NULL);

	return(NULL);
}

/************************************************************
*
*  Routine Name: xvw_appcontext - return the application context associated
*				  with a object
*
*       Purpose: Returns the application context associated with the
*		 object.    Note that this is the GUI & Visualization
*                services equivalent of \fIXtWidgetToApplicationContext()\fP.
*		 If object is NULL, returns the default application context.
*
*         Input:  object - object for which to get the application context
*        Output: 
*       Returns: The application context associated with the object 
*		 on success, NULL on failure
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: Mark Young
*          Date: Jan 21, 1993 10:35
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

XtAppContext xvw_appcontext(
   xvobject object)
{
	Widget widget = xvw_widget(object);

	if (!object)
	   return(appcontext);

	do
	{
	   if (XtIsWidget(widget))
	      return(XtWidgetToApplicationContext(widget));
	} while ((widget = XtParent(widget)) != NULL);
	return(NULL);
}

/************************************************************
*
*  Routine Name: xvw_screen - return the screen associated with a object
*
*       Purpose: Returns the display screen associated with the
*		 object.  Note that this is the GUI & Visualization
*                services equivalent of \fIXtScreen()\fP.
*		 If object is NULL, returns the default screen.
*
*         Input:  object - object for which to get the screen
*        Output: 
*       Returns: The Screen associated with the object 
*		 on success, NULL on failure
*
*  Restrictions: Restrictions on data or input as applicable
*    Written By: Mark Young
*          Date: Jan 21, 1993 10:35
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

Screen *xvw_screen(
   xvobject object)
{
	Widget widget = xvw_widget(object);

	if (!object)
	   return(screen);

	do
	{
	   if (XtIsWidget(widget))
	      return(XtScreen(widget));
	} while ((widget = XtParent(widget)) != NULL);
	return(NULL);
}

/************************************************************
*
*  Routine Name: xvw_screennum - return the screen number associated 
*                                with an object
*
*       Purpose: Returns the screen index number associated with the
*		 object.  Note that this is the GUI & Visualization
*		 services equivalent of \fIXScreenNumberOfScreen()\fP.
*		 If object is NULL, returns the default screen number.
*
*         Input:  object - object for which to get the screen number
*        Output: 
*       Returns: The screen number associated with the object
*		 on success, -1 on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jan 21, 1993 10:35
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

int xvw_screennum(
   xvobject object)
{
	Widget widget = xvw_widget(object);

	if (!object) return(screennum);

	do
	{
	   if (XtIsWidget(widget))
	      return(XScreenNumberOfScreen(XtScreen(widget)));
	} while ((widget = XtParent(widget)) != NULL);
	return(-1);
}
