 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>         Resource Convert Utilities
   >>>>
   >>>>  Private:
   >>>>   Static:
   >>>>   Public:
   >>>>             xvw_convert_resource()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
 

/************************************************************
*
*  Routine Name: xvw_convert_resource - converts a resource from
*					one type to another
*
*       Purpose: The convert resource is used to convert a resource
*		 from one type to another.  This is done by calling
*		 the correct converter in order to have the value
*		 converted.
*
*         Input: object - the object in which to convert for
*                itype - the input argument's resource type
*		 iarg  - the input argument
*                otype - the output argument's resource type
*
*        Output: oarg - the output argument
*       Returns: TRUE (1) on success, FALSE (0) otherwise
*
*  Restrictions:
*    Written By:
*          Date: 
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/
/* ARGSUSED */
int xvw_convert_resource(
   xvobject object,
   char  *itype,
   kaddr iarg,
   char  *otype,
   kaddr oarg)
{
	/*
	 *  If the xv attribute class is not the same as that of the objects
	 *  then go ahead and call the converter to convert it.  If it turns
	 *  out that no such converter exists a warning will be printed...
	 */
#if 0
	if (xvwres(temp) != widres(temp))
	{
	   to.size = 0;
	   to.addr = NULL;
	   from.addr = addr;
	   from.size = sizeof(from.addr);
	   XtConvert(widget, XrmQuarkToString(xvwres(temp)), &from,
		     XrmQuarkToString(widres(temp)), &to);

	   if (widres(temp) == XtQfloat)
	   {
	      kmemcpy(&fvalue, to.addr, to.size);
	      addr = (XtPointer) &fvalue;
	   }
	   else if (widres(temp) == XtQdouble)
	   {
	      kmemcpy(&dvalue, to.addr, to.size);
	      addr = (XtPointer) &dvalue;
	   }
	   else if (widres(temp) == XtQstring ||
		    widres(temp) == XtQfilename)
	   {
	      addr = (XtPointer) to.addr;
	   }
	   else
	   {
	      kmemcpy(&value, to.addr, to.size);
	      addr = (XtPointer) &value;
	   }
	}
#endif

	return(TRUE);
}
