 /* Khoros: $Id$ */
 /* $Log$ */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private include file for xvutils library
   >>>>
   >>>>    Written By: Danielle Argiro
   >>>>
   >>>>          Date: Jul 16, 1992
   >>>>
   >>>> Modifications: Updated to Khoros 2.0 (DA)
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvutils_internals_h_
#define _xvutils_internals_h_


        /*-------------------------------------*
        |       #include
        ---------------------------------------*/

#include <design.h>
#include <xvinclude.h>


        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

#define XVU_LEFT_MARGIN     6

#define XVU_BOGUS_PATH      0
#define XVU_DIRECTORY_PATH  1
#define XVU_FILE_PATH       2

#define XVU_MAXFILENUM      50


        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

/*
 *    xvu_list_entry maintains items in list	
 *    where only one item can be selected
 */
typedef struct _xvu_list_entry {

        int count;
        xvw_list_struct *entry;
        struct _xvu_list_entry *next; 
	struct _xvu_list_entry *prev;

} xvu_list_entry;

/*
 *    xvu_multlist_entry maintains items in list	
 *    where more than one item can be selected
 */
typedef struct _xvu_multlist_entry {

        xvobject button;
        xvobject list_back;
        char   *filename;
        char   **items;
        int    currently_mapped;
        int   numitems;
        struct _xvu_multlist_entry *next;
} xvu_multlist_entry;

typedef struct {

        xvobject toplevel;
        xvobject back;
        xvobject label;
        char *path;
        int duplicate_entries;
        xvu_multlist_entry *multlist;
} List_Data;

typedef struct _Select_Info
{
	xvobject	toplevel;
	char		*prompt;                /* KLUDGE */
	int		num;
} Select_Info;

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/


/* exit.c */
int xvu_create_exit PROTO((char *, char *, char *, char *, char *));

/* help.c */
void xvu_display_online_help PROTO((xvobject, kaddr, kaddr));

/* list_util.c */
xvu_list_entry *xvu_add_list_entry    PROTO((void));
void            xvu_delete_list_entry PROTO((xvu_list_entry *));

/* prompt.c */
int xvu_create_prompt PROTO((char *, char *, char *, char *));

/* query.c */
xvobject xvu_create_query PROTO((char *, char **, char *, char **, int, int));

/* select.c */
int xvu_create_select PROTO((char *, char *, char **, int));

/* text.c */
xvobject xvu_create_text_object PROTO((char *, char *, char *, int, int));

/* utilities.c */

char **xvu_get_path_info       PROTO((char *, int *, int *));
char **xvu_compose_single_list PROTO((char *, char *, int *, int));
int xvu_compose_whole_list PROTO((char *, char **, int, char **, int *, int));
int xvu_figure_width       PROTO((char *));
int xvu_figure_height      PROTO((char *, int));
void xvu_dummy_icon_cb     PROTO((xvobject, kaddr));
int xvu_find_string_width  PROTO((char *));

/* view.c */
int xvu_create_view PROTO((char *, char *));

/* warn.c */
int xvu_create_warn PROTO((char *, char *, char *, char *));

#endif /* _xvutils_internals_h_ */
/* Don't add after the endif */
