 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros RootWindow Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>> 		SetValues()
   >>>> 		Realize()
   >>>>   Public:
   >>>>			xvw_create_rootwindow()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/RootWindowP.h>

static void	Realize         PROTO((Widget, XtValueMask *, 
                                       XSetWindowAttributes *));
static void     ClassInitialize PROTO((void));
static void ConstraintInitialize PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void	Destroy		PROTO((Widget));

static void RootWindowDepth	 PROTO((Widget, int, XrmValue *));
static void RootWindowColormap	 PROTO((Widget, int, XrmValue *));
static void RootWindowSensitive  PROTO((Widget, int, XrmValue *));

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
  NULL,
};

/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwRootWindowWidgetRec, rootwindow.field)

static XtResource resources[] = { 
{XtNx, XtCPosition, XtRPosition, sizeof(Position),
  XtOffsetOf(XvwRootWindowWidgetRec, core.x), XtRImmediate, (XtPointer) 0},
{XtNy, XtCPosition, XtRPosition, sizeof(Position),
  XtOffsetOf(XvwRootWindowWidgetRec, core.y), XtRImmediate, (XtPointer) 0},
{ XtNdepth, XtCDepth, XtRInt, sizeof(int),
  XtOffsetOf(XvwRootWindowWidgetRec, core.depth), XtRCallProc,
  (XtPointer) RootWindowDepth},
{ XtNcolormap, XtCColormap, XtRColormap, sizeof(Colormap),
  XtOffsetOf(XvwRootWindowWidgetRec, core.colormap), XtRCallProc,
  (XtPointer) RootWindowColormap},
{ XtNancestorSensitive, XtCSensitive, XtRBoolean, sizeof(Boolean),
  XtOffsetOf(XvwRootWindowWidgetRec, core.ancestor_sensitive), XtRCallProc,
  (XtPointer) RootWindowSensitive},
};

#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for RootWindow Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwRootWindowWidgetClassRec xvwRootWindowWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "RootWindow",			/* class_name		  */
    sizeof(XvwRootWindowWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),                /* resource_count         */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwRootWindowWidgetConstraintsRec),/* constraint_size	  */
    ConstraintInitialize,		    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwRootWindowWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwRootWindowWidgetClass = (WidgetClass) &xvwRootWindowWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef kwidget
#undef kwidgetclass
#undef kconstraint

#define kwidget(widget)	    (XvwRootWindowWidget) (widget)
#define kwidgetclass(widget) (XvwRootWindowWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwRootWindowWidgetConstraints) (widget)->core.constraints


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwRootWindowWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Oct 19, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwRootWindowWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/RootWindow");
}


/*-----------------------------------------------------------
|
|  Routine Name: ConstraintInitialize
|
|       Purpose: This method is used to overide the transient
|
|         Input: request - widget child with requested constraints
|                new     - widget child with overidden translations and
|                          installed accelerators
|    Written By: Mark Young
|          Date: Oct 27, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ConstraintInitialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XSetWindowAttributes attr;

	if (XtIsWidget(new))
	{
	   if (!XtWindow(new))
	      XtRealizeWidget(new);

	   attr.override_redirect = TRUE;
	   XChangeWindowAttributes(XtDisplay(new), XtWindow(new),
		CWOverrideRedirect, &attr);
	}
}


/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This method will set up the window attributes
|                and create a window for the XvwRootWindowWidget. 
|                The desired initial window attributes are passed 
|                in via a mask and list of specification attributes.
|		 The gc is also initialized here.
|
|         Input: widget     - the widget to realize
|                valuemask  - determines the window attributes being passed in
|                attributes - the list of window attributes to be set
|    Written By: Mark Young
|          Date: Oct 19, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget               widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
	XvwRootWindowWidget xwid = kwidget(widget);
	Display *display = xvw_display(NULL);
	Screen  *screen  = xvw_screen(NULL);
	int     screenum = xvw_screennum(NULL);

	/*
	 *  Initialize the background grid, now that we have a valid window
	 */
	xwid->core.x = xwid->core.y = 0;
	xwid->core.window = xvw_rootwindow(NULL);
	xwid->core.width  = XDisplayWidth(display, screenum);
	xwid->core.height = XDisplayHeight(display, screenum);
	xwid->core.background_pixel = BlackPixelOfScreen(screen);
	xwid->manager.preferred_width  = xwid->core.width;
	xwid->manager.preferred_height = xwid->core.height;
	ManagerCreateGrid(widget);
/*
	XtGrabPointer(widget, True, PointerMotionMask|ButtonPressMask|
		ButtonReleaseMask, GrabModeAsync, GrabModeAsync,
		None, None, CurrentTime);
 */
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwRootWindowWidget instance.  The public values
|                which can be changed are all related to the scrollbars. 
|		 FILL IN WHAT ALLOW_VERTICAL, ALLOW_HORIZONTAL, ETC.
|		 ARE FOR			-SK
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Oct 20, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwRootWindowWidget cxwid = kwidget(current);
	XvwRootWindowWidget nxwid = kwidget(new);


	if (cxwid->core.x != nxwid->core.x ||
	    cxwid->core.y != nxwid->core.y)
	{
	   nxwid->core.x = nxwid->core.y = 0;
	}

	if (cxwid->core.width  != nxwid->core.width ||
	    cxwid->core.height != nxwid->core.height)
	{
	   int screenum = XScreenNumberOfScreen(XtScreen(new));
	   nxwid->core.width  = XDisplayWidth(XtDisplay(new), screenum);
	   nxwid->core.height = XDisplayHeight(XtDisplay(new), screenum);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: This method will deallocate the gc used
|                by the XvwManagerWidget before it is destroyed.
|
|         Input: widget - the widget being destroyed
|
|    Written By: Mark Young
|          Date: Aug 19, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
}

/*-----------------------------------------------------------
|
|  Routine Name: RootWindowDepth - the default depth for root window
|
|    Written By: Mark Young
|          Date: Oct 20, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RootWindowDepth(
    Widget      widget,
    int         offset,
    XrmValue    *value)
{
	value->addr = (kaddr) (&DefaultDepthOfScreen(XtScreen(widget)));
}

/*-----------------------------------------------------------
|
|  Routine Name: RootWindowColormap - the default colormap for root window
|
|    Written By: Mark Young
|          Date: Oct 20, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RootWindowColormap(
    Widget      widget,
    int         offset,
    XrmValue    *value)
{
	value->addr = (kaddr) (&DefaultColormapOfScreen(XtScreen(widget)));
}

/*-----------------------------------------------------------
|
|  Routine Name: RootWindowSensitive - the default sensitivity for root window
|
|    Written By: Mark Young
|          Date: Oct 20, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void RootWindowSensitive(
    Widget      widget,
    int         offset,
    XrmValue    *value)
{
	static Boolean sensitive = TRUE;

	value->addr = (kaddr) (&sensitive);
}


/************************************************************
*
*  Routine Name: xvw_create_rootwindow() - create a rootwindow object
*
*       Purpose: Creates a rootwindow object.  This is a toplevel object
*		 similar to a shell object, which serve as a toplevel for
*		 an application; the toplevel serves as a mediating device
*		 between the application and the window manager.  This call
*		 allows the application to have several independant windows,
*		 which is the case with xvroutines having multiple subforms.
*		 The routine also supports the creation of toplevels on
*		 potentially different screens, which applies when a Khoros
*		 application distributes its user interface with the concert
*		 program.  Both the display and screen are optional arguments;
*		 if either of these are set to NULL, then the default display 
*                and default screen will be used.
*
*         Input: name    - name with which to reference rootwindow object
*		 display - the X Display structure; if NULL, use the
*			   default display
*                screen  - the X Screen structure; if NULL, use the
*			   default screen
*
*        Output: 
*	Returns: The rootwindow object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Oct 13, 1994
*      Verified: 
*  Side Effects:
* Modifications:
*   Declaration: xvobject xvw_create_rootwindow(
*                !   char    *name,
*                !   Display *display,
*                !   Screen  *screen)
*
*******************************************************************/

xvobject xvw_create_rootwindow(
   char    *name,
   Display *display,
   Screen  *screen)
{
	xvobject parent, rootwindow;


	/*
	 *  Create the invisible parent.  Shouldn't have to do this, but
	 *  Xt and most widget set expect toplevel widgets to be subclassed
	 *  off a shell widget.
	 */
	parent = xvw_create_application_shell(name, display, screen);

	/*
	 *  Go ahead create the root and realize it
	 */
	rootwindow = xvw_create(parent, FALSE, TRUE,name,RootWindowWidgetClass);
	xvw_realize(rootwindow);

	return(rootwindow);
}
