 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros NotifyWindow Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		Realize()
   >>>>
   >>>> 		NotifySetString()
   >>>> 		NotifyGetString()
   >>>>   Public:
   >>>>			xvw_create_notifywindow()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/NotifyWindowP.h>

static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static void	Realize         PROTO((Widget, XtValueMask *, 
                                       XSetWindowAttributes *));
static int NotifySetString	PROTO((xvobject, char *, kaddr));
static int NotifyGetString	PROTO((xvobject, char *, kaddr));


/*-------------------------------------------------------------------*
|
|   Define Default Pixmap Paths
|
--------------------------------------------------------------------*/
 
#define NOTIFY_PIXMAP "$DESIGN/objects/library/xvobjects/misc/pixmaps/hourglass.xbm"

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_NOTIFYWINDOW_LABEL_OBJECT,   NULL,   XtRPointer,  NULL},
{XVW_NOTIFYWINDOW_ICON_OBJECT,    NULL,   XtRPointer,  NULL},
{XVW_NOTIFYWINDOW_TEXT_OBJECT,    NULL,   XtRPointer,  NULL},
{XVW_NOTIFYWINDOW_LABEL,	  NULL,   XtRString,   NULL},
{XVW_NOTIFYWINDOW_MESSAGE,	  NULL,   XtRString,   NULL},
{XVW_NOTIFYWINDOW_TITLE,	  NULL,   XtRString,   NULL},
{XVW_NOTIFYWINDOW_VISIBLE,	  NULL,   XtRInt,      NULL},
{XVW_NOTIFYWINDOW_NOTIFYFOR,	  NULL,   XtRPointer,  NULL},

{XVW_NOTIFYWINDOW_PIXMAP,	  NULL,   XtRPixmap,   NULL},
{XVW_NOTIFYWINDOW_PIXMAPFILE,	  XVW_NOTIFYWINDOW_PIXMAP,   XtRFilename, XtRPixmap},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwNotifyWindowWidgetRec, notifywindow.field)

static XtResource resources[] = { 
{XVW_NOTIFYWINDOW_LABEL_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(label), XtRImmediate, (XtPointer) NULL},
{XVW_NOTIFYWINDOW_ICON_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(icon), XtRImmediate, (XtPointer) NULL},
{XVW_NOTIFYWINDOW_TEXT_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(text), XtRImmediate, (XtPointer) NULL},
{XVW_NOTIFYWINDOW_NOTIFYFOR, NULL, XtRPointer, sizeof(XtPointer),
        offset(notifyfor), XtRImmediate, (XtPointer) NULL},

{XVW_NOTIFYWINDOW_PIXMAP, XVW_NOTIFYWINDOW_PIXMAPFILE,  XtRPixmap, 
	sizeof(Pixmap),
        offset(notify_pixmap), XtRString, (XtPointer) NOTIFY_PIXMAP},

{XVW_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(WidgetRec, core.width), XtRImmediate, (XtPointer) 350 },
{XVW_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(WidgetRec, core.height), XtRImmediate, (XtPointer) 150},
{XVW_MANAGER_DELAYED_LAYOUT, NULL, XtRBoolean, sizeof(Boolean),
        XtOffsetOf(XvwManagerWidgetRec, manager.delayed_layout),
	XtRImmediate, (XtPointer) FALSE },
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for NotifyWindow Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwNotifyWindowWidgetClassRec xvwNotifyWindowWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "NotifyWindow",			/* class_name		  */
    sizeof(XvwNotifyWindowWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    Realize,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,				/* expose		  */
    NULL,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwNotifyWindowWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwNotifyWindowWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwNotifyWindowWidgetClass = (WidgetClass) &xvwNotifyWindowWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwNotifyWindowWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwNotifyWindowWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Neil Bowers and Mark Young
|          Date: Nov 24, 1993
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassInitialize(void)
{
	xvw_init_attributes(xvwNotifyWindowWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/NotifyWindow");
        xvw_define_attributes(xvwNotifyWindowWidgetClass,
           XVW_NOTIFYWINDOW_LABEL,   XtRString,NotifySetString, NotifyGetString,
           XVW_NOTIFYWINDOW_MESSAGE, XtRString,NotifySetString, NotifyGetString,
           XVW_NOTIFYWINDOW_TITLE,   XtRString,NotifySetString, NotifyGetString,
           XVW_NOTIFYWINDOW_VISIBLE, XtRInt,   NotifySetString, NotifyGetString,
           NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial notifywindow widget
|		 instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: Apr 10, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwNotifyWindowWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);


	xwid->notifywindow.visible = FALSE;
	xwid->notifywindow.label_string = NULL;
	xwid->notifywindow.text_string  = NULL;
	xwid->notifywindow.title_string = NULL;

	xwid->notifywindow.icon = xvw_create_pixmap(object, "pixmap");
	xvw_set_attributes(xwid->notifywindow.icon,
		XVW_PIXMAP,	      xwid->notifywindow.notify_pixmap,
		XVW_FORCE_REDISPLAY,  TRUE,
		XVW_BELOW,            NULL,
		XVW_RIGHT_OF,         NULL,
		XVW_BORDER_WIDTH,     0,
		NULL);

	xwid->notifywindow.label = xvw_create_labelstr(object, "label");
	xvw_set_attributes(xwid->notifywindow.label,
	   XVW_LABEL,		"   Please Wait   ",
	   XVW_FORCE_REDISPLAY, TRUE,
	   XVW_BELOW,		xwid->notifywindow.icon,
	   XVW_ABOVE,		xwid->notifywindow.icon,
	   XVW_RIGHT_OF,	xwid->notifywindow.icon,
	   NULL);

	xwid->notifywindow.text = xvw_create_labelstr(object, "text");
	xvw_set_attributes(xwid->notifywindow.text,
	   XVW_LABEL,		"   Initializing...   ",
	   XVW_FORCE_REDISPLAY, TRUE,
	   XVW_BELOW,		xwid->notifywindow.icon,
	   XVW_ABOVE,		NULL,
	   XVW_LEFT_OF,		NULL,
	   XVW_RIGHT_OF,	NULL,
	   XVW_LABEL_JUSTIFY,	KLABEL_JUSTIFY_CENTER,
	   NULL);
}


/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This method will set up the window attributes
|                and create a window for the XvwNotifyWindowWidget. 
|                The desired initial window attributes are passed 
|                in via a mask and list of specification attributes.
|
|         Input: widget     - the widget to realize
|                valuemask  - determines the window attributes being passed in
|                attributes - the list of window attributes to be set
|    Written By: Mark Young
|          Date: Apr 10, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget               widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
	XvwNotifyWindowWidget xwid = kwidget(widget);

	int	 mode;
	xvobject child;

        if ((mode = XDoesBackingStore(XtScreen(widget))) != NotUseful)
        {
           *valuemask |= CWBackingStore;
           winattrib->backing_store = mode;
        }
	(*xvwNotifyWindowWidgetClass->core_class.superclass->core_class.realize)
		(widget, valuemask, winattrib);

	child = xwid->notifywindow.icon;
	ManagerRealizeObject(xvw_class(child), xvw_widget(child));
	child = xwid->notifywindow.label;
	ManagerRealizeObject(xvw_class(child), xvw_widget(child));
	child = xwid->notifywindow.text;
	ManagerRealizeObject(xvw_class(child), xvw_widget(child));
}

/*-----------------------------------------------------------
|
|  Routine Name: NotifySetString - select an item
|
|       Purpose: Resource attribute for setting  an item.  The
|
|         Input: xvobject - the parent object in which we are to select the item
|                attribute - the 
|                calldata - the item to be selected
|    Written By: Mark Young
|          Date: Apr 10, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static int NotifySetString(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	xvobject toplevel;
        Widget   widget = xvw_widget(object);
        XvwNotifyWindowWidget xwid = kwidget(widget);


	if (kstrcmp(attribute, XVW_NOTIFYWINDOW_TITLE) == 0)
	{
	   String   string = *(String *) calldata;

	   toplevel = xvw_toplevel(object);
	   kfree(xwid->notifywindow.title_string);
	   xwid->notifywindow.title_string = kstrdup(string);
	   xvw_set_attribute(toplevel, XVW_SHELL_TITLE, 
			xwid->notifywindow.title_string);
	}
	else if (kstrcmp(attribute, XVW_NOTIFYWINDOW_LABEL) == 0)
	{
	   String   string = *(String *) calldata;

	   kfree(xwid->notifywindow.label_string);
	   xwid->notifywindow.label_string = kstrdup(string);
	   xvw_set_attribute(xwid->notifywindow.label, XVW_LABEL,
			xwid->notifywindow.label_string);
	}
	else if (kstrcmp(attribute, XVW_NOTIFYWINDOW_MESSAGE) == 0)
	{
	   String   string = *(String *) calldata;

	   kfree(xwid->notifywindow.text_string);
	   xwid->notifywindow.text_string = kstrdup(string);
	   xvw_set_attribute(xwid->notifywindow.text, XVW_LABEL,
			xwid->notifywindow.text_string);
	}
	else if (kstrcmp(attribute, XVW_NOTIFYWINDOW_VISIBLE) == 0)
	{
	   int visible = *(int *) calldata;

	   xwid->notifywindow.visible = visible;
	   if (xwid->notifywindow.toplevel)
	   {
	      toplevel = xvw_toplevel(object);
	      if (xwid->notifywindow.visible)
	         xvw_place(toplevel, xwid->notifywindow.notifyfor);
	      else
	         xvw_unmap(toplevel);
	   }
	   else
	   {
	      if (xwid->notifywindow.visible)
	      {
	         xvw_map(object);
		 xvw_raise(object);
	      }
	      else
	         xvw_unmap(object);
	   }
	   XSync(xvw_display(object), FALSE);
	}
        else
        {
           kinfo(KSTANDARD,"NotifySetString:  Unknown xvattribute '%s' ",
			attribute);
           return(FALSE);
        }
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: NotifyGetString - select an item
|
|       Purpose: Resource attribute for setting  an item.  The
|
|         Input: xvobject - the parent object in which we are to select the item
|                attribute - the 
|                calldata - the item to be selected
|    Written By: Mark Young
|          Date: Apr 10, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static int NotifyGetString(
   xvobject object,
   char     *attribute,
   kaddr    calldata)
{
	String   *string  = (String *) calldata;
	Boolean  *visible = (Boolean *) calldata;
        Widget   widget = xvw_widget(object);
        XvwNotifyWindowWidget xwid = kwidget(widget);


	if (kstrcmp(attribute, XVW_NOTIFYWINDOW_TITLE) == 0)
	   *string = xwid->notifywindow.title_string;
	else if (kstrcmp(attribute, XVW_NOTIFYWINDOW_LABEL) == 0)
	   *string = xwid->notifywindow.label_string;
	else if (kstrcmp(attribute, XVW_NOTIFYWINDOW_MESSAGE) == 0)
	   *string = xwid->notifywindow.text_string;
	else if (kstrcmp(attribute, XVW_NOTIFYWINDOW_VISIBLE) == 0)
	   *visible = xwid->notifywindow.visible;
        else
        {
           kinfo(KSTANDARD,"NotifyGetString:  Unknown xvattribute '%s' ",
			attribute);
           return(FALSE);
        }
	return(TRUE);
}


/************************************************************
*
*  Routine Name: xvw_create_notifywindow - create a notifywindow object
*
*       Purpose: The notifywindow object provides a convenient mechanism
*		 for the application to notify the user when it is performing
*		 an operation that will take some time, and that the user
*		 is expected to wait patiently until it is done.  
*
*		 The notifywindow object pops up without placement;
*		 it contains an icon (by default, an hourglass), a
*		 label, and a message so that the application may inform
*		 the user exactly why they are waiting. 
*
*		 With applications that will use the notifywindow periodically,
*		 it is recommended that a single notifywindow be created for the
*                application on startup, with \f(CWXVW_NOTIFYWINDOW_VISIBLE\fP
*		 set to FALSE.  Then, whenever necessary, the message displayed 
*		 by the notifywindow can be updated using the 
*		 \f(CWXVW_NOTIFYWINDOW_MESSAGE\fP attribute, and the 
*                notifywindow object popped up using the 
*                \f(CWXVW_NOTIFYWINDOW_VISIBLE\fP attribute.
*		 When the application is done, \f(CWXVW_NOTIFYWINDOW_VISIBLE\fP
*                can be set to FALSE again, until the next time the notifywindow
*		 object is to be popped up.
*
*         Input: parent - parent of the notifywindow object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference notifywindow object
*
*        Output:
*       Returns: The notifywindow object on success, NULL on failure
*
*  Restrictions:
*    Written By: Neil Bowers and Mark Young
*          Date: Nov 24, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_notifywindow(
   xvobject parent,
   char     *name)
{
	xvobject object;
        XvwNotifyWindowWidget xwid;

	if ((object = xvw_create(parent, TRUE, TRUE, name,
		NotifyWindowWidgetClass)) == NULL)
	   return(NULL);

	xwid = (XvwNotifyWindowWidget) xvw_widget(object);
	if (!parent)
	{
	   xwid->notifywindow.toplevel = TRUE;
	   xvw_set_attribute(xvw_toplevel(object), XVW_MAP_WHEN_MANAGED, FALSE);
	}
	else
	   xwid->notifywindow.toplevel = FALSE;

	return(object);
}
