 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros Help Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		SetValues()
   >>>> 		QuitCallback()
   >>>> 		UpdateHelp()
   >>>> 		HelpCallback()
   >>>> 		MenuCallback()
   >>>> 		CreateTermList()
   >>>> 		CreateOptionsMenu()
   >>>> 		SetTextDisplayFile()
   >>>> 		GetTextDisplayTitle()
   >>>>   Public:
   >>>>			xvw_create_help()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvobjects/HelpP.h>

static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));

static int   UpdateHelp           PROTO((xvobject, char *, kaddr));
static void  QuitCallback         PROTO((xvobject, kaddr, kaddr));
static void  HelpCallback         PROTO((xvobject, kaddr, kaddr));
static void  MenuCallback         PROTO((xvobject, kaddr, kaddr));
static void  CreateTermList       PROTO((xvobject));
static void  CreateOptionsMenu    PROTO((xvobject));
static void  SetTextDisplayFile   PROTO((xvobject, char *));
static char *GetTextDisplayTitle  PROTO((char *, char *));

static int tb_num = 0;
static char **toolboxes = NULL;
static klist *glossary = NULL;
static klist *manpages = NULL;

/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_HELP_TEXTDISPLAY_OBJECT,  NULL,   XtRPointer,  NULL},
{XVW_HELP_NAME_OBJECT, NULL,   XtRPointer,  NULL},
{XVW_HELP_TITLE_OBJECT, NULL,   XtRPointer,  NULL},
{XVW_HELP_QUIT_OBJECT,  NULL,   XtRPointer,  NULL},
{XVW_HELP_MENU_OBJECT,  NULL,   XtRPointer,  NULL},
{XVW_HELP_CALLBACK,	NULL,   XtRCallback, NULL},
{XVW_HELP_FILENAME,	NULL,   XtRString, NULL},
{XVW_HELP_DISPLAYQUIT,	NULL,   XtRInt,    XtRBoolean},
{XVW_HELP_DISPLAYTITLE,	NULL,   XtRInt,    XtRBoolean},
{XVW_HELP_DISPLAYMENU,	NULL,   XtRInt,    XtRBoolean},
{XVW_HELP_HYPERTEXT,    NULL,   XtRInt,    XtRBoolean},
{XVW_HELP_MORE_FILES,   NULL,   XtRInt,    XtRBoolean},
{XVW_HELP_DESTROY_ON_QUIT, NULL,XtRInt,    XtRBoolean},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwHelpWidgetRec, help.field)

static XtResource resources[] = { 
{XVW_HELP_NAME_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(name), XtRImmediate, (XtPointer) NULL},
{XVW_HELP_TITLE_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(title), XtRImmediate, (XtPointer) NULL},
{XVW_HELP_QUIT_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(quit), XtRImmediate, (XtPointer) NULL},
{XVW_HELP_MENU_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(menubutton), XtRImmediate, (XtPointer) NULL},
{XVW_HELP_TEXTDISPLAY_OBJECT, NULL, XtRPointer, sizeof(XtPointer),
        offset(textdisplay), XtRImmediate, (XtPointer) NULL},
{XVW_HELP_FILENAME, NULL, XtRString, sizeof(String),
      offset(filename), XtRImmediate, (XtPointer) NULL},
{XVW_HELP_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(help_callback), XtRCallback, (XtPointer) NULL},
{XVW_HELP_DISPLAYQUIT, NULL, XtRBoolean, sizeof(Boolean),
      offset(display_quit), XtRImmediate, (XtPointer) TRUE},
{XVW_HELP_DISPLAYMENU, NULL, XtRBoolean, sizeof(Boolean),
      offset(display_menu), XtRImmediate, (XtPointer) TRUE},
{XVW_HELP_DISPLAYTITLE, NULL, XtRBoolean, sizeof(Boolean),
      offset(display_title), XtRImmediate, (XtPointer) TRUE},
{XVW_HELP_HYPERTEXT, NULL, XtRBoolean, sizeof(Boolean),
      offset(do_hypertext), XtRImmediate, (XtPointer) FALSE},
{XVW_HELP_MORE_FILES, NULL, XtRBoolean, sizeof(Boolean),
      offset(more_files), XtRImmediate, (XtPointer) TRUE},
{XVW_HELP_DESTROY_ON_QUIT, NULL, XtRBoolean, sizeof(Boolean),
      offset(destroy_on_quit), XtRImmediate, (XtPointer) TRUE},

{XVW_PREFERRED_WIDTH, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwManagerWidgetRec, manager.preferred_width),
	XtRImmediate, (XtPointer) 500 },
{XVW_PREFERRED_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
        XtOffsetOf(XvwManagerWidgetRec, manager.preferred_height),
	XtRImmediate, (XtPointer) 650},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for Help Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwHelpWidgetClassRec xvwHelpWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "Help",				/* class_name		  */
    sizeof(XvwHelpWidgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwHelpWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwHelpWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwHelpWidgetClass = (WidgetClass) &xvwHelpWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for Class and Constraint Declarations
|
--------------------------------------------------------------------*/

#undef kwidget
#undef kwidgetclass
#undef kconstraint

#define kwidget(widget)	     (XvwHelpWidget) (widget)
#define kwidgetclass(widget) (XvwHelpWidgetClass) (widget)->core.widget_class
#define kconstraint(widget)  (XvwHelpWidgetConstraints) (widget)->core.constraints


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwHelpWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|         Input:
|
|        Output:
|       Returns: 
|
|    Written By: Mark Young
|          Date: Oct 19, 1992 9:54
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwHelpWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvobjects/app-defaults/Help");
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial help widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: May 26, 1993 13:28
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwHelpWidget xwid = kwidget(new);
	xvobject object = xvw_object(new);

	xwid->help.filenames = NULL;
	xwid->help.hfiles    = NULL;
	xwid->help.numhfiles = xwid->help.current = xwid->help.num = 0;

	xwid->help.quit = xvw_create_button(object, "quit");
	xvw_set_attributes(xwid->help.quit,
		XVW_LABEL,		"Quit",
		XVW_CHAR_HEIGHT,	1.0,
		XVW_LABEL_JUSTIFY,      KLABEL_JUSTIFY_CENTER,
		XVW_BELOW,		NULL,
		XVW_LEFT_OF,		NULL,
		XVW_MAP_WHEN_MANAGED,   xwid->help.display_quit,
		NULL);

	xwid->help.title = xvw_create_label(object, "title");
	xvw_set_attributes(xwid->help.title,
		XVW_LABEL,		"Online Help",
		XVW_CHAR_HEIGHT,	1.0,
		XVW_LABEL_JUSTIFY,      KLABEL_JUSTIFY_CENTER,
		XVW_LEFT_OF,		NULL,
		XVW_RIGHT_OF,		NULL,
		XVW_BELOW,		NULL,
		XVW_MAP_WHEN_MANAGED,   xwid->help.display_title,
		NULL);

	xwid->help.next = xvw_create_button(object, "next");
	xvw_set_attributes(xwid->help.next,
		XVW_LABEL,		"Next",
		XVW_CHAR_HEIGHT,	1.0,
		XVW_LABEL_JUSTIFY,      KLABEL_JUSTIFY_CENTER,
		XVW_LEFT_OF,		NULL,
		XVW_ABOVE,		NULL,
		NULL);

	xwid->help.previous = xvw_create_button(object, "previous");
	xvw_set_attributes(xwid->help.previous,
		XVW_LABEL,		"Previous",
		XVW_CHAR_HEIGHT,	1.0,
		XVW_LABEL_JUSTIFY,      KLABEL_JUSTIFY_CENTER,
		XVW_RIGHT_OF,		NULL,
		XVW_ABOVE,		NULL,
		NULL);

	xwid->help.name = xvw_create_button(object, "name");
	xvw_set_attributes(xwid->help.name,
		XVW_LABEL,		"No File Currently Being Displayed",
		XVW_CHAR_HEIGHT,	1.0,
		XVW_LABEL_JUSTIFY,      KLABEL_JUSTIFY_CENTER,
		XVW_TACK_EDGE,		KMANAGER_TACK_HORIZ,
		XVW_LEFT_OF,		xwid->help.next,
		XVW_RIGHT_OF,		xwid->help.previous,
		XVW_ABOVE,		NULL,
		NULL);

	xwid->help.textdisplay = xvw_create_textdisplay(object, "textdisplay");
	xvw_set_attributes(xwid->help.textdisplay,
		XVW_BELOW,		xwid->help.quit,
		XVW_ABOVE,		xwid->help.name,
		XVW_TACK_EDGE,		KMANAGER_TACK_ALL,
		NULL);

	xvw_sensitive(xwid->help.next, FALSE);
	xvw_sensitive(xwid->help.previous, FALSE);
	xvw_insert_callback(xwid->help.quit, XVW_BUTTON_SELECT, TRUE,
		QuitCallback, object);
	xvw_insert_callback(xwid->help.name, XVW_BUTTON_SELECT, TRUE,
		HelpCallback, object);
	xvw_insert_callback(xwid->help.next, XVW_BUTTON_SELECT, TRUE,
		HelpCallback, object);
	xvw_insert_callback(xwid->help.previous, XVW_BUTTON_SELECT, TRUE,
		HelpCallback, object);
	xvw_insert_callback(xwid->help.textdisplay, XVW_TEXTDISPLAY_CALLBACK,
		TRUE, HelpCallback, object);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwHelpWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the help.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output:
|       Returns:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/

/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwHelpWidget cxwid = kwidget(current);
	XvwHelpWidget nxwid = kwidget(new);


	if (cxwid->help.filename != nxwid->help.filename)
	{
	   kfree(nxwid->help.hfiles);
	   nxwid->help.current = nxwid->help.numhfiles = 0;

	   nxwid->help.filename = kstrdup(nxwid->help.filename);
	   if (!cxwid->help.filename)
	       CreateOptionsMenu(xvw_object(new));
	   else xvw_remove_detectfile(xvw_object(new), cxwid->help.filename,
				      UpdateHelp, NULL);

	   SetTextDisplayFile(xvw_object(new), nxwid->help.filename);
	   xvw_add_detectfile(xvw_object(new), nxwid->help.filename,
			      1.0, UpdateHelp, NULL);

	   nxwid->help.hfiles = karray_add(nxwid->help.hfiles,
			nxwid->help.filename, nxwid->help.numhfiles++);
	   xvw_sensitive(nxwid->help.next, FALSE);
	   xvw_sensitive(nxwid->help.previous, FALSE);

	   if (!cxwid->help.filename)
	       CreateTermList(xvw_object(new));

	   kfree(cxwid->help.filename);
	}

	if (cxwid->help.display_quit  != nxwid->help.display_quit  ||
	    cxwid->help.display_title != nxwid->help.display_title ||
	    cxwid->help.display_menu != nxwid->help.display_menu)
	{
	   if (!nxwid->help.display_quit && !nxwid->help.display_title &&
	       !nxwid->help.display_menu)
	   {
	      xvw_unmap(nxwid->help.quit);
	      xvw_unmap(nxwid->help.title);
	      xvw_unmap(nxwid->help.menubutton);
	      xvw_set_attribute(nxwid->help.textdisplay, XVW_BELOW, NULL);
	   }
	   if (nxwid->help.display_menu)
	   {
	      xvw_map(nxwid->help.menubutton);
	      if (!nxwid->help.display_title && !nxwid->help.display_quit)
	         xvw_set_attribute(nxwid->help.textdisplay, XVW_BELOW,
			nxwid->help.menubutton);
	   }
	   if (nxwid->help.display_title)
	   {
	      xvw_map(nxwid->help.title);
	      if (!nxwid->help.display_quit)
	         xvw_set_attribute(nxwid->help.textdisplay, XVW_BELOW,
			nxwid->help.title);
	   }
	   if (nxwid->help.display_quit)
	   {
	      xvw_map(nxwid->help.quit);
	      xvw_set_attribute(nxwid->help.textdisplay, XVW_BELOW,
			nxwid->help.quit);
	   }
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: QuitCallback
|
|       Purpose: This routine will be called when the quit callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|
|        Output: None
|       Returns: None
|
|    Written By: Mark Young
|          Date: Jun 06, 1993 10:58
| Modifications:
|
------------------------------------------------------------*/
 
/* ARGSUSED */
static void QuitCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject help = (xvobject) client_data;
	XvwHelpWidget xwid = (XvwHelpWidget) xvw_widget(help);

	int destroy_or_unmap = TRUE;


	XtCallCallbacks(xvw_widget(help), XVW_HELP_CALLBACK, &destroy_or_unmap);
	if (destroy_or_unmap)
	{
	   if (xwid->help.destroy_on_quit)
	      xvw_destroy(help);
	   else
	      xvw_unmap(xvw_toplevel(help));
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: UpdateHelp
|
|       Purpose: This input handler routine redisplays the help page.
|
|         Input: object      - the help object
|                filename    - the file being looked at 
|                client_data - not used
|    Written By: Mark Young
|          Date: Apr 05, 1995
| Modifications:
|
------------------------------------------------------------*/

/* ARGSUSED */
static int UpdateHelp(
   xvobject help,
   char     *filename,
   kaddr    client_data)
{
	SetTextDisplayFile(help, filename);
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: HelpCallback
|
|       Purpose: This routine will be called when the help callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|
|        Output: None
|       Returns: None
|
|    Written By: Mark Young
|          Date: Jun 06, 1993 10:58
| Modifications:
|
------------------------------------------------------------*/
 
/* ARGSUSED */
static void HelpCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject help = (xvobject) client_data;
	XvwHelpWidget xwid = (XvwHelpWidget) xvw_widget(help);

	int   indx;
	klist *list;
	char  *name, *filename, temp[KLENGTH];

	char  **hfiles  = xwid->help.hfiles;
	int   current  = xwid->help.current;
	int   numhfiles = xwid->help.numhfiles;


	if (object == xwid->help.next)
	{
	   current++;
	   if (current == (numhfiles-1))
	      xvw_sensitive(xwid->help.next, FALSE);

	   xvw_sensitive(xwid->help.previous, TRUE);
	   SetTextDisplayFile(help, hfiles[current]);
	}
	else if (object == xwid->help.name && hfiles != NULL)
	{
	   kstrcpy(temp, hfiles[0]);
	   xvw_set_attribute(help, XVW_HELP_FILENAME, temp);
	   return;
	}
	else if (object == xwid->help.previous)
	{
	   current--;
	   if (current == 0)
	      xvw_sensitive(xwid->help.previous, FALSE);

	   xvw_sensitive(xwid->help.next, TRUE);
	   SetTextDisplayFile(help, hfiles[current]);
	}
	else if (object == xwid->help.textdisplay)
	{
	   name = *((char **) call_data);
	   if ((list = klist_locate(manpages, (kaddr) kstring_to_token(name))) == NULL)
	   {
	      return;
	   }

	   /*
	    *  Need to make sure that we aren't already displaying this file.
	    */
	   filename = (char *) klist_clientdata(list);
	   if (kstrcmp(filename, hfiles[current]) == 0)
	      return;

	   if ((indx = karray_locate(hfiles,(kaddr) filename, numhfiles)) == -1)
	   {
	      if (kaccess(filename, R_OK) == -1)
	      {
	         kerror(XVOBJECTS, "Help Object", "Failure to find the file \
'%s'.", filename);
		 return;
	      }
	      current = numhfiles;
              xvw_sensitive(xwid->help.next, FALSE);
              xvw_sensitive(xwid->help.previous, TRUE);
	      xwid->help.hfiles = karray_add(hfiles, filename, numhfiles++);
	   }
	   else
	   {
	      current = indx;
	      if (current == 0)
	      {
		 xvw_sensitive(xwid->help.previous, FALSE);
		 xvw_sensitive(xwid->help.next, TRUE);
	      }
	      else if (current == (numhfiles-1))
	      {
		 xvw_sensitive(xwid->help.previous, FALSE);
		 xvw_sensitive(xwid->help.next, TRUE);
	      }
	   }
	   SetTextDisplayFile(help, hfiles[current]);
	}
	xwid->help.hfiles    = hfiles;
	xwid->help.current   = current;
	xwid->help.numhfiles = numhfiles;
}

/*-----------------------------------------------------------
|
|  Routine Name: MenuCallback
|
|       Purpose: This routine will be called when the menu callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|
|        Output: None
|       Returns: None
|
|    Written By: Mark Young
|          Date: Nov 26, 1993
| Modifications:
|
------------------------------------------------------------*/
 
/* ARGSUSED */
static void MenuCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject help = (xvobject) client_data;
	XvwHelpWidget xwid = (XvwHelpWidget) xvw_widget(help);

	int  i;
	char *option, temp[KLENGTH], **filenames = xwid->help.filenames;

	option = xvw_name(object);
	if (kstrcmp(option, "Print") != 0)
	{
	   for (i = 0; i < xwid->help.num; i++)
	   {
	      if (kstrcmp(kbasename(filenames[i], temp), option) == 0)
	      {
		 xvw_set_attribute(help, XVW_HELP_FILENAME, filenames[i]);
		 break;
	      }
	   }
	}
	else
	{
	   kinfo(KSTANDARD, "Sorry!  Printing is not available at this time");
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: CreateTermList
|
|       Purpose: This routine will be called when we need to initialize
|		 the text terms.
|
|         Input: help      - which help to be initialized
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Nov 11, 1993
| Modifications:
|
------------------------------------------------------------*/
 
/* ARGSUSED */
static void CreateTermList(
   xvobject help)
{
	XvwHelpWidget xwid = (XvwHelpWidget) xvw_widget(help);

	kdbm     *dbm;
	int      i, token;
	kdatum   key, data;
	char     temp[KLENGTH];
	static   int initialized = FALSE;

	char  *name;
	klist *list;


	if (!xwid->help.do_hypertext)
	   return;

	if (!initialized)
	{
	   /*
	    *  Now do the "words", which are the manpages and the glossary
	    *  terms..
	    */
	   initialized = TRUE;
           if (toolboxes == NULL &&
		(toolboxes = kcms_query_toolboxes(&tb_num)) == NULL)
           {
              kinfo(KXVLIB, "Warning: No toolboxes accessable in which to \
search for man and glossary terms");
              return;
           }

           for (i = 0; i < tb_num; i++)
           {
	      if (!toolboxes[i])
	         continue;

	      ksprintf(temp, "$%s/repos/db/manpage", toolboxes[i]);
	      if ((dbm = kdbm_open(temp, O_RDONLY, 0666)) == NULL)
	      {
	         kinfo(KXVLIB, "Warning: Failed to open manpage database \
'%s'", temp);
	         continue;
	      }

	      key = kdbm_firstkey(dbm);
	      while (key.dptr != NULL)
	      {
	         data = kdbm_fetch(dbm, key);
	         if (key.dptr != NULL && data.dptr != NULL)
	         {
		    token = kstring_to_token(key.dptr);
	            manpages = klist_add(manpages, (kaddr) token,
				kstrdup(data.dptr));
	         }
	         key = kdbm_nextkey(dbm);
	      }
	      kdbm_close(dbm);

	      ksprintf(temp, "$%s/repos/db/glossary", toolboxes[i]);
	      if ((dbm = kdbm_open(temp, O_RDONLY, 0666)) == NULL)
	      {
	         kinfo(KXVLIB, "Warning: Failed to open glossary database \
'%s'", temp);
	         continue;
	      }

	      key = kdbm_firstkey(dbm);
	      while (key.dptr != NULL)
	      {
	         data = kdbm_fetch(dbm, key);
	         if (key.dptr != NULL && data.dptr != NULL)
	         {
		    token = kstring_to_token(key.dptr);
	            glossary = klist_add(glossary, (kaddr) token,
				kstrdup(data.dptr));
	         }
	         key = kdbm_nextkey(dbm);
	      }
	      kdbm_close(dbm);
           }
	}

	/*
	 *  Set the terms for the textdisplay
	 */
	for (list = manpages; list != NULL; list = klist_next(list))
	{
	   if ((name = ktoken_to_string((int) klist_identifier(list))) == NULL)
	      continue;
	   xvw_set_attribute(xwid->help.textdisplay,
			XVW_TEXTDISPLAY_ADDWORD, name);
	}

	for (list = glossary; list != NULL; list = klist_next(list))
	{
	   if ((name = ktoken_to_string((int) klist_identifier(list))) == NULL)
	      continue;
	   xvw_set_attribute(xwid->help.textdisplay,
			XVW_TEXTDISPLAY_ADDWORD, name);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: CreateOptionsMenu
|
|       Purpose: This routine will be called when we need to create
|		 the options menu
|
|         Input: object      - which help to be initialized
|        Output:
|       Returns:
|    Written By: Mark Young
|          Date: Nov 26, 1993
| Modifications:
|
------------------------------------------------------------*/
 
static void CreateOptionsMenu(
   xvobject help)
{
        XvwHelpWidget xwid = (XvwHelpWidget) xvw_widget(help);

        struct   stat buf;
	xvobject button, menu;
	int	 i, mode, num;
	char	 **filenames, *name, *base, temp1[KLENGTH], temp2[KLENGTH];


	button = xvw_create_menubutton(help, "menu");
	xvw_set_attributes(button,
		XVW_LABEL,		"Other Files",
		XVW_CHAR_MAX_HEIGHT,	1.0,
		XVW_BELOW,		NULL,
		XVW_RIGHT_OF,		NULL,
		XVW_MAP_WHEN_MANAGED,   xwid->help.display_menu,
		NULL);
	xwid->help.menubutton = button;
	menu = xvw_retrieve_menu(button);

	if (xwid->help.filename != NULL && xwid->help.more_files == TRUE)
	{
           name = kfullpath(xwid->help.filename, NULL, temp1);
 
           /*
            *  Get the directory path to the file
            */
           if (stat(name, &buf) == -1 || !S_ISDIR(buf.st_mode))
	   {
	      name = kdirname(xwid->help.filename, temp1);
	      base = kbasename(xwid->help.filename, temp2);

	      /*
	       *  set the list mode to look for files and directories.
	       */
	      mode = KFILE | KPATH;
	      filenames = karray_dirlist(name, NULL,".*\\.(doc|hlp)", 
				      mode, FALSE, &num);
	   }
	   else
	   {
	      name = xwid->help.filename;
	      base = NULL;

	      /*
	       *  set the list mode to look for files and directories.
	       */
	      mode = KFILE | KPATH;
	      filenames = karray_dirlist(name, NULL, NULL, mode, FALSE, &num);
	   }

	   if (!filenames)
	      filenames = karray_add(NULL, kstrdup(xwid->help.filename), num++);

	   for (i = 0; i < num; i++)
	   {
	      name = kbasename(filenames[i], temp1);
	      if (kstrcmp(name, base) == 0 || (base == NULL && i == 0))
		 xwid->help.filename = kstrdup(filenames[i]);

	      button = xvw_create_button(menu, name);
	      name = GetTextDisplayTitle(filenames[i], temp1);
	      xvw_set_attribute(button, XVW_LABEL, name);
	      xvw_insert_callback(button, XVW_BUTTON_SELECT, TRUE,
			MenuCallback, help);
	   }
	   xwid->help.num       = num;
	   xwid->help.filenames = filenames;
	   if (xwid->help.filename == NULL)
	      xwid->help.filename = filenames[0];
	}
	button = xvw_create_button(menu, "Print");
	xvw_set_attribute(button, XVW_LABEL, "Print");
	xvw_insert_callback(button, XVW_BUTTON_SELECT, TRUE, MenuCallback,help);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetTextDisplayFile - sets the file to be displayed by
|				      the textdisplay object
|
|       Purpose: Sets the textdisplay object being displayed.  This
|		 routine first checks to see if this is a roff'able
|		 file.  If so then it passes the roff'ed descriptor
|		 from kpopen(), otherwise the filename is passed to
|		 the textdisplay object.
|
|         Input: widget   - the help widget
|		 filename - the new file to be displayed
|        Output:
|       Returns: 
|    Written By: Mark Young and Tom Sauer
|          Date: Nov 17, 1993
| Modifications:
|
------------------------------------------------------------*/
 
/* ARGSUSED */
static void SetTextDisplayFile(
   xvobject help,
   char     *filename)
{
	XvwHelpWidget xwid = (XvwHelpWidget) xvw_widget(help);

        kfile *file;
	char  command[KLENGTH];
        int   i, use_roff, use_popen, status = FALSE;
        static char *roffcmds[] =
	{
		"^\\.helpPage.*", "^\\.onlineHelp.*", "^\\.section.*",
		"^\\.SH.*", "^\\.LP.*", "^\\.PP.*", "^\\.NH.*",
		"^\\.IP.*", "^\\.bp.*", "^\\.pp.*",
		"^\\.lp.*", "^\\.so.*", "^\\.code.*"
	};
 

	/*
	 *  Open the file so that we can check to see if this is a roff file..
	 */
	if ((file = kfopen(filename, "r")) == NULL)
	{
	   kerror(XVOBJECTS, "SetTextDisplayFile", "Cannot open \
the file '%s'.", filename);
	   return;
	}

	/*
	 *  We be busy now, so please do not disturb...
	 */
	for (i = 0; i < knumber(roffcmds); i++)
	{
	    status = kparse_file_search(file, roffcmds[i], KLITERAL, NULL);
	    if (status == KPARSE_OK)
	       break;

	    krewind(file);
	}

	if (status == KPARSE_OK)
	{
	   kfclose(file);

	   if (kstrstr(filename, ".doc") || kstrstr(filename, ".hlp"))
	      ksprintf(command, "kman -hlp %s", filename);
	   else
	      ksprintf(command, "kman -man %s", filename);

	   if ((file = kpopen(command, "r")) == NULL)
	   {
	      kerror(XVOBJECTS, "SetTextDisplayFile", "Cannot execute \
the following format command '%s'", command);
	      return;
	   }
	   use_roff = TRUE;
	   use_popen = TRUE;
	}
	else
	{
	   krewind(file);
	   status = kparse_file_search(file, "", KLITERAL, NULL);
	   if (status == KPARSE_OK)
	      use_roff = TRUE;
	   else
	      use_roff = FALSE;

	   use_popen = FALSE;
	   krewind(file);
	}
	xvw_set_attribute(help, XVW_HELP_NAME, filename);
	xvw_set_attributes(xwid->help.textdisplay,
			XVW_TEXTDISPLAY_FILE, file,
			XVW_TEXTDISPLAY_ROFF, use_roff,
			NULL);

	if (use_popen == TRUE)
	   kpclose(file);
	else
	   kfclose(file);
}

/*-----------------------------------------------------------
|
|  Routine Name: GetTextDisplayTitle - 
|
|       Purpose: Get the text display label.  This is done by reading the
|		 first line out of the help file (which should be):
|
|		.onlineHelp ENVISION "The Attributes Pane" ANIMATE
|
|         Input: filename - filename to retrieve the title for
|        Output: title    - the return title
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Aug 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static char *GetTextDisplayTitle(
   char *filename,
   char *title)
{
	kfile *file;
	char  temp[KLENGTH];

	file = kfinput(filename);
	if (kfscanf(file, ".onlineHelp %[^\"]\"%[^\"]", temp, title) != 2)
	   kbasename(filename, title);

	kfclose(file);
	return(title);
}

/************************************************************
*
*  Routine Name: xvw_create_help - create a help object
*
*       Purpose: The help object provides a mechanism for displaying
*		 online help pages.  Online help pages providing information
*		 corresponding to the man page of a software object are
*		 automatically generated as *.hlp files;  xvroutines will
*		 have additional help pages created from scratch, named
*		 *.doc (see Chapter 6 of the Toolbox Programmer's Manual
*		 for more details).
*
*		 The largest part of the help object 
*		 is devoted to a large, scrollable window, in which the 
*		 help page is displayed. On the top is a label for the
*		 help object; on the top right is a "Quit" button that
*		 is used to pop down the help object; on the top left
*		 is a pulldown menu that may be used to view other online
*		 help pages.  On the bottom is a label listing the path
*		 to the help file being displayed.
*
*		 The help object will format a help page that contain
*		 \fIroff\fP formatting commands before displaying it;  
*		 alternatively, it can be used to display plain ascii 
*		 text files as is.  The help object may be provided with
*		 a path to a particular help file, or a path to a directory
*		 in which many help files exist.  If the path provided is
*		 a path to a directory, the help page displayed by default
*		 will be the first one in the directory;  if the path
*		 provided is a path to a particular file, that file will
*		 be displayed.  In either case, if other help files (ie,
*		 files with names that end in ".doc" or ".hlp") will
*		 be accessable from the button on the upper left hand 
*		 corner of the help object, labelled, "More Help Pages".
*		
*		 The first line in a help file controls the label of the
*		 entry in the "More Help Pages" pulldown menu that will
*		 cause that help file to be displayed. Such a line reads
*		 as follows:
*		 .br
*		 \f(CW .onlineHelp TOOLBOX "Label To Appear In Menu" ONAME\fP
*		 .sp
*		 The word "TOOLBOX" should be replaced with the name of
*		 the toolbox, the word "ONAME" should be replaced with
*		 the program name, and the label that you would like the
*		 user to see when they using the "Other Files" pulldown 
*		 menu should be entered instead of "Label To Appear In Menu".
*		 For example, the first line of the online help page for
*		 the "Files" subform of \fHeditimage\fP reads:
*		 .br
*		 \f(CW  .onlineHelp ENVISION "Input/Output" EDITIMAGE\fP
*		
*
*         Input: parent - parent of the help object; NULL will cause
*                         a default toplevel to be created automatically
*                name   - name with which to reference help object
*
*        Output:
*       Returns: The help widget on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Oct 27, 1993
*      Verified: 
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_help(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, HelpWidgetClass);
	return(object);
}
