 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "copyright.h"          /* Khoros copyright */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>	              Khoros FinderList Widget
   >>>>  Private:
   >>>>   Static:
   >>>> 		ClassInitialize()
   >>>>			Initialize()
   >>>> 		SetValues()
   >>>> 		SelectCallback()
   >>>> 		CreateCallback()
   >>>> 		FinderListActions()
   >>>>   Public:
   >>>>			xvw_create_finderlist()
   >>>>	
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvlang/FinderListP.h>

static Boolean	SetValues       PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void     ClassInitialize PROTO((void));
static void	Initialize	PROTO((Widget, Widget, ArgList, Cardinal *));

static void	UpdateFinderList  PROTO((Widget));
static void	SelectCallback    PROTO((xvobject, kaddr, kaddr));
static void	CreateCallback    PROTO((xvobject, kaddr, kaddr));
static int	FinderListActions PROTO((xvobject, char *, kaddr));


/*-------------------------------------------------------------------*
|
|   Full class attributes
|
--------------------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_FINDERLIST_SELECT,      NULL,   XtRCallback, NULL},
{XVW_FINDERLIST_CREATE,      NULL,   XtRCallback, NULL},
{XVW_FINDERLIST_EXPRESSION,  NULL,   XtRString, NULL},
};


/*-------------------------------------------------------------------*
|
|   Full class record constant
|
--------------------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwFinderListWidgetRec, finderlist.field)

static XtResource resources[] = { 
{XVW_FINDERLIST_SELECT, NULL, XtRCallback, sizeof(XtPointer),
      offset(select_callback), XtRCallback, (XtPointer) NULL},
{XVW_FINDERLIST_CREATE, NULL, XtRCallback, sizeof(XtPointer),
      offset(create_callback), XtRCallback, (XtPointer) NULL},
{XVW_FINDERLIST_EXPRESSION, NULL, XtRString, sizeof(String),
      offset(expression), XtRImmediate, (XtPointer) NULL},

{XVW_DEF_HORIZ_DIST, NULL, XtRPosition, sizeof(Position),
        XtOffsetOf(XvwFinderListWidgetRec, manager.horiz_offset),
        XtRImmediate, (XtPointer) 0},
{XVW_DEF_VERT_DIST, NULL, XtRPosition, sizeof(Position),
        XtOffsetOf(XvwFinderListWidgetRec, manager.vert_offset),
        XtRImmediate, (XtPointer) 0},
};
#undef offset


/*-------------------------------------------------------------------*
|
|   Class Declaration for FinderList Widget
|
--------------------------------------------------------------------*/

#define superclass (&xvwManagerWidgetClassRec)

XvwFinderListWidgetClassRec xvwFinderListWidgetClassRec =
{
  {
    (WidgetClass) superclass,		/* superclass		  */	
    "FinderList",			/* class_name		  */
    sizeof(XvwFinderListWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    XtNumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    XtInheritQueryGeometry,		/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,				    /* subresources	  */
    0,					    /* subresources_count */
    sizeof(XvwFinderListWidgetConstraintsRec),  /* constraint_size	  */
    NULL,				    /* initialize	  */
    NULL,				    /* destroy		  */
    NULL,				    /* set_values	  */
    NULL,				    /* extension	  */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                        /* child layout routine  */
    XtInheritChangeSel,			    /* change selected proc   */
    XtInheritEraseSel,			    /* erase selected proc    */
    XtInheritRefreshSel,		    /* refresh selection proc */
    XtInheritResize,			    /* resize		      */
    XtInheritGeometryManager,		    /* geometry_manager	      */
  },  /* XvwManagerWidgetClass fields initialization */
  {
    NULL,  		                    /* extension          */
  },  /* XvwFinderListWidgetClass fields initialization */
};
#undef superclass

  /* for public consumption */
WidgetClass xvwFinderListWidgetClass = (WidgetClass) &xvwFinderListWidgetClassRec;


/*-------------------------------------------------------------------*
|
|   Miscelleanous defines for widget definition
|
--------------------------------------------------------------------*/

#undef  kwidget
#define kwidget(widget)	     (XvwFinderListWidget) (widget)


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of a XvwFinderListWidget class has been created.
|                This is where the attributes for the class are
|		 initialized. 
|
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
	xvw_init_attributes(xvwFinderListWidgetClass, attributes,
		XtNumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvlang/app-defaults/FinderList");
	xvw_define_attributes(xvwFinderListWidgetClass,
		XVW_FINDERLIST_OPEN, XtRInt, FinderListActions, NULL,
		NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial finderlist widget
|		 instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwFinderListWidget xwid = kwidget(new);

	xvobject object, list;


	/*
	 *  Initialize the selected program info to be initially empty
	 */
	object = xvw_object(new);
	list  = xvw_create_list(object, "FinderList");
	xvw_set_attributes(list,
		XVW_BORDER_WIDTH, 0,
		XVW_TACK_EDGE, KMANAGER_TACK_ALL,
		NULL);

	xwid->finderlist.finder_list = list = xvw_retrieve_list(list);
	xvw_insert_callback(list, XVW_LIST_ITEM_SELECT, FALSE,
			SelectCallback, object);
	xvw_insert_callback(list, XVW_LIST_ITEM_ACTION, FALSE,
			CreateCallback, object);
	UpdateFinderList(new);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a XvwFinderListWidget instance.  The public values
|                which can be changed are all related to the display
|		 of the error.
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/

static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num)
{
	XvwFinderListWidget cxwid = kwidget(current);
	XvwFinderListWidget nxwid = kwidget(new);


	if (cxwid->finderlist.expression != nxwid->finderlist.expression)
	{
	   kfree(cxwid->finderlist.expression);
	   nxwid->finderlist.expression = kstrdup(nxwid->finderlist.expression);
	   UpdateFinderList(new);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: UpdateFinderList - update the finder list according to the
|				    current expression.
|
|       Purpose: This routine updates the list, according to the supplied
|		 expression.
|
|         Input: widget - the finder list widget in which to update.
|    Written By: Mark Young
|          Date: Jul 04, 1994
| Modifications:
|
------------------------------------------------------------*/

static void UpdateFinderList(
   Widget widget)
{
	XvwFinderListWidget xwid = kwidget(widget);

	int   size = 0;
        klist *category_list, *subcategory_list, *panelist;
	char  temp[KLENGTH], *expression, **info, **list = NULL;

 
        /*
         *  Initialize the selected program info to be initially empty
         */
        xwid->finderlist.selected.icon_name   = NULL;
        xwid->finderlist.selected.tbname      = NULL;
        xwid->finderlist.selected.oname       = NULL;
        xwid->finderlist.selected.category    = NULL;
        xwid->finderlist.selected.subcategory = NULL;
        xwid->finderlist.selected.panefile    = NULL;
        xwid->finderlist.selected.short_desc  = NULL;

        xvw_get_contents(&category_list, NULL);
	expression = xwid->finderlist.expression;

	ksprintf(temp, "^.*%s.*$", !expression ? "" : expression);
	kre_icomp(temp);
        while (category_list != NULL)
        {
            subcategory_list = (klist *) category_list->client_data;
            while (subcategory_list != NULL)
            {
                panelist = (klist *) subcategory_list->client_data;
                while (panelist != NULL)
                {
		    info = klist_clientdata(panelist);
		    ksprintf(temp, "%s - %s - %s",
			info[2] ? info[2] : "(unknown object name)",
			info[0] ? info[0] : "(unknown icon name)",
			info[7] ? info[7] : "(unknown short description)");
		    if (kre_exec(temp) && kre_status() == KPARSE_OK)
		       list = karray_add(list, kstrdup(temp), size++);

                    panelist = klist_next(panelist);
                }
                subcategory_list = klist_next(subcategory_list);
            }
            category_list = klist_next(category_list);
        }
	xvw_change_list(xwid->finderlist.finder_list, list, size, FALSE);
	karray_free(list, size, NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: SelectCallback
|
|       Purpose: This routine will be called when the list callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/
 
static void SelectCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject finderlist = (xvobject) client_data;
        xvw_list_struct *entry = (xvw_list_struct *) call_data;

	xvw_program_info selected;
	char    **info, temp[KLENGTH];
	klist   *category_list, *subcategory_list, *panelist;
	Widget  widget = xvw_widget(finderlist);
	XvwFinderListWidget xwid = kwidget(widget);


	/*
	 *  Get the category list contents...
	 */
	xvw_get_contents(&category_list, NULL);
	while (category_list != NULL)
	{
	   subcategory_list = (klist *) klist_clientdata(category_list);
	   while (subcategory_list != NULL)
	   {
	      panelist = (klist *) subcategory_list->client_data;
	      while (panelist != NULL)
	      {
		 /*
		  *  Check to see if this matches the entry we've looking
		  *  for.
		  */
		 info = klist_clientdata(panelist);
		 ksprintf(temp, "%s - %s - %s",
                        info[2] ? info[2] : "(unknown object name)",
                        info[0] ? info[0] : "(unknown icon name)",
                        info[7] ? info[7] : "(unknown short description)");
                 if (kstrcmp(temp, entry->string) == 0)
		 {
		    xvw_load_content(panelist, &xwid->finderlist.selected);
		    selected = xwid->finderlist.selected;
		    XtCallCallbacks(widget, XVW_FINDERLIST_SELECT, &selected);
		    return;
		 }
		 panelist = klist_next(panelist);
	      }
	      subcategory_list = klist_next(subcategory_list);
	   }
	   category_list = klist_next(category_list);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: CreateCallback
|
|       Purpose: This routine will be called when the list callback is
|                activated.
|
|         Input: object      - which button being manipulated
|                client_data - the button widget
|                call_data   - int representing the index
|    Written By: Mark Young
|          Date: Jul 02, 1994
| Modifications:
|
------------------------------------------------------------*/
 
static void CreateCallback(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
	xvobject finderlist = (xvobject) client_data;

	xvw_program_info selected;
	Widget   widget = xvw_widget(finderlist);
	XvwFinderListWidget xwid = (XvwFinderListWidget) widget;

	selected = xwid->finderlist.selected;
	XtCallCallbacks(widget, XVW_FINDERLIST_CREATE, &selected);
}

/*-----------------------------------------------------------
|
|  Routine Name: FinderListActions
|
|       Purpose: FinderListActions is used to set the certain actions associated
|		 with the current FinderList object.
|
|         Input: object    - the object in which we will be setting the
|			     attribute value for
|		 attribute - the desired attribute
|		 calldata  - the value to be set
|
|        Output:
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Jul 10, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static int FinderListActions(
   xvobject finderlist,
   char     *attribute,
   kaddr    calldata)
{
	XvwFinderListWidget xwid = (XvwFinderListWidget) xvw_widget(finderlist);
	Widget widget = (Widget) xwid;


	if (kstrcmp(attribute, XVW_FINDERLIST_OPEN) == 0)
	{
	   if (xwid->finderlist.selected.icon_name != NULL)
	   {
	      XtCallCallbacks(widget, XVW_FINDERLIST_CREATE,
			&xwid->finderlist.selected);
	   }
	   else
	   {
	       kerror(XVLANG, "FinderList", "You must first select the object \
from the list, before using the 'Open' operator");
	       return(TRUE);
	   }
	}
	else
	{
	   kerror(XVLANG, "FinderListActions", "invalid attribute %s",
			attribute);
	   return(FALSE);
	}
	return(TRUE);
}


/************************************************************
*
*  Routine Name: xvw_create_finderlist - create a finder list object
*
*       Purpose: Creates a finder list object. The finder list is used 
*		 to select an operator by name; key words can also be used 
*		 to scan for a particular operator.  The finder list consists 
*		 of a single list containing all available operators; 
*		 the user may scroll through the list and select the desired
*		 operator.
*
*		 Two callbacks are provided which can be used to notify
*		 the programmer when the user selects or activates an operator
*		 from the list.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object
*        Output: None
*       Returns: The finder list object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Jul 02, 1994
*      Verified:
*  Side Effects:
* Modifications:
*
*******************************************************************/

xvobject xvw_create_finderlist(
   xvobject parent,
   char     *name)
{
	xvobject object;


	object = xvw_create(parent, FALSE, TRUE, name, FinderListWidgetClass);
	return(object);
}
