 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>            General Utility Routines
   >>>>
   >>>>   Static:
   >>>>  Private:
   >>>>		   xvw_set_type()
   >>>>		   xvw_get_type()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


/*-----------------------------------------------------------
|
|  Routine Name: xvw_set_type - set the update and reload type
|
|       Purpose: 
|         Input: 
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 03, 1993
| Modifications:
|
------------------------------------------------------------*/

int xvw_set_type(
  kobject object,
  int     reload_type,
  int     update_type)
{
	if (!object)
	   return(FALSE);

	/*
	 *  Set the reload type...
	 */
	if (!kdms_query_attribute(object, NULL, KRELOAD_TYPE, NULL, NULL,
				    NULL, NULL))
	{
	   kdms_create_attribute(object, NULL, KRELOAD_TYPE, 1, 1, KINT, 
				 FALSE, FALSE);
	   kpds_set_attribute(object, KRELOAD_TYPE, NONE);
	}

	if (reload_type != -1)
	   kpds_set_attribute(object, KRELOAD_TYPE, reload_type);


	/*
	 *  Get the reload type...
	 */
	if (!kdms_query_attribute(object, NULL, KUPDATE_TYPE, NULL, NULL,
				    NULL, NULL))
	{
	   kdms_create_attribute(object, NULL, KUPDATE_TYPE, 1, 1, KINT, 
				 FALSE, FALSE);
	   kpds_set_attribute(object, KUPDATE_TYPE, NONE);
	}

	if (update_type != -1)
	   kpds_set_attribute(object, KUPDATE_TYPE, update_type);

	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: xvw_get_type - get the update and reload type
|
|       Purpose: 
|         Input: 
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 03, 1993
| Modifications:
|
------------------------------------------------------------*/

int xvw_get_type(
  kobject object,
  int     *reload_type,
  int     *update_type)
{
	if (!object)
	   return(FALSE);

	/*
	 *  Get the reload type...
	 */
	if  (!kdms_query_attribute(object, NULL, KRELOAD_TYPE, NULL, NULL,
				    NULL, NULL))
	{
	   kdms_create_attribute(object, NULL, KRELOAD_TYPE, 1, 1, KINT, 
				 FALSE, FALSE);
	   kpds_set_attribute(object, KRELOAD_TYPE, NONE);
	}

	if (reload_type)
	{
	   *reload_type = NONE;
	   kpds_get_attribute(object, KRELOAD_TYPE, reload_type);
	}


	/*
	 *  Get the update type...
	 */
	if (!kdms_query_attribute(object, NULL, KUPDATE_TYPE, NULL, NULL,
				    NULL, NULL))
	{
	   kdms_create_attribute(object, NULL, KUPDATE_TYPE, 1, 1, KINT, 
			  	 FALSE, FALSE);
	   kpds_set_attribute(object, KUPDATE_TYPE, NONE);
	}

	if (update_type)
	{
	   *update_type = NONE;
	   kpds_get_attribute(object, KUPDATE_TYPE, update_type);
	}
	return(TRUE);
}
