 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>             String Value Gadget Routines
   >>>>
   >>>>	 Private:
   >>>>	  Static:
   >>>>			ClassInitialize()
   >>>>			Destroy()
   >>>>			SetValues()
   >>>>   Public:
   >>>>			xvw_create_stringvalue()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/StringValueP.h>

static void    ClassInitialize PROTO((void));
static void    Destroy         PROTO((Widget));
static Boolean SetValues       PROTO((Widget, Widget, Widget, 
				      ArgList,Cardinal *));

/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
  {XVW_STRING_VALUE,     NULL,    XtRDouble,    NULL},
  {XVW_STRING_FORMAT,    NULL,    XtRString,    NULL},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwStringValueGadgetRec, stringvalue.field)

static double value = KMAXFLOAT;
#define DEFAULT_FORMAT "%g"

static XtResource resources[] = { 
{XVW_STRING_VALUE, NULL, XtRDouble, sizeof(double),
      offset(value), XtRDouble, (XtPointer) &value},
{XVW_STRING_FORMAT, NULL, XtRString, sizeof(String),
      offset(format), XtRString, (XtPointer) NULL},
};
#undef offset


#define SUPERCLASS (&xvwStringGadgetClassRec)

XvwStringValueGadgetClassRec xvwStringValueGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "StringValue",			/* class_name		  */
    sizeof(XvwStringValueGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    XtInheritPicking,			/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    XtInheritChangeGeometry,		/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    XtInheritRecomputePosition,		/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwStringGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwStringValueGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwStringValueGadgetClass for public consumption
 */
WidgetClass xvwStringValueGadgetClass = (WidgetClass) &xvwStringValueGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of string value object class has been created.
|                It will initialize all the class attributes. 
|
|         Input: None 
|
|        Output: None
|
|    Written By: Mark Young & John Salas
|          Date: Aug 15, 1992 12:31
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwStringValueGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/StringValue.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/StringValue");
}



/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: This routine will free the memory associated
|                with the string before the string is destroyed
|
|         Input: widget - the string object being destroyed
|        Output:
|    Written By: Danielle Argiro & Mark Young
|          Date: Feb 22, 1995
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
        XvwStringValueGadget xobj = (XvwStringValueGadget) widget;

        /* free memory associated with StringValue object */
        kfree(xobj->stringvalue.format);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: If the the format or value of the string 
|		 value object has changed, update the string. 
|
|         Input: current - the object containing current settings 
|                request - the object containing requested settings
|                new     - the object processed through all set values methods 
|
|        Output: None directly 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Jun 29, 1992 10:35
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwStringValueGadget cobj = (XvwStringValueGadget) current;
	XvwStringValueGadget nobj = (XvwStringValueGadget) new;

	char temp[KLENGTH];


	if (cobj->stringvalue.format != nobj->stringvalue.format ||
	    cobj->stringvalue.value != nobj->stringvalue.value)
	{
           if (cobj->stringvalue.format != nobj->stringvalue.format)
           {
	      if ((kstrcmp(nobj->stringvalue.format, "%s") == 0) ||
		  (kstrcmp(nobj->stringvalue.format, "%c") == 0))
              {
		kerror("xvisual", "Stringvalue SetValues",
		       "Cannot set string format to %%c or %%s");
	        nobj->stringvalue.format = cobj->stringvalue.format;
	        return(FALSE);
	      }
              if (cobj->stringvalue.format)
		 kfree(cobj->stringvalue.format);

              nobj->stringvalue.format = kstrdup(nobj->stringvalue.format);
           }

	   if (nobj->stringvalue.format == NULL)
	      nobj->stringvalue.format = kstrdup(DEFAULT_FORMAT);

	   ksprintf(temp, nobj->stringvalue.format, nobj->stringvalue.value);
	   xvw_set_attribute(xvw_object(new), XVW_STRING_STRING, temp);
	}
	return(FALSE);
}


/************************************************************
*
*  Routine Name: xvw_create_stringvalue - creates a string value object
*
*       Purpose: A stringvalue object supports the display of a formatted 
*                number annotation.  Thus, standard C formatting strings such
*                as "%g" or "%.3f" may be used to neatly display a floating
*                point or double precision value.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel be created automatically
*                name   - the name with which to reference the object 
*
*        Output: None 
*
*	Returns: The stringvalue object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young & John M. Salas
*          Date: Jul 03, 1992 14:34
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_stringvalue(
   xvobject parent,
   char     *name)
{
	xvobject  object;


	/*
	 *  Call the xvw_create() routine to do the actual creation.
	 */
	object = xvw_create(parent, FALSE, TRUE, name, StringValueGadgetClass);
	if (object != NULL)
	{
	   xvw_set_attributes(object,
		XVW_MENUABLE,     TRUE,     /* menuable       */
		XVW_RESIZABLE,    FALSE,    /* resizable      */
		XVW_SELECTABLE,   TRUE,     /* selectable     */
		NULL);
	}
	return(object);
}
