 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                 PanIcon Widget Routines
   >>>>
   >>>>	 Private:
   >>>>	  Static:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			SetValues()
   >>>>			Redisplay()
   >>>>			UpdatePosition()
   >>>>			PanIconCallback()
   >>>>			ChangePanIconPosition()
   >>>>   Public:
   >>>>			xvw_create_panicon()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/PanIconP.h>


static void ClassInitialize PROTO((void));
static void Initialize	    PROTO((Widget, Widget, ArgList, Cardinal *));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,
				   Cardinal *));
static void Redisplay	    PROTO((Widget, XEvent *, Region));
static void UpdatePosition  PROTO((xvobject, kaddr, XEvent *, int *));
static void PanIconCallback PROTO((kobject, char *, Widget, kdms_callback *));
static void ChangePanIconPosition PROTO((Widget, int));

#undef kwidget
#undef kwidgetclass

#define kwidget(widget)      (XvwPanIconWidget) (widget)
#define kwidgetclass(widget) (XvwPanIconWidgetClass) (widget)->core.widget_class

/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_PANICON_SIZE,	NULL,	XtRInt,		XtRDimension},
{XVW_PANICON_XPOS,	NULL,	XtRInt,		XtRPosition},
{XVW_PANICON_YPOS,	NULL,	XtRInt,		XtRPosition},
{XVW_PANICON_WIDTH,	NULL,	XtRInt,		XtRDimension},
{XVW_PANICON_HEIGHT,	NULL,	XtRInt,		XtRDimension},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwPanIconWidgetRec, panicon.field)

static XtResource resources[] = { 
{XVW_PANICON_SIZE, NULL, XtRDimension, sizeof(Dimension),
      offset(size), XtRImmediate, (XtPointer) 100},
{XVW_PANICON_XPOS, NULL, XtRPosition, sizeof(Position),
      offset(xpos), XtRImmediate, (XtPointer) 0},
{XVW_PANICON_YPOS, NULL, XtRPosition, sizeof(Position),
      offset(ypos), XtRImmediate, (XtPointer) 0},
{XVW_PANICON_WIDTH, NULL, XtRDimension, sizeof(Dimension),
      offset(width), XtRImmediate, (XtPointer) 100},
{XVW_PANICON_HEIGHT, NULL, XtRDimension, sizeof(Dimension),
      offset(height), XtRImmediate, (XtPointer) 100},

{NULL, NULL, XtRInt, sizeof(int),
      XtOffsetOf(XvwImageWidgetRec, image.reload_type),
      XtRImmediate, (XtPointer) PANICON_OBJECT_RELOAD},
{NULL, NULL, XtRPixel, sizeof(Pixel),
      offset(black), XtRString, (XtPointer) "black"},
{NULL, NULL, XtRPixel, sizeof(Pixel),
      offset(white), XtRString, (XtPointer) "white"},
};
#undef offset


#define SUPERCLASS (&xvwImageWidgetClassRec)

XvwPanIconWidgetClassRec xvwPanIconWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "PanIcon",				/* class_name		  */
    sizeof(XvwPanIconWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),			/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,	            		/* subresources       */
    0,					/* subresources_count */
    sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size    */
    NULL,				/* initialize         */
    NULL,                               /* destroy            */
    NULL,				/* set_values         */
    NULL,                               /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,                    /* child layout routine  */
    XtInheritChangeSel,                 /* change selected proc   */
    XtInheritEraseSel,                  /* erase selected proc    */
    XtInheritRefreshSel,                /* refresh selection proc */
    XtInheritResize,                    /* resize                 */
    XtInheritGeometryManager,           /* geometry_manager       */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
  {
    XtInheritColorReload,		/* reload color proc             */
  },  /* XvwColorWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwImageWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwPanIconWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwPanIconWidgetClass for public consumption
 */
WidgetClass xvwPanIconWidgetClass = (WidgetClass) &xvwPanIconWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of panicon widget class has been created.
|                It will initialize all the class attributes.
|
|         Input: None 
|
|        Output: None
|
|    Written By: Mark Young and John M. Salas
|          Date: Aug 15, 1992 12:31
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwPanIconWidgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/PanIcon.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/PanIcon");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial image
|		 for an image widget instance. 
|
|         Input: request - not used
|		 new	 - widget instance after initialization, with 
|		           initial image
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Mon Jun 29 10:35:11 MDT 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwPanIconWidget xwid = kwidget(new);

	XColor color;

	/*
	 *  Initialize the factor to a scale of 1
	 */
	xwid->panicon.factor = 1.0;
	xwid->panicon.max_width  = 0;
	xwid->panicon.max_height = 0;
	xvw_set_attribute(xvw_object(new), XVW_FOREGROUND_COLOR, "yellow");
	xvw_add_event(xvw_object(new), ButtonMotionMask | ButtonPressMask |
		      ButtonReleaseMask, UpdatePosition, NULL);

	color.flags = DoRed | DoGreen | DoBlue;

	color.red = color.green = color.blue = 0;
	if (XAllocColor(XtDisplay(new), new->core.colormap, &color) != 0)
	   xwid->panicon.black = color.pixel;

	color.red = color.green = color.blue = 65535;
	if (XAllocColor(XtDisplay(new), new->core.colormap, &color) != 0)
	   xwid->panicon.white = color.pixel;
}

/*-----------------------------------------------------------
|
|  Routine Name: Redisplay
|
|       Purpose: This routine will redraw the rectangle within the
|		 PanIcon.
|
|         Input: widget - widget data structure for panicon
|		 event	- the event that caused the redraw
|		 region	- the region that was exposed
|        Output: None
|
|    Written By: Mark Young
|          Date: Jun 26, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
        XvwPanIconWidget xwid = (XvwPanIconWidget) widget;

	(*xvwPanIconWidgetClass->core_class.superclass->core_class.expose)
                (widget, event, region);
	ChangePanIconPosition(widget, FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a panicon widget instance.   
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output: None
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Oct 24, 1992 23:59
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwPanIconWidget cxwid = (XvwPanIconWidget) current;
	XvwPanIconWidget nxwid = (XvwPanIconWidget) new;

	double factor;
	int w, h, d, t, e, redisplay = FALSE;
	int type, region_width, region_height, num_rgns;


	if (cxwid->image.iobject != nxwid->image.iobject)
	{
	   kpds_add_value_callback(nxwid->image.iobject, KPDS_CALLBACK_ACCESS,
			PanIconCallback, (kaddr) new);
	}

	if (nxwid->image.iobject != NULL &&
	   (cxwid->image.iobject != nxwid->image.iobject  ||
	    cxwid->panicon.size  != nxwid->panicon.size))
	{
	   /*
	    *  Get the value data demsionality
	    */
	   kpds_get_attribute(nxwid->image.iobject, KPDS_VALUE_SIZE,
			&w, &h, &d, &t, &e);

	   factor = nxwid->panicon.size;
	   factor = kmin(factor/w, factor/h);
	   w *= factor; h *= factor;

           /*
            *  Max it out...
            */
           nxwid->panicon.max_width = /*nxwid->manager.preferred_width  =*/
           nxwid->manager.max_width = nxwid->core.width  = w;
           nxwid->panicon.max_height = /*nxwid->manager.preferred_height =*/
           nxwid->manager.max_height = nxwid->core.height = h;

	   nxwid->panicon.factor = factor; 
	   xvw_set_attributes(xvw_object(new),
		XVW_PREFERRED_WIDTH,  nxwid->core.width,
		XVW_PREFERRED_HEIGHT, nxwid->core.height,
		NULL);
	   kpds_set_attributes(nxwid->image.iobject,
		KPDS_VALUE_SIZE, w, h, d, t, e,
		KPDS_VALUE_INTERPOLATE, KZERO_ORDER,
		NULL);

	   /*
	    *  In case there is a mask segment...
	    */
	   kpds_set_attributes(nxwid->image.iobject,
		KPDS_MASK_SIZE, w, h, d, t, e,
		KPDS_MASK_INTERPOLATE, KZERO_ORDER,
		NULL);

	   /*
	    *   we really need to delete this kludge, but if we do then data
	    *   services will core dump...  Jun 06, 1994 (MY)
	    */
	   if (xvw_check_subclass(xvw_object(XtParent(new)),
				  xvwManagerWidgetClass))
	   {
	      XvwManagerWidgetConstraints kman = (XvwManagerWidgetConstraints)
							new->core.constraints;
	      kman->manager.max_width  = w;
	      kman->manager.max_height = h;
	   }

	   kpds_get_attributes(nxwid->image.iobject,
		KPDS_VALUE_DATA_TYPE, &type,
	   	KPDS_VALUE_OPTIMAL_REGION_SIZE, &region_width, &region_height,
		&d, &t, NULL, &num_rgns, NULL);

	   if (type == KDOUBLE  || type == KFLOAT ||
	       type == KCOMPLEX || type == KDCOMPLEX || d != 1 || t != 1)
	   {
	      num_rgns = 1;
	   }
	   else if (nxwid->image.image_depth == 1)
	      num_rgns /= e;

	   if (num_rgns <= 0) num_rgns = 1;
	   if (region_width == 1)
	   {
	      region_width = num_rgns;
	      num_rgns = region_height;
	      region_height = 1;
	   }
	   nxwid->image.region_num    = num_rgns;
	   nxwid->image.region_width  = region_width;
	   nxwid->image.region_height = region_height;
#if 0
	   kfprintf(kstderr,"Optimal Region Size is '%d' for '%d' regions\n",
		region_width*region_height*d*t*e, nxwid->image.region_num);
#endif
	}

	if (cxwid->panicon.xpos   !=  nxwid->panicon.xpos  ||
	    cxwid->panicon.ypos   !=  nxwid->panicon.ypos  ||
	    cxwid->panicon.width  !=  nxwid->panicon.width  ||
	    cxwid->panicon.height !=  nxwid->panicon.height)
	{
	   ChangePanIconPosition(new, TRUE);
	}
	return(redisplay);
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangePanIconPosition
|
|       Purpose: changes the PanIcon position of the panner in the image object
|                so that if there is other devices that have any access
|                callbacks we will know it.
|
|         Input: widget    - panicon widget
|                update	   - whether to trigger an update
|        Output: 
|       Returns:
|
|    Written By: Mark Young
|          Date: Jun 26, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void ChangePanIconPosition(
   Widget widget,
   int    update)
{
        XvwPanIconWidget xwid = (XvwPanIconWidget) widget;
	double value;
	int    x, y, w, h, d, t, e, xtmp, ytmp, type;


	/*
	 *  Sanity check to make sure the PanIcon is realized.
	 */
	if (!XtIsRealized(widget)) return;

	kpds_get_attributes(xwid->image.iobject,
		KPDS_VALUE_DATA_TYPE, &type,
		KPDS_VALUE_POSITION, &w, &h, &d, &t, &e,
		NULL);

	x = xwid->panicon.xpos   * xwid->panicon.factor; xtmp = x;
	y = xwid->panicon.ypos   * xwid->panicon.factor; ytmp = y;
	w = xwid->panicon.width  * xwid->panicon.factor;
	h = xwid->panicon.height * xwid->panicon.factor;
	if (x < 0)
	   x = 0;
	else if ((x + w + 1) >= xwid->panicon.max_width)
	   x = xwid->panicon.max_width - w - 1;
	if (y < 0)
	   y = 0;
	else if ((y + h + 1) >= xwid->panicon.max_height)
	   y = xwid->panicon.max_height - h - 1;

	if (x != xtmp) xwid->panicon.xpos = x/xwid->panicon.factor;
	if (y != ytmp) xwid->panicon.ypos = y/xwid->panicon.factor;

	/*
	 *  Clear the previous rectangle.
	 */
	XClearArea(XtDisplay(widget), XtWindow(widget), 0, 0, 0, 0, FALSE);

	/*
	 *  Draw the background "black" rectangles.
	 */
	XSetForeground(XtDisplay(widget), xwid->manager.gc,xwid->panicon.black);
	XDrawRectangle(XtDisplay(widget), XtWindow(widget), xwid->manager.gc,
		x-1, y-1, (unsigned int) w+2, (unsigned int) h+2);
	XDrawRectangle(XtDisplay(widget), XtWindow(widget), xwid->manager.gc,
		x+1, y+1, (unsigned int) w-2, (unsigned int) h-2);

	/*
	 *  Now draw the foreground "white" rectangle.
	 */
	XSetForeground(XtDisplay(widget), xwid->manager.gc,xwid->panicon.white);
	XDrawRectangle(XtDisplay(widget), XtWindow(widget), xwid->manager.gc,
		x, y, (unsigned int) w, (unsigned int) h);
	if (update)
	{
	   kpds_set_attributes(xwid->image.iobject,
		KPDS_VALUE_DATA_TYPE, KDOUBLE,
		KPDS_VALUE_POSITION, x, y, d, t, e,
		NULL);

	   xvw_set_type(xwid->image.iobject, PANICON_OBJECT_RELOAD,
			PANICON_POSITION_UPDATE);
	   kpds_get_data(xwid->image.iobject, KPDS_VALUE_POINT, &value);
	   kpds_set_attribute(xwid->image.iobject, KPDS_VALUE_DATA_TYPE, type);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: UpdatePosition
|
|       Purpose: updates the position of the panner in the image object
|                so that if there is other devices that have any access
|                access callbacks we will know it.
|
|         Input: widget      - image widget
|                client_data - client data (unused)
|                event       - type of event that triggered us
|
|        Output: dispatch    - whether to continue dispatching this event
|       Returns: none
|
|    Written By: Mark Young
|          Date: Aug 19, 1992 9:13
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */ 
static void UpdatePosition(
   xvobject object,
   kaddr    client_data,
   XEvent   *event,
   int      *dispatch)
{
	int x, y, xpos, ypos, update = FALSE;
	XvwPanIconWidget xwid = (XvwPanIconWidget) xvw_widget(object);

 
	if (event->type == MotionNotify)
	{
	   x = event->xmotion.x; y = event->xmotion.y;
	   if (event->xmotion.state == 0) return;
	}
	else if (event->type == ButtonPress || event->type == ButtonRelease)
	{
	   x = event->xbutton.x; y = event->xbutton.y;
	   if (event->type == ButtonRelease)
	      update = TRUE;
	}
	else
	   return;

	xpos = x / xwid->panicon.factor - ((int) xwid->panicon.width)/2;
	ypos = y / xwid->panicon.factor - ((int) xwid->panicon.height)/2;
	xwid->panicon.xpos = xpos;
	xwid->panicon.ypos = ypos;
	ChangePanIconPosition((Widget) xwid, update);
}

/*-----------------------------------------------------------
|
|  Routine Name: PanIconCallback
|
|       Purpose: This redisplays the position of the object being tracked
|                 
|         Input: 
|        Output:
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Nov 17, 1992 10:24
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void PanIconCallback(
   kobject object,
   char    *segment,
   Widget  widget,
   kdms_callback *cb)
{
	XvwPanIconWidget xwid = (XvwPanIconWidget) widget;

	int x, y, w, h, d, reload, update;
	xvobject panicon = xvw_object(widget);


	/*
	 *  Make sure we aren't here because of ourself.  In other words, we
	 *  don't want to have the PanIcon update when kpds_get_data() is
	 *  performmed by the PanIcon, only other visual objects, such as
	 *  Image objects.
	 */
	if (object == cb->object)
	   return;

	xvw_get_type(object, &reload, &update);
	if (reload != IMAGE_OBJECT_RELOAD || update != IMAGE_REFRESH_UPDATE)
	   return;

	kpds_get_attribute(cb->object, KPDS_VALUE_SIZE, &w, &h, NULL,NULL,NULL);
	if (cb->begin.w == 0 && cb->begin.h == 0 &&
	    (w-10) <= (cb->end.w - cb->begin.w) &&
	    (h-10) <= (cb->end.h - cb->begin.h))
	{
	   if (xvw_check_mapped(panicon)) xvw_unmanage(panicon);
	   return;
	}
	else if (!xvw_check_mapped(panicon))
	   xvw_manage(panicon);

	x = cb->begin.w / xwid->panicon.factor;
	y = cb->begin.h / xwid->panicon.factor;
	w = (cb->end.w - cb->begin.w) / xwid->panicon.factor;
	h = (cb->end.h - cb->begin.h) / xwid->panicon.factor;
	d = cb->begin.d;

	xvw_set_attributes(xvw_object(widget),
		XVW_IMAGE_BANDNUM,  d,
		XVW_PANICON_XPOS,   x,
		XVW_PANICON_YPOS,   y,
		XVW_PANICON_WIDTH,  w,
		XVW_PANICON_HEIGHT, h,
		NULL);
}


/************************************************************
*
*  Routine Name: xvw_create_panicon - create a panicon object
*
*       Purpose: A panicon object provides a mechanism with which to roam 
*                around in an image which is too large to be accomodated
*                by the image object in which it is displayed.  Thus,
*                the panicon object must be used in conjunction 
*                with an image object on which it will pan.  
*
*                Note that the 
*                .symbol noindex XVW_IMAGE_IMAGEOBJ 
*                attribute is used to specify the data object on which 
*                the panicon should pan; this should be the same data 
*                object as the one displayed in the image object.
*
*                The panicon object will \fInot\fP be mapped unless
*                it is needed;  a created panicon object will remain
*                "invisible" if the image being displayed 
*                is small enough to fit within the image object.  
*                Thus, if an application using an image object expects
*                to \fIever\fP receive a request to display an image
*                which is larger than the image object size, a pan
*                icon object should \fIalways\fP be created;  it will
*                not appear unless it is necessary.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: none
*       Returns: Returns the created panicon xvobject, or NULL upon failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Oct 08, 1992 15:37
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_panicon(
   xvobject parent,
   char     *name)
{
	xvobject object;

	object = xvw_create(parent, FALSE, FALSE, name, PanIconWidgetClass);
	if (object != NULL)
	{
	   xvw_set_attributes(object,
                XVW_MENUABLE,     TRUE,      /* menuable       */
                XVW_RESIZABLE,    FALSE,     /* resizable      */
                XVW_SELECTABLE,   TRUE,      /* selectable     */
		NULL);
	}
	return(object);
}
