 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */



/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                 ImageIcon Widget Routines
   >>>>
   >>>>	 Private:
   >>>>	  Static:
   >>>>			ClassInitialize()
   >>>>			Resize()
   >>>>			SetValues()
   >>>>   Public:
   >>>>			xvw_create_imageicon()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/ImageIconP.h>


static void ClassInitialize PROTO((void));
static void Resize	    PROTO((Widget));
static Boolean SetValues    PROTO((Widget, Widget, Widget, ArgList,
				   Cardinal *));

#undef kwidget
#undef kwidgetclass

#define kwidget(widget)      (XvwImageIconWidget) (widget)
#define kwidgetclass(widget) (XvwImageIconWidgetClass) (widget)->core.widget_class

/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_IMAGEICON_SIZE,	NULL,	XtRInt,		XtRDimension},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwImageIconWidgetRec, imageicon.field)

static XtResource resources[] = { 
{XVW_IMAGEICON_SIZE, NULL, XtRDimension, sizeof(Dimension),
      offset(size), XtRString, (XtPointer) "100"},

{NULL, NULL, XtRInt, sizeof(int),
      XtOffsetOf(XvwImageWidgetRec, image.reload_type),
      XtRImmediate, (XtPointer) IMAGEICON_OBJECT_RELOAD},
};
#undef offset


#define SUPERCLASS (&xvwImageWidgetClassRec)

XvwImageIconWidgetClassRec xvwImageIconWidgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "ImageIcon",			/* class_name		  */
    sizeof(XvwImageIconWidgetRec),	/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    XtInheritRealize,			/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),			/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    TRUE,				/* compress_motion	  */
    XtExposeCompressMaximal,		/* compress_exposure	  */
    TRUE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    NULL,				/* resize		  */
    XtInheritExpose,			/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    XtInheritDisplayAccelerator,	/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
    NULL,                    		/* geometry_manager	  */
    XtInheritChangeManaged,		/* change_managed	  */
    XtInheritInsertChild,		/* insert_child	  	  */
    XtInheritDeleteChild,		/* delete_child	  	  */
    NULL,				/* extension	 	  */
  },  /* CompositeClass fields initialization */
  {
    NULL,	            		/* subresources       */
    0,					/* subresources_count */
    sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size    */
    NULL,				/* initialize         */
    NULL,                               /* destroy            */
    NULL,				/* set_values         */
    NULL,                               /* extension          */
  },  /* ConstraintClass fields initialization */
  {
    XtInheritLayout,			/* child layout routine  */
    XtInheritChangeSel,		        /* change selected proc   */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    Resize,				/* resize		  */
    XtInheritGeometryManager,  		/* geometry_manager	  */
  }, /* XvwManagerWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwGraphicsWidgetClass fields initialization */
  {
    XtInheritColorReload,		/* reload color proc             */
  },  /* XvwColorWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwImageWidgetClass fields initialization */
  {
    NULL,                                     /* field not used    */
  },  /* XvwImageIconWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwImageIconWidgetClass for public consumption
 */
WidgetClass xvwImageIconWidgetClass = (WidgetClass) &xvwImageIconWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of imageicon widget class has been created.
|                It will initialize all the class attributes.
|
|    Written By: Mark Young and John M. Salas
|          Date: Aug 15, 1992
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwImageIconWidgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/ImageIcon.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/ImageIcon");
}

/*-----------------------------------------------------------
|
|  Routine Name: Resize
|
|       Purpose: This method is used to set the imageicon size
|		 to a new size if the image is resized, and
|		 to reset the image factor.
|
|         Input: widget - the widget containing the new position 
|                         and size information
|    Written By: Mark Young
|          Date: Oct 14, 1994
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Resize(
   Widget widget)
{
	XvwImageIconWidget xwid = kwidget(widget);
	int  w, h, d, t, e;

	/*
	 * Initialize the new value data demsionality
	 */
	w = xwid->image.wsize = widget->core.width;
	h = xwid->image.hsize = widget->core.height;
	d = xwid->image.dsize;
	t = xwid->image.tsize;
	e = xwid->image.esize;

	/*
	 *  Set the new value data dimensionality, and in case there is a
	 *  mask segment do the same.
	 */
	kpds_set_attribute(xwid->image.iobject, KPDS_VALUE_SIZE, w, h, d, t, e);
	kpds_set_attribute(xwid->image.iobject, KPDS_MASK_SIZE, w, h, d, t, e);

	/*
	 *  Call our superclass's resize procedure to take care of
	 *  resizing the actual image.
	 */
	(*xvwImageIconWidgetClass->core_class.superclass->core_class.resize)
		(widget);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a imageicon widget instance.   
|
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output: None
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Oct 24, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwImageIconWidget cxwid = (XvwImageIconWidget) current;
	XvwImageIconWidget nxwid = (XvwImageIconWidget) new;

	double factor;
	int w, h, d, t, e, type;
	int region_width, region_height, num_rgns;


	if (nxwid->image.iobject   != NULL &&
	   (cxwid->image.iobject   != nxwid->image.iobject  ||
	    cxwid->imageicon.size  != nxwid->imageicon.size))
	{
	   /*
	    *  Get the value data demsionality
	    */
	   kpds_get_attribute(nxwid->image.iobject, KPDS_VALUE_SIZE,
			&w, &h, &d, &t, &e);

	   factor = nxwid->imageicon.size;
	   factor = kmin(factor/w, factor/h);
	   w *= factor; h *= factor;
	   nxwid->core.width  = w;
	   nxwid->core.height = h;
	   xvw_set_attributes(xvw_object(new),
		XVW_PREFERRED_WIDTH,  nxwid->core.width,
		XVW_PREFERRED_HEIGHT, nxwid->core.height,
		NULL);
	   kpds_set_attributes(nxwid->image.iobject,
		KPDS_VALUE_SIZE, w, h, d, t, e,
		KPDS_VALUE_INTERPOLATE, KZERO_ORDER,
		NULL);

	   /*
	    *  In case there is a mask segment...
	    */
	   kpds_set_attributes(nxwid->image.iobject,
		KPDS_MASK_SIZE, w, h, d, t, e,
		KPDS_MASK_INTERPOLATE, KZERO_ORDER,
		NULL);

	   kpds_get_attributes(nxwid->image.iobject,
		KPDS_VALUE_DATA_TYPE, &type,
	   	KPDS_VALUE_OPTIMAL_REGION_SIZE, &region_width, &region_height,
		&d, &t, NULL, &num_rgns, NULL);

	   if (type == KDOUBLE  || type == KFLOAT ||
	       type == KCOMPLEX || type == KDCOMPLEX || d != 1 || t != 1)
	   {
	      num_rgns = 1;
	   }
	   else if (nxwid->image.image_depth == 1)
	      num_rgns /= e;

	   if (num_rgns <= 0) num_rgns = 1;
	   if (region_width == 1)
	   {
	      region_width = num_rgns;
	      num_rgns = region_height;
	      region_height = 1;
	   }
	   nxwid->image.region_num    = num_rgns;
	   nxwid->image.region_width  = region_width;
	   nxwid->image.region_height = region_height;
#if 0
	   kfprintf(kstderr,"Optimal Region Size is %d for %d regions\n",
		region_width*region_height*d*t*e, nxwid->image.region_num);
#endif
	}
	return(FALSE);
}


/************************************************************
*
*  Routine Name: xvw_create_imageicon - create a imageicon object
*
*       Purpose: The image icon visual object displays the image as an icon
*                (a miniature, subsampled version of the image).
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object
*
*        Output: none
*       Returns: Returns the created imageicon xvobject, or NULL upon failure
*
*  Restrictions:
*    Written By: Mark Young
*          Date: Oct 08, 1992
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/
 
xvobject xvw_create_imageicon(
   xvobject parent,
   char     *name)
{
        xvobject object;
 
        object = xvw_create(parent, FALSE, TRUE, name, ImageIconWidgetClass);
        return(object);
}
