 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>           Graphics Widget/Gadget Routines
   >>>>
   >>>>	 Static:
   >>>>			ClassInitializeGadget()
   >>>>			ClassInitializeWidget()
   >>>>			ClassPartInitializeGadget()
   >>>>			ClassPartInitializeWidget()
   >>>>			Initialize()
   >>>>			Realize()
   >>>>			Destroy()
   >>>>			SetValues()
   >>>>                 ColorSetVisual()
   >>>>
   >>>>	Private:
   >>>>	 Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/ColorP.h>

static void ClassInitializeGadget	PROTO((void));
static void ClassInitializeWidget	PROTO((void));
static void ClassPartInitializeGadget	PROTO((WidgetClass));
static void ClassPartInitializeWidget	PROTO((WidgetClass));

static void Initialize	   PROTO((Widget, Widget, ArgList, Cardinal *));
static void Realize	   PROTO((Widget,XtValueMask *,XSetWindowAttributes *));
static void Destroy	   PROTO((Widget));
static Boolean SetValues   PROTO((Widget, Widget, Widget, ArgList, Cardinal *));
static void ColorSetVisual PROTO((Widget));


/*-------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_COLOR_BEGIN,          NULL,     XtRInt,         XtRPosition},
{XVW_COLOR_END,            NULL,     XtRInt,         XtRPosition},
{XVW_COLOR_COLOROBJ,       NULL,     XtRPointer,     NULL},
{XVW_COLOR_CALLBACK,	   NULL,     XtRCallback,    NULL},
{XVW_COLOR_NORM_TYPE,	   NULL,     XtRInt,         NULL},
{XVW_COLOR_NORM_METHOD,	   NULL,     XtRInt,         NULL},
{XVW_COLOR_RED_FUNCTION,   NULL,     XtRString,      NULL},
{XVW_COLOR_GREEN_FUNCTION, NULL,     XtRString,      NULL},
{XVW_COLOR_BLUE_FUNCTION,  NULL,     XtRString,      NULL},
{XVW_COLOR_ALLOC_POLICY,   NULL,     XtRInt,         NULL},
{XVW_COLOR_NORM_UBYTE,     NULL,     XtRInt,         XtRBoolean},
{XVW_COLOR_PRIVATE_CMAP,   NULL,     XtRInt,         XtRBoolean},
};

/*-------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwColorPart, field)

static XtResource color_resources[] = {
{XVW_COLOR_BEGIN, NULL, XtRPosition, sizeof(Position),
      offset(begin), XtRImmediate, (XtPointer) 0},
{XVW_COLOR_END, NULL, XtRPosition, sizeof(Position),
      offset(end), XtRImmediate, (XtPointer) 0},
{XVW_COLOR_COLOROBJ, NULL, XtRPointer, sizeof(kobject),
      offset(object), XtRImmediate, (XtPointer) NULL},
{XVW_COLOR_CALLBACK, NULL, XtRCallback, sizeof(XtPointer),
      offset(color_callbacks), XtRCallback, (XtPointer) NULL},
{XVW_COLOR_NORM_TYPE, NULL, XtRInt, sizeof(int),
      offset(norm_type), XtRImmediate, (XtPointer) KCOLOR_NORM_GLOBAL},
{XVW_COLOR_NORM_METHOD, NULL, XtRInt, sizeof(int),
      offset(norm_method), XtRImmediate, (XtPointer) KCOLOR_NORM_MAXCOLORS},
{XVW_COLOR_RED_FUNCTION, NULL, XtRString, sizeof(String),
      offset(red_function), XtRString, (XtPointer) "M0"},
{XVW_COLOR_GREEN_FUNCTION, NULL, XtRString, sizeof(String),
      offset(green_function), XtRString, (XtPointer) "M1"},
{XVW_COLOR_BLUE_FUNCTION, NULL, XtRString, sizeof(char *),
      offset(blue_function), XtRString, (XtPointer) "M2"},
{XVW_COLOR_ALLOC_POLICY, NULL, XtRInt, sizeof(int),
      offset(alloc_policy), XtRImmediate, (XtPointer) KCOLOR_ALLOC_READONLY},
{XVW_COLOR_NORM_UBYTE, NULL, XtRBoolean, sizeof(Boolean),
      offset(norm_ubyte), XtRImmediate, (XtPointer) TRUE},
{XVW_COLOR_PRIVATE_CMAP, NULL, XtRBoolean, sizeof(Boolean),
      offset(private_cmap), XtRImmediate, (XtPointer) FALSE},

{NULL, NULL, XtRBoolean, sizeof(Boolean),
      offset(initialize_visual), XtRImmediate, (XtPointer) TRUE},
};
#undef offset


#define SUPERCLASS (&xvwGraphicsGadgetClassRec)

XvwColorGadgetClassRec xvwColorGadgetClassRec =
{
  {
	 (WidgetClass) SUPERCLASS,	/* superclass		  */	
	 "Color",			/* class_name		  */
	 sizeof(XvwColorGadgetRec),	/* size			  */
	 ClassInitializeGadget,		/* class_initialize	  */
	 ClassPartInitializeGadget,	/* class_part_initialize  */
	 FALSE,				/* class_inited		  */
	 Initialize,			/* initialize		  */
	 NULL,		                /* initialize_hooks       */
	 NULL,				/* realize		  */
	 NULL,				/* actions		  */
	 0,				/* num_actions		  */
	 NULL,				/* resources		  */
	 0,				/* resource_count	  */
	 NULLQUARK,			/* xrm_class		  */
	 FALSE,				/* compress_motion	  */
	 FALSE,				/* compress_exposure	  */
	 FALSE,				/* compress_enterleave    */
	 FALSE,				/* visible_interest	  */
	 Destroy,			/* destroy		  */
	 XtInheritResize,		/* resize		  */
	 NULL,				/* expose		  */
	 SetValues,			/* set_values		  */
	 NULL,				/* set_values_hook	  */
	 XtInheritSetValuesAlmost,	/* set_values_almost	  */
	 NULL,				/* get_values_hook	  */
	 NULL,				/* accept_focus		  */
	 XtVersion,			/* version		  */
	 NULL,				/* callback_private	  */
	 NULL,				/* tm_table		  */
	 NULL,				/* query_geometry	  */
	 NULL,				/* display_accelerator	  */
	 NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
	 XtInheritPicking,              /* pick object proc       */
	 XtInheritEraseSel,             /* erase selected proc    */
	 XtInheritRefreshSel,           /* refresh selection proc */
         XtInheritChangeGeometry,	/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
	 XtInheritRecomputePosition,	/* recompute position proc       */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
	 NULL,				/* reload color proc		 */
  },  /* XvwColorGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwColorGadgetClass for public consumption
 */
WidgetClass xvwColorGadgetClass = (WidgetClass) &xvwColorGadgetClassRec;



#define SUPERCLASS (&xvwGraphicsWidgetClassRec)

XvwColorWidgetClassRec xvwColorWidgetClassRec =
{
  {
	 (WidgetClass) SUPERCLASS,	/* superclass		  */	
	 "Color",			/* class_name		  */
	 sizeof(XvwColorWidgetRec),	/* size			  */
	 ClassInitializeWidget,		/* class_initialize	  */
	 ClassPartInitializeWidget,	/* class_part_initialize  */
	 FALSE,				/* class_inited		  */
	 Initialize,			/* initialize		  */
	 NULL,				/* initialize_hook	  */
	 Realize,			/* realize		  */
	 NULL,				/* actions		  */
	 0,				/* num_actions		  */
	 NULL,				/* resources		  */
	 0,				/* resource_count	  */
	 NULLQUARK,			/* xrm_class		  */
	 TRUE,				/* compress_motion	  */
	 XtExposeCompressMaximal,	/* compress_exposure	  */
	 TRUE,				/* compress_enterleave    */
	 FALSE,				/* visible_interest	  */
	 Destroy,			/* destroy		  */
         NULL,				/* resize		  */
	 XtInheritExpose,		/* expose		  */
	 SetValues,			/* set_values		  */
	 NULL,				/* set_values_hook	  */
	 XtInheritSetValuesAlmost,	/* set_values_almost	  */
	 NULL,				/* get_values_hook	  */
	 NULL,				/* accept_focus		  */
	 XtVersion,			/* version		  */
	 NULL,				/* callback_private	  */
	 XtInheritTranslations,		/* tm_table		  */
	 NULL,				/* query_geometry	  */
	 NULL,				/* display_accelerator	  */
	 NULL				/* extension		  */
  },  /* CoreClass fields initialization */
  {
         NULL,                    	/* geometry_manager	  */
	 XtInheritChangeManaged,        /* change_managed         */
	 XtInheritInsertChild,          /* insert_child           */
	 XtInheritDeleteChild,          /* delete_child           */
	 NULL,                          /* extension              */
  },  /* CompositeClass fields initialization */
  {
	 NULL,		                /* subresources           */
	 0,				/* subresources_count     */
	 sizeof(XvwManagerWidgetConstraintsRec),/* constraint_size        */
	 NULL,			        /* initialize             */
	 NULL,                          /* destroy                */
	 NULL,                          /* set_values             */
	 NULL,                          /* extension              */
  },  /* ConstraintClass fields initialization */
  {
	 XtInheritLayout,               /* child layout routine   */
         XtInheritChangeSel,	        /* change selected proc   */
         XtInheritEraseSel,		/* erase selected proc    */
         XtInheritRefreshSel,		/* refresh selection proc */
         XtInheritResize,		/* resize		  */
         XtInheritGeometryManager,  	/* geometry_manager	  */
  }, /* XvwManagerWidgetClass fields initialization */
  {
	 NULL,                          /* field not used         */

  },  /* XvwGraphicsWidgetClass fields initialization */
  {
	 NULL,
  },  /* XvwColorWidgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwColorWidgetClass for public consumption
 */
WidgetClass xvwColorWidgetClass = (WidgetClass) &xvwColorWidgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassPartInitializeWidget
|
|       Purpose: This method is called when the first time an
|                instance of XvwColorWidgetClass or a subclass of
|                the XvwColorWidgetClass is created.  It handles the
|                inheritence of special methods from the superclass
|                to the subclass.
|
|         Input: wclass - the object class being initialized
|        Output:
|    Written By: Mark Young
|          Date: May 24, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassPartInitializeWidget(
   WidgetClass wclass)
{
	XvwColorWidgetClass cclass = (XvwColorWidgetClass) wclass;
	XvwColorWidgetClass sclass = (XvwColorWidgetClass)
					wclass->core_class.superclass;

	/*
	 *  make sure we aren't trying to inherit from the color widget's
	 *  superclass.
	 */
	if (wclass != xvwColorWidgetClass)
	{
	   if (cclass->color_class.color_reload == XtInheritColorReload)
	   {
	      cclass->color_class.color_reload =
			sclass->color_class.color_reload;
	   }
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: ClassPartInitializeGadget
|
|       Purpose: This method is called when the first time an 
|                instance of XvwColorGadgetClass or a subclass of 
|                the XvwColorGadgetClass is created.  It handles the
|                inheritence of special methods from the superclass 
|                to the subclass.
|
|         Input: wclass - the object class being initialized
|        Output:
|    Written By: Mark Young
|          Date: May 24, 1994
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ClassPartInitializeGadget(
   WidgetClass wclass)
{
	XvwColorGadgetClass cclass = (XvwColorGadgetClass) wclass;
	XvwColorGadgetClass sclass = (XvwColorGadgetClass)
					wclass->core_class.superclass;

	/*
	 *  make sure we aren't trying to inherit from the color object's
	 *  superclass.
	 */
	if (wclass != xvwColorGadgetClass)
	{
	   if (cclass->color_class.color_reload == XtInheritColorReload)
	   {
	      cclass->color_class.color_reload =
			sclass->color_class.color_reload;
	   }
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: ClassInitializeGadget
|
|       Purpose: This method is called the first time an 
|                instance of color object class has been created. 
|		 It makes a copy of the color resources so that
|		 the color object class has them available.
|
|         Input: None
|
|        Output: None
|
|    Written By: Mark Young
|          Date: May 15, 1993 14:45
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitializeGadget(void)
{
	int	   i;
	XtResource *resources;
	unsigned int num_bytes     = sizeof(color_resources);
	unsigned int num_resources = knumber(color_resources);
	unsigned int res_offset    = XtOffsetOf(XvwColorGadgetRec, color);


	/*
	 *  Redo the resources so that we can share them between both
	 *  the xvwColorGadgetClass and xvwColorWidgetClass
	 */
	resources = (XtResource *) kmalloc(num_bytes);
	kmemcpy(resources, (char *) color_resources, num_bytes);

	for (i = 0; i < num_resources; i++)
	    resources[i].resource_offset += res_offset;

	xvwColorGadgetClass->core_class.resources     = resources;
	xvwColorGadgetClass->core_class.num_resources = num_resources;
	xvw_init_attributes(xvwColorGadgetClass, attributes,
		knumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Color");

	xvw_define_attributes(xvwColorGadgetClass,
	  XVW_COLOR_RELOAD,       XtRInt,     ColorSetUtil, NULL,
	  XVW_COLOR_COLORFILE,    XtRString,  ColorSetUtil, ColorGetUtil,
	  XVW_COLOR_RED_MAPCOL,   XtRInt,     ColorSetUtil, ColorGetUtil,
	  XVW_COLOR_GREEN_MAPCOL, XtRInt,     ColorSetUtil, ColorGetUtil,
	  XVW_COLOR_BLUE_MAPCOL,  XtRInt,     ColorSetUtil, ColorGetUtil,
	  XVW_COLOR_SAVEMAP,	  XtRString,  ColorSetUtil, NULL,
	  XVW_COLOR_COLORS,       XtRPointer, NULL,         ColorGetUtil,
	  XVW_COLOR_NUMCOLORS,    XtRInt,     NULL,         ColorGetUtil,

	  XVW_COLOR_CHANGE_RED_MAPCOL,   XtRInt, ColorChangeMapCol, NULL,
	  XVW_COLOR_CHANGE_GREEN_MAPCOL, XtRInt, ColorChangeMapCol, NULL,
	  XVW_COLOR_CHANGE_BLUE_MAPCOL,  XtRInt, ColorChangeMapCol, NULL,
	  NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an 
|                instance of color widget class has been created. 
|		 It makes a copy of the color resources so that
|		 the color widget class has them available.
|
|         Input: None
|
|        Output: None
|
|    Written By: Mark Young
|          Date: May 15, 1993 14:45
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitializeWidget(void)
{
	int	   i;
	XtResource *resources;
	unsigned int num_bytes     = sizeof(color_resources);
	unsigned int num_resources = knumber(color_resources);
	unsigned int res_offset    = XtOffsetOf(XvwColorWidgetRec, color);


	resources = (XtResource *) kmalloc(num_bytes);
	kmemcpy(resources, (char *) color_resources, num_bytes);

	for (i = 0; i < num_resources; i++)
	    resources[i].resource_offset += res_offset;

	xvwColorWidgetClass->core_class.resources     = resources;
	xvwColorWidgetClass->core_class.num_resources = num_resources;
	xvw_init_attributes(xvwColorWidgetClass, attributes,
		knumber(attributes), NULL, 0, NULL);
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Color");

	xvw_define_attributes(xvwColorWidgetClass,
	  XVW_COLOR_RELOAD,       XtRInt,    ColorSetUtil, NULL,
	  XVW_COLOR_COLORFILE,    XtRString, ColorSetUtil, ColorGetUtil,
	  XVW_COLOR_RED_MAPCOL,   XtRInt,    ColorSetUtil, ColorGetUtil,
	  XVW_COLOR_GREEN_MAPCOL, XtRInt,    ColorSetUtil, ColorGetUtil,
	  XVW_COLOR_BLUE_MAPCOL,  XtRInt,    ColorSetUtil, ColorGetUtil,
	  XVW_COLOR_SAVEMAP,	  XtRString, ColorSetUtil, NULL,
	  XVW_COLOR_CHANGE_RED_MAPCOL,   XtRInt, ColorChangeMapCol, NULL,
	  XVW_COLOR_CHANGE_GREEN_MAPCOL, XtRInt, ColorChangeMapCol, NULL,
	  XVW_COLOR_CHANGE_BLUE_MAPCOL,  XtRInt, ColorChangeMapCol, NULL,
	  NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|	Purpose: This method will set up the initial image
|                for an image widget instance.
|
|	  Input: request - not used
|                new     - widget instance after initialization, with
|                          initial image
|
|	 Output: None
|
|    Written By: Mark Young
|          Date: May 15, 1993 14:49
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
	Widget   request,
	Widget   new,
	ArgList  args,
	Cardinal *num_args)
{
	XvwColorPart    *color    = GetColorPart(new);

	color->id   = 0;
	color->info = NULL;
	color->allocated = FALSE;
	color->red_function   = kstrdup(color->red_function);
	color->green_function = kstrdup(color->green_function);
	color->blue_function  = kstrdup(color->blue_function);
	if (color->initialize_visual == TRUE)
	   ColorSetVisual(new);
}

/*-----------------------------------------------------------
|
|  Routine Name: Realize
|
|       Purpose: This method will set up the window attributes 
|                and create a window for the image widget.
|
|         Input: widget	    - the widget to realize 
|		 valuemask  - determines the window attributes being passed in
|		 attributes - the list of window attributes to be set 
|
|        Output: None 
|
|    Written By: Mark Young
|          Date: Jun 29, 1992
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Realize(
   Widget               widget,
   XtValueMask          *valuemask,
   XSetWindowAttributes *winattrib)
{
	Visual            *visual;
	Window	          windows[2];
	XWindowAttributes xwa;

	Display	*display  = XtDisplay(widget);
	xvobject object   = xvw_object(widget);
	xvobject toplevel = xvw_toplevel(object);


	(*xvwColorWidgetClass->core_class.superclass->core_class.realize)
                (widget, valuemask, winattrib);
	xvw_get_attribute(object, XVW_VISUAL, &visual);
	XGetWindowAttributes(display, xvw_window(toplevel), &xwa);
	if (visual != xwa.visual)
	{
	   windows[0] = xvw_window(object);
	   windows[1] = xvw_window(toplevel);
	   XSetWMColormapWindows(display, windows[1], windows, 2);
	}
}


/*-----------------------------------------------------------
|
|  Routine Name: Destroy
|
|       Purpose: Destroy the color object/widget
|
|         Input: widget - the color object/widget being destroyed
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Nov 17, 1992 19:24
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
	Widget widget)
{
	XvwColorPart *color = GetColorPart(widget);
	xvobject object;


	if (color->id != 0)
           XtRemoveTimeOut(color->id);

	/*
	 *  First close the object, so we no longer referencing it.
	 */
	kpds_close_object(color->object);
	color->object = NULL;

	/*
	 *  Now that the object has been closed, see if we should clean up
	 *  the object by calling ColorInit() to remove the callback, etc.
	 */
	if (color->info != NULL && color->info->widget != NULL)
	{
	   if (color->info->widget != widget)
	   {
              /*
               * need to check if object is NULL before removing callback,
               * as it will be NULL if a new colormap was set using
               * XVW_COLOR_COLOROBJ (DA)
               */
              object = xvw_object(color->info->widget);
              if (object != NULL)
                  xvw_remove_callback(object, XVW_COLOR_CALLBACK, 
                                      ColorUtilCallback, (XtPointer) widget);
	   }
	   else
	      color->info->widget = NULL;
	}
	kfree(color->red_function);
	kfree(color->green_function);
	kfree(color->blue_function);
	if (color->info != NULL)
	   color->info->references--;

	if (color->info != NULL && color->info->references == 0)
	{
	   ColorFree(widget, 0, color->info->ncolors);
	   kfree(color->info->pixels);
	   kfree(color->info->xcolors);
	   kfree(color->info->mapping);
           kfree(color->info->maps);
           kfree(color->info->red);
           kfree(color->info->green);
           kfree(color->info->blue);
           kfree(color->info->filename);
           kfree(color->info->histogram);
	   kfree(color->info);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: This method is used to set the public values
|                of a color object/widget instance.  The actual changes
|		 to the color part are made throught a specific set
|		 values call to a routine which operates only on the
|		 color part.
|                 
|         Input: current - the widget containing current settings
|                request - the widget containing requested settings
|                new     - the widget processed through all set values methods
|
|        Output: None 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: May 15, 1993 14:45
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues(
	Widget   current,
	Widget   request,
	Widget   new,
	ArgList  args,
	Cardinal *num_args)
{
	XvwColorPart *ncolor = GetColorPart(new);
	XvwColorPart *ccolor = GetColorPart(current);

	if (ccolor->object != ncolor->object)
	{
	   ColorFree(current, 0, -1);

	   /*
	    *  Make a reference of the data object, so we can twiddle
	    *  attributes and then add a map callback to the object.
	    *  But before adding a map callback we need to call
	    *  ColorInit(), since this will create a map segment
	    *  if needed.
	    */
	   ncolor->object = kpds_reference_object(ncolor->object);
	   ColorInit(new);
	   kpds_close_object(ccolor->object);
	}

	if (ccolor->norm_method    != ncolor->norm_method  ||
	    ccolor->alloc_policy   != ncolor->alloc_policy ||
	    ccolor->norm_type      != ncolor->norm_type    ||
	    ccolor->red_function   != ncolor->red_function   ||
	    ccolor->green_function != ncolor->green_function ||
	    ccolor->blue_function  != ncolor->blue_function)
	{
	   /*
	    *  According to the RGB mapping functions, load the red, green, blue
	    *  map arrays.
	    */
	   if (ccolor->red_function != ncolor->red_function)
	   {
	      ncolor->red_function = kstrdup(ncolor->red_function);
	      ApplyMapcolFunction(new, RED_COLOR);
	   }

	   if (ccolor->green_function != ncolor->green_function)
	   {
	      ncolor->green_function = kstrdup(ncolor->green_function);
	      ApplyMapcolFunction(new, GREEN_COLOR);
	   }

	   if (ccolor->blue_function != ncolor->blue_function)
	   {
	      ncolor->blue_function = kstrdup(ncolor->blue_function);
	      ApplyMapcolFunction(new, BLUE_COLOR);
	   }

	   if (ccolor->alloc_policy == KCOLOR_ALLOC_READONLY)
	      ColorFree(current, 0, -1);

	   ColorReloadXData(new);
	}

	if (ccolor->private_cmap != ncolor->private_cmap)
	{
	   Display *display = XtDisplay(new);
	   int     screen   = XScreenNumberOfScreen(XtScreen(new));

	   ColorFree(current, 0, -1);
	   if (ncolor->private_cmap == FALSE)
	      new->core.colormap = DefaultColormap(display, screen);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: ColorSetVisual - routine for getting the best visual
|
|       Purpose: This routine sets the visual given an object's data
|		 object.
|
|         Input: 
|        Output: 
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Jun 20, 1993
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void ColorSetVisual(
	Widget   widget)
{
	XvwColorPart *color = GetColorPart(widget);

	Display	*display  = XtDisplay(widget);
	xvobject object   = xvw_object(widget);
	int     screen    = XScreenNumberOfScreen(XtScreen(widget));

	int         depth;
	XVisualInfo vinfo;
	Visual      *visual;


	/*
	 *  Set the current visual to the default visual if it is null
	 */
	visual = NULL;
	xvw_get_attribute(object, XVW_VISUAL, &visual);
	if (!visual)
	   visual = DefaultVisual(display, screen);

	/*
	 *   Find a useable visual
	 */
	depth = widget->core.depth;
	if (XMatchVisualInfo(display, screen, 24, TrueColor, &vinfo)   ||
	    XMatchVisualInfo(display, screen, depth, PseudoColor, &vinfo) ||
	    XMatchVisualInfo(display, screen, depth, TrueColor,   &vinfo) ||
	    XMatchVisualInfo(display, screen, depth, DirectColor, &vinfo))
	{
	   if (visual != vinfo.visual)
	      xvw_set_attribute(object, XVW_VISUAL, vinfo.visual);

	   visual = vinfo.visual;
	   color->visual_depth = vinfo.depth;
	}
	else
	   color->visual_depth = DefaultDepth(display, screen);

	/*
	 *  If we using sporting a 24bit display, then we want to figure out
	 *  the RGB mask and shift factors.
	 */
	if (color->visual_depth == 24)
	{
	   color->rshift = 0; color->rmask = visual->red_mask;
	   color->gshift = 0; color->gmask = visual->green_mask;
	   color->bshift = 0; color->bmask = visual->blue_mask;
	   for (; !(color->rmask & 0x01) && color->rmask; color->rshift++)
	       color->rmask >>= 1;
	   for (; !(color->gmask & 0x01) && color->gmask; color->gshift++)
	       color->gmask >>= 1;
	   for (; !(color->bmask & 0x01) && color->bmask; color->bshift++)
	       color->bmask >>= 1;
	}
	else
	{
	   color->rshift = color->gshift = color->bshift = 0;
	   color->rmask  = color->gmask  = color->bmask  = 0;
	}
}
