 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                Circle Gadget Routines
   >>>>
   >>>>	 Private:
   >>>>   Static:
   >>>>			ClassInitialize()
   >>>>			Redisplay()
   >>>>			SetValues()
   >>>>			RecomputePosition()
   >>>>			ChangeGeometry()
   >>>>			PickGadget()
   >>>>   Public:
   >>>>			xvw_create_circle()
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"
#include <xvisual/CircleP.h>

static void ClassInitialize	 PROTO((void));
static void Redisplay		 PROTO((Widget, XEvent *, Region));
static Boolean SetValues	 PROTO((Widget, Widget, Widget, ArgList,
					Cardinal *));
static void RecomputePosition	 PROTO((Widget));
static void ChangeGeometry	 PROTO((Widget));
static int  PickGadget		 PROTO((Widget, int, int));


/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_CIRCLE_XCENTER,   NULL,    XtRDouble,    NULL},
{XVW_CIRCLE_YCENTER,   NULL,    XtRDouble,    NULL},
{XVW_CIRCLE_RADIUS,    NULL,    XtRDouble,     NULL},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwCircleGadgetRec, circle.field)

static XtResource resources[] = { 
{XVW_CIRCLE_XCENTER, NULL, XtRDouble, sizeof(double), 
      offset(center.x), XtRString, (XtPointer) "0.0"},
{XVW_CIRCLE_YCENTER, NULL, XtRDouble, sizeof(double), 
      offset(center.y), XtRString, (XtPointer) "0.0"},
{XVW_CIRCLE_RADIUS, NULL, XtRDouble, sizeof(double), 
      offset(radius), XtRString, (XtPointer) "1.0"},
};
#undef offset


#define SUPERCLASS (&xvwGraphicsGadgetClassRec)

XvwCircleGadgetClassRec xvwCircleGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Circle",			        /* class_name		  */
    sizeof(XvwCircleGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    NULL,				/* initialize		  */
    NULL,				/* initialize_hook	  */
    NULL,				/* realize		  */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    NULL,				/* destroy		  */
    XtInheritResize,			/* resize		  */
    Redisplay,				/* expose		  */
    SetValues,				/* set_values		  */
    NULL,				/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    NULL,				/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    PickGadget,				/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* refresh selection proc */
    ChangeGeometry,			/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    RecomputePosition,			/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwCircleGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwCircleGadgetClass for public consumption
 */
WidgetClass xvwCircleGadgetClass = (WidgetClass) &xvwCircleGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an  
|                instance of circle object class has been created.
|                It will initialize all the class attributes. 
|
|         Input: None 
|
|        Output: None
|
|    Written By: Mark Young & John Salas
|          Date: Aug 15, 1992 12:31
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwCircleGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Circle.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Circle");
}

/*-----------------------------------------------------------
|
|  Routine Name: Redisplay
|
|       Purpose: This routine will redraw the circle object in response
|                to an expose event. 
|
|         Input: widget - the circle object that was exposed 
|                event  - the event that caused the redraw
|                region - the region that was exposed 
|
|        Output: None
|
|    Written By: Mark Young
|          Date: Jun 29, 1992 10:35
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Redisplay(
   Widget widget,
   XEvent *event,
   Region region)
{
	XvwCircleGadget xobj = (XvwCircleGadget) widget;

	int    id;
	XColor *fg, *bg;

	id = xobj->graphics.id;
	fg = &xobj->graphics.fg;
	bg = &xobj->graphics.bg;

	if (xobj->graphics.filled == FALSE)
	   X2D_draw_circle(id, xobj->circle.center,
			   (Real) xobj->circle.radius, fg);
	else
	   X2D_fill_circle(id, xobj->circle.center,
			   (Real) xobj->circle.radius, fg, bg);
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: If the radius or the postion of the circle 
|		 has changed, recalculate the size and position
|		 of the circle.
|
|         Input: current - the object containing current settings 
|                request - the object containing requested settings
|                new     - the object processed through all set values methods 
|
|        Output: None directly 
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Jun 29, 1992 10:35
| Modifications: 
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwCircleGadget cobj = (XvwCircleGadget) current;
	XvwCircleGadget nobj = (XvwCircleGadget) new;


	if (cobj->circle.center.x != nobj->circle.center.x ||
	    cobj->circle.center.y != nobj->circle.center.y ||
	    cobj->circle.radius   != nobj->circle.radius)
	{
	   if (nobj->circle.radius <= 0.0)
	   {
	      kinfo(KFORCE, "Circle Object: The radius must be > 0.0, setting \
back to %g.\n", cobj->circle.radius);
	      nobj->circle.radius = cobj->circle.radius;
	   }
	   RecomputePosition(new);
	}
	return(FALSE);
}

/*-----------------------------------------------------------
|
|  Routine Name: RecomputePosition
|
|       Purpose: Given a new center and radius, recompute
|		 the new device coordinate position of 
|		 the circle. 
|
|         Input: widget - the circle object  
|
|        Output: None directly 
|
|    Written By: Mark Young
|          Date: Jun 29, 1992 10:35
| Modifications: 
|
------------------------------------------------------------*/

static void RecomputePosition(
   Widget widget)
{
	XvwCircleGadget xobj = (XvwCircleGadget) widget;

	Coord  coord;
	int id = xobj->graphics.id;
	Real xpos1, xpos2, ypos1, ypos2;
	XtWidgetGeometry temp;


	coord = xobj->circle.center;
	coord.x -= xobj->circle.radius;
	coord.y -= xobj->circle.radius;
	X2D_convert_point_wc_to_dc(id, coord, &xpos1, &ypos1);

	coord = xobj->circle.center;
	coord.x += xobj->circle.radius;
	coord.y += xobj->circle.radius;
	X2D_convert_point_wc_to_dc(id, coord, &xpos2, &ypos2);

	temp.request_mode = CWWidth | CWHeight | CWX | CWY;
	temp.x = (Position) kmin(xpos1, xpos2);
	temp.y = (Position) kmin(ypos1, ypos2);
	temp.width  = (Dimension) kabs(xpos2 - xpos1);
	temp.height = (Dimension) kabs(ypos2 - ypos1);
	(void) XtMakeGeometryRequest(widget, &temp, &temp);
}

/*-----------------------------------------------------------
|
|  Routine Name: ChangeGeometry
|
|       Purpose: Given a new device coordinate description of the
|		 circle, recompute the world coordinate center
|		 and radius.
|
|         Input: widget - the circle object
|
|        Output: None directly 
|
|    Written By: Mark Young
|          Date: Jun 29, 1992 10:35
| Modifications: 
|
------------------------------------------------------------*/

static void ChangeGeometry(
   Widget widget)
{
	XvwCircleGadget xobj = (XvwCircleGadget) widget;
	Coord coord1, coord2;

	int id = xobj->graphics.id;
	Real xpos1, xpos2, ypos1, ypos2, change;

	xpos1 = widget->core.x;
	ypos1 = widget->core.y;
/*
	if (kabs((Real) widget->core.width - (Real) xobj->graphics.old_width) >
	    kabs((Real) widget->core.height - (Real) xobj->graphics.old_height))
	{
	   change = (Real) widget->core.width;
	   widget->core.height = (Dimension) change;
	}
	else
 */
	{
	   change = (Real) widget->core.height;
	   widget->core.width  = (Dimension) change;
	}
	xpos2 = xpos1 + change;
	ypos2 = ypos1 + change;

	X2D_convert_point_dc_to_wc(id, xpos1, ypos1, &coord1);
	X2D_convert_point_dc_to_wc(id, xpos2, ypos2, &coord2);

	xpos1 = kabs(coord1.x - coord2.x);
	ypos1 = kabs(coord1.y - coord2.y);

	xobj->circle.center.x = xpos1/2.0 + kmin(coord1.x, coord2.x); 
	xobj->circle.center.y = ypos1/2.0 + kmin(coord1.y, coord2.y); 

	xobj->circle.radius = xpos1/2.0;
}

/*-----------------------------------------------------------
|
|  Routine Name: PickGadget
|
|       Purpose: Given a circle object and an attempted picking location,
|		 see if the circle has been picked. 
|
|         Input: widget - the circle object we are checking 
|                x      - the x device coordinate that the pick attempt was at 
|                y      - the y device coordinate that the pick attempt was at
|
|        Output: None 
|
|       Returns: TRUE (1) if object was successfully picked, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: Jun 29, 1992 10:35
| Modifications: 
|
------------------------------------------------------------*/

static int PickGadget(
   Widget widget,
   int    x,
   int    y)
{
        XvwCircleGadget xobj = (XvwCircleGadget) widget;

	Coord  coord;
	double radius;
	Real   xpos1, ypos1;
	int    id = xobj->graphics.id;


	xpos1 = x;
	ypos1 = y;
	X2D_convert_point_dc_to_wc(id, xpos1, ypos1, &coord);

	xpos1 = kabs(xobj->circle.center.x - coord.x);
	ypos1 = kabs(xobj->circle.center.y - coord.y);
	radius = sqrt(xpos1*xpos1 + ypos1*ypos1);

	if (xobj->graphics.filled)
	{
	   if ((radius - xobj->circle.radius) <= 0.0)
	      return(TRUE);
        }
	else
	{
	   if (kabs(radius - xobj->circle.radius) <= 0.05)
	      return(TRUE);
	}

	if (kabs(x - widget->core.x) <= PICK_TOLERANCE &&
	    kabs(y - widget->core.y) <= PICK_TOLERANCE)
	{
	   return(TRUE);
	}
	else if (kabs(x-(int)(widget->core.x+widget->core.width)) <= PICK_TOLERANCE &&
		 kabs(y - widget->core.y) <= PICK_TOLERANCE)
	{
	   return(TRUE);
	}
	else if (kabs(x - (int) (widget->core.x + widget->core.width)) <= PICK_TOLERANCE &&
		 kabs(y - (int) (widget->core.y + widget->core.height)) <= PICK_TOLERANCE)
	{
	   return(TRUE);
	}
	else if (kabs(x - widget->core.x) <= PICK_TOLERANCE &&
		 kabs(y - (int) (widget->core.y + widget->core.height)) <= PICK_TOLERANCE)
	{
	   return(TRUE);
	}
        return(FALSE);
}


/************************************************************
*
*  Routine Name: xvw_create_circle - create a circle object.
*
*       Purpose: A circle visual object supports the display of a circle.  
*                The (x, y) location of the circle center and the radius of 
*                the circle are specified in world coordinates.  The world 
*                coordinates are specified by the parent.  By default, these 
*                world coordinates are from 0 to 1 unless otherwise specified.  
*                So, for example, if the circle is created as the child of
*                a manager object, its world coordinates are from 0 to 1.  
*                In contrast, if the circle is created as the child of an image,
*                the world coordinates will be dictated by the size of the 
*                image; if it created as the child of a plot object, the world 
*                coordinates will be dictated by the plot.
*
*         Input: parent - the parent object; NULL will cause a
*                         default toplevel to be created automatically.
*                name   - the name with which to reference the object 
*
*        Output: None 
*
*	Returns: The circle xvobject on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young 
*          Date: Jun 29, 1992 10:31
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_circle(
   xvobject parent,
   char     *name)
{
	xvobject  object;


	/*
	 *  Create the circle object
	 */
	object = xvw_create(parent, FALSE, TRUE, name, CircleGadgetClass);
	return(object);
}
