 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                  2D Axis Routines
   >>>>
   >>>>	Private:
   >>>>			ClassInitialize()
   >>>>			Initialize()
   >>>>			Destroy()
   >>>>			SetValues()
   >>>>			InitializeHook()
   >>>>			GetValuesHook()
   >>>>			SetValuesHook()
   >>>>			PickGadget()
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include <xvisual/Axis2DP.h>

static void ClassInitialize	PROTO((void));
static void Initialize		PROTO((Widget, Widget, ArgList, Cardinal *));
static void InitializeHook	PROTO((Widget, ArgList, Cardinal *));
static Boolean SetValues	PROTO((Widget, Widget, Widget, ArgList,
				       Cardinal *));
static void Destroy	        PROTO((Widget));
static Boolean SetValuesHook	PROTO((Widget, ArgList, Cardinal *));
static void GetValuesHook	PROTO((Widget, ArgList, Cardinal *));
static int PickGadget		PROTO((Widget, int, int));


#define XVW_AXIS2D_CHANGE_LABELS "changeLabels"
#define XVW_AXIS2D_CHANGE_RANGE  "changeRange"

/*--------------------------------------------------------
|
|   Full class attributes
|
--------------------------------------------------------*/

static xvattribute attributes[] = {
{XVW_AXIS2D_CHANGE_LABELS,  NULL,    XtRInt,       NULL}, 
{XVW_AXIS2D_CHANGE_RANGE,   NULL,    XtRInt,       NULL}, 
{XVW_AXIS2D_AXIS_X,	    NULL,    XtRObject,    NULL},
{XVW_AXIS2D_AXIS_Y,	    NULL,    XtRObject,    NULL},
{XVW_AXIS2D_SHOW_AXIS_X,    NULL,    XtRInt,       XtRBoolean},
{XVW_AXIS2D_SHOW_AXIS_Y,    NULL,    XtRInt,       XtRBoolean},
};

/*--------------------------------------------------------
|
|   Full class record constant
|
--------------------------------------------------------*/

#define offset(field) XtOffsetOf(XvwAxis2DGadgetRec, axis2d.field)

static XtResource resources[] = {
{XVW_AXIS2D_AXIS_X, NULL, XtRObject, sizeof(xvobject),
        offset(axis_x), XtRImmediate, (XtPointer) NULL},
{XVW_AXIS2D_AXIS_Y, NULL, XtRObject, sizeof(xvobject),
        offset(axis_y), XtRImmediate, (XtPointer) NULL},
{XVW_AXIS2D_SHOW_AXIS_X, NULL, XtRBoolean, sizeof(Boolean),
        offset(show_axis_x), XtRImmediate, (XtPointer) TRUE},
{XVW_AXIS2D_SHOW_AXIS_Y, NULL, XtRBoolean, sizeof(Boolean),
        offset(show_axis_y), XtRImmediate, (XtPointer) TRUE},
};
#undef offset


#define SUPERCLASS (&xvwGraphicsGadgetClassRec)

XvwAxis2DGadgetClassRec xvwAxis2DGadgetClassRec =
{
  {
    (WidgetClass) SUPERCLASS,		/* superclass		  */	
    "Axis2D",				/* class_name		  */
    sizeof(XvwAxis2DGadgetRec),		/* size			  */
    ClassInitialize,			/* class_initialize	  */
    NULL,				/* class_part_initialize  */
    FALSE,				/* class_inited		  */
    Initialize,				/* initialize		  */
    InitializeHook,			/* initialize_hook	  */
    NULL,	                        /* realize                */
    NULL,				/* actions		  */
    0,					/* num_actions		  */
    resources,				/* resources		  */
    knumber(resources),		/* resource_count	  */
    NULLQUARK,				/* xrm_class		  */
    FALSE,				/* compress_motion	  */
    FALSE,				/* compress_exposure	  */
    FALSE,				/* compress_enterleave    */
    FALSE,				/* visible_interest	  */
    Destroy,				/* destroy		  */
    NULL,				/* resize		  */
    NULL,				/* expose		  */
    SetValues,				/* set_values		  */
    SetValuesHook,			/* set_values_hook	  */
    XtInheritSetValuesAlmost,		/* set_values_almost	  */
    GetValuesHook,			/* get_values_hook	  */
    NULL,				/* accept_focus		  */
    XtVersion,				/* version		  */
    NULL,				/* callback_private	  */
    NULL,				/* tm_table		  */
    NULL,				/* query_geometry	  */
    NULL,				/* display_accelerator	  */
    NULL				/* extension		  */
  },  /* RectObjClass fields initialization */
  {
    PickGadget,				/* pick object proc       */
    XtInheritEraseSel,			/* erase selected proc    */
    XtInheritRefreshSel,		/* Refresh selection proc */
    XtInheritChangeGeometry,		/* change geometry proc   */
  },  /* XvwManagerGadgetClass fields initialization */
  {
    XtInheritRecomputePosition,		/* recompute position proc    */
  },  /* XvwGraphicsGadgetClass fields initialization */
  {
    NULL,				/* extension - not used   */
  },  /* XvwAxis2DGadgetClass fields initialization */
};
#undef SUPERCLASS

/*
 * xvwAxis2DGadgetClass for public consumption
 */
WidgetClass xvwAxis2DGadgetClass = (WidgetClass) &xvwAxis2DGadgetClassRec;


/*-----------------------------------------------------------
|
|  Routine Name: ClassInitialize
|
|       Purpose: This method is called the first time an
|                instance of axis2d object class has been created.
|                It will initialize all the class attributes.
|
|         Input: None
|
|        Output: None
|
|    Written By: Mark Young and John M. Salas
|          Date: Aug 15, 1992 12:31
| Modifications:
|
------------------------------------------------------------*/

static void ClassInitialize(void)
{
        xvw_init_attributes(xvwAxis2DGadgetClass, attributes,
		knumber(attributes), NULL, 0, 
		"$DESIGN/objects/library/xvisual/uis/Axis2D.pane");
	xvw_load_resources("$DESIGN/objects/library/xvisual/app-defaults/Axis2D");
}


/*-----------------------------------------------------------
|
|  Routine Name: Initialize
|
|       Purpose: This method will set up the initial settings
|                for a 2D axis object instance.
|
|         Input: request - not used
|                new     - object instance after initialization,
|                          with attributes set
|
|        Output: None
|
|    Written By: Mark Young and John M. Salas
|          Date: Jun 29, 1992 10:35
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Initialize(
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwAxis2DGadget xobj = (XvwAxis2DGadget) new;


	/*
	 *  Initialize the graphics ID to show on
	 */
	xobj->axis2d.id = (int) xobj;
	X3D_init_graphics(xobj->axis2d.id, KGRAPHICS_2D);
	X2D_set_clipping(xobj->axis2d.id,  FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: InitializeHook
|
|       Purpose: This method will initialize the subparts of
|                the 2D axis object (i.e. the x and y axis
|                objects) on the creation of an 2D axis object.
|
|         Input: new      - the 2D axis object being created
|                args     - some initial settings for the subparts
|                num_args - the number of initial settings
|
|        Output: None
|
|    Written By: Mark Young and John M. Salas
|          Date: Jun 29, 1992 10:35
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void InitializeHook(
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
	XvwAxis2DGadget xobj = (XvwAxis2DGadget) new;

	Coord direction;
	Coord end_axis;
	Coord begin_axis;
	double wcmin_x, wcmax_x;
	double wcmin_y, wcmax_y;
	xvobject parent = xvw_object(xobj->object.parent);

	/*
	 *  Create the X,Y axis objects
	 */
	xobj->axis2d.axis_x = xvw_create(parent, FALSE, TRUE, "xaxis",
			AxisGadgetClass);
	xobj->axis2d.axis_y = xvw_create(parent, FALSE, TRUE, "yaxis",
			AxisGadgetClass);

	/*
	 *  Set the direction for axis_x to be in the "X" direction
	 */
	begin_axis.x = 0.0;
	begin_axis.y = 0.0;
	begin_axis.z = 0.0;
	end_axis.x = 1.0;
	end_axis.y = 0.0;
	end_axis.z = 0.0;
	direction.x = 1.0;
	direction.y = 0.0;
	direction.z = 0.0;
	xvw_get_attributes(xobj->axis2d.axis_x,
			   XVW_GRAPHICS_WCMAX_X, &wcmax_x,
			   XVW_GRAPHICS_WCMIN_X, &wcmin_x,
			   NULL);
	xvw_set_attributes(xobj->axis2d.axis_x,
			   XVW_MENUABLE,	 FALSE,
			   XVW_SELECTABLE,	 FALSE,
			   XVW_AXIS_LABEL,	 "X Axis",
			   XVW_AXIS_BEGIN_AXIS,	 &begin_axis,
			   XVW_AXIS_END_AXIS,	 &end_axis,
			   XVW_AXIS_DIRECTION,	 &direction,
			   NULL);
	xvw_set_attributes(xobj->axis2d.axis_x,
			   XVW_AXIS_LABELED_MAX, wcmax_x,
			   XVW_AXIS_LABELED_MIN, wcmin_x,
			   NULL);
	xvw_set_attributes(xobj->axis2d.axis_x,
			   XVW_AXIS_LABELING_MODE, KAXIS_SET_DEFAULT_MODE,
			   NULL);
	/*
	 *  Set the direction for axis_y to be in the "Y" direction
	 */
	begin_axis.x = 0.0;
	begin_axis.y = 0.0;
	begin_axis.z = 0.0;
	end_axis.x = 0.0;
	end_axis.y = 1.0;
	end_axis.z = 0.0;
	direction.x = 0.0;
	direction.y = 1.0;
	direction.z = 0.0;
	xvw_get_attributes(xobj->axis2d.axis_y,
			   XVW_GRAPHICS_WCMAX_Y, &wcmax_y,
			   XVW_GRAPHICS_WCMIN_Y, &wcmin_y,
			   NULL);

	xvw_set_attributes(xobj->axis2d.axis_y,
			   XVW_MENUABLE,	 FALSE,
			   XVW_SELECTABLE,	 FALSE,
			   XVW_AXIS_LABEL,	 "Y Axis",
			   XVW_AXIS_BEGIN_AXIS,	 &begin_axis,
			   XVW_AXIS_END_AXIS,	 &end_axis,
			   XVW_AXIS_DIRECTION,	 &direction,
			   NULL);
	xvw_set_attributes(xobj->axis2d.axis_y,
			   XVW_AXIS_LABELED_MAX, wcmax_y,
			   XVW_AXIS_LABELED_MIN, wcmin_y,
			   NULL);
	xvw_set_attributes(xobj->axis2d.axis_y,
			   XVW_AXIS_LABELING_MODE, KAXIS_SET_DEFAULT_MODE,
			   NULL);
}

/*-----------------------------------------------------------
|
|  Routine Name: Destroy - destroys the widget
|
|       Purpose: Destroy's the object's x&y axis.
|         Input: widget - widget to destroy
|       Returns: nothing
|
|    Written By: Mark Young
|          Date: Jan 06, 1995
|
------------------------------------------------------------*/
/* ARGSUSED */
static void Destroy(
   Widget widget)
{
        XvwAxis2DGadget xobj = (XvwAxis2DGadget) widget;
	Widget parent;

	/*
	 *  Destroy the x&y axis subparts if they are not being destroyed
	 */
	parent =  XtParent(widget);
	if (!parent->core.being_destroyed)
	{
	   xvw_destroy(xobj->axis2d.axis_x);
	   xvw_destroy(xobj->axis2d.axis_y);
	}
}

/*-----------------------------------------------------------
|
|  Routine Name: SetValues
|
|       Purpose: If the show or show numerical labels have 
|                changed on either the x or y axis, update 
|		 them accordingly.  This involves going
|		 to each of the numerical labels and mapping
|		 them or unmapping them depending on whether
|		 or not they should be shown. 
|
|         Input: current - the object containing current settings 
|                request - the object containing requested settings
|                new     - the object processed through all set values methods 
|
|        Output: None
|
|       Returns: TRUE (1) if redisplay is required, FALSE (0) otherwise
|
|    Written By: Mark Young and John M. Salas
|          Date: Jun 29, 1992 10:35
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValues (
   Widget   current,
   Widget   request,
   Widget   new,
   ArgList  args,
   Cardinal *num_args)
{
  XvwAxis2DGadget caxis  = (XvwAxis2DGadget) current;
  XvwAxis2DGadget naxis  = (XvwAxis2DGadget) new;
  XvwAxisGadget   axis_x = (XvwAxisGadget) naxis->axis2d.axis_x;
  XvwAxisGadget   axis_y = (XvwAxisGadget) naxis->axis2d.axis_y;
  tic_label_list *temp_list;
  Boolean redisplay = FALSE;
  int i;

  if (caxis->axis2d.show_axis_y != naxis->axis2d.show_axis_y)
  {
    xvw_set_attributes(naxis->axis2d.axis_y,
		       XVW_MAPPED, naxis->axis2d.show_axis_y,
		       NULL);

    if (naxis->axis2d.show_axis_y)
    {
      xvw_set_attributes(naxis->axis2d.axis_y,
		         XVW_AXIS_SHOW_NUMERICAL_LABELS,
		         naxis->axis2d.show_axis_y_tic_labels,
		         NULL);
      xvw_set_attributes(naxis->axis2d.axis_y,
		         XVW_AXIS_SHOW_AXIS_LABEL, 
		         naxis->axis2d.show_axis_y_label,
		         NULL);
    }
    else
    {
      xvw_get_attributes(naxis->axis2d.axis_y,
		         XVW_AXIS_SHOW_NUMERICAL_LABELS,
		         &naxis->axis2d.show_axis_y_tic_labels,
		         NULL);
      xvw_get_attributes(naxis->axis2d.axis_y,
		         XVW_AXIS_SHOW_AXIS_LABEL, 
		         &naxis->axis2d.show_axis_y_label,
		         NULL);

      temp_list = axis_y->axis.list_head;

      for ( i = 0 ; i < axis_y->axis.number_stringvalue_widgets && temp_list != NULL ;
            i++ , temp_list = temp_list->next)
      {
        xvw_set_attributes(temp_list->stringvalue, XVW_MAPPED, FALSE, NULL);
      }

      xvw_set_attributes(naxis->axis2d.axis_y,
                         XVW_AXIS_SHOW_NUMERICAL_LABELS,
                         naxis->axis2d.show_axis_y,
                         NULL);
      xvw_set_attributes(naxis->axis2d.axis_y,
		         XVW_AXIS_SHOW_AXIS_LABEL, 
		         naxis->axis2d.show_axis_y,
		         NULL);
    }
    redisplay = TRUE;
  }

  if (caxis->axis2d.show_axis_x != naxis->axis2d.show_axis_x)
  {
    xvw_set_attributes(naxis->axis2d.axis_x,
		       XVW_MAPPED, naxis->axis2d.show_axis_x,
		       NULL);

    if (naxis->axis2d.show_axis_x)
    {
      xvw_set_attributes(naxis->axis2d.axis_x,
		         XVW_AXIS_SHOW_NUMERICAL_LABELS,
		         naxis->axis2d.show_axis_x_tic_labels,
		         NULL);
      xvw_set_attributes(naxis->axis2d.axis_x,
		         XVW_AXIS_SHOW_AXIS_LABEL, 
		         naxis->axis2d.show_axis_x_label,
		         NULL);
    }
    else
    {
      xvw_get_attributes(naxis->axis2d.axis_x,
		         XVW_AXIS_SHOW_NUMERICAL_LABELS,
		         &naxis->axis2d.show_axis_x_tic_labels,
		         NULL);
      xvw_get_attributes(naxis->axis2d.axis_x,
		         XVW_AXIS_SHOW_AXIS_LABEL, 
		         &naxis->axis2d.show_axis_x_label,
		         NULL);

      temp_list = axis_x->axis.list_head;

      for ( i = 0 ; i < axis_x->axis.number_stringvalue_widgets && temp_list != NULL ;
            i++ , temp_list = temp_list->next)
      {
        xvw_set_attributes(temp_list->stringvalue, XVW_MAPPED, FALSE, NULL);
      }

      xvw_set_attributes(naxis->axis2d.axis_x,
                         XVW_AXIS_SHOW_NUMERICAL_LABELS,
                         naxis->axis2d.show_axis_x,
                         NULL);
      xvw_set_attributes(naxis->axis2d.axis_x,
		         XVW_AXIS_SHOW_AXIS_LABEL, 
		         naxis->axis2d.show_axis_x,
		         NULL);
    }
    redisplay = TRUE;
  }

  return(redisplay);
}


/*-----------------------------------------------------------
|
|  Routine Name: SetValuesHook
|
|       Purpose: This method is called to set the public values
|                of the subparts of the axis 2D object. i.e. the
|                x and y axis objects.
|
|         Input: widget   - the object containing the subpart
|                           to set the values on
|                args     - the list of args to set
|                num_args - the number of args being set
|
|        Output: None
|
|    Written By: Mark Young and John M. Salas
|          Date: Jun 29, 1992 10:35
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static Boolean SetValuesHook(
   Widget   widget,
   ArgList  args,
   Cardinal *num_args)
{
	XvwAxis2DGadget xobj = (XvwAxis2DGadget) widget;

	XtSetValues(xvw_widget(xobj->axis2d.axis_x), args, *num_args);
	XtSetValues(xvw_widget(xobj->axis2d.axis_y), args, *num_args);

	return(FALSE);
}


/*-----------------------------------------------------------
|
|  Routine Name: GetValuesHook
|
|       Purpose: This method is called to get the public values
|                of the subparts of the axis 2D object. i.e. the
|                x and y axis objects.
|
|         Input: widget - the object with the subparts that we
|                         are getting from
|
|        Output: args   - the arguments we are getting
|                num_args - the number of arguments successfully gotten
|
|    Written By: Mark Young and John M. Salas
|          Date: Jun 29, 1992 10:35
| Modifications:
|
------------------------------------------------------------*/
/* ARGSUSED */
static void GetValuesHook(
   Widget   widget,
   ArgList  args,
   Cardinal *num_args)
{
	XvwAxis2DGadget xobj = (XvwAxis2DGadget) widget;

	XtGetValues(xvw_widget(xobj->axis2d.axis_x), args, *num_args);
	XtGetValues(xvw_widget(xobj->axis2d.axis_y), args, *num_args);
}


/*-----------------------------------------------------------
|
|  Routine Name: PickGadget
|
|       Purpose: Given a axis2d object and an attempted picking location,
|                see if the axis2d has been picked. 
|
|         Input: widget - the line object we are checking 
|                x      - the x device coordinate that the pick attempt was at 
|                y      - the y device coordinate that the pick attempt was at
|
|        Output: None 
|
|       Returns: TRUE (1) if object was successfully picked, FALSE (0) otherwise|
|    Written By: Mark Young
|          Date: May 24, 1993 13:30
| Modifications: 
|
------------------------------------------------------------*/

static int PickGadget(
   Widget widget,
   int    x,
   int    y)
{
	XvwAxis2DGadget xobj = (XvwAxis2DGadget) widget;


	if (ManagerCheckSelection(xobj->axis2d.axis_x, x, y) ||
	    ManagerCheckSelection(xobj->axis2d.axis_y, x, y))
	{
	   return(TRUE);
	}
	return(FALSE);
}


/************************************************************
*
*  Routine Name: xvw_create_axis2d - create a 2D axis object
*
*       Purpose: The 2D axis object provides a set of X, Y axes
*                for use with a 2D plot.
*
*         Input: parent - the parent object; NULL will cause a  
*                         default toplevel to be created automatically
*                name   - the name with which to reference the object 
*
*        Output: none
*	Returns: The 2D axis object on success, NULL on failure
*
*  Restrictions:
*    Written By: Mark Young and John M. Salas
*          Date: Oct 08, 1992 15:37
*      Verified:
*  Side Effects:
* Modifications:
*
*************************************************************/

xvobject xvw_create_axis2d(
   xvobject parent,
   char     *name)
{
	xvobject  object;


	/*
	 *  Create the main Axis2d workspace
	 */
	object = xvw_create(parent, FALSE, TRUE, name, Axis2DGadgetClass);
	return(object);
}
