/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>                2D Get Utilities
   >>>>
   >>>>  Private:
   >>>>  	       X2D_get_window()
   >>>>  	       X2D_get_viewport()
   >>>>  	       X2D_get_wc_min_max()
   >>>>   Static:
   >>>>   Public:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "graphics.h"


/*-----------------------------------------------------------
|
|  Routine Name: X2D_get_window
|
|       Purpose: Inquires the minimum and maximum device coordinate
|		 for a given X11 Window.
|
|         Input: id	- X3D graphics structure ID
|
|        Output: x	- x offset in device coordinates
|		 y	- y offset in device coordinates
|		 width	- width of the window in device coordinates
|		 height	- height of the window in device coordinates
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int X2D_get_window (
   int   id,
   int *x,
   int *y,
   unsigned int *width,
   unsigned int *height)
{
	X3DGraphics 	*graphics;


	if ((graphics = _X3D_get_graphics(id)) == NULL)
	{
	   (void) kfprintf (kstderr,"X2D_get_window:");
	   (void) kfprintf (kstderr,"\t unknown graphics id %d\n",id);
	   return(FALSE);
	}

	if (graphics->device == X11)
	{
	   *x = graphics->X11_xmin;
	   *y = graphics->X11_ymin;
	   *width  = graphics->X11_xmax - *x;
	   *height = graphics->X11_ymax - *y;
	}
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: X2D_get_viewport
|
|       Purpose: Inquires the minimum and maximum viewport values
		 for a given X3D graphics structure.
|
|         Input: id	 - X3D graphics structure ID
|
|        Output: viewmin - the viewport minimum coordinate value.
|		 viewmax - the viewport maximum coordinate value.
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int X2D_get_viewport(
   int   id,
   Coord *viewmin,
   Coord *viewmax)
{
	X3DGraphics *graphics;

	if ((graphics = _X3D_get_graphics(id)) == NULL)
	{
	   (void) kfprintf (kstderr,"X2D_get_viewport:");
	   (void) kfprintf (kstderr,"\t unknown graphics id %d\n",id);
	   return(FALSE);
	}
	viewmin->x = graphics->xv_min;
	viewmin->y = graphics->yv_min;
	viewmax->x = graphics->xv_max;
	viewmax->y = graphics->yv_max;
	return(TRUE);
}

/*-----------------------------------------------------------
|
|  Routine Name: X2D_get_wc_min_max
|
|       Purpose: Inquires the minimum and maximum world coordinate
|		 points for a given X3D graphics structure.
|
|         Input: id	- X3D graphics structure ID
|
|        Output: wc_min	- A coord containing the minimum world
|			  coordinate values
|		 wc_max	- A coord containing the maximum world
|			  coordinate values
|
|       Returns: TRUE (1) on success, FALSE (0) otherwise
|
|    Written By: Mark Young
|          Date: 
| Modifications:
|
------------------------------------------------------------*/

int X2D_get_wc_min_max (
   int   id,
   Coord *wc_min,
   Coord *wc_max)
{
	X3DGraphics *graphics;

	if ((graphics = _X3D_get_graphics(id)) == NULL)
	{
	   (void) kfprintf (kstderr,"X2D_get_wc_min_max:");
	   (void) kfprintf (kstderr,"\t unknown graphics id %d\n",id);
	   return(FALSE);
	}

	*wc_min = graphics->wc_min;
	*wc_max = graphics->wc_max;
	return(TRUE);
}
