/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>          Initialization of Forms                      <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>   Static:                                             <<<<
   >>>>            xvf_init_attributes()	              <<<<
   >>>>   Public:                                             <<<<
   >>>>            xvf_initialize()                           <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"
#include "attributes.h"


static void xvf_init_attributes PROTO((void));
static int  ignore_announce     PROTO((char *, char *, char *, char *, char *));


/*-------------------------------------------------------------
|
|  Routine Name: xvf_initialize
|
|       Purpose: Does initializations in preparation for the use of
|                the xvforms library by the Khoros application.  
|
|         Input: None
|        Output: None 
|       Returns: None
|
|    Written By: Danielle Argiro & Mark Young
|          Date: Jul 16, 1992 
| Modifications: Converted from Khoros 1.0 (DA)
|
-------------------------------------------------------------*/

void xvf_initialize(void)
{
	char *value, *program;
	static int initialized = FALSE;

	if (initialized == TRUE)
	   return;
	else initialized = TRUE;

	/*
	 *  install GUI Khoros error handler
	 */

	if (xvw_display(NULL) != NULL)
	{
	    /* 
	     * set standard GUI handlers for errors, warnings, 
	     * prompts, info, choose
	     */
            kset_errorhandler(xvu_error);
            kset_warnhandler(xvu_warn);
            kset_prompthandler(xvu_prompt);
            kset_infohandler(xvu_info);
            kset_announcehandler(ignore_announce);
            kset_choosehandler(xvu_choose);
	
	    /*
             *  Check to see if the user wishes to desensitize 
             *  optional selections when they are turned off.
             */
	    program = kprog_get_program();
            if (((value = XGetDefault(xvw_display(NULL), program, 
				      "desensitize_optionals")) != NULL) ||
                ((value = XGetDefault(xvw_display(NULL), program, 
				      "Desensitize_Optionals")) != NULL))
            {
               value = kstring_lower(value, NULL);
               if (kstrcmp(value,"true") == 0)
                  xvf_desensitize_optionals = TRUE;
               else xvf_desensitize_optionals = FALSE;
               kfree(value);
            }
            else
               xvf_desensitize_optionals = TRUE;

	    /*
             *  set routines for menu actions used by internal menuforms
	     */
	    xvf_init_attributes();
	}
}

/*-----------------------------------------------------------
|
|       Routine: xvf_init_attributes
|       Purpose: Initializes the action attributes for all
|                the different UIS line attributes controlled by
|                menu panes.
|
|         Input: none
|        Output: none
|
|          Date: Nov 13, 1992
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/
static void xvf_init_attributes(void)
{
        int i;

	/*
	 * initialize the attribute table
	 */
        for (i = 0; i < xvf_attribute_num; i++)
        {
            xvf_attribute_table[i].token =
                 kstring_to_token(xvf_attribute_table[i].attribute);
        }

	/*  
	 * general actions 
	 */
	xvw_define_attribute(NULL, XVF_ACTIVATE, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_SELECTED, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_OPTIONAL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_OPTSEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LIVE, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_VARIABLE, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_DESCRIPTION, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_TITLE, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_BUTTONTITLE, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_GUIDEPANETITLE, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LITERAL, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_MODIFIED, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

	/*
	 * general geometry
	 */
	xvw_define_attribute(NULL, XVF_WIDTH,  XtRFloat, 
		   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_HEIGHT, XtRFloat, 
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_X, XtRFloat, 
		   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_Y, XtRFloat, 
		   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_BUTTONWIDTH,  XtRFloat, 
		   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_BUTTONHEIGHT, XtRFloat, 
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_BUTTONX, XtRFloat, 
		   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_BUTTONY, XtRFloat, 
		   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_XPOS, XtRFloat, 
		   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_YPOS, XtRFloat, 
		   xvf_set_defined_attribute, xvf_get_defined_attribute);

	/* 
	 * actions for logicals 
	 */
	xvw_define_attribute(NULL, XVF_LOGIC_VAL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LOGIC_DEF, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LOGIC_1LABEL, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LOGIC_0LABEL, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	
	/* 
	 * actions for integers 
	 */
        xvw_define_attribute(NULL, XVF_INT_GT0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_INT_GE0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_INT_LE0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_INT_LT0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

        xvw_define_attribute(NULL, XVF_INT_UPPER_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_INT_LOWER_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_INT_BOUNDS_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_INT_NOBOUNDS_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

        xvw_define_attribute(NULL, XVF_INT_UPPER, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_INT_LOWER, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_INT_DEF, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_INT_VAL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

        /*
         * actions for floats
         */
        xvw_define_attribute(NULL, XVF_FLOAT_GT0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_FLOAT_GE0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_FLOAT_LE0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_FLOAT_LT0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

        xvw_define_attribute(NULL, XVF_FLOAT_UPPER_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_FLOAT_LOWER_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_FLOAT_BOUNDS_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_FLOAT_NOBOUNDS_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

        xvw_define_attribute(NULL, XVF_FLOAT_UPPER, XtRFloat,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_FLOAT_LOWER, XtRFloat,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_FLOAT_DEF, XtRFloat,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_FLOAT_VAL, XtRFloat,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

        xvw_define_attribute(NULL, XVF_FLOAT_PREC, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

        /*
         * actions for doubles
         */
        xvw_define_attribute(NULL, XVF_DOUBLE_GT0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_DOUBLE_GE0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_DOUBLE_LE0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_DOUBLE_LT0_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

        xvw_define_attribute(NULL, XVF_DOUBLE_UPPER_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_DOUBLE_LOWER_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_DOUBLE_BOUNDS_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_DOUBLE_NOBOUNDS_SEL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

        xvw_define_attribute(NULL, XVF_DOUBLE_UPPER, XtRDouble,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_DOUBLE_LOWER, XtRDouble,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_DOUBLE_DEF, XtRDouble,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_DOUBLE_VAL, XtRDouble,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

        xvw_define_attribute(NULL, XVF_DOUBLE_PREC, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

	/* 
	 * actions for cycles & lists: they have different attributes
         * which utilize the same set and get routines.
	 */
	xvw_define_attribute(NULL, XVF_LIST_SIZE, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LIST_VAL, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LIST_LABEL, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LIST_INDEX, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LIST_START, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LIST_CHOICES, XtRInt,
                   xvf_set_defined_attribute, NULL);
	xvw_define_attribute(NULL, XVF_LIST_CONTENTS, XtRPointer,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LIST_DOUBLECLICK, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_LIST_ADD, XtRString,
                   xvf_set_defined_attribute, NULL);
	xvw_define_attribute(NULL, XVF_LIST_DELETE, XtRString,
                   xvf_set_defined_attribute, NULL);
	xvw_define_attribute(NULL, XVF_LIST_DELETEALL, XtRInt,
                   xvf_set_defined_attribute, NULL);

	/*
	 * actions for files, strings
	 */
	xvw_define_attribute(NULL, XVF_FILE_NAME, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_FILE_CHECK, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_FILE_DEF, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_STRING_VAL, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_STRING_DEF, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_STRING_MULTILINE, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

	/*
	 * actions for toggles
	 */
	xvw_define_attribute(NULL, XVF_TOGGLE_MEMBERS, XtRInt,
                   xvf_set_defined_attribute, NULL);
        xvw_define_attribute(NULL, XVF_TOGGLE_SIZE, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_TOGGLE_NUM, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_TOGGLE_VAL, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_TOGGLE_TYPE, XtRInt,
                   NULL, xvf_get_defined_attribute);

	/*
	 *  actions for printing UIS
	 */
	xvw_define_attribute(NULL, XVF_PRINT_UIS, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_PRINT_PANE, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_PRINT_SUBFORM, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_PANE_FILE, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
        xvw_define_attribute(NULL, XVF_SUBFORM_FILE, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);

	/*
	 *  miscellaneous actions
	 */
	xvw_define_attribute(NULL, XVF_ROUTINE, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_EXECTYPE, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_DELETE, XtRInt,
                   xvf_set_defined_attribute, NULL);
	xvw_define_attribute(NULL, XVF_DISPLAY_SUBFORM, XtRInt,
                   xvf_set_defined_attribute, NULL);
	xvw_define_attribute(NULL, XVF_DISPLAY_PANE, XtRInt,
                   xvf_set_defined_attribute, NULL);
	xvw_define_attribute(NULL, XVF_HELPPATH, XtRString,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
	xvw_define_attribute(NULL, XVF_MECHANISM, XtRInt,
                   xvf_set_defined_attribute, xvf_get_defined_attribute);
}

/*-----------------------------------------------------------
|
|  Routine Name: ignore_announce - temporary thang to ignore announces by
|				   default
|
|       Purpose: This routine should be temporary.  Just here for Mark
|		 Scneider's visit to get rid of announces.
|         Input: toolbox   - name of toolbox (if applicable)
|                program   - name of program (if applicable, NULL otherwise)
|                library   - name of library (if applicable, NULL otherwise)
|                routine   - name of routine
|                message   - grammatically correct, clear explanation of
|        Output:
|       Returns:
|
|    Written By: Mark Young
|          Date: Jul 14, 1994
| Modifications:
|
------------------------------------------------------------*/

static int ignore_announce(
   char *toolbox,
   char *program,
   char *library,
   char *routine,
   char *message)
{
	/* luvin it ain't you */
	return(TRUE);
}
