 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>            Value Collection Routines                  <<<<
   >>>>                                                       <<<<
   >>>>  Private: xvf_collect_check_data()		      <<<<
   >>>> 	  xvf_collect_value()			      <<<<
   >>>> 	  xvf_update_form_tree()		      <<<<
   >>>>                                                       <<<<
   >>>>   Static: collect_check_selections                    <<<<
   >>>>   Public:                                             <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */

#include "internals.h"

static int collect_check_selections PROTO((kselection *));
/*-----------------------------------------------------------
|
| Routine Name:  xvf_collect_check_data
|
|      Purpose:  This routine checks all of the text objects on selections 
|		 of a control panel (master, guidepane, or pane) to see if 
|                their contents have been updated by the user.  Text objects 
|                are found in KUIS_INPUTFILE, KUIS_OUTPUTFILE, String, Integer,
|		 and Float selections.  If any values have changed, 
|		 then the database is updated with the selection value.
|
|         Input: control - pointer to the selection master, guidepane, or pane 
|        Output: none
|          Date: April 14, 1994
|    Written By: Danielle Argiro
| Modifications:
|
------------------------------------------------------------*/

int xvf_collect_check_data(
   kform *form)
{
	ksubform *subform;
	kguide   *guide;

	if (form->master != NULL)
	{
	    if (!(collect_check_selections(form->master->sel_list)))
	        return(FALSE);
	    subform = form->master->subform_list;
	}
	else subform = form->subform;

        /*
         * collect parameters from subform list
         */
        while (subform != NULL)
        {
            if (subform->guidepane != NULL)
            {
                if (!(collect_check_selections(subform->guidepane->sel_list)))
                    return(FALSE);
                guide = subform->guidepane->guide_list;
            }
            else guide = subform->guide;

            /*
             * collect parameters from panes
             */
            while (guide != NULL)
            {
                if (!(collect_check_selections(guide->pane->sel_list)))
                    return(FALSE);
                guide = guide->next;
            }
            subform = subform->next;
        }
	return(TRUE);
}

/*-----------------------------------------------------------
|
| Routine Name:  collect_check_selections
|
|      Purpose:  This routine check and collects user input from
|		 all of the text objects on a selection list.
|
|         Input: sel_list - pointer to the selection list
|        Output: none
|          Date: April 14, 1994
|    Written By: Danielle Argiro
| Modifications: 
|
------------------------------------------------------------*/

static int collect_check_selections(
    kselection *sel_list)
{
        kform      *form;
        ksubform   *subform;
        kselection *selection;

        /*
         * go through the entire selection list on which this
         * action button appears; collect any/all parameters of input files,
         * output files, strings, integers, or floats that may have been
         * changed and change their values at this time
         */

        selection = sel_list;
        if (selection == NULL) return(TRUE);

        while (selection != NULL)
        {
            switch (selection->type)
            {
                case KUIS_INPUTFILE:
                case KUIS_OUTPUTFILE:
                case KUIS_INTEGER:
                case KUIS_FLOAT:
                case KUIS_DOUBLE:
                case KUIS_STRING:
                case KUIS_STRINGLIST:
                     if (!(xvf_collect_value(selection)))
                           return(FALSE);
                break;

                default:
                    break;
            }
            if (selection->group_next != NULL)
                if (!(collect_check_selections(selection->group_next)))
                    return(FALSE);
            selection = selection->next;
        }
	return(TRUE);
}

/*------------------------------------------------------------
|
| Routine Name:  xvf_collect_value
|
|      Purpose:  This routine collects text from the text object 
|                of a selection and sets the literal accordingly.
|
|         Input: selection - pointer to the selection
|        Output: 
|          Date: Oct 19, 1994
|    Written By: Danielle Argiro
| Modifications: 
|
------------------------------------------------------------*/

int xvf_collect_value(
   kselection *selection)
{
	char *text_return, *text_contents; 

	/*
	 * possibility of attempt to collect integer from int selection
         * w/ no text widget.  In this case, consider it up to date.
	 */
	if (selection->value_object == NULL) return(TRUE);

	/* 
	 * get the string representing the integer from the ascii object 
	 */
	xvw_get_attribute(selection->value_object, 
		          XVW_TEXT_STRING, &text_return);
	text_contents = kstrdup(text_return);

	/*
	 * set the literal of the selection to the text contents.
         * if it is an expression, the expression will be evaluated
         * before the integer value is set (in kvf_set_literal)
	 */
	if (!(xvf_set_attribute(selection->back_kformstruct, XVF_LITERAL, 
			        text_contents)))
	    return(FALSE);

	kfree(text_contents);
	return(TRUE);
}

/*------------------------------------------------------------
|
|  Routine Name: xvf_update_form_tree
|
|       Purpose: Marks the associated control as selected
|         Input: selection - pointer to the selection selection structure
|        Output: none
|          Date: Mar 24, 1992
|    Written By: Danielle Argiro
| Modifications: Converted from Khoros 1.0 (DA)
|
------------------------------------------------------------*/
	  
void xvf_update_form_tree(
   kselection *selection)
{
	Line_Info line_info;

	/* 
	 * mark associated master, guidepane, or pane as selected 
	 */
	kvf_clear_line_info(&line_info);
	kvf_gen_parse(selection->back_control->control_line, &line_info);
	line_info.selected = TRUE;
	kvf_gen_deparse(&line_info, &selection->back_control->control_line);
	kvf_free_line_info_strings(&line_info);
}
