/*
 * Khoros: $Id$
 */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

/*
 * $Log$
 */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>	      Routines to Clear the Form Tree                 <<<<
   >>>>                                                       <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>   Static:                                             <<<<
   >>>>            xvf_clear_subform()                        <<<<
   >>>>            xvf_clear_sel_list()                       <<<<
   >>>>   Public:                                             <<<<
   >>>>            xvf_clear_selections()                     <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< */

#include "internals.h"


static void xvf_clear_subform  PROTO((ksubform *));
static void xvf_clear_sel_list PROTO((kselection *));

/************************************************************
*
*  Routine Name: xvf_clear_selections - reset GUI items of xvroutine
*
*       Purpose: Resets all action buttons and "live" selections 
*                on the GUI, so that they are not considered "selected" 
*                by the user.  The necessary call to this routine is 
*                automatically generated by conductor in the main
*                GUI driver of an xvroutine, located in "form_drv.c".
*
*         Input: form - pointer to the form tree associated with the
*                       GUI to be cleared.
*        Output: 
*       Returns:
*  Restrictions:
*    Written By: Danielle Argiro
*          Date: Jul 16, 1992 
*      Verified: 
*  Side Effects:
* Modifications:
*
************************************************************/

void xvf_clear_selections(
   kform *form)
{
	ksubform *subform;

	if (form->master != NULL)
	{
	     subform = form->master->subform_list;
	     while (subform != NULL)
	     {
	         xvf_clear_subform(subform);
	         subform = subform->next;
	     }
	     xvf_clear_sel_list(form->master->sel_list);
	}
	else
	    xvf_clear_subform(form->subform);
	  
}

/*-----------------------------------------------------------
|
|  Routine Name: xvf_clear_subform
|
|       Purpose: Resets all selections on a subform, so that they
|                are no longer considered "selected".
|
|         Input: subform - pointer to the subform
|        Output: none
|          Date: May 26, 1992
|    Written By: Danielle Argiro
| Modifications:
|
-----------------------------------------------------------*/

static void xvf_clear_subform(
   ksubform *subform)
{
	kguide *guide;

	if  (subform->guidepane != NULL)
	{
	    guide = subform->guidepane->guide_list;
	    while (guide != NULL) 
	    {
	        if (guide->pane != NULL)
                {
	    	    xvf_clear_sel_list(guide->pane->sel_list);
	        }
		guide = guide->next;
	    }
	    xvf_clear_sel_list(subform->guidepane->sel_list);
	}
	else
	{
	    if ((subform->guide != NULL) && 
	        (subform->guide->pane != NULL))
	    	xvf_clear_sel_list(subform->guide->pane->sel_list);
	}

}

/*-----------------------------------------------------------
|
|  Routine Name: xvf_clear_sel_list
|
|       Purpose: Resets all selections in a selection list, so that they
|                are no longer considered "selected".
|
|         Input: selection - header of the selection list
|        Output: none
|          Date: May 26, 1992
|    Written By: Danielle Argiro
| Modifications:
|
-----------------------------------------------------------*/

static void xvf_clear_sel_list(
   kselection *selection)
{
	Line_Info line_info;

	/*
 	 *  Go thru all selections, clearing UIS lines 
 	 */
	kvf_clear_line_info(&line_info);
        while (selection != NULL) 
        {
	    if ((selection->selected) && 
		(selection->group_next == NULL))
	    {
		kvf_set_attribute(selection->back_kformstruct, 
				  KVF_SELECTED,  FALSE);
	    }
	    if (selection->group_next != NULL)
                xvf_clear_sel_list(selection->group_next);
	    selection->modified = FALSE;
	    selection = selection->next;
	}
}
