 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */ 

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>                                                       <<<<
   >>>>             Athena XVObject Creation                  <<<<
   >>>>                                                       <<<<
   >>>>  Private:                                             <<<<
   >>>>   Static:                                             <<<<
   >>>>   Public:                                             <<<<
   >>>>                xvw_initialize()  		      <<<<
   >>>>                                                       <<<<
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  */


#include "internals.h"

#ifdef KATHENA_DEF

#if XtSpecificationRelease == 4
#include <X11/Xaw/Scrollbar.h>
#endif

/*------------------------------------------------------------
|
|  Routine Name: xvw_initialize()
|
|       Purpose: initializes the xvwidget library to use the Athena widget
|		 set.
|
|         Input: menu_handler - the general menu handling routines one of:
|
|                ! XVW_MENUS_XVFORMS -  Enable the use of xvforms as internal
|                !                      menus
|                ! XVW_MENUS_NONE    -  Disable internal menus
|
|        Output: none
|       Returns: the newly initialize display structure or NULL upon failure
|    Written By: Mark Young and Danielle Argiro
|          Date: Jun 17, 1993
| Modifications:
|
------------------------------------------------------------------*/

Display *xvw_initialize(
   kfunc_void menu_handler)
{
	Display *display;
	char    *tbname, *program, path[KLENGTH], toolbox[KLENGTH];

	display = xvw_init_display(menu_handler);
	xvw_load_resources("$DESIGN/objects/library/Athena/app-defaults/Athena");
	if ((program = kprog_get_program()) != NULL &&
	    (tbname = kprog_get_toolbox())  != NULL)
	{
	   kstring_upper(tbname, toolbox);
	   ksprintf(path, "$%s/objects/xvroutine/%s/app-defaults/%s",
			toolbox, program, program);
           xvw_load_resources(path);
	}

#if XtSpecificationRelease == 4
	XtInitializeWidgetClass(labelWidgetClass);
	XtInitializeWidgetClass(smeLineObjectClass);
	XtInitializeWidgetClass(scrollbarWidgetClass);
	xvw_init_converters();
#endif
	return(display);
}

#else
/*
 * These are dummy function calls so that if the widget set is not supported
 * on the machine a message is printed out.
 */

/* ARGSUSED */
Display *xvw_initialize(
   kfunc_void menu_handler)
{
	kfprintf(kstderr,"\nThe Athena widget set is either not supported for \
this machine or was not\ncompiled in by the installer of Khoros.  Please \
contact the person who installed Khoros for your site and have them enable \
Athena.\n\n");
	return(NULL);
}

#endif /* KATHENA_DEF */
/* Don't add after the endif */
