 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: attribute definitions
   >>>>		       for general character xvobject geometry
   >>>>
   >>>>     Written By: Mark Young & Danielle Argiro & John Salas
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvwidgets_GenCharGeometry_h_
#define _xvwidgets_GenCharGeometry_h_


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute	XVW_CHAR_WIDTH
| Description:	The width of the object in characters.
| Type:		float
| Default:	calculated
| Legal Values:	values > 0.0
| Resource:	charWidth
------------------------------------------------------------------------*/
#define XVW_CHAR_WIDTH 		"charWidth"

/*------------------------------------------------------------------------
| Attribute:	XVW_CHAR_HEIGHT
| Description:	The height of the object in characters.
| Type:		float
| Default:	calculated
| Legal Values:	values > 0.0
| Resource:	charHeight
------------------------------------------------------------------------*/
#define XVW_CHAR_HEIGHT 	"charHeight"

/*------------------------------------------------------------------------
| Attribute:	XVW_CHAR_MIN_WIDTH
| Description:	The minimum width of the object in characters.
| Type:		float
| Default:	calculated
| Legal Values:	values > 0.0
| Resource:	charMinWidth
------------------------------------------------------------------------*/
#define XVW_CHAR_MIN_WIDTH 	"charMinWidth"

/*------------------------------------------------------------------------
| Attribute:	XVW_CHAR_MIN_HEIGHT
| Description:	The minimum height of the object in characters.
| Type:		float
| Default:	calculated
| Legal Values:	values > 0.0
| Resource:	charMinHeight
------------------------------------------------------------------------*/
#define XVW_CHAR_MIN_HEIGHT 	"charMinHeight"

/*------------------------------------------------------------------------
| Attribute:	XVW_CHAR_MAX_WIDTH
| Description:	The maximum width of the object in characters.
| Type:		float
| Default:	calculated
| Legal Values:	values > 0.0
| Resource:	charMaxWidth
------------------------------------------------------------------------*/
#define XVW_CHAR_MAX_WIDTH 	"charMaxWidth"

/*------------------------------------------------------------------------
| Attribute:	XVW_CHAR_MAX_HEIGHT
| Description:	The maximum height of the object in characters.
| Type:		float
| Default:	calculated
| Legal Values:	values > 0.0
| Resource:	charMaxHeight
------------------------------------------------------------------------*/
#define XVW_CHAR_MAX_HEIGHT 	"charMaxHeight"

/*------------------------------------------------------------------------
| Attribute:	XVW_CHAR_XPOS
| Description:	The X position in characters, with respect to the 
|		upper left hand corner of the parent.
| Type:		float
| Default:	0.0
| Legal Values:	values >= 0.0
| Resource:	charXpos
------------------------------------------------------------------------*/
#define XVW_CHAR_XPOS		"charXpos"

/*------------------------------------------------------------------------
| Attribute:	XVW_CHAR_YPOS
| Description:	The Y position in characters, with respect to the 
|		upper left hand corner of the parent.
| Type:		float
| Default:	0.0
| Legal Values:	values >= 0.0
| Resource:	charYpos
------------------------------------------------------------------------*/
#define XVW_CHAR_YPOS		"charYpos"

#endif /* _xvwidgets_GenCharGeometry_h_ */
/* Don't add after this point */
