 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of  TextInput Widget
   >>>>
   >>>>    Written By: Mark Young and Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_TextInput_h_
#define _xvobjects_TextInput_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTINPUT_CRLABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               pixmap object component of the the textinput object that
|               indicates a "live" selection.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The pixmap object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTINPUT_CRLABEL_OBJECT	"textinputCrlabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTINPUT_LABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               label object component of the the textinput object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The label object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTINPUT_LABEL_OBJECT	"textinputLabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTINPUT_TEXT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               text object component of the the textinput object.
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The text object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTINPUT_TEXT_OBJECT	"textinputTextObject"


/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTINPUT_TEXT
| Description:  This is the text that appears in the textinput object. 
| Type:         char * 
| Default:      NULL 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTINPUT_TEXT		"textinputTextObject.textString"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTINPUT_LABEL
| Description:  This is the label that appears on the label object
|		component of the textinput object. 
| Type:         char * 
| Default:       
| Legal Values:  
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTINPUT_LABEL		"textinputLabelObject.label"

/*------------------------------------------------------------------------
| Attribute:	XVW_TEXTINPUT_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the textinput object which will be fired when
|               the user enters new text and presses <cr>.
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(textinputobj, XVW_TEXTINPUT_CALLBACK,
|                                textinput_cb, client_data);
|               .end code
|               Note that the current text appearing in the textinput object 
|		will be passed to the callback in the \fIcall_data\fP.  The 
|		value must be cast to a string before use, as in:
|               .br
|               \f(CWchar *string = *((char **) call_data);\fP
|               .br
|               Alternatively, the filename may be obtained with
|               .symbol index XVW_TEXTINPUT_TEXT .
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_TEXTINPUT_CALLBACK		"textinputCallback"


/*
 *  Define the Class name, by which people should be externally referencing
 *  the TextInput Object by.
 */
#define TextInputWidgetClass	xvwTextInputWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration TextInputWidgetClass
 */
extern   WidgetClass     TextInputWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for TextInput Object
 */
xvobject xvw_create_textinput PROTO((xvobject, char *));


#endif /* _xvobjects_TextInput_h_ */
/* Do not add after this line */
