 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of the Pixmap object
   >>>>
   >>>>    Written By: Mark Young & Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Pixmap_h_
#define _xvobjects_Pixmap_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:	XVW_PIXMAP_FILENAME
|
| Description:  This is the name of the file defining the pixmap. 
|
| Type:         char *
| Default:      NULL
| Legal Values: The full path to a valid xpm or xbm file, defining
|               the desired pixmap.  Note that the path may contain
|               $TOOLBOX.
| Resource:	pixmapFilename
------------------------------------------------------------------------*/
#define XVW_PIXMAP_FILENAME	 	"pixmapFilename"

/*------------------------------------------------------------------------
| Attribute:	XVW_PIXMAP_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the pixmap object which will be fired when the 
|		user clicks on it. When calling \fIxvw_add_callback()\fP, 
|		pass this attribute directly, as in
|               .begin code
|               xvw_add_callback(pixmapobj, XVW_PIXMAP_CALLBACK,
|                                pixmap_cb, client_data);
|               .end code
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PIXMAP_CALLBACK	 	"pixmapCallback"

/*------------------------------------------------------------------------
| Attribute:	XVW_PIXMAP_MASK
|
| Description:  Pixmaps are defined by a rectangular grid of values.  For 
|		implementing non-rectangular pixmaps, a bitmap is used to 
|		indicate which portions of the rectangular pixmap should 
|		appear, and which portions should not be displayed. This 
|		bitmap is referred to as a \fImask\fP.  The bitmap must be 
|		defined in an xbm file, and the bitmap should be of the same 
|		size as the pixmap being displayed.  Anywhere a 1 appears in 
|		the bitmap, the value of the pixmap at that point is displayed; 
|		anywhere a 0 appears in the bitmap, the value of the pixmap 
|		at that point will not be displayed.  Thus, a circular pixmap
|		can be implemented with a pixmap/bitmap mask pair:  the pixmap
|		will define the picture in the circle, while the bitmap mask
|		has all 1's within the boundaries of the circle, and all 0's
|		outside the circle bounds.
|
|               Candidates for the bitmap may be created with 
|               \fIXCreateBitmapFromData()\fP;  see \fIThe Xlib Reference 
|		Manual\fP by O'Reilly and Associates.  Note that this 
|		attribute is
|               mutually exclusive with
|               .symbol index XVW_PIXMAP_MASKNAME ;
|               specify one or the other, not both.
|
| Type:         Pixmap
| Default:      NULL
| Legal Values: Valid Pixmap structure
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PIXMAP_MASK	 		"pixmapMask"

/*------------------------------------------------------------------------
| Attribute:	XVW_PIXMAP_MASKNAME
| Description:  This is the file defining the bitmap mask used with
|		non-rectangular pixmaps;  see 
|		.symbol index XVW_PIXMAP_MASK
|		for more details. 
| Type:         char *
| Default:      NULL
| Legal Values: The full path to the xbm file defining the mask;
|		Note that the path may contain $TOOLBOX.
| Resource:	pixmapMaskname
------------------------------------------------------------------------*/
#define XVW_PIXMAP_MASKNAME		"pixmapMaskname"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Pixmap Object by.
 */
#define PixmapGadgetClass	xvwPixmapGadgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration PixmapGadgetClass
 */
extern   WidgetClass     PixmapGadgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Khoros Function Definition for Pixmap Object
 */
xvobject xvw_create_pixmap PROTO((xvobject, char *));


#endif /* _xvobjects_Pixmap_h_ */
/* Don't add after this point */
