 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions of attributes that control
   >>>>                the type & amount of direct manipulation
   >>>>                that is enabled on an object, if any   
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_ManagerManip_h_
#define _xvobjects_ManagerManip_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_EDIT_MODE_ON
|
| Description:  This attribute allows the application to control whether or 
|		not a visual object is in \fIedit mode\fP.  When the visual
|		object is in "edit mode", it will usually display a grid
|		where each square is 1/2 character width by 1/2 character 
|		height.  Once an object is in edit mode, it will allow the
|		user to select, resize, and move its children (provided
|		that the children have
|		.symbol index XVW_SELECTABLE 
|		and
|		.symbol index XVW_RESIZABLE
|		set to TRUE, respectively. 
|
|		Note that the user can put a visual object in edit mode
|		by doing a "meta-click", ie, by holding down the "meta" key 
|		(the key which acts as "meta" on a keyboard will depend on 
|		the keyboard mapping -- most common are "Alt", "Compose", 
|		"Ctrl", and "Shift"), and simultaneously clicking the left 
|		mouse button on the visual object. 
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     editModeOn
------------------------------------------------------------------------*/
#define XVW_EDIT_MODE_ON        "editModeOn"

/*------------------------------------------------------------------------
| Attribute:    XVW_SELECTABLE
|
| Description:	If TRUE, will allow the user to select the object when the
|		parent is in \fIedit mode\fP.  When an item is selected, it 
|		will be "bracketed".  A \fIselect list\fP is kept; 
|		this is a list of all the children that are selected at any
|		given time.  The application may inquire which children are 
|		selected at any given time by using the 
|		.symbol index XVW_XVW_SELECTIONS
|		attribute.  Note that the manager object will allow selected 
|		objects to be moved by the user.
|
| Type:		int
| Default:	FALSE
| Legal Values: TRUE/FALSE
| Resource:     selectable
------------------------------------------------------------------------*/
#define XVW_SELECTABLE          "selectable"

/*------------------------------------------------------------------------
| Attribute:    XVW_RESIZABLE
|
| Description:  If TRUE, this attribute will allow the user to interactively
|		resize the object after selecting it, when the parent is in
|		\fIedit mode\fP .
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     resizable
------------------------------------------------------------------------*/
#define XVW_RESIZABLE           "resizable"


/*------------------------------------------------------------------------
| Attribute:    XVW_SELECT_REPLACE
|
| Description:  This \fIaction attribute\fP allows the application to
|		un-select any currently selected children of the parent
|		of the specified object, and instead force the specified
|		object to be the one that is selected.  This causes the previous
|		\fIselect list\fP to be replaced with a list of size 1,
|		containing only the object specified.
|
| Type:         xvobject
| Default:      N/A
| Legal Values: Visual objects that have
|		.symbol index XVW_SELECTABLE
|		set to true, and a parent currently in \fIedit mode\fP.
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_SELECT_REPLACE      "selectReplace"

/*------------------------------------------------------------------------
| Attribute:    XVW_SELECT_ADD
|
| Description:  This \fIaction attribute\fP causes the specified object
|		to be selected, and adds it to the \fIselect list\fP of
|		the parent.
|
| Type:         xvobject
| Default:      N/A
| Legal Values: Visual objects that have
|               .symbol index XVW_SELECTABLE
|               set to true, and a parent currently in \fIedit mode\fP.
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_SELECT_ADD          "selectAdd"

/*------------------------------------------------------------------------
| Attribute:    XVW_SELECT_ADD_ALL
|
| Description:  This \fIaction attribute\fP takes \fIall\fP children
|		of the object on which the attribute is set, and selects
|		them.  All the children are added to the \fIselect list\fP
|		of the object on which the attribute is set.
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_SELECT_ADD_ALL      "selectAddAll"

/*------------------------------------------------------------------------
| Attribute:    XVW_SELECT_DELETE
|
| Description:  This \fIaction attribute\fP causes the specified object
|               to be un-selected, and deletes it from the \fIselect list\fP of
|               the parent.
|
| Type:         xvobject
| Default:	N/A
| Legal Values: Visual objects that have
|               .symbol index XVW_SELECTABLE
|               set to true, and a parent currently in \fIedit mode\fP.
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_SELECT_DELETE       "selectDelete"

/*------------------------------------------------------------------------
| Attribute:    XVW_SELECT_DELETE_ALL
|
| Description:  This \fIaction attribute\fP takes \fIall selected children\fP
|               of the object on which the attribute is set, and un-selects
|               them.  All the previously selected children are deleted from 
|		the \fIselect list\fP of the object of which the attribute 
|		is set.
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_SELECT_DELETE_ALL   "selectDeleteAll"

/*------------------------------------------------------------------------
| Attribute:    XVW_GROUP_ADD
|
| Description:  This \fIaction attribute\fP causes the specified object
|		to be added into the child's \fIgroup list\fP.  The object
|		will then be selected when the child is selected.
|
| Type:         xvobject
| Default:      N/A
| Legal Values: Visual objects that have
|               .symbol index XVW_SELECTABLE
|               set to true
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GROUP_ADD          "groupAdd"

/*------------------------------------------------------------------------
| Attribute:    XVW_GROUP_DELETE
|
| Description:  This \fIaction attribute\fP causes the specified object
|               to be deleted from the child's \fIgroup list\fP.  The object
|               will then no longer be selected when the child is selected.
|
| Type:         xvobject
| Default:	N/A
| Legal Values: Visual objects that have
|               .symbol index XVW_SELECTABLE
|               set to true, and a parent currently in \fIedit mode\fP.
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GROUP_DELETE       "groupDelete"

/*------------------------------------------------------------------------
| Attribute:    XVW_GROUP_DELETE_ALL
|
| Description:  This \fIaction attribute\fP causes the child's
|               entire \fIgroup list\fP to be deleted.  All the previously
|		grouped siblings are deleted from the \fIgroup list\fP of
|		the object of which the attribute is set.
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GROUP_DELETE_ALL   "groupDeleteAll"

/*------------------------------------------------------------------------
| Attribute:    XVW_SELECT_CALLBACK
|
| Description:	If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the visual object which will be
|               fired when the user selects it.
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(visualobj, XVW_SELECT_CALLBACK,
|                                callback_function, client_data);
|               .end code
|
|		Note that in order to allow the user to select the object, the
|		.symbol index XVW_SELECTABLE
|		attribute must be set to TRUE on the visual object, and
|		its parent must be in edit mode.
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_SELECT_CALLBACK     "selectCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_GEOMETRY_CALLBACK
|
| Description:	If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the visual object which will be
|               fired when the user resizes or moves the object.
|               When calling \fIxvw_add_callback()\fP, pass this attribute
|               directly, as in
|               .begin code
|               xvw_add_callback(visualobj, XVW_GEOMETRY_CALLBACK,
|                                callback_function, client_data);
|               .end code
|
|		Note that in order to allow the user to resize the object, the
|               .symbol index XVW_RESIZABLE
|               attribute must be set to TRUE;  to be moved, the 
|		.symbol index XVW_SELECTABLE
|		attribute must be set to TRUE.
|		Inside the callback, the new width, height, x and y position
|		of the visual object may be obtained using pixel geometry
|		attributes or character geometry attributes.
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_GEOMETRY_CALLBACK   "geometryCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_SELECTIONS
|
| Description: 	This \fIread only\fP attribute only applies to 
|		\fIconstraint\fP objects, such as manager objects, canvas 
|		objects, rowcol objects, and so on, that support layout and 
|		direct manipulation of children. If the 
|		.symbol index XVW_SELECTABLE
|		attribute is TRUE, the user will be allowed to interactively
|		select child objects of the specified object.  Selected 
|		objects will be "bracketed" on all four corners to indicate
|		that they are currently selected.  The
|		.symbol index XVW_SELECTIONS
|		attribute may be used to obtain an array of the currently
|		selected child objects of the object specified.
|
| Type:         xvobject * 
| Default:      NULL
| Legal Values: array of xvobjects that are currently selected
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_SELECTIONS          "selections"

/*------------------------------------------------------------------------
| Attribute:    XVW_NUM_SELECTIONS
|
| Description:  This  \fIread only\fP attribute is used in conjunction with
|               .symbol index XVW_SELECTIONS ;
|               it returns the number of selected children in the 
|		object specified.

| Type:         int
| Default:      N/A
| Legal Values: number of selected children (values >= 0)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_NUM_SELECTIONS      "numSelections"

/*------------------------------------------------------------------------
| Attribute:    XVW_MENUABLE
|
| Description:  If TRUE, will allow the user to bring up an internal 
|		menuform for the object.  Note that the *.pane file 
|		describing the internal menuform for the object must
|		be specified using
|		.symbol index XVW_MENU_FORM .
| Type:		int
| Default:	FALSE
| Legal Values: TRUE/FALSE
| Resource:    	menuable
------------------------------------------------------------------------*/
#define XVW_MENUABLE            "menuable"

/*------------------------------------------------------------------------
| Attribute:    XVW_MENU_FORM
|
| Description:  This attribute defines the internal menuform associated
|		with a visual object.  The menuform should include selections
|		appropriate for each attribute that can be interactively
|		set by the user.  Variable names must be equal to the
|               resource names.
|
| Type:         kaddr
| Default:      NULL
| Legal Values: valid internal menuform structure
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_MENU_FORM           "menuForm"

/*------------------------------------------------------------------------
| Attribute:    XVW_MENU_FORMFILE
|
| Description:  This attribute defines the *.pane file which defines
|               the internal menuform of a visual object.  The *.pane
|               file defining the menuform should include selections
|               appropriate for each attribute that can be interactively
|               set by the user.  Variable names must be equal to the
|               resource names.
|
| Type:         char *
| Default:      NULL
| Legal Values: valid path to *.pane file defining internal menuform.
|               Use of $TOOLBOX is encouraged.
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_MENU_FORMFILE        "menuFormfile"

/*------------------------------------------------------------------------
| Attribute:    XVW_MENU_CLIENTDATA
|
| Description:  When \fIxvw_define_attribute\fP is used to define additional
|               attributes of objects, this is the client data that is 
|               sent to the \fIset\fP and \fIget\fP routines.
|
| Type:         kaddr
| Default:      NULL
| Legal Values: pointer to the client data
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_MENU_CLIENTDATA     "menuClientdata"

/*------------------------------------------------------------------------
| Attribute:    XVW_CANVAS_GRID
|
| Description:  This attribute indicates when a grid should be displayed on
|               the canvas.
|               .symbol index KMANAGER_GRID_OFF
|               specifies that the grid is always off.
|               .symbol index KMANAGER_GRID_ON
|               specifies that the grid is always on.
|               .symbol index KMANAGER_GRID_EDIT
|               specifies that the grid is only on when the canvas is in
|               "edit mode".  The canvas can be put in edit mode by the user,
|               or through the application by setting the manager object
|               attribute
|               .symbol index XVW_EDIT_MODE_ON
|               to TRUE.
|               .symbol index KMANAGER_GRID_SELECT
|               specifies that the grid is only displayed when a child of the
|               canvas has been selected by the user, or through the
|               application by setting the manager object attribute
|               .symbol index XVW_SELECT_ADD
|               to TRUE.
|
| Type:         int
| Default:      .symbol index KMANAGER_GRID_ON
| Legal Values: .symbol index KMANAGER_GRID_OFF
|               .symbol index KMANAGER_GRID_ON
|               .symbol index KMANAGER_GRID_EDIT
|               .symbol index KMANAGER_GRID_SELECT
| Resource:     canvasGrid
------------------------------------------------------------------------*/
#define XVW_CANVAS_GRID         "canvasGrid"

#define KMANAGER_GRID_OFF      0
#define KMANAGER_GRID_ON       1
#define KMANAGER_GRID_EDIT     2
#define KMANAGER_GRID_SELECT   3

/*------------------------------------------------------------------------
| Attribute:     XVW_CANVAS_GRIDSIZE
| Description:   The dimensions of the grid, given in pixels.
| Type:          int
| Default:       15
| Legal Values:  value > 0
| Resource:      canvasGridsize
------------------------------------------------------------------------*/
#define XVW_CANVAS_GRIDSIZE     "canvasGridsize"

/*------------------------------------------------------------------------
| Attribute:    XVW_XSNAP
|
| Description:  This attribute only applies to \fIconstraint\fP objects,
|               such as manager objects, canvas objects, rowcol objects,
|               and so on, that support layout and direct manipulation of
|               children. With interactive movement of selected child objects,
|               the child objects can be made to "snap" to the new position,
|               aiding the user in more precise interactive layout of objects.
|               This attribute specifies, in pixels, the horizontal 
|               increments of the implied grid (visible or not) to which 
|               children will "snap".  For example, if 
|               .symbol index XVW_XSNAP
|               is set to 15, then objects will "snap" to positions in
|               15-pixel increments.
|
| Type:         int
| Default:      10
| Legal Values: values > 0
| Resource:     Xsnap
------------------------------------------------------------------------*/
#define XVW_XSNAP                       "Xsnap"

/*------------------------------------------------------------------------
| Attribute:    XVW_YSNAP
|
| Description:  This attribute only applies to \fIconstraint\fP objects,
|               such as manager objects, canvas objects, rowcol objects,
|               and so on, that support layout and direct manipulation of
|               children. With interactive movement of selected child objects,
|               the child objects can be made to "snap" to the new position,
|               aiding the user in more precise interactive layout of objects.
|               This attribute specifies, in pixels, the vertical 
|               increments of the implied grid (visible or not) to which 
|               children will "snap".  For example, if 
|               .symbol index XVW_YSNAP
|               is set to 20, then objects will "snap" to positions in
|               20-pixel increments.
|
| Type:         int
| Default:      10
| Legal Values: values > 0
| Resource:     Ysnap
------------------------------------------------------------------------*/
#define XVW_YSNAP                       "Ysnap"

/*------------------------------------------------------------------------
| Attribute:    XVW_CHILDREN
|
| Description:  This \fIread only\fP attribute allows you to obtain an array
|		of the \fIWidgets\fP representing the children of the specified
|		object.  The fact that this attribute returns Widgets rather
|		than xvobjects represents an inconsistency;  however, due
|		to internal limitations, the children must be returned as
|		Widgets at this time. Note that a Widget may always be 
|		converted to an xvobject with the use of \fIxvw_object()\fP.
|
| Type:         Widget *
| Default:      N/A
| Legal Values: Widget array of the children of the specified object.
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_CHILDREN            "children"

/*------------------------------------------------------------------------
| Attribute:    XVW_NUM_CHILDREN
|
| Description:  This  \fIread only\fP attribute is used in conjunction with
|		.symbol index XVW_CHILDREN ;
|		it returns the number of children of the object specified.
|		
| Type:         int
| Default:      N/A
| Legal Values: number of children (values >= 0) of the specified object.
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_NUM_CHILDREN        "numChildren"


#endif /* _xvobjects_ManagerManip_h_ */
/* Do not add after this line */
