 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attributes of Error Object
   >>>>
   >>>>    Written By: Mark Young, Danielle Argiro
   >>>>
   >>>>          Date: Aug 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvobjects_Error_h_
#define _xvobjects_Error_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:	XVW_ERROR_LABEL_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               label object component of the error object (the
|		object used to display the label).
|
| Type:         xvobject
| Default:      NULL
| Legal Values: The label object (read-only).
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_ERROR_LABEL_OBJECT   "errorLabelObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_ERROR_BUTTON_OBJECT
|
| Description:	This \fIread-only\fP attribute allows you to obtain the
|		the button object component of the error object (the button
|		used to allow the user to acknowledge the error message).
|
| Type:		xvobject
| Default:	NULL
| Legal Values:	The button object (read-only)
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_ERROR_BUTTON_OBJECT  "errorButtonObject"

/*------------------------------------------------------------------------
| Attribute:	XVW_ERROR_TEXT_OBJECT
|
| Description:  This \fIread-only\fP attribute allows you to obtain the
|               the text object component of the error object (the text
|		displaying the error message).
|
| Type:		xvobject
| Default:	NULL
| Legal Values:	The text object (read-only)
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_ERROR_TEXT_OBJECT    "errorTextObject"


/*------------------------------------------------------------------------
| Attribute:    XVW_ERROR_MESSAGE
| Description:  The error message to be displayed in the error object.
| Type:  	char *       
| Default:      NULL
| Legal Values: any printable text
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_ERROR_MESSAGE	"errorTextObject.textString"

/*------------------------------------------------------------------------
| Attribute:	XVW_ERROR_LABEL
| Description:  The label for the error object.
| Type:         char * 
| Default:      NULL 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_ERROR_LABEL		"errorLabelObject.label"

/*------------------------------------------------------------------------
| Attribute:    XVW_ERROR_BUTTON_LABEL
| Description:  The label for the acknowledgment button. 
| Type:         char * 
| Default:      "Ok" 
| Legal Values: any printable text 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_ERROR_BUTTON_LABEL	"errorButtonObject.label"

/*------------------------------------------------------------------------
| Attribute:    XVW_ERROR_CALLBACK
|
| Description:  If desired, \fIxvw_add_callback()\fP may be used to install
|               a callback on the error object which will be 
|		fired when the user clicks on the acknowledgement button.  
|		When calling \fIxvw_add_callback()\fP, pass this attribute 
|		directly, as in
|               .begin code
|               xvw_add_callback(errorobj, XVW_ERROR_CALLBACK,
|                                error_cb, client_data);
|               .end code
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|		.begin code
|		void callback_function
|		   xvobject object,
|		   kaddr client_data,
|		   kaddr call_data)
|		.end code
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_ERROR_CALLBACK	"errorCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_ERROR_PIXMAPFILE
|
| Description:  This is the file defining the pixmap that appears at the 
|		upper left of the error object. 
|
| Type:         char *
| Default:      The stopsign.xpm file in the \fIxvobjects/misc/pixmaps\fP 
|		directory, which defines the "stop sign" pixmap.
| Legal Values: The full path to a valid xpm or xbm file, defining
|		the desired pixmap.  Note that the path may contain
|		$TOOLBOX. 
| Resource:	errorPixmapfile
------------------------------------------------------------------------*/
#define XVW_ERROR_PIXMAPFILE	"errorPixmapfile"

/*------------------------------------------------------------------------
| Attribute:    XVW_ERROR_PIXMAP
|
| Description:  This is the pixmap that appears to the upper 
|		left of the error object.  Candidates for the value
|		of this attribute may be created with the use
|		of \fIXCreatePixmap()\fP;  see \fIThe Xlib Reference Manual\fP
|		by O'Reilly and Associates.  Note that this attribute is
|               mutually exclusive with
|               .symbol index XVW_ERROR_PIXMAPFILE ;
|               specify one or the other, not both.
|
| Type:         Pixmap
| Default:      The "stop sign" pixmap.
| Legal Values: Valid Pixmap structure
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_ERROR_PIXMAP	"errorPixmap"


/*
 *  Define the Class name, by which people should be externally referencing
 *  the Error Object by.
 */
#define ErrorWidgetClass	xvwErrorWidgetClass

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration ErrorWidgetClass
 */
extern   WidgetClass     ErrorWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Error Object
 */
xvobject xvw_create_error PROTO((xvobject, char *));


#endif /* _xvobjects_Error_h_ */
/* Do not add after this line */
