 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions for Khoros Workspace Widget
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Aug 28, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_Workspace_h_
#define _xvlang_Workspace_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_INHERIT
| Description:  Procedures that are created from the top level workspace can
|		have their own local attributes, or can inherit their
|		attributes from the parent workspace.  This attribute is
|		made inactive on the toplevel parent.  This attribute may
|		be set to true or false.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	workspaceInherit
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_INHERIT		"workspaceInherit"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_SHOW_CLIPBOARD
| Description:  The clipboard is used to hold cut or copied items for later
|               pasting.  This this action attribute may be used to map or
|		unmap the clipboard workspace.
| Type:         int
| Default:      N/A (read-only)
| Legal Values: TRUE/FALSE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_SHOW_CLIPBOARD    "workspaceShowClipboard"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_PARALLEL
| Description:  When a workspace contains several independant networks,
|		turning parallel execution to 'true' makes the workspace
|		execute quicker, as each of the independant networks will
|		execute simulataneously.  This attribute may be set to true
|		or false.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	workspaceParallel
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_PARALLEL		"workspaceParallel"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_RESPONSIVE
| Description:  When a workspace is put into 'responsive' mode then the
|		workspace schedules glyphs such that scheduling of a
|		network is continually done.  When a workspace is running
|		then the scheduler will continously monitor the network
|		and run glyphs as they become modified.  If the workspace
|		is not running then the scheduler is turned off.  By turning
|		.symbol index XVW_WORKSPACE_RESPONSIVE
|		to FALSE the scheduler is always turned off.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	workspaceResponsive
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_RESPONSIVE	"workspaceResponsive"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_VARIABLES
| Description:  Variables and expressions can be local to a procedure or
|		global to the entire workspace. Setting 'Use Global
|		Variables' to 'false' will cause the variables to only be
|		known within the local procedure or workspace; setting
!		 'Use Global Variables' to 'true' will make them globally
|		available to all workspaces. This attribute may be set to
|		.symbol index KWORKSPACE_VARIABLES_GLOBAL
|		or
|		.symbol index KWORKSPACE_VARIABLES_LOCAL
| Type:         int
| Default:      .symbol index KWORKSPACE_VARIABLES_GLOBAL
| Legal Values: .symbol index KWORKSPACE_VARIABLES_GLOBAL
|		.symbol index KWORKSPACE_VARIABLES_LOCAL
| Resource:	workspaceVariables
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_VARIABLES		"workspaceVariables"

/*
 *  Defines for the scope for the workspace variables in which the workspace
 *  define the heirarchy in which kexpr will search for variables.
 */
#define KWORKSPACE_VARIABLES_GLOBAL  1
#define KWORKSPACE_VARIABLES_LOCAL   2

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_RUN
| Description:  After a network is constructed, this action attribute
|		may be used to execute or stop the entire network.
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_RUN		"workspaceRun"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_STEP
| Description:  After a network is constructed, this action attribute
|		may be used to single step execute a network.
| Type:         int
| Default:      N/A (read-only)
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_STEP		"workspaceStep"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_RESET
| Description:  After a network is constructed, this action attribute
|               may be used to "touch" all glyphs in the workspace so
|               that RUN will re-execute ALL glyphs, whether or not they
|	        have been modified.
| Type:         int
| Default:      N/A (read-only)
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_RESET		"workspaceReset"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_REDRAW
| Description:  This action attribute is used to force a redisplay of the
| Type:         int 
| Default:      N/A (read-only) 
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_REDRAW		"workspaceRedraw"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_CLEAR
| Description:  After a network is constructed, this action attribute
|               may be used to "clear" all glyphs in the workspace so
|               that the workspace is empty.
| Type:         int 
| Default:      N/A (read-only)
| Legal Values: TRUE 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_CLEAR		"workspaceClear"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_CHECK
| Description:  After a network is constructed, this action attribute
|               may be used to "check" that all glyphs in the workspace have
|               their required inputs and outputs specified.
| Type:         int
| Default:      N/A (read-only) 
| Legal Values: TRUE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_CHECK		"workspaceCheck"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_INFO
| Description:  After a network is constructed, this action attribute
|               may be used to display "information" on all glyphs can
|		be displayed.
| Type:         int 
| Default:      N/A 
| Legal Values: TRUE 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_INFO		"workspaceInfo"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_SAVE
| Description:  After a network is constructed, this action attribute
|               may be used to "save" the workspace to the specified
|		filename.  Only the selected glyphs will be saved.  If
|		no glyphs are selected then all glyphs are then saved.
| Type:         char *
| Default:      N/A
| Legal Values: any legal filename
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_SAVE		"workspaceSave"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_SAVEALL
| Description:  After a network is constructed, this action attribute
|               may be used to "save" the workspace to the specified
|		filename.  This differs from the
|		.symbol index XVW_WORKSPACE_SAVE
|		attribute since it saves all glyphs, irregardless if they
|		are selected or not.
| Type:         char *
| Default:      N/A
| Legal Values: any legal filename
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_SAVEALL		"workspaceSaveall"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_RESTORE
| Description:  This action attribute may be used to "restore" the workspace
|		from the specified filename. 
| Type:         char * 
| Default:      N/A 
| Legal Values: any legal workspace file 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_RESTORE		"workspaceRestore"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_WKSPGUI
| Description:  This attribute is a read/only attribute that points to the
|		GUI form structure which contains the workspace GUI parameters. 
| Type:         kform * 
| Default:      $DESIGN/objects/library/
|		xvlang/uis/panel.subform
| Legal Values: any legal single pane kform structure 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_WKSPGUI	"workspaceWkspGUI"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_SAVE_WKSPGUI
| Description:  This action attribute can be used to save the workspace GUI
|		parameters to a file.  The filename is specified as part of
|		the action attribute, which will contain a valid UIS specifi-
|	        cation.  This is typically used when creating an ecapsulated
|		workspace object, from the current workspace.
| Type:         char * 
| Default:      N/A
| Legal Values: any legal path to a file in which to store the UIS 
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_SAVE_WKSPGUI	"workspaceSaveWkspGUI"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_SHOW_WKSPGUI
| Description:  This action attribute can be used to force the workspace to
|		map it's workspace GUI pane.  If the pane is not realized 
|		then the pane is created and then mapped.  This attribute
|		can be used by the programmer to display the workspace GUI
|		even if the workspace itself is not mapped.  This allows
|		the user to interact with the visual program via the workspace
|		GUI parameters even though the workspace is not visible.
| Type:		int
| Default:      N/A (read-only)
| Legal Values: TRUE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_SHOW_WKSPGUI	"workspaceShowWkspGUI"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_EXPORT_SELECTIONS
| Description:  After a network is constructed, this action attribute
|		may be used to export the selections from the selected
|		glyphs into the workspace GUI.
| Type:         int
| Default:      N/A (read-only)
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_EXPORT_SELECTIONS	 "workspaceExportSelections"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_CREATE_PROCEDURE
| Description:  This action attribute will take the currently selected glyphs
|		within a workspace and place them inside of a newly created
|		procedure.
| Type:         int 
| Default:      N/A (read-only) 
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_CREATE_PROCEDURE	"workspaceCreateProcedure"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_CREATE_WHILELOOP
| Description:  This action attribute will take the currently selected glyphs
|		within a workspace and place them inside of a newly created
|		while loop.
| Type:         int 
| Default:      N/A (read-only) 
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_CREATE_WHILELOOP	"workspaceCreateWhileloop"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_CREATE_COUNTLOOP
| Description:  This action attribute will take the currently selected glyphs
|		within a workspace and place them inside of a newly created
|		count loop.
| Type:         int 
| Default:      N/A (read-only) 
| Legal Values: TRUE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_CREATE_COUNTLOOP	"workspaceCreateCountloop"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_RUN_CALLBACK
| Description:  If desired, a callback may be installed on the workspace
|		object that will be fired each time a glyph is run or stopped
|		within the workspace.
| Type:         kfunc_void
| Default:      NULL
| Legal Values: N/A
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_RUN_CALLBACK	"workspaceRunCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_WORKSPACE_ACTIVE_CALLBACK
| Description:  If desired, a callback may be installed on the workspace
|		object that will be fired each time there is change to the
|		active workspace.  This helps to define the workspace scope
|		to show which workspace is currently active.
| Type:         kfunc_void
| Default:      NULL
| Legal Values: N/A
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_ACTIVE_CALLBACK	"workspaceActiveCallback"

/*------------------------------------------------------------------------
| Attribute:     XVW_WORKSPACE_PROCEDURE_OBJECT
| Description:   The procedure object represented by the Workspace.  By default
|		 this is NULL, but is necessary for the Workspace and Procedure
|		 to establish a protocol.
| Type:          xvobject
| Default:       created by the procedure object
| Legal Values:  any xvobject that is subclassed off the ProcedureClass
| Resource:	 N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_PROCEDURE_OBJECT	"workspaceProcedureObject"

/*------------------------------------------------------------------------
| Attribute:     XVW_WORKSPACE_FILENAME
| Description:   The workspace filename that represents the current workspace.
|		 This is used by the commandbar object to know where to save
|		 the current workspace to.
| Type:          char *
| Default:       NULL
| Legal Values:  N/A
| Resource:	 N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_FILENAME		"workspaceFilename"

/*------------------------------------------------------------------------
| Attribute:     XVW_WORKSPACE_NAME
| Description:   The workspace name represents the name that is
|		 reflected by the procedure object's XVW_NODE_NAME.
| Type:          char *
| Default:       NULL
| Legal Values:  N/A
| Resource:	 N/A
------------------------------------------------------------------------*/
#define XVW_WORKSPACE_NAME		"workspaceProcedureObject.nodeName"


/*
 *  Define the Class name, by which people should be externally referencing
 *  the Workspace Object by.
 */
#define WorkspaceWidgetClass	xvwWorkspaceWidgetClass


        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration WorkspaceWidgetClass
 */
extern   WidgetClass     WorkspaceWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Workspace Object
 */
xvobject xvw_create_workspace PROTO((xvobject, char *));


#endif /* _xvlang_Workspace_h_ */
/* Do not add after this line */
