 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions for Khoros Procedure Widget
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Jul 25, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_Procedure_h_
#define _xvlang_Procedure_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:     XVW_PROCEDURE_WORKSPACE_OBJECT
| Description:   The workspace object represented by the Procedure.
| Type:          xvobject
| Default:       created by the procedure object
| Legal Values:  any xvobject that is subclassed off the ManagerClass
| Resource:	 N/A
------------------------------------------------------------------------*/
#define XVW_PROCEDURE_WORKSPACE_OBJECT	"procedureWorkspaceObject"

/*------------------------------------------------------------------------
| Attribute:     XVW_PROCEDURE_PIXMAP
| Description:   The pixmap that is displayed in the center of the procedure.
| Type:          Pixmap
| Default:       xvlang/misc/glyph/procedure.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 procedurePixmap
------------------------------------------------------------------------*/
#define XVW_PROCEDURE_PIXMAP    "procedurePixmap"

/*------------------------------------------------------------------------
| Attribute:     XVW_PROCEDURE_OPEN_PIXMAP
| Description:   The pixmap that is used to open a procedure glyph.
| Type:          Pixmap
| Default:       xvlang/misc/glyph/open.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 procedureOpenPixmap
------------------------------------------------------------------------*/
#define XVW_PROCEDURE_OPEN_PIXMAP    "procedureOpenPixmap"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Procedure Object by.
 */
#define ProcedureWidgetClass	xvwProcedureWidgetClass

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration ProcedureWidgetClass
 */
extern   WidgetClass     ProcedureWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Procedure Object
 */
xvobject xvw_create_procedure PROTO((xvobject, char *));


#endif /* _xvlang_Procedure_h_ */
/* Do not add after this line */
