 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions for Khoros Port Object
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 22, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_Port_h_
#define _xvlang_Port_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_DAV
| Description:  Whether the port currently has data available or not.  Data
|		available is used to indicate whether the port is referencing
|		valid data or not.  This attribute is used in conjunction with
|		the GlyphClass to coordinate the scheduling and execution of
|		glyphs.
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PORT_DAV		   "portDav"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_TYPE
| Description:  The type of port.  The port type is used to indicate how
|		the information of data available should be propagated.
|		If the port is of type 
|		.symbol index KPORT_TYPE_OUTPUT ,
|		then when data
|		available, 
|		.symbol index XVW_PORT_DAV ,
|		is set then the value will propagated
|		to the other connections.
| Type:         int
| Default:      .symbol index KPORT_TYPE_UNKNOWN
| Legal Values: .symbol index KPORT_TYPE_UNKNOWN
|		.symbol index KPORT_TYPE_INPUT
|		.symbol index KPORT_TYPE_OUTPUT
|		.symbol index KPORT_TYPE_TRANSIENT
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PORT_TYPE		   "portType"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_SHOWDAV
| Description:  Whether the visual representation for data available should
|		be displayed when data is available.  The pixmap used for
|		representing data availabl can be specified by the
|		.symbol index XVW_PORT_DAV_PIXMAP
|		resource.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:	portShowdav
------------------------------------------------------------------------*/
#define XVW_PORT_SHOWDAV	   "portShowdav"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_SELECTION
| Description:  The UIS selection that is used to represent the port.  The
|		selection needs to be either of type
|		.symbol index KUIS_INPUTFILE
|		or
|		.symbol index KUIS_OUTPUTFILE .
| Type:         kformstruct *
| Default:      NULL
| Legal Values: a legal
|		.symbol index KUIS_INPUTFILE
|		or
|		.symbol index KUIS_OUTPUTFILE
|		selection
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PORT_SELECTION	   "portSelection"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_SELECTED
| Description:  Whether the port is currently optionally selected or not.
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PORT_SELECTED	   "portSelected"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_MODIFIED
| Description:  Whether the port is current modified or not.
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PORT_MODIFIED	   "portModified"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_CONNECTION_PARENT
| Description:  The parent in which connections between ports should be
|               created.  If NULL, then use the port's parent object.
| Type:         xvobject
| Default:      NULL
| Legal Values: any xvobject that is subclassed off the ManagerClass
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PORT_CONNECTION_PARENT "portConnectionParent"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_FILENAME
| Description:  Filename associated with the port.  Depending on whether
|	        the filename is an input or output port, the filename
|		will be propagated to other input ports.
| Type:         char *
| Default:      NULL
| Legal Values: any legal path and filename
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PORT_FILENAME		"portFilename"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_DAV_CALLBACK
| Description:  Callback routines which will be notified when a port's data
|		available state changes.
| Type:         kfunc_void
| Default:      NULL
| Legal Values: any legal callback routine
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PORT_DAV_CALLBACK	   "portDavCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_SELECTED_CALLBACK
| Description:  Callback routines which will be notified when a port changes
|               whether it is selected or not.
| Type:         kfunc_void
| Default:      NULL
| Legal Values: any legal callback routine
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PORT_SELECTED_CALLBACK "portSelectedCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_FILENAME_CALLBACK
| Description:  Callback routines which will be notified when a port's filename
|               changes.
| Type:         kfunc_void
| Default:      NULL
| Legal Values: any legal callback routine
| Resource:	N/A
------------------------------------------------------------------------*/
#define XVW_PORT_FILENAME_CALLBACK "portFilenameCallback"


/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_DAV_PIXMAP
| Description:	The pixmap that used to visually indicate that a port's
|		data available is present.
| Type:         Pixmap
| Default:      xvlang/misc/
|		glyph/dav.xpm
| Legal Values: any bitmap or pixmap
| Resource:	portDavPixmap
------------------------------------------------------------------------*/
#define XVW_PORT_DAV_PIXMAP        "portDavPixmap"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_OPTIONAL_PIXMAP
| Description:  The pixmap that is used to visually indicate that a port
|		is optionally not selected.
| Type:         Pixmap
| Default:      xvlang/misc/
|		glyph/io_optional.xpm
| Legal Values: any bitmap or pixmap
| Resource:	portOptionalPixmap
------------------------------------------------------------------------*/
#define XVW_PORT_OPTIONAL_PIXMAP   "portOptionalPixmap"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_REQUIRED_PIXMAP
| Description:  The pixmap that is used to visually indicate that a port
|               is selected.
| Type:         Pixmap
| Default:      xvlang/misc/
|		glyph/io_required.xpm
| Legal Values: any bitmap or pixmap
| Resource:	portRequiredPixmap
------------------------------------------------------------------------*/
#define XVW_PORT_REQUIRED_PIXMAP   "portRequiredPixmap"

/*------------------------------------------------------------------------
| Attribute:    XVW_PORT_SELECTED_PIXMAP
| Description:  The pixmap that is used to visually indicate that a port
|		is selected for connecting with other ports.
| Type:         Pixmap
| Default:      xvlang/misc/
|		glyph/io_selected.xpm
| Legal Values: any bitmap or pixmap
| Resource:	portSelectedPixmap
------------------------------------------------------------------------*/
#define XVW_PORT_SELECTED_PIXMAP   "portSelectedPixmap"

#define KPORT_TYPE_UNKNOWN	0
#define KPORT_TYPE_INPUT	1
#define KPORT_TYPE_OUTPUT	2
#define KPORT_TYPE_TRANSIENT	2

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Port Object by.
 */
#define PortGadgetClass	xvwPortGadgetClass

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration PortGadgetClass
 */
extern   WidgetClass     PortGadgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Port Object
 */
xvobject xvw_create_port PROTO((xvobject, char *));


#endif /* _xvlang_Port_h_ */
/* Do not add after this line */
