 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions for Khoros Glyph Widget
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: May 21, 1993 09:41
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvlang_Glyph_h_
#define _xvlang_Glyph_h_

        /*-------------------------------------*
        |       #defines
        ---------------------------------------*/


/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_FORM
| Description:   The UIS form which is used to represent the glyph.  If
|                left NULL, then the XVW_GLYPH_TBNAME and XVW_GLYPH_ONAME will
|                be used to retrieve the object's pane file.
| Type:          kform *
| Default:       NULL
| Legal Values:  a kform structure with a single pane
| Resource:	 N/A
------------------------------------------------------------------------*/
#define XVW_GLYPH_FORM	  	  "glyphForm"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_FORMFILE
| Description:   The UIS form file which is used to represent the glyph.  If
|		 left NULL, then the XVW_GLYPH_TBNAME and XVW_GLYPH_ONAME will
|		 be used to retrieve the object's pane file.
| Type:          char *
| Default:       NULL
| Legal Values:  a UIS file with a single pane
| Resource:	 glyphFormfile
------------------------------------------------------------------------*/
#define XVW_GLYPH_FORMFILE	  "glyphFormfile"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_TBNAME
| Description:	 The toolbox in which the object name can be found. 
| Type:          char * 
| Default:       NULL
| Legal Values:  any legal toolbox
| Resource:	 glyphTbname
------------------------------------------------------------------------*/
#define XVW_GLYPH_TBNAME	  "glyphTbname"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_ONAME
| Description:   The object name in which the glyph is representing.
| Type:          char *
| Default:       NULL
| Legal Values:  any object within the toolbox specified by XVW_GLYPH_TBNAME
| Resource:	 glyphOname
------------------------------------------------------------------------*/
#define XVW_GLYPH_ONAME	  	  "glyphOname"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_WKSPGUI
| Description:   The form in which the glyph's user interface selections should
|		 be exported.  If NULL then exporting selections is disabled.
| Type:          kform *
| Default:       NULL
| Legal Values:  a kform structure with a single pane
| Resource:	 N/A
------------------------------------------------------------------------*/
#define XVW_GLYPH_WKSPGUI	  "glyphWkspGUI"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_SHOWSTATUS
| Description:   Whether the status label beneath the glyph should appear.
| Type:          int
| Default:       FALSE
| Legal Values:  TRUE/FALSE
| Resource:	 glyphShowstatus
------------------------------------------------------------------------*/
#define XVW_GLYPH_SHOWSTATUS	  "glyphShowstatus"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_CONNECTION_PARENT
| Description:   The parent in which connections between glyphs should be
|		 created.  If NULL, then use the glyph's parent object.
| Type:          xvobject
| Default:       NULL
| Legal Values:  any xvobject that is subclassed off the ManagerClass
| Resource:	 glyphConnectionParent
------------------------------------------------------------------------*/
#define XVW_GLYPH_CONNECTION_PARENT "glyphConnectionParent"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_EXPRESSION_ID
| Description:   The id in which expressions should be evaluated.  Initially
|		 it uses id 0 so that all glyphs share, but if a glyph is
|		 placed within a workspace, then the workspace will have the
|		 id default to the workspace id itself.
| Type:          long
| Default:       0
| Legal Values:  and legal long value
| Resource:	 glyphExpressionId
------------------------------------------------------------------------*/
#define XVW_GLYPH_EXPRESSION_ID "glyphExpressionId"

/*------------------------------------------------------------------------
| Attribute:    XVW_GLYPH_ECHO
| Description:  When set to 'true', this attribute causes the processes to
|               be executed to be echoed to the console log. This attribute
|               may be set to true or false.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     workspaceEcho
------------------------------------------------------------------------*/
#define XVW_GLYPH_ECHO              "glyphEcho"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_REPORTING
| Description:   Whether the glyph should capture stdout and stderr from
|		 sub-processes and report them to the user.  If set to
|		 TRUE then an icon will appear below the glyph, which
|		 the user can click on to get the information.  If FALSE
|		 then the output will not be captured and will be reported
|		 to the users tty (or Console if one is present).
| Type:          int
| Default:       TRUE
| Legal Values:  TRUE/FALSE
| Resource:	 glyphReporting
------------------------------------------------------------------------*/
#define XVW_GLYPH_REPORTING	  "glyphReporting"


/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_ON_PIXMAP
| Description:   The pixmap that indicates the glyph is running
| Type:          Pixmap
| Default:       xvlang/misc/glyph/on.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 glyphOnPixmap
------------------------------------------------------------------------*/
#define XVW_GLYPH_ON_PIXMAP         "glyphOnPixmap"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_OFF_PIXMAP
| Description:   The pixmap that indicates the glyph is not running
| Type:          Pixmap
| Default:       xvlang/misc/glyph/on.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 glyphOffPixmap
------------------------------------------------------------------------*/
#define XVW_GLYPH_OFF_PIXMAP        "glyphOffPixmap"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_DESTROY_PIXMAP
| Description:   The pixmap that is used to destroy the glyph
| Type:          Pixmap
| Default:       xvlang/misc/glyph/on.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 glyphDestroyPixmap
------------------------------------------------------------------------*/
#define XVW_GLYPH_DESTROY_PIXMAP    "glyphDestroyPixmap"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_ERROR_PIXMAP
| Description:   The pixmap that is used to indicate that an error message
|		 needs to be displayed.
| Type:          Pixmap
| Default:       xvlang/misc/glyph/error.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 glyphErrorPixmap
------------------------------------------------------------------------*/
#define XVW_GLYPH_ERROR_PIXMAP    "glyphErrorPixmap"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_INFO_PIXMAP
| Description:   The pixmap that is used to indicate that an information
|		 message needs to be displayed.
| Type:          Pixmap
| Default:       xvlang/misc/glyph/info.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 glyphInfoPixmap
------------------------------------------------------------------------*/
#define XVW_GLYPH_INFO_PIXMAP    "glyphInfoPixmap"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_OPENPANE_PIXMAP
| Description:   The pixmap that is used to open the glyph's menuform
| Type:          Pixmap
| Default:       xvlang/misc/glyph/on.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 glyphOpenpanePixmap
------------------------------------------------------------------------*/
#define XVW_GLYPH_OPENPANE_PIXMAP   "glyphOpenpanePixmap"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_CLOSEPANE_PIXMAP
| Description:   The pixmap that is used to close the glyph's menuform
| Type:          Pixmap
| Default:       xvlang/misc/glyph/on.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 glyphClosepanePixmap
------------------------------------------------------------------------*/
#define XVW_GLYPH_CLOSEPANE_PIXMAP  "glyphClosepanePixmap"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_DISTRIBUTE_PIXMAP
| Description:   The pixmap that is used to distribute the location in which
|		 a glyph will be executed
| Type:          Pixmap
| Default:       xvlang/misc/glyph/on.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 glyphDistributePixmap
------------------------------------------------------------------------*/
#define XVW_GLYPH_DISTRIBUTE_PIXMAP "glyphDistributePixmap"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_DAV_PIXMAP
| Description:   The pixmap that is used to indicate data available 
| Type:          Pixmap
| Default:       xvlang/misc/glyph/dav.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 glyphDavPixmap
------------------------------------------------------------------------*/
#define XVW_GLYPH_DAV_PIXMAP	    "glyphDavPixmap"

/*------------------------------------------------------------------------
| Attribute:     XVW_GLYPH_CONTROL_PIXMAP
| Description:   The pixmap that is used to indicate where control
|                connections can be made.
| Type:          Pixmap
| Default:       xvlang/misc/glyph/control.xpm
| Legal Values:  any bitmap or pixmap
| Resource:	 glyphControlPixmap
------------------------------------------------------------------------*/
#define XVW_GLYPH_CONTROL_PIXMAP    "glyphControlPixmap"


/*
 *  Define the Class name, by which people should be externally referencing
 *  the Glyph Object by.
 */
#define GlyphWidgetClass	xvwGlyphWidgetClass

        /*-------------------------------------*
        |       global variable declarations
        ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration GlyphWidgetClass
 */
extern   WidgetClass     GlyphWidgetClass;


        /*-------------------------------------*
        |       routine definitions
        ---------------------------------------*/

/*
 *  Khoros Function Definition for Glyph Object
 */
xvobject xvw_create_glyph PROTO((xvobject, char *));


#endif /* _xvlang_Glyph_h_ */
/* Do not add after this line */
