 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Private declarations for the image zoom
   >>>>		       widget.
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 15:05
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_ZoomP_h_
#define _xvisual_ZoomP_h_


    /*-------------------------------------*
    |       #include 
    ---------------------------------------*/

#include <xvisual/ImageP.h>
#include <xvisual/Zoom.h>


    /*-------------------------------------*
    |       typedefs
    ---------------------------------------*/

typedef struct _XvwZoomWidgetClass
{
    XtPointer  extension;
} XvwZoomWidgetClassPart;


typedef struct _XvwZoomWidgetClassRec
{
    CoreClassPart		core_class;
    CompositeClassPart		composite_class;
    ConstraintClassPart		constraint_class;
    XvwManagerWidgetClassPart	manager_class;
    XvwGraphicsWidgetClassPart	graphics_class;
    XvwColorWidgetClassPart	color_class;
    XvwImageWidgetClassPart	image_class;
    XvwZoomWidgetClassPart	zoom_class;
} XvwZoomWidgetClassRec;

typedef struct _XvwZoomPart
{
    double	zoomfactor;
    Position	xposition;
    Position	yposition;
    int		location_marker;
    int		update_mode;
    int		interpolate;
    Boolean	center_image;
} XvwZoomPart;

typedef struct _XvwZoomWidgetRec
{
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    XvwManagerPart	manager;
    XvwGraphicsPart	graphics;
    XvwColorPart	color;
    XvwImagePart	image;
    XvwZoomPart		zoom;
} XvwZoomWidgetRec;


typedef struct  _XvwZoomWidgetClassRec     *XvwZoomWidgetClass;
typedef struct  _XvwZoomWidgetRec          *XvwZoomWidget;


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit Widget Declaration XvwZoomWidget
 */
extern  XvwZoomWidgetClassRec xvwZoomWidgetClassRec;


#endif /* _xvisual_ZoomP_h_ */
/* Don't add after this point */
