 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       Pseudo object.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 16, 1992 16:20
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Pseudo_h_
#define _xvisual_Pseudo_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for Pseudo Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_INDEX1
|
| Description:  If the pseudocolor scrollbars are to operate on a range of 
|               pixels, this is the first pixel value (colormap index) in the 
|               range.
|
| Type:         int       
| Default:      N/A
| Legal Values: valid colormap index
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_INDEX1	"pseudoIndex1"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_INDEX2
|
| Description:  If the pseudocolor scrollbars are to operate on a range of 
|               pixels, this is the last pixel value (colormap index) in the 
|               range.
|
| Type:         int
| Default:      N/A
| Legal Values: valid colormap index
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_INDEX2	"pseudoIndex2"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_SHOW_PALETTE
|
| Description:  This attribute causes the palette of linear colormap values 
|               to be displayed above the RGB scrollbars.  Set to FALSE if 
|               the palette is not to be shown.
|
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     pseudoShowPalette
------------------------------------------------------------------------*/
#define XVW_PSEUDO_SHOW_PALETTE	"pseudoShowPalette"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_PALETTE_OBJECT
| Description:  This is the palette component of the pseudo object.
|               The palette component is where the actual pixels are
|		displayed and can be interactively selected.
| Type:         xvobject
| Default:      NULL
| Legal Values: valid xvobject
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_PALETTE_OBJECT "pseudoPaletteObject"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_PALETTE_TYPE
| Description:  .include $DESIGN/manual/shared/xvisual/palette/Type.sec
| Type:         int
| Default:      .symbol index KPALETTE_TYPE_COLORBAR
| Legal Values: .symbol index KPALETTE_TYPE_COLORBAR
|               .symbol index KPALETTE_TYPE_COLORCELL
|               .symbol index KPALETTE_TYPE_COLORWHEEL
| Resource:     pseudoPaletteObject.paletteType
------------------------------------------------------------------------*/
#define XVW_PSEUDO_PALETTE_TYPE	"pseudoPaletteObject.paletteType"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_UPDATE_ONADD
|
| Description:  When set to TRUE, this attribute will cause pixels to
|		immediately change to the color specified by the pseudo
|		object's RGB scrollbars when they are added to the 
|		pseudocolor list with
|		.symbol index XVW_PSEUDO_ADD
|		When set to FALSE, pixels do not change color until the
|		user changes the color specified by the RGB scrollbars.
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     pseudoUpdateOnadd
-----------------------------------------------------------------------*/
#define XVW_PSEUDO_UPDATE_ONADD	"pseudoUpdateOnadd"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_INDEXLIST
|
| Description:  This \fIread-only\fP attribute may be used to obtain an array
|               of integers representing the pixel values (colormap indices) 
|               that are currently associated with the pseudocolor object; 
|               ie, those pixels that will have their color changed when the 
|               user moves the RGB scrollbars.
|
| Type:         int *
| Default:      NULL
| Legal Values: integer array containing index list
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_INDEXLIST	"pseudoIndexlist"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_INDEXNUM
|
| Description:  This is \fIread-only\fP attribute may be used to obtain 
|               the size of the integer array that is returned by the
|               .symbol noindex XVW_PSEUDO_INDEXLIST
|               attribute.
|
| Type:         int
| Default:      0
| Legal Values: size of index list array given by
|               .symbol index XVW_PSEUDO_INDEXLIST
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_INDEXNUM	"pseudoIndexnum"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_REDVAL
|
| Description:  This is the red component of the color in which the pixel 
|               value(s) that are associated with the pseudocolor object
|               appear.
|
| Type:         int
| Default:      0
| Legal Values: 0-255
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_REDVAL	"pseudoRedval"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_GREENVAL
|
| Description:  This is the green component of the color in which the pixel 
|               value(s) that are associated with the pseudocolor object
|               appear.
|
| Type:         int
| Default:      0
| Legal Values: 0-255
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_GREENVAL	"pseudoGreenval"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_BLUEVAL
|
| Description:  This is the blue component of the color in which the pixel 
|               value(s) that are associated with the pseudocolor object
|               appear.
|
| Type:         int 
| Default:      0
| Legal Values: 0-255
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_BLUEVAL	"pseudoBlueval"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_USE_ALPHA
|
| Description:  TRUE if an integer object is to be created so that the
|               user can change the alpha channel; FALSE otherwise.
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     pseudoUseAlpha
------------------------------------------------------------------------*/
#define XVW_PSEUDO_USE_ALPHA      "pseudoUseAlpha"


/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_ALPHAVAL
|
| Description:  This is the alpha channel value that determines the blending
|               factor that is applied to the color defined by the Red,
|               Green, and Blue values.  A value of 1.0 for the alpha channel
|               implies that the color defined by the RGB values is completely
|               "solid" (ie, the only color showing is that which is defined
|               by the RGB values; none of the background color will "show 
|               through").  A value of 0.0 for the alpha channel implies that 
|               the color defined by the RGB values is completely "transparent" 
|               (ie, the only color showing is that of the background; none
|               of the color defined by the RGB values will be displayed).
|               As the alpha channel value moves from 0.0 to 1.0, the color
|               defined by the RGB values will become less "transparent" and
|               more "solid"; the background color will "show though" less
|               and less, until it does not appear at all.
|
| Type:         float
| Default:      0.0
| Legal Values: 0.0 - 1.0
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_ALPHAVAL      "pseudoAlphaval"


/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_ADD
|
| Description:  This \fIaction attribute\fP adds the pixel value specified
|		to the pseudocolor list of pixels.  This can have two effects,
|		depending on whether there are already pixels in the pseudocolor
|		list.
|		.sp
|		(1) if \fIno\fP pixels are currently in the pseudocolor list,
|		.symbol index XVW_PSEUDO_ADD
|		will cause the pseudocolor object's RGB scrollbars to reflect 
|		the RGB components of color of the pixel specified.
|		.sp
|		(2) if there are \fIalready\fP one or more pixels in the
|		pseudocolor list, 
|               .symbol index XVW_PSEUDO_ADD
|               will cause the pixel being added to the list to change to
|		the color currently reflected by the RGB scrollars of the
|		pseudocolor object; pixels currently on the pseudocolor list 
|		will already be displayed in this color.
|		.sp
|		In either case, subsequent movement of the pseudocolor 
|		RGB scrollbars will change the color in which the pixel 
|		is displayed to the color specified by the scrollbars.
|		.sp
|		Note that if desired, the 
|		.symbol index XVW_IMAGE_VALUE
|		attribute can be used to obtain the pixel value over
|		which the pointer is positioned;  the
|		.symbol index XVW_PSEUDO_ADD
|		attribute may then be set to that pixel value.
|		.sp
|		Note that if desired, the
|		.symbol index XVW_PSEUDO_CLEAR
|		action attribute may be used to clear the psuedocolor list
|		prior to adding a new pixel value, thus achieving the first
|		effect.
|
| Type:         int
| Default:      N/A
| Legal Values: pixel values that appear in the data of the displayed image
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_ADD		"pseudoAdd"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_DELETE
| Description:  This \fIaction attribute\fP deletes the pixel value specified
|               to the pseudocolor list of pixels. Subsequent movement of
|		the pseudocolor RGB scrollbars will have no effect on the
|		color of the pixel once it is deleted from the psuedocolor
|		list.
| Type:         int
| Default:      N/A
| Legal Values: pixel values currently in the pseudocolor list, having
|		been added previously with the use of
|		.symbol index XVW_PSEUDO_ADD
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_DELETE	"pseudoDelete"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_CLEAR
|
| Description:  This \fIaction attribute\fP clears all pixel(s)
|		from the pseudocolor list. 
|
| Type:         int
| Default:      N/A
| Legal Values: TRUE (action attribute)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_CLEAR	"pseudoClear"

/*------------------------------------------------------------------------
| Attribute:    XVW_PSEUDO_CALLBACK
|
| Description:  If desired, a callback may be installed on the pseudocolor 
|               object that will be fired each time the user employs one of 
|               the RGB scrollbars to change the colormap of the displayed 
|               object.  An \fIxvw_pseudo_struct\fP will be passed in as the 
|               call_data; cast this parameter accordingly before using, as in:
|               .begin code
|               xvw_pseudo_struct *pseudo_struct;
|               pseudo_struct = (xvw_pseudo_struct *) call_data;\fP
|               .end code
|               The \fIxvw_psuedo_struct\fP is defined in
|               $ENVISION/include/xvisual/Psuedo.h as follows:
|               .begin code
|               typedef struct
|               {
|                   xvobject object; 
|                   int      value;
|                   int      type;
|               } xvw_pseudo_struct;
|               .end code
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                   xvobject object,
|                   kaddr client_data,
|                   kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_PSEUDO_CALLBACK	"pseudoCallback"

/*
 *  Value definitions for Pseudo Visual Object
 */
#define KPSEUDO_RED		0
#define KPSEUDO_GREEN		1
#define KPSEUDO_BLUE		2
#define KPSEUDO_ALPHA		3

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Pseudo Object by.
 */
#define PseudoWidgetClass	xvwPseudoWidgetClass
 
        /*-------------------------------------*
        |       typedefs
        ---------------------------------------*/

/*
 *  Callback structure for the XVW_PSEUDO_CALLBACK.  The calldata
 *  consists of:
 *
 *  1) the integer object that allows the user to change the color, 
 *     or the float object that allows the user to change the alpha channel
 *     (depending on which of the values was changed: R, G, B, or A)
 *
 *  2) which of the values was changed (Red, Green, Blue, or Alpha)
 *
 *  3) the Red, Green, or Blue value
 */
typedef struct
{
	xvobject object;     /* the integer object corresponding to the 
				Red, Green, Blue, or Alpha scrollbar */

	int	 type;       /* one of: KPSEUDO_RED, 
                                        KPSEUDO_GREEN, 
                                        KPSEUDO_BLUE,
  				     or KPSEUDO_ALPHA */

	int      value;     /* R,G,B, or alpha value between 0 and 255 (*/

} xvw_pseudo_struct;

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

/*
 *  XToolkit Widget Declaration for PseudoWidgetClass
 */
extern   WidgetClass     PseudoWidgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for Pseudo Visual Object
 */
xvobject xvw_create_pseudo  PROTO((xvobject, char *));


#endif /* _xvisual_Pseudo_h_ */
/* Don't add after this point */
