 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       graphical position annotation.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 17, 1992 10:17
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Position_h_
#define _xvisual_Position_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for Position Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_POSITION_OBJECT
|
| Description:  This is the data object (kobject) containing the image 
|               on which the position object will track. Note that this 
|               attribute is mutually exclusive with
|               .symbol index XVW_POSITION_FILENAME ;
|               use one or the other, not both.
|
| Type:         kobject
| Default:      NULL
| Legal Values: valid data object
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_POSITION_OBJECT	"positionObject"

/*------------------------------------------------------------------------
| Attribute:    XVW_POSITION_FILENAME
|
| Description:  A file containing the image on which the position object
|               will track may be specified directly using this attribute.
|
| Type:         char *
| Default:      NULL
| Legal Values: valid input filename
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_POSITION_FILENAME	"positionFilename"

/*------------------------------------------------------------------------
| Attribute:    XVW_POSITION_SHOW_VALUE
|
| Description:  If TRUE, the position object will display information in 
|               (X x Y = Z) format, where X and Y display the location of the 
|               pointer in the data object, and Z is the pixel value at that 
|               location.  If FALSE, the position object will simply display 
|               (X x Y) location information;  the pixel value will be omitted.
|
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     positionShowValue
------------------------------------------------------------------------*/
#define XVW_POSITION_SHOW_VALUE	"positionShowValue"

/*------------------------------------------------------------------------
| Attribute:    XVW_POSITION_UPDATEMODE
|
| Description:  The update mode attribute indicates when the position object 
|               is to update the information which it displays.  If set to
|               .symbol index KPOSITION_UM_CONTINUOUS , 
|               the position object will continually update as the pointer 
|               is moved across the image;  if set to
|               .symbol index KPOSITION_UM_BUTTON_PRESS , 
|               the position object will not update until the mouse button 
|               is pressed in the image object.
|
| Type:         int
| Default:      .symbol index KPOSITION_UM_CONTINUOUS
| Legal Values: .symbol index KPOSITION_UM_CONTINUOUS
|               .symbol index KPOSITION_UM_BUTTON_PRESS
| Resource:     positionUpdatemode
------------------------------------------------------------------------*/
#define XVW_POSITION_UPDATEMODE	"positionUpdatemode"

/*
 *  Value definitions for Position Visual Object
 */
#define KPOSITION_UM_CONTINUOUS      0
#define KPOSITION_UM_BUTTON_PRESS    1

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Position Object by.
 */
#define PositionGadgetClass	xvwPositionGadgetClass

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/

/*
 *  XToolkit Widget Declaration for PositionGadgetClass
 */
extern   WidgetClass     PositionGadgetClass;


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for Position Visual Object
 */
xvobject xvw_create_position PROTO((xvobject, char *));


#endif /* _xvisual_Position_h_ */
/* Don't add after this point */
