 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>                raster or image display widget (used in
   >>>>		       such programs as editimage).
   >>>>
   >>>>    Written By: John Salas and Mark Young
   >>>>
   >>>>          Date: Aug 05, 1992 14:11
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Image_h_
#define _xvisual_Image_h_

    /*-------------------------------------*
    |       #defines 
    ---------------------------------------*/

/*
 *  Attribute definitions for Image Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_XOFFSET
| Description:  .include  $DESIGN/manual/shared/xvisual/image/XOffset.sec
| Type:         int
| Default:      -1
| Legal Values: -1 <= value <= image width
| Resource:     imageXoffset
------------------------------------------------------------------------*/
#define XVW_IMAGE_XOFFSET		"imageXoffset"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_YOFFSET
| Description:  .include  $DESIGN/manual/shared/xvisual/image/YOffset.sec
| Type:         int
| Default:      -1
| Legal Values: -1 <= value <= image height
| Resource:     imageYoffset
------------------------------------------------------------------------*/
#define XVW_IMAGE_YOFFSET		"imageYoffset"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_BANDNUM
| Description:  .include $DESIGN/manual/shared/xvisual/image/BandNum.sec
| Type:         int
| Default:      0
| Legal Values: 0 < bandnum < # bands in image
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_BANDNUM		"imageBandnum"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_IMAGEOBJ
| Description:  .include $DESIGN/manual/shared/xvisual/image/ImageObj.sec
|               Note that this attribute is mutually exclusive with
|               .symbol index XVW_IMAGE_IMAGEFILE ;
|               use one or the other, not both.
| Type:         kobject
| Default:      NULL
| Legal Values: valid data object defining image to display
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_IMAGEOBJ		"imageImageobj"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_CLIPOBJ
|
| Description:  .include $DESIGN/manual/shared/xvisual/image/ClipObj.sec 
|               Note that this attribute is mutually exclusive with
|               .symbol index XVW_IMAGE_CLIPFILE ;
|               use one or the other, not both.
|
| Type:         kobject
| Default:      NULL
| Legal Values: valid data object defining clip maks
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_CLIPOBJ		"imageClipobj"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_COLORMAPOBJ
|
| Description:  .include $DESIGN/manual/shared/xvisual/image/ColormapObj.sec
|               Note that this attribute is mutually exclusive with
|               .symbol index XVW_IMAGE_COLORMAPFILE ;
|               use one or the other, not both.
|
| Type:         kobject
| Default:      NULL
| Legal Values: valid data object defining colormap
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_COLORMAPOBJ		"imageColormapobj"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_IMAGEFILE
| Description:  .include $DESIGN/manual/shared/xvisual/image/ImageFile.sec
| Type:         char *
| Default:      NULL
| Legal Values: valid name of input file containing image to display
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_IMAGEFILE		"imageImagefile"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_SAVEIMAGE
| Description:  .include $DESIGN/manual/shared/xvisual/image/SaveImage.sec
| Type:         char *
| Default:      NULL
| Legal Values: filename for saved image
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_SAVEIMAGE		"imageSaveimage"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_CLIPFILE
| Description:  .include $DESIGN/manual/shared/xvisual/image/ClipFile.sec
| Type:         char *
| Default:      NULL
| Legal Values: valid name of input file containing clip mask
| Resource:     N/A
-----------------------------------------------------------------------*/
#define XVW_IMAGE_CLIPFILE		"imageClipfile"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_COLORMAPFILE
| Description:  .include $DESIGN/manual/shared/xvisual/image/ColormapFile.sec
| Type:         char *
| Default:      NULL
| Legal Values: valid name of input file containing colormap
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_COLORMAPFILE		"imageColormapfile"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_XPOSITION
| Description:  .include $DESIGN/manual/shared/xvisual/image/XPosition.sec
| Type:         int
| Default:      N/A
| Legal Values: 0 =< value <= image width
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_XPOSITION		"imageXposition"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_YPOSITION
| Description:  .include $DESIGN/manual/shared/xvisual/image/YPosition.sec
| Type:         int
| Default:      N/A
| Legal Values: 0 =< value <= image height
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_YPOSITION		"imageYposition"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_VALUE
| Description:  .include $DESIGN/manual/shared/xvisual/image/Value.sec
| Type:         double
| Default:      0.0
| Legal Values: pixel value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_VALUE			"imageValue"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_PIXEL
| Description:  Corresponding to the current image value, as indicated by
|		.symbol index XVW_IMAGE_VALUE ,
|		this is the pixel value that was actually allocated for
|		that particular image data value.
| Type:         unsigned long
| Default:      0
| Legal Values: pixel value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_PIXEL			"imagePixel"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_BACKING
| Description:  .include $DESIGN/manual/shared/xvisual/image/Backing.sec
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     imageBacking
------------------------------------------------------------------------*/
#define XVW_IMAGE_BACKING		"imageBacking"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_ROI
|
| Description:  If this action attribute is \fIset\fP, then the region of interest
|		contained in the data object specified will be inserted into
|		the displayed image.  Note that the polymorphic data services
|		attribute 
|		.symbol index KPDS_SUBOBJECT_POSITION 
|		may be set on the data object to specify where in the image 
|		the region of interest is to be inserted.  If the
|               .symbol index KPDS_SUBOBJECT_POSITION 
|		attribute is \fInot\fP set in the data object, then the user
|		will be interactively prompted to indicate where the region
|		of interest is to be placed.
|		.sp
|		If a \fIget\fP attribute procedure is done, then the user
|		will be interactively prompted to specify the desired region
|		of interest, and the region of interest will be stored in
|		the specified data object.  The
|               .symbol index KPDS_SUBOBJECT_POSITION 
|		will be set on the resulting data object, to indicate the
|		position of origination in the displayed image.
|
| Type:         kobject
| Default:      NULL
| Legal Values: valid data object
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_ROI			"imageRoi"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_ROI_SHAPE
|
| Description:  When the 
|               .symbol index XVW_IMAGE_ROI
|               attribute is used to extract or insert a region of interest,
|               this attribute specifies the shape of the ROI.  ROI's may
|               be rectangular, polygonal, or circular.
|
| Type:         int
| Default:      .symbol index KIMAGE_ROI_RECTANGLE
| Legal Values: .symbol index KIMAGE_ROI_RECTANGLE 
|               .symbol index KIMAGE_ROI_POLYLINE  
|               .symbol index KIMAGE_ROI_CIRCLE    
|               .symbol index KIMAGE_ROI_ELLIPSE    
|               .symbol index KIMAGE_ROI_LINE    
|               .symbol index KIMAGE_ROI_FREEHAND  
|
| Resource:     imageRoiShape
------------------------------------------------------------------------*/
#define XVW_IMAGE_ROI_SHAPE                   "imageRoiShape"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_ROI_POLICY
|
| Description:  When the 
|               .symbol index XVW_IMAGE_ROI
|               attribute is used to extract a region of interest,
|               this attribute specifies whether the ROI is defined by the
|		region inside the shape, by the region outside the shape,
|		or by the outline of the shape itself.
|
| Type:         int
| Default:      KIMAGE_ROI_INSIDE
| Legal Values: .symbol index KIMAGE_ROI_INSIDE
|               .symbol index KIMAGE_ROI_OUTLINE
|               .symbol index KIMAGE_ROI_OUTSIDE
| Resource:     imageRoiPolicy
------------------------------------------------------------------------*/
#define XVW_IMAGE_ROI_POLICY                  "imageRoiPolicy"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_ROI_PRESENTATION
|
| Description:  When the 
|               .symbol index XVW_IMAGE_ROI
|               attribute is used to extract a region of interest,
|               this attribute specifies whether the ROI should be handed
|		back as a signal, image, or surface.  If the roi is defined
|		as a signal, then it can be displayed using the 2D plotting
|		routines.  If the roi is extracted as an image, then the
|		roi can be displayed using the image display routines.
|		And finally, if extracted as a surface, the roi can be
|		displayed using the 3D plotting routines. 
|
| Type:         int
| Default:      KIMAGE_ROI_IMAGE
| Legal Values: .symbol index KIMAGE_ROI_SIGNAL
|               .symbol index KIMAGE_ROI_IMAGE
|               .symbol index KIMAGE_ROI_SURFACE
| Resource:     imageRoiPresentation
------------------------------------------------------------------------*/
#define XVW_IMAGE_ROI_PRESENTATION              "imageRoiPresentation"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_ROI_MULTIBAND
|
| Description:  When the 
|               .symbol index XVW_IMAGE_ROI
|               attribute is used to extract a region of interest,
|               this attribute specifies whether the shape of the ROI should
|		extract the present band or all bands within the ROI extent.
|	        ROI's may be rectangular, polygonal, or circular.  In the case
|		of multiband being TRUE, all bands within the ROI will be
|		extracted, otherwise only the current displayed band is
|		extracted.
|
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     imageRoiMultiband
------------------------------------------------------------------------*/
#define XVW_IMAGE_ROI_MULTIBAND                  "imageRoiMultiband"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_ROI_MULTIPLE
|
| Description:  When the 
|               .symbol index XVW_IMAGE_ROI
|               attribute is used to extract a region of interest,
|               this attribute specifies whether multiple ROIs should be
|		extracted.  ROI's may be rectangular, polygonal, or circular.
|		In the case of multiple ROIs being TRUE, a single data object
|		will be passed back with the mask set indicating which ROI
|		belongs to which.  So for the first roi, the mask will be
|		set to 1.  For the second roi, the mask will be set to
|		set to 2, and so forth.  If multiple ROIs is set to FALSE
|		then a binary mask will be created, using 0's and 1's to
|		represent which bits in the mask are valid for the single
|		roi.
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     imageRoiMultiple
------------------------------------------------------------------------*/
#define XVW_IMAGE_ROI_MULTIPLE                  "imageRoiMultiple"


/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_RELOAD
|
| Description:  When set to TRUE, this attribute causes the image data to be 
|		re-read from the associated data object;  the data is then 
|		redisplayed.
|		.sp
|		Use of this attribute is useful when displaying images with
|		large images (large enough to require the use of a pan icon)
|		that also have a large number of image values.  When displaying
|		such images on screens that are less than 24 bit, the limitation
|		of the number of colorcells available for allocation on the
|		screen can cause difficulties in realistically displaying 
|		the colors in the image.
|		.sp
|		If the image being displayed has more values than can be 
|		accomodated by the screen, then some image values must be 
|		mapped to appear as the same pixel as other image values.  
|		If the image is small, or the number of image values is
|		not \fImuch\fP greater than that which can be displayed on
|		the screen being used, there is not much that can be done.
|		.sp
|		However, consider the situation of a large image that cannot
|		be displayed in its entirety, and furthermore containing a
|		much greater number of image values than can be displayed on
|		the current screen, \fInot all of which appear in every region
|		of the image\fP.  The displayed result will be most acceptable 
|		for the region of the image was loaded first, since the image 
|		values in that region of the image will have the greatest chance
|		of getting unique pixel values allocated for them.  However, 
|		other regions of the image with a large number of data values 
|		that differ from the values of the first region may suffer from 
|		the effect of having a large number of data values all being 
|		mapped to the same pixel value.  Such situations can be 
|		rectified by allowing the currently region to be re-read from 
|		scratch, causing the color allocation process to be redone, and
|		the current region being allowed to commandeer all the available
|		pixel values.
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     N/A
-----------------------------------------------------------------------*/
#define XVW_IMAGE_RELOAD		"imageReload"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_REDISPLAY
|
| Description:  This state variable attribute causes the currently displayed
|		image to be redisplayed.  Use of this attribute may be
|		appropriate after making a deliberate change to the image
|		data of the data object being displayed.
|
| Type:         int 
| Default:      FALSE 
| Legal Values: TRUE/FALSE 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_REDISPLAY		"imageRedisplay"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_COMPLEX_CONVERT
|
| Description:  Only relevant if complex images are to be displayed,
|		this attribute maps to the polymorphic data services
|		.symbol index KPDS_VALUE_COMPLEX_CONVERT
|		attribute.  It specifies how complex data should be converted
|		in preparation for display as an image. See Chapter 3 of
|		Programming Services Manual Volume I, "Math Services" for
|		explanations of the various settings.
|
| Type:         int 
| Default:      .symbol index KLOGMAGP1 
| Legal Values: .symbol index KREAL
|               .symbol index KIMAGINARY
|		.symbol index KPHASE
|		.symbol index KMAGNITUDE
|		.symbol index KLOGMAGP1 
|		.symbol index KLOGMAG  
|		.symbol index KLOGMAGSQP1
|		.symbol index KLOGMAGSQ 
|		.symbol index KMAGSQ   
| Resource: 	imageComplexConvert
------------------------------------------------------------------------*/
#define XVW_IMAGE_COMPLEX_CONVERT	"imageComplexConvert"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_BAND_DIMENSIONS
|
| Description:  This mask attribute dictates how the total number of 
|		displayable frames in the data object should be computed.
|		The values are \fIor\fP'd in as desired. For example,
|		if bands are sequenced with respect to depth and time:
|		.begin code
|		int mask;
|		mask = KIMAGE_DEPTH | KIMAGE_TIME;
|		xvw_set_attribute(imageobj,
|				  XVW_IMAGE_BAND_DIMENSIONS, mask);
|		.end code
|		Note that use of this attribute implies foreknowledge about
|		the dimensionality of the data to be displayed.
|
| Type:         int 
| Default:      KIMAGE_ELEMENTS | 
|		.br
|		KIMAGE_DEPTH | 
|		.br
|		KIMAGE_TIME 
| Legal Values: Any combination of:
|		KIMAGE_ELEMENTS | 
|               .br
|               KIMAGE_DEPTH | 
|               .br
|               KIMAGE_TIME
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_BAND_DIMENSIONS	"imageBandDimensions"

/*------------------------------------------------------------------------
| Attribute:    XVW_IMAGE_BAND_MAXNUM
|
| Description:  The maximum index of the bands available in the currently 
|		displayed image; ie, the number of bands computed for the
|		data, given the value of 
|		.symbol index XVW_IMAGE_BAND_DIMENSIONS .
|
| Type:         int 
| Default:      0 
| Legal Values: 0 to (number of bands computed - 1). 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_IMAGE_BAND_MAXNUM		"imageBandMaxnum"

/*
 * this attribute is not supported yet.
 */
#define XVW_IMAGE_DATA			"imageData"


/*
 * Allowed values for XVW_IMAGE_ROI_SHAPE
 */
#define KIMAGE_ROI_RECTANGLE  1
#define KIMAGE_ROI_POLYLINE   2
#define KIMAGE_ROI_CIRCLE     3
#define KIMAGE_ROI_ELLIPSE    4
#define KIMAGE_ROI_LINE       5
#define KIMAGE_ROI_FREEHAND   6
#define KIMAGE_ROI_CURVE      7

/*
 * Allowed values for XVW_IMAGE_ROI_POLICY
 */
#define KIMAGE_ROI_INSIDE   1
#define KIMAGE_ROI_OUTLINE  2
#define KIMAGE_ROI_OUTSIDE  3

/*
 * Allowed values for XVW_IMAGE_ROI_PRESENTATION
 */
#define KIMAGE_ROI_SIGNAL   1
#define KIMAGE_ROI_IMAGE    2
#define KIMAGE_ROI_SURFACE  3

/*
 *  Which dimension of the image object should be incorporated into the
 *  image bandnums.  The XVW_IMAGE_BAND_DIMENSIONS is used to say whether
 *  or not the elements, depth, and time dimensions should be used in computing
 *  the total number of bands displayable within the image widget.
 */
#define KIMAGE_ELEMENTS (1L<<0)
#define KIMAGE_DEPTH    (1L<<1)
#define KIMAGE_TIME     (1L<<2)

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Image Object by.
 */
#define ImageWidgetClass	xvwImageWidgetClass


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration ImageWidgetClass
 */
extern   WidgetClass     ImageWidgetClass;


    /*-------------------------------------*
    |       routine definitions
    ---------------------------------------*/

/*
 *  Function definitions for Image Visual Object
 */
xvobject xvw_create_image  PROTO((xvobject, char *));


#endif /* _xvisual_Image_h_ */
/* Don't add after this point */
