 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines for general graphics attributes 
   >>>>
   >>>>    Written By: John Salas, Danielle Argiro, Mark Young
   >>>>
   >>>>          Date: Aug 20, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_GraphicsGen_h_
#define _xvisual_GraphicsGen_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_PROPORTIONAL
|
| Description:  When this attribute is set to 
|               .symbol index KGRAPHICS_NONPROP ,
|               the scale in each axis direction is determined by the
|               world coordinate minimums and maximums of the data. Thus,
|               if the X values range from 0 to 1, and the Y values range
|               from 1 to 100, and the physical length of the X and Y axes
|               are the same, then the scale in the X direction (1) is much
|               smaller than the scale in the Y direction (100).
|               .sp
|               In contrast, when this attribute is set to
|               .symbol index KGRAPHICS_PROP_WINDOWED 
|               or 
|               .symbol index KGRAPHICS_PROP_NONWINDOWED ,
|               it causes the scale in each axis direction to be the same.  
|               When a visual object is proportional, this means that the 
|               minimum and maximum values across being displayed as X and Y 
|               are found before the object is displayed.  Then the minimum 
|               and maximum are set on each axis so that the scale is the same.
|               .sp
|               If 
|               .symbol index KGRAPHICS_PROP_WINDOWED
|               is specified, then the center of the data is determined along 
|               each axis and the minimum and maximum values are set such that 
|               the data is in the center of the world coordinate space. If
|               .symbol index KGRAPHICS_PROP_NONWINDOWED 
|               is specified, the range of numbers covered, i.e, the minimum 
|               and maximum values are the same, by the X and Y axes are the
|               same.  The "sense of proportion" conveyed by the object is 
|               correct, but details of the object may be lost if the range 
|               spanned by X varies greatly from that spanned by Y.
|               .sp
|               In some cases, proportional display not be a good method of 
|               display.  For example, suppose a 2D plot object has data 
|               displayed as X ranges from 0 to 255, but the data displayed as 
|               Y ranges from 0 to 1.  Obviously, the plot will not be very 
|               informative, as all the points will be bunched against the X 
|               axis.  In cases like this, non-proportional display may be 
|               more useful.
|
| Type:         int
| Default:      .symbol index KGRAPHICS_NONPROP
| Legal Values: .symbol index KGRAPHICS_NONPROP
|               .symbol index KGRAPHICS_PROP_WINDOWED
|               .symbol index KGRAPHICS_PROP_NONWINDOWED
| Resource:     graphicsProportional
-----------------------------------------------------------------------*/
#define XVW_GRAPHICS_PROPORTIONAL	"graphicsProportional"

/*
 * the XVW_GRAPHICS_TYPE attribute is used internally, but should
 * not be used by the calling application.
 */
#define XVW_GRAPHICS_TYPE		"graphicsType"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_FILLED
| Description:  .include $DESIGN/manual/shared/xvisual/graphics/Filled.sec
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     graphicsFilled
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_FILLED		"graphicsFilled"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_LINETYPE
|
| Description:  Visual objects involving a line may specify the line type.
|
| Type:         int
| Default:      .symbol index KLINE_SOLID
| Legal Values: .symbol index KLINE_SOLID
|               .symbol index KLINE_DOTTED
|               .symbol index KLINE_DOT_DASH
|               .symbol index KLINE_SHORT_DASH
|               .symbol index KLINE_LONG_DASH
|               .symbol index KLINE_ODD_DASH
|               .symbol index KLINE_GRID_DOTTED
| Resource:     graphicsLinetype
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_LINETYPE		"graphicsLinetype"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_MARKERTYPE
| Description:  Visual objects involving a marker may specify the marker type.
| Type:         int
| Default:      .symbol index KMARKER_SQUARE
| Legal Values: 
|		.symbol index KMARKER_NONE
|               .symbol index KMARKER_ARC
|               .symbol index KMARKER_BOW_TIE
|               .symbol index KMARKER_BOX
|               .symbol index KMARKER_CARET
|               .symbol index KMARKER_CIRCLE
|               .symbol index KMARKER_CROSS
|               .symbol index KMARKER_DAGGER
|               .symbol index KMARKER_DIAMOND
|               .symbol index KMARKER_DOT
|               .symbol index KMARKER_HEXAGON
|               .symbol index KMARKER_POINT
|               .symbol index KMARKER_SQUARE
|               .symbol index KMARKER_TRIANGLE
|               .symbol index KMARKER_X
|               .symbol index KMARKER_V
| Resource:     graphicsMarkertype
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_MARKERTYPE		"graphicsMarkertype"

/*------------------------------------------------------------------------
| Attribute:    XVW_GRAPHICS_LINEWIDTH
| Description:  Visual objects involving a line may specify the line width.
| Type:         int
| Default:      .symbol index KLINE_EXTRA_FINE
| Legal Values: .symbol index KLINE_NONE
|               .symbol index KLINE_EXTRA_FINE
|               .symbol index KLINE_FINE
|               .symbol index KLINE_MEDIUM_FINE
|               .symbol index KLINE_MEDIUM
|               .symbol index KLINE_MEDIUM_WIDE
|               .symbol index KLINE_WIDE
|               .symbol index KLINE_EXTRA_WIDE
| Resource:     graphicsLinewidth
------------------------------------------------------------------------*/
#define XVW_GRAPHICS_LINEWIDTH		"graphicsLinewidth"

#endif /* _xvisual_GraphicsGen_h_ */
/* Don't add after this point */
