 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for creating a
   >>>>		       ColorCell widget.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Sep 29, 1993
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_ColorCell_h_
#define _xvisual_ColorCell_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for Color Cell Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_INDEX
| Description:  .include $DESIGN/manual/shared/xvisual/colorcell/Index.sec
| Type:         int 
| Default:      none
| Legal Values: any valid image pixel value
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_INDEX		"colorcellIndex"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_SHOWINDEX
| Description:  .include $DESIGN/manual/shared/xvisual/colorcell/ShowIndex.sec
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     colorcellShowindex
------------------------------------------------------------------------*/
#define XVW_COLORCELL_SHOWINDEX		"colorcellShowindex"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_REDVAL
|
| Description:  This attribute can be used to set the red component of the 
|               color that is displayed by the colorcell; by extension, this 
|               will identically affect the color of the pixels in the image 
|               that are in the colorcell list.
|
| Type:         int
| Default:      0
| Legal Values: 0-255
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_REDVAL		"colorcellRedval"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_GREENVAL
|
| Description:  This attribute can be used to set the green component of the 
|               color that is displayed by the colorcell; by extension, this 
|               will identically affect the color of the pixels in the image 
|		that are in the colorcell list.
|
| Type:         int
| Default:      0
| Legal Values: 0-255
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_GREENVAL		"colorcellGreenval"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_BLUEVAL
|
| Description:  This attribute can be used to set the blue component of the 
|               color that is displayed by the colorcell; by extension, this 
|               will identically affect the color of the pixels in the image 
|               that are in the colorcell list.
|
| Type:         int
| Default:      0
| Legal Values: 0-255
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_BLUEVAL		"colorcellBlueval"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_INDEXLIST
|
| Description:  This \fIread-only\fP attribute allows you to obtain the 
|               array of image data values (pixels) currently associated 
|               with the colorcell object (ie, those pixels currently in
|		the colorcell list).  The array obtained will contain 
|               the pixel values which appear in the color reflected in the 
|               colorcell object.
|
| Type:         int *
| Default:      N/A
| Legal Values: integer array of image pixel values
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_INDEXLIST		"colorcellIndexlist"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_INDEXNUM
|
| Description:  This is \fIread-only\fP attribute allows you to obtain the 
|               number of image data values (pixels) currently associated 
|               with the the colorcell object. Note that this is the size 
|               of the array returned by 
|               .symbol noindex XVW_COLORCELL_INDEXLIST .
|
| Type:         int
| Default:      N/A
| Legal Values: size of the array specified by
|               .symbol index XVW_COLORCELL_INDEXLIST
| 
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_INDEXNUM		"colorcellIndexnum"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_UPDATE_ONADD
|
| Description:  When this attribute is set to TRUE, the colorcell object will 
|               force pixels in the associated image to immediately appear in 
|               the color displayed by the colorcell when they are added to the
|               pixel list using 
|               .symbol noindex XVW_COLORCELL_ADD .
|
| Type:         int 
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     colorcellUpdateOnadd
------------------------------------------------------------------------*/
#define XVW_COLORCELL_UPDATE_ONADD	"colorcellUpdateOnadd"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_RESTORE_ONDELETE
|
| Description:  When this attribute is set to TRUE, the colorcell object will 
|               force pixels in the associated image to be immediately restored
|               to their original color when they are deleted from the pixel 
|               list using 
|               .symbol noindex XVW_COLORCELL_DELETE .
|
| Type:         int
| Default:      FALSE
| Legal Values: TRUE/FALSE
| Resource:     colorcellRestoreOndelete
------------------------------------------------------------------------*/
#define XVW_COLORCELL_RESTORE_ONDELETE	"colorcellRestoreOndelete"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_ADD
|
| Description:  Use of this \fIwrite-only\fP attribute adds the specified
|               image data value (pixel) to \fIcolorcell list\fP (the list 
|		of pixels with which the colorcell is associated). 
|               If
|               .symbol noindex XVW_COLORCELL_UPDATE_ONADD
|               is set to TRUE, use of this attribute will force 
|		the color in which a pixel value is displayed to be the same 
|		as the color currently displayed by the colorcell object.
|
| Type:         int
| Default:      N/A 
| Legal Values: valid pixel value of the displayed data object
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_ADD	        "colorcellAdd"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_DELETE
|
| Description:  Use of this \fIwrite-only\fP attribute deletes 
|               the image data value (pixel) from the \fIcolorcell list\fP 
|		(the list of pixels with which the colorcell is associated). 
|               If
|               .symbol noindex XVW_COLORCELL_RESTORE_ONDELETE
|               is set to TRUE, use of this attribute will restore the 
|		pixel to its original color in which it appeared before it 
|               was added to the index list with
|               .symbol noindex XVW_COLORCELL_ADD.
|
| Type:         int
| Default:      N/A (action attribute)
| Legal Values: valid pixel value of the displayed data object
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_DELETE	        "colorcellDelete"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_CLEAR
|
| Description:  This \fIaction\fP attribute clears the \fIcolorcell list\fP
|		(the list of pixels with which the colorcell is associated), 
|		so that the colorcell can subsequently be associated with 
|		new pixel value(s).
|
| Type:         int
| Default:      N/A (action attribute)
| Legal Values: TRUE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_CLEAR	        "colorcellClear"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_RESTORE
|
| Description:  This \fIaction\fP attribute restores the pixels in the
|		\fIcolorcell list\fP to the the original colors in which
|		they appeared in before they added to the colorcell list
|		using
|		.symbol index XVW_COLORCELL_ADD .
|
| Type:         int
| Default:      N/A (action attribute)
| Legal Values: TRUE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_RESTORE	        "colorcellRestore"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLORCELL_UPDATE
|
| Description:  This \fIaction attribute\fP updates the colors of the
|		pixels in the colorcell list, according to the color 
|		currently displayed by the colorcell.
|
| Type:         int
| Default:      N/A (action attribute)
| Legal Values: TRUE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLORCELL_UPDATE	        "colorcellUpdate"

/*
 *  Define the Class name, by which people should be externally referencing
 *  the ColorCell Object by.
 */
#define ColorCellWidgetClass	xvwColorCellWidgetClass
 
	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/*
 *  Function definitions for Circle Visual Object
 */
xvobject xvw_create_colorcell  PROTO((xvobject, char *));


    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration ColorCellWidgetClass
 */
extern   WidgetClass	ColorCellWidgetClass;


#endif /* _xvisual_ColorCell_h_ */
/* Don't add after this point */
