 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines and #includes for subclassing a
   >>>>		       Color widget.
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Nov 16, 1992 16:20
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_Color_h_
#define _xvisual_Color_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*
 *  Attribute definitions for Color Visual Object
 */

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_BEGIN
|
| Description:  Use this attribute to specify the beginning of the range of 
|               color indices to be allocated, if that range is to be limited 
|               to something other than the full number of indices in the 
|               colormap.
|
| Type:         int
| Default:      0
| Legal Values: 0 to height of colormap
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_BEGIN		 "colorBegin"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_END
|
| Description:  Use this attribute to specify the end of the range of 
|               color indices to be allocated, if that range is to be limited 
|               to something other than the full number of indices in the 
|               colormap.
|
| Type:         int
| Default:      0
| Legal Values: 0 to height of colormap
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_END		 "colorEnd"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_COLORS
| Description:  This \fIread only\fP attribute can be used to obtain
|		the XColor array representing the map data for the displayed
|		data object.  Red, green, and blue values are normalized 
|		between 0 and 65,536.  Pixel values reflect those that were
|		allocated in order to display the colormap.
| Type:         XColor *
| Default:      NULL
| Legal Values:  
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_COLORS	 "colorColors"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_NUMCOLORS
| Description:  This \fIread only\fP attribute is used to obtain the size 
|		of the XColor array returned by
|		.symbol index XVW_COLOR_COLORS .
| Type:         int
| Default:      0
| Legal Values: value > 0
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_NUMCOLORS	 "colorNumcolors"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_COLOROBJ
| Description:  This is the data object containing the colormap to be
|		displayed.  Note that this attribute is mutually exclusive
|		with 
|		.symbol index XVW_COLOR_COLORFILE ;
|		set one or the other, not both. 
| Type:         kobject
| Default:      NULL
| Legal Values: valid data object
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_COLOROBJ	 "colorColorobj"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_COLORFILE
|
| Description:  The name of the file containing the colormap to be displayed.
|               Note that this attribute is mutually exclusive with 
|               .symbol index XVW_COLOR_COLOROBJ ; 
|		set one or the other, not both.
|
| Type:         char *
| Default:      NULL
| Legal Values: name of file w/ colormap
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_COLORFILE	 "colorColorfile"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_RELOAD
|
| Description:  Use of this \fIaction attribute\fP causes the data to be
|               re-read from the associated data object;  the data is then
|               redisplayed.
|               .sp
|               Use of this attribute is useful when displaying data with
|               a large number of image values.  When displaying such data 
|		on screens that are less than 24 bit, the limitation
|               of the number of colorcells available for allocation on the
|               screen can cause difficulties in realistically displaying
|               the colors in the data.
|               .sp
|               If the data being displayed has more values than can be
|               accomodated by the screen, then some data values must be
|               mapped to the same pixel as other data values.
|               .sp
|               Consider the situation of a large image that cannot
|               be displayed in its entirety, and furthermore containing a
|               much greater number of image values than can be displayed on
|               the current screen, \fInot all of which appear in every region
|               of the image\fP.  The displayed result will be most acceptable
|               for the region of the image was loaded first, since the image
|               values in that region of the image will have the greatest chance
|               of getting unique pixel values allocated for them.  However,
|               other regions of the image with a large number of data values
|               that differ from the values of the first region may suffer from
|               the effect of having a large number of data values all being
|               mapped to the same pixel value.  Such situations can be
|               rectified by allowing the currently region to be re-read from
|               scratch, causing the color allocation process to be redone, and
|               the current region being allowed to commandeer all the available
|               pixel values.
|
| Type:         int
| Default:      N/A
| Legal Values: TRUE (action attribute)
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_RELOAD	 "colorReload"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_CALLBACK
|
| Description:  If desired, you may install a callback that will be fired
|               when the colormap is changed.  The colormap may be changed
|               by an autocolor procedure or a colormap operation being 
|               applied, a pseudocoloring operation, a change in the map 
|               data of the data object being displayed, or any other
|               modification of the colormap.
|
| Type:         kfunc_void
| Default:      NULL
| Legal Values: callback function, in the form:
|               .begin code
|               void callback_function
|                  xvobject object,
|                  kaddr client_data,
|                  kaddr call_data)
|               .end code
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_CALLBACK	 "colorCallback"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_NORM_TYPE
| Description:  .include $DESIGN/manual/shared/xvisual/color/NormType.sec
| Type:         int
| Default:      .symbol index KCOLOR_NORM_LOCAL
| Legal Values: .symbol index KCOLOR_NORM_GLOBAL
|               .symbol index KCOLOR_NORM_LOCAL
| Resource:     colorNormType
------------------------------------------------------------------------*/
#define XVW_COLOR_NORM_TYPE      "colorNormType" 

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_NORM_UBYTE
| Description:  If desired, you may normalize unsigned byte data.  Normally
|	        all data types are normalized, but under certain conditions
|		(especially when comparing images together) you don't want
|		to perform normalization.
| Type:         int
| Default:      TRUE
| Legal Values: TRUE/FALSE
| Resource:     colorNormUbyte
------------------------------------------------------------------------*/
#define XVW_COLOR_NORM_UBYTE      "colorNormUbyte" 

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_NORM_METHOD
| Description:  .include $DESIGN/manual/shared/xvisual/color/NormMethod.sec
| Type:         int
| Default:      .symbol index KCOLOR_NORM_MAXCOLORS
| Legal Values: .symbol index KCOLOR_NORM_MAXCOLORS
|               .symbol index KCOLOR_NORM_1STDDEV
|               .symbol index KCOLOR_NORM_2STDDEV
|               .symbol index KCOLOR_NORM_3STDDEV
| Resource:     colorNormMethod
------------------------------------------------------------------------*/
#define XVW_COLOR_NORM_METHOD    "colorNormMethod"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_RED_FUNCTION
| Description:  .include $DESIGN/manual/shared/xvisual/color/RedFunction.sec
| Type:         char *
| Default:      "M0"
| Legal Values: see description
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_RED_FUNCTION   "colorRedFunction"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_GREEN_FUNCTION
| Description:  .include $DESIGN/manual/shared/xvisual/color/GreenFunction.sec
| Type:         char *
| Default:      "M1"
| Legal Values: see description
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_GREEN_FUNCTION "colorGreenFunction"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_BLUE_FUNCTION
| Description:  .include $DESIGN/manual/shared/xvisual/color/BlueFunction.sec
| Type:         char *
| Default:      "M2"
| Legal Values: see description
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_BLUE_FUNCTION  "colorBlueFunction"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_ALLOC_POLICY
|
| Description:  A \fIvisual\fP describes the characteristics of a virtual
|               colormap that is created for use with an application on a 
|               particular screen.  For a complete explanation of visuals, 
|               you are referred to Chapters 7.2, 7.3, and 7.4 of \fIThe 
|               XLib Programming Manual\fP, by Adrian Nye, published by
|               O'Reilly & Associates.  Depending on your particular 
|               workstation, you may have a DirectColor, GreyScale, 
|               PseudoColor, StaticColor, StaticGrey, or TrueColor visual.  
|               The former three visual types support two types of colorcells: 
|               \fIread only\fP and \fIread/write\fP.  The color in a read 
|               only cell is set once by one application, and from then on 
|               can be shared by multiple applications, but not changed.  A
|               read/write color cell can have its color changed at any time 
|               by the application that allocated it; however, it cannot be 
|               shared by other applications.  The latter three visual types 
|               are limited to read only colorcells.
|               .sp
|               By default, the color class will allocate color cells as read 
|               only.  If you set the
|               .symbol index XVW_COLOR_ALLOC_POLICY to
|               .symbol index KCOLOR_ALLOC_READWRITE ,
|               and the user is on a workstation that has a visual of type 
|               DirectColor, GreyScale, or PseudoColor (\f(CW% xdpyinfo\fP 
|               will indicate the type of visual on a workstation) the 
|               read/write method of color allocation will be used.  
|               .sp
|               There are tradeoffs that must be taken into account when 
|               setting the color allocation method;  again, you are referred 
|               to \fIThe XLib Programming Manual\fP for more information.
|               .sp
|               To summarize very briefly, the color class will be able to 
|               update the colors that are displayed in a subclassed object
|               such as an image or zoom object \fImuch\fP faster when a 
|               read/write color allocation method is used.  However, since 
|               color cells will not be shared with other applications, this 
|               may result in the annoying "techno-flashing" phenomenon where 
|               the colormaps of spectrum and any other applications that 
|               happen to be running at the same time are installed and 
|               de-installed as the pointer is moved in and out of the 
|               application's GUI.  Thus, if this application is the only 
|               application requiring a large number of colors that the user
|               happens to be running, use of the read/write color allocation 
|               scheme is recommended.  Technoflashing will increasingly become
|               a problem as the application has to compete with other 
|               applications for color.  Technoflashing is minimized by 
|               leaving an application with the read-only color allocation 
|               default behavior.  However, colors will be slower to refresh,  
|               particularly the colors of classes with a large number of 
|               clusters assigned.
|               .sp
|               The recommended solution is to use a logical command line 
|               argument for applications, which will allow the user to
|               change the value of the
|               .symbol index XVW_COLOR_ALLOC_POLICY
|               attribute.  At this time, it cannot be set via the app-defaults
|               file.
|             
| Type:         int
| Default:      .symbol index KCOLOR_ALLOC_READONLY
| Legal Value   .symbol index KCOLOR_ALLOC_READONLY
|               .symbol index KCOLOR_ALLOC_READWRITE
| Resource:     N/A
-----------------------------------------------------------------------*/
#define XVW_COLOR_ALLOC_POLICY   "colorAllocPolicy"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_PRIVATE_CMAP
|
| Description:  To summarize very briefly, the color class will be able to 
|               allocate more colors if a private colormap is created.  This
|               allows for a better representation.  However, since 
|               colormaps will not be shared with other applications, this 
|               may result in the annoying "techno-flashing" phenomenon where 
|               the colormaps of spectrum and any other applications that 
|               happen to be running at the same time are installed and 
|               de-installed as the pointer is moved in and out of the 
|               application's GUI.  Thus, if this application wants as many
|		colors to be allocated as possible, use of the private colormap
|		allocation scheme is recommended.  Technoflashing will
|		increasingly become a problem as the application has to
|		compete with other applications for color.  Technoflashing
|		is minimized by leaving an application with the private
|		colormap set to FALSE, since the default colormap will be
|		used.  However, colors displayed may not truly reflect their
|               real values.
|               .sp
|               The recommended solution is to use a logical command line 
|               argument for applications, which will allow the user to
|               change the value of the
|               .symbol index XVW_COLOR_PRIVATE_CMAP
|               attribute or set thru the app-defaults.
| Type:         int
| Default:      FALSE
| Legal Value   TRUE/FALSE
| Resource:     colorPrivateCmap
-----------------------------------------------------------------------*/
#define XVW_COLOR_PRIVATE_CMAP   "colorPrivateCmap"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_RED_MAPCOL
| Description:  .include $DESIGN/manual/shared/xvisual/color/RedMapcol.sec
| Type:         int
| Default:      0
| Legal Values: valid map column index
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_RED_MAPCOL    "colorRedMapcol"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_GREEN_MAPCOL
| Description:  .include $DESIGN/manual/shared/xvisual/color/GreenMapcol.sec
| Type:         int
| Default:      0
| Legal Values: valid map column index
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_GREEN_MAPCOL  "colorGreenMapcol"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_BLUE_MAPCOL
| Description:  .include $DESIGN/manual/shared/xvisual/color/BlueMapcol.sec
| Type:         int
| Default:      0
| Legal Values: valid map column index
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_BLUE_MAPCOL   "colorBlueMapcol"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_SAVEMAP
| Description:  This \fIaction attribute\fP allows you to save the colormap
|		associated with the displayed data object \fIby itself\fP;
|		that is, the data object written out will not contain
|		value, mask, time, or location data, but only the map data. 
| Type:         char *
| Default:      NULL 
| Legal Values: valid filename 
| Resource: 	N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_SAVEMAP   	"colorSavemap"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_CHANGE_RED_MAPCOL
|
| Description:  This is an \fIaction\fP attribute; i.e, it may only be used
|               with \fIxvw_set_attribute(s)()\fP.  Provide TRUE as the value.
|               .sp
|               This attribute provides a convenient, interactive front end 
|               that an application may use to allow the user to set the
|               .symbol index XVW_COLOR_RED_MAPCOL
|               attribute.  It will query the number of map columns associated 
|               with the image, and present the user with a pop-up list of the 
|               map columns available.  The user will be allowed to choose one 
|               of the map columns from the list;  then,
|               .symbol index XVW_COLOR_RED_MAPCOL
|               will be automatically set according to the choice made by the 
|               user.
|
| Type:         int
| Default:      N/A (action attribute)
| Legal Values: TRUE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_CHANGE_RED_MAPCOL    "colorChangeRedMapcol"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_CHANGE_GREEN_MAPCOL
|
| Description:  This is an \fIaction\fP attribute; i.e, it may only be used 
|               with \fIxvw_set_attribute(s)()\fP.  Provide TRUE as the value. 
|               See
|               .symbol noindex XVW_COLOR_RED_MAPCOL
|               for more details.
|
| Type:         int
| Default:      N/A  (action attribute)
| Legal Values: TRUE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_CHANGE_GREEN_MAPCOL  "colorChangeGreenMapcol"

/*------------------------------------------------------------------------
| Attribute:    XVW_COLOR_CHANGE_BLUE_MAPCOL
|
| Description:  This is an \fIaction\fP attribute; i.e, it may only be used 
|               with \fIxvw_set_attribute(s)()\fP.  Provide TRUE as the value. 
|               See
|               .symbol noindex XVW_COLOR_RED_MAPCOL
|               for more details.
|
| Type:         int
| Default:      N/A (action attribute)
| Legal Values: TRUE
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_COLOR_CHANGE_BLUE_MAPCOL   "colorChangeBlueMapcol"


/*
 *  values for XVW_COLOR_NORM_TYPE
 */
#define KCOLOR_NORM_GLOBAL	1
#define KCOLOR_NORM_LOCAL	2

/*
 *  values for XVW_COLOR_NORM_METHOD
 */
#define KCOLOR_NORM_MAXCOLORS 	1
#define KCOLOR_NORM_1STDDEV     2
#define KCOLOR_NORM_2STDDEV     3
#define KCOLOR_NORM_3STDDEV     4

/*
 *  values for XVW_COLOR_ALLOC_POLICY
 */
#define KCOLOR_ALLOC_READONLY     1
#define KCOLOR_ALLOC_READWRITE    2

/*
 *  Define the Class name, by which people should be externally referencing
 *  the Color Object by.
 */
#define ColorWidgetClass	xvwColorWidgetClass
#define ColorGadgetClass	xvwColorGadgetClass

    /*-------------------------------------*
    |       global variable declarations
    ---------------------------------------*/

/*
 *  XToolkit WidgetClass Declaration ColorGadgetClass
 */
extern   WidgetClass	ColorGadgetClass;

/*
 *  XToolkit WidgetClass Declaration ColorWidgetClass
 */
extern   WidgetClass	ColorWidgetClass;


#endif /* _xvisual_Color_h_ */
/* Don't add after this point */
