 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines for axis class attributes 
   >>>>		       that control line widths and line types
   >>>>
   >>>>    Written By: John Salas, Danielle Argiro, Mark Young
   >>>>
   >>>>          Date: Aug 20, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_AxisLines_h_
#define _xvisual_AxisLines_h_

	/*-------------------------------------*
	|       #defines 
        ---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_MAJOR_GRID_LINE_WIDTH
|
| Description:  The line width with which the major grid is drawn.
|
| Type:         int
| Default:      .symbol index KLINE_MEDIUM_FINE
| Legal Values: .symbol index KLINE_NONE
|               .symbol index KLINE_EXTRA_FINE
|               .symbol index KLINE_FINE
|               .symbol index KLINE_MEDIUM_FINE
|               .symbol index KLINE_MEDIUM
|               .symbol index KLINE_MEDIUM_WIDE
|               .symbol index KLINE_WIDE
|               .symbol index KLINE_EXTRA_WIDE
| Resource:     axisMajorGridLineWidth
------------------------------------------------------------------------*/
#define XVW_AXIS_MAJOR_GRID_LINE_WIDTH	 "axisMajorGridLineWidth"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_MINOR_GRID_LINE_WIDTH
|
| Description:  The line width with which the minor grid is drawn.
|
| Type:         int
| Default:      .symbol index KLINE_EXTRA_FINE
| Legal Values: .symbol index KLINE_NONE
|               .symbol index KLINE_EXTRA_FINE
|               .symbol index KLINE_FINE
|               .symbol index KLINE_MEDIUM_FINE
|               .symbol index KLINE_MEDIUM
|               .symbol index KLINE_MEDIUM_WIDE
|               .symbol index KLINE_WIDE
|               .symbol index KLINE_EXTRA_WIDE
| Resource:     axisMinorGridLineWidth
------------------------------------------------------------------------*/
#define XVW_AXIS_MINOR_GRID_LINE_WIDTH	 "axisMinorGridLineWidth"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_MAJOR_GRID_LINE_TYPE
|
| Description: 	The line type with which the major grid is drawn.
|
| Type:         int
| Default:      .symbol index KLINE_GRID_DOTTED
| Legal Values: .symbol index KLINE_SOLID
|               .symbol index KLINE_DOTTED
|               .symbol index KLINE_DOT_DASH
|               .symbol index KLINE_SHORT_DASH
|               .symbol index KLINE_LONG_DASH
|               .symbol index KLINE_ODD_DASH
|               .symbol index KLINE_GRID_DOTTED
| Resource:     axisMajorGridLineType
------------------------------------------------------------------------*/
#define XVW_AXIS_MAJOR_GRID_LINE_TYPE    "axisMajorGridLineType"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_MINOR_GRID_LINE_TYPE
|
| Description:  The line type with which the minor grid is drawn.
|
| Type:         int
| Default:      .symbol index KLINE_GRID_DOTTED
| Legal Values: .symbol index KLINE_SOLID
|               .symbol index KLINE_DOTTED
|               .symbol index KLINE_DOT_DASH
|               .symbol index KLINE_SHORT_DASH
|               .symbol index KLINE_LONG_DASH
|               .symbol index KLINE_ODD_DASH
|               .symbol index KLINE_GRID_DOTTED
| Resource:     axisMinorGridLineType
------------------------------------------------------------------------*/
#define XVW_AXIS_MINOR_GRID_LINE_TYPE    "axisMinorGridLineType"

#endif /* _xvisual_AxisLines_h_ */
/* Don't add after this point */
