 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: #defines for axis class attributes
   >>>>		       that provide control over color of axis elements
   >>>>
   >>>>    Written By: John Salas, Danielle Argiro, Mark Young
   >>>>
   >>>>          Date: Aug 20, 1994
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _xvisual_AxisColor_h_
#define _xvisual_AxisColor_h_

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_AXIS_COLOR
|
| Description:  The string that specifies the name of the desired color
|               for the axis.
|
| Type:         char *
| Default:      default fg color
| Legal Values: any valid color name: see /usr/lib/X11/rgb.txt or Section
|		7.1.1 of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:     axisAxisColor
------------------------------------------------------------------------*/
#define XVW_AXIS_AXIS_COLOR              "axisAxisColor"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_AXIS_PIXEL
|
| Description:  The pixel value that defines the desired color for the axis.
|
| Type:         unsigned long
| Default:      default fg pixel (XtDefaultForeground)
| Legal Values:	any valid pixel value: see Section 7.3 and 7.4 
|		of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_AXIS_PIXEL              "axisAxisPixel"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_BOX_COLOR
|
| Description:  The string that specifies the name of the desired 
|               color for the axis box.
|
| Type:         char *
| Default:      default foreground color
| Legal Values: any valid color name: see /usr/lib/X11/rgb.txt or Section
|               7.1.1 of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	axisBoxColor 
------------------------------------------------------------------------*/
#define XVW_AXIS_BOX_COLOR		 "axisBoxColor"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_BOX_PIXEL
|
| Description:  The pixel value that defines the desired color for the box.
|
| Type:         unsigned long
| Default:      default fg pixel (XtDefaultForeground)
| Legal Values: any valid pixel value: see Section 7.3 and 7.4 
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:	N/A 
------------------------------------------------------------------------*/
#define XVW_AXIS_BOX_PIXEL		 "axisBoxPixel"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_MAJOR_GRID_COLOR
|
| Description:  The string that specifies the name of the desired color 
|               for the major grid.
|
| Type:         char *       
| Default:      default foreground color
| Legal Values: any valid color name: see /usr/lib/X11/rgb.txt or Section
|               7.1.1 of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:     axisMajorGridColor
------------------------------------------------------------------------*/
#define XVW_AXIS_MAJOR_GRID_COLOR	 "axisMajorGridColor"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_MAJOR_GRID_PIXEL
|
| Description:  The pixel value that defines the desired color for the 
|               major grid.
|
| Type:         unsigned long
| Default:      default fg pixel (XtDefaultForeground)
| Legal Values: any valid pixel value: see Section 7.3 and 7.4 
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_MAJOR_GRID_PIXEL	 "axisMajorGridPixel"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_MINOR_GRID_COLOR
|
| Description:  The string that specifies the name of the desired color 
|               for the minor grid.
|
| Type:         char *
| Default:      default foreground color
| Legal Values: any valid color name: see /usr/lib/X11/rgb.txt or Section
|               7.1.1 of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:     axisMinorGridColor
------------------------------------------------------------------------*/
#define XVW_AXIS_MINOR_GRID_COLOR	 "axisMinorGridColor"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_MINOR_GRID_PIXEL
|
| Description:  The pixel value that defines the desired color for the 
|               minor grid.
|
| Type:         unsigned long
| Default:      default fg pixel (XtDefaultForeground)
| Legal Values: any valid pixel value: see Section 7.3 and 7.4 
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_MINOR_GRID_PIXEL	 "axisMinorGridPixel"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_NUMERICAL_LABELS_COLOR
|
| Description:  The string that specifies the name of the desired 
|               color for the numerical labels.
|
| Type:         char *
| Default:      default foreground color
| Legal Values: any valid color name: see /usr/lib/X11/rgb.txt or Section
|               7.1.1 of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:     axisNumericalLabelsColor
------------------------------------------------------------------------*/
#define XVW_AXIS_NUMERICAL_LABELS_COLOR	 "axisNumericalLabelsColor"

/*------------------------------------------------------------------------
| Attribute:    XVW_AXIS_NUMERICAL_LABELS_PIXEL
|
| Description:  The pixel value that defines the desired color for 
|               the numerical labels.
|
| Type:         unsigned long
| Default:      default fg pixel (XtDefaultForeground)
| Legal Values: any valid pixel value: see Section 7.3 and 7.4 
|               of \fIThe XLib Programming Manual\fP by Adrian Nye
| Resource:     N/A
------------------------------------------------------------------------*/
#define XVW_AXIS_NUMERICAL_LABELS_PIXEL	 "axisNumericalLabelsPixel"

#endif /* _xvisual_AxisColor_h_ */
/* Don't add after this point */
